/*
 * Decompiled with CFR 0.152.
 */
package ghidra.framework.main.datatree;

import docking.widgets.tree.GTreeNode;
import docking.widgets.tree.GTreeState;
import ghidra.app.util.FileOpenDataFlavorHandler;
import ghidra.framework.main.datatree.CopyTask;
import ghidra.framework.main.datatree.DataTree;
import ghidra.framework.main.datatree.DataTreeDragNDropHandler;
import ghidra.framework.main.datatree.DataTreeFlavorHandler;
import ghidra.framework.main.datatree.DomainFileNode;
import ghidra.framework.main.datatree.DomainFolderNode;
import ghidra.framework.model.DomainFile;
import ghidra.framework.model.DomainFolder;
import ghidra.framework.plugintool.PluginTool;
import ghidra.util.Msg;
import ghidra.util.SystemUtilities;
import ghidra.util.exception.DuplicateFileException;
import ghidra.util.exception.FileInUseException;
import ghidra.util.task.Task;
import ghidra.util.task.TaskLauncher;
import ghidra.util.task.TaskMonitor;
import ghidra.util.task.TaskMonitorSplitter;
import java.awt.Component;
import java.awt.datatransfer.DataFlavor;
import java.awt.dnd.DropTargetDropEvent;
import java.io.IOException;
import java.util.List;

public final class LocalTreeNodeHandler
implements DataTreeFlavorHandler,
FileOpenDataFlavorHandler {
    private DataTree dataTree;
    private GTreeState treeState;

    @Override
    public void handle(PluginTool tool, Object obj, DropTargetDropEvent e, DataFlavor f) {
        if (f.equals(DataTreeDragNDropHandler.localDomainFileFlavor)) {
            List files = (List)obj;
            DomainFile[] domainFiles = new DomainFile[files.size()];
            for (int i = 0; i < files.size(); ++i) {
                domainFiles[i] = (DomainFile)files.get(i);
            }
            tool.acceptDomainFiles(domainFiles);
        } else if (f.equals(DataTreeDragNDropHandler.localDomainFileTreeFlavor)) {
            List files = (List)obj;
            DomainFile[] domainFiles = new DomainFile[files.size()];
            for (int i = 0; i < files.size(); ++i) {
                DomainFileNode node = (DomainFileNode)files.get(i);
                domainFiles[i] = node.getDomainFile();
            }
            tool.acceptDomainFiles(domainFiles);
        }
    }

    @Override
    public boolean handle(PluginTool tool, DataTree tree, GTreeNode destinationNode, Object transferData, int dropAction) {
        this.dataTree = tree;
        this.treeState = tree.getTreeState();
        List list = (List)transferData;
        if (list.size() == 0) {
            return false;
        }
        CopyAllTask task = new CopyAllTask(list, destinationNode, dropAction);
        new TaskLauncher((Task)task, (Component)((Object)this.dataTree), 1000);
        if (this.treeState != null) {
            SystemUtilities.runSwingLater(() -> {
                this.treeState.updateStateForMovedNodes();
                this.dataTree.restoreTreeState(this.treeState);
            });
        }
        return true;
    }

    private void add(GTreeNode destNode, GTreeNode draggedNode, int dropAction, TaskMonitor monitor) {
        DomainFolderNode folderNode = this.getDestinationFolderNode(destNode);
        if (!this.isValidDrag(folderNode, draggedNode)) {
            return;
        }
        DomainFolder destFolder = folderNode.getDomainFolder();
        this.addDraggedTreeNode(destFolder, draggedNode, dropAction, monitor);
    }

    private boolean isValidDrag(DomainFolderNode folderNode, GTreeNode draggedNode) {
        if (folderNode == draggedNode) {
            return false;
        }
        if (draggedNode.getParent() == folderNode) {
            return false;
        }
        if (draggedNode instanceof DomainFolderNode) {
            return !draggedNode.isAncestor((GTreeNode)folderNode);
        }
        return true;
    }

    private DomainFolderNode getDestinationFolderNode(GTreeNode destNode) {
        if (destNode instanceof DomainFolderNode) {
            return (DomainFolderNode)destNode;
        }
        return (DomainFolderNode)destNode.getParent();
    }

    private void addDraggedTreeNode(DomainFolder destFolder, GTreeNode data, int dropAction, TaskMonitor monitor) {
        try {
            if (data instanceof DomainFolderNode) {
                DomainFolder sourceFolder = ((DomainFolderNode)data).getDomainFolder();
                this.handleFolderDrag(destFolder, dropAction, sourceFolder, monitor);
            } else {
                DomainFile file = ((DomainFileNode)data).getDomainFile();
                this.handleFileDrag(destFolder, dropAction, file, monitor);
            }
        }
        catch (Exception e) {
            String msg = e.getMessage();
            if (msg == null) {
                msg = e.toString();
            }
            String nodeType = data instanceof DomainFolderNode ? "folder" : "file";
            Msg.showError((Object)this, (Component)((Object)this.dataTree), (String)"Copy/Move Failed", (Object)("Failed to copy/move " + nodeType + ": " + data.getName() + "\n" + msg), (Throwable)e);
        }
    }

    private void handleFileDrag(DomainFolder destFolder, int dropAction, DomainFile file, TaskMonitor monitor) {
        if (dropAction == 1 || !file.isInWritableProject()) {
            CopyTask task = new CopyTask(destFolder, file);
            task.run(monitor);
            return;
        }
        try {
            file.moveTo(destFolder);
        }
        catch (IOException e) {
            String msg = e.getMessage();
            if (msg == null) {
                msg = e.toString();
            }
            Msg.showError((Object)this, (Component)((Object)this.dataTree), (String)"Cannot Move File", (Object)("Move file " + file.getName() + " failed.\n" + msg));
        }
    }

    private void handleFolderDrag(DomainFolder destFolder, int dropAction, DomainFolder sourceFolder, TaskMonitor monitor) {
        if (dropAction == 1 || !sourceFolder.isInWritableProject()) {
            CopyTask task = new CopyTask(destFolder, sourceFolder);
            task.run(monitor);
            return;
        }
        try {
            sourceFolder.moveTo(destFolder);
        }
        catch (DuplicateFileException dfe) {
            Msg.showError((Object)this, (Component)((Object)this.dataTree), (String)"Error Moving Folder", (Object)("Destination folder already contains a folder named \"" + sourceFolder.getName() + "\""));
        }
        catch (FileInUseException fiue) {
            Object message = fiue.getMessage();
            if (message == null || ((String)message).length() == 0) {
                message = "Cannot move folder '" + sourceFolder.toString() + "' to '" + destFolder.toString() + "'\nsince it contains a file that is checked out or in use.";
            }
            Msg.showError((Object)this, (Component)((Object)this.dataTree), (String)"Error Moving Folder", (Object)message);
        }
        catch (IOException e) {
            Msg.showError((Object)this, (Component)((Object)this.dataTree), (String)"Error Moving Folder", (Object)"Cannot Move Folder", (Throwable)e);
        }
    }

    private class CopyAllTask
    extends Task {
        private List<GTreeNode> toCopy;
        private GTreeNode destination;
        private int dropAction;

        CopyAllTask(List<GTreeNode> toCopy, GTreeNode destination, int dropAction) {
            super("Copy Files", true, true, true);
            this.toCopy = toCopy;
            this.destination = destination;
            this.dropAction = dropAction;
        }

        public void run(TaskMonitor monitor) {
            int size = this.toCopy.size();
            TaskMonitor[] subMonitors = TaskMonitorSplitter.splitTaskMonitor((TaskMonitor)monitor, (int)size);
            monitor.initialize((long)size);
            for (int i = 0; i < size; ++i) {
                if (monitor.isCancelled()) {
                    return;
                }
                GTreeNode copyNode = this.toCopy.get(i);
                monitor.setMessage("Processing file " + (i + 1) + " of " + size + ": " + copyNode.getName());
                LocalTreeNodeHandler.this.add(this.destination, copyNode, this.dropAction, subMonitors[i]);
                monitor.setProgress((long)i);
            }
        }
    }
}

