/*
 * Decompiled with CFR 0.152.
 */
package ghidra.framework.main.logviewer.ui;

import docking.dnd.GClipboard;
import ghidra.framework.main.logviewer.event.FVEvent;
import ghidra.framework.main.logviewer.event.FVEventListener;
import ghidra.framework.main.logviewer.event.MouseWheelAction;
import ghidra.framework.main.logviewer.model.ChunkModel;
import ghidra.framework.main.logviewer.model.ChunkReader;
import ghidra.framework.main.logviewer.ui.FVSlider;
import ghidra.framework.main.logviewer.ui.FVTable;
import ghidra.framework.main.logviewer.ui.FVTableModel;
import ghidra.framework.main.logviewer.ui.FVToolBar;
import ghidra.framework.main.logviewer.ui.ViewportUtility;
import ghidra.util.Msg;
import ghidra.util.Swing;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.datatransfer.Clipboard;
import java.awt.datatransfer.StringSelection;
import java.io.File;
import java.io.IOException;
import java.util.List;
import java.util.Observable;
import java.util.Observer;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import utilities.util.FileUtilities;

public class FileViewer
extends JPanel
implements Observer {
    private FVTable table;
    private JScrollPane scrollPane;
    private FVSlider slider;
    private FVToolBar toolbar;
    private ChunkReader reader;
    private ViewportUtility viewportUtility;
    private ChunkModel model;
    private FVEventListener eventListener;

    public FileViewer(ChunkReader reader, ChunkModel model, FVEventListener eventListener) throws IOException {
        this.reader = reader;
        this.model = model;
        this.eventListener = eventListener;
        this.setLayout(new BorderLayout());
        this.viewportUtility = new ViewportUtility(eventListener);
        this.table = new FVTable(reader, this.viewportUtility, model, eventListener);
        this.scrollPane = new JScrollPane((Component)((Object)this.table));
        this.scrollPane.setVerticalScrollBarPolicy(21);
        this.scrollPane.setHorizontalScrollBarPolicy(30);
        this.viewportUtility.setTable(this.table);
        this.viewportUtility.setReader(reader);
        this.viewportUtility.setModel(model);
        this.viewportUtility.setViewport(this.scrollPane.getViewport());
        this.scrollPane.addMouseWheelListener(new MouseWheelAction(eventListener));
        this.slider = new FVSlider(this.scrollPane, this.table, this.viewportUtility, model, reader, eventListener);
        this.toolbar = new FVToolBar(eventListener);
        this.slider.setMaximum(reader.getFileSize());
        this.add((Component)this.toolbar, "First");
        this.add((Component)this.scrollPane, "Center");
        this.add((Component)this.slider, "East");
        eventListener.addObserver(this);
    }

    @Override
    public void update(Observable o, Object arg) {
        if (o instanceof FVEventListener && arg instanceof FVEvent) {
            Swing.runIfSwingOrRunLater(() -> this.handleFVEvent((FVEvent)arg));
        }
    }

    private void handleFVEvent(FVEvent event) {
        switch (event.eventType) {
            case COPY_SELECTION: {
                try {
                    List<byte[]> byteArrays = this.reader.readBytes(this.model.selectedByteStart, this.model.selectedByteEnd);
                    StringBuilder strBuilder = new StringBuilder();
                    for (byte[] byteArray : byteArrays) {
                        String str = new String(byteArray);
                        strBuilder.append(str);
                    }
                    StringSelection stringSelection = new StringSelection(strBuilder.toString());
                    Clipboard clipboard = GClipboard.getSystemClipboard();
                    clipboard.setContents(stringSelection, null);
                }
                catch (IOException e) {
                    Msg.error((Object)this, (Object)"Error reading bytes from file", (Throwable)e);
                }
                break;
            }
            case DECREMENT_SELECTION: {
                if (this.table.getSelectedRow() < 0) break;
                this.table.decrementSelection((Integer)event.arg);
                this.slider.syncWithViewport();
                this.table.restoreSelection();
                break;
            }
            case DECREMENT_AND_ADD_SELECTION: {
                if (this.table.getSelectedRow() < 0) break;
                this.table.decrementAndAddSelection((Integer)event.arg);
                this.slider.syncWithViewport();
                this.table.restoreSelection();
                break;
            }
            case FILE_CHANGED: {
                this.reloadFile();
                break;
            }
            case INCREMENT_SELECTION: {
                if (this.table.getSelectedRow() < 0) break;
                this.table.incrementSelection((Integer)event.arg);
                this.slider.syncWithViewport();
                this.table.restoreSelection();
                break;
            }
            case INCREMENT_AND_ADD_SELECTION: {
                if (this.table.getSelectedRow() < 0) break;
                this.table.incrementAndAddSelection((Integer)event.arg);
                this.slider.syncWithViewport();
                this.table.restoreSelection();
                break;
            }
            case OPEN_FILE_LOCATION: {
                try {
                    FileUtilities.openNative((File)this.reader.getFile().getParentFile());
                }
                catch (IOException e) {
                    Msg.error((Object)this, (Object)("Error opening log file: " + this.reader.getFile()), (Throwable)e);
                }
                break;
            }
            case RELOAD_FILE: {
                this.reloadFile();
                break;
            }
            case SCROLL_HOME: {
                this.viewTopOfFile();
                this.setScrollLock(true);
                break;
            }
            case SCROLL_END: {
                boolean updateSlider = event.arg == null ? true : (Boolean)event.arg;
                this.viewEndOfFile(updateSlider);
                this.viewportUtility.moveViewportToBottom();
                break;
            }
            case SLIDER_CHANGED: {
                try {
                    long newFilePos = (Long)event.arg;
                    newFilePos = newFilePos > this.reader.getFileSize() ? this.reader.getFileSize() - 1L : newFilePos;
                    this.updateViewToFilePos(newFilePos);
                    this.table.restoreSelection();
                }
                catch (IOException e) {
                    Msg.error((Object)this, (Object)"Error retrieving file size from reader", (Throwable)e);
                }
                break;
            }
            case SCROLL_LOCK_OFF: {
                this.setScrollLock(false);
                break;
            }
            case SCROLL_LOCK_ON: {
                this.setScrollLock(true);
                break;
            }
            case VIEWPORT_UPDATE: {
                this.slider.syncWithViewport();
                this.table.restoreSelection();
                break;
            }
        }
    }

    private void setScrollLock(boolean lock) {
        this.toolbar.setScrollLockOn(lock);
    }

    private void viewEndOfFile(boolean updateSlider) {
        this.table.clear();
        this.model.clear();
        try {
            ((FVTableModel)this.table.getModel()).addRowsToBottom(this.reader.readLastChunk());
            this.viewportUtility.moveViewportToBottom();
            this.table.restoreSelection();
            if (updateSlider) {
                this.slider.setValue(this.slider.getMaximum());
            }
        }
        catch (IOException e) {
            Msg.error((Object)this, (Object)"Error reading last chunk of data", (Throwable)e);
        }
    }

    private void viewTopOfFile() {
        this.table.clear();
        this.model.clear();
        try {
            ((FVTableModel)this.table.getModel()).addRowsToBottom(this.reader.readNextChunk());
            this.viewportUtility.moveViewportToTop();
            this.table.restoreSelection();
        }
        catch (IOException e) {
            Msg.error((Object)this, (Object)"Error reading first chunk of data", (Throwable)e);
        }
    }

    private void updateViewToFilePos(long filePos) {
        this.model.clear();
        this.table.clear();
        try {
            List<String> lines = this.reader.readNextChunkFrom(filePos);
            int i = 0;
            while (lines.size() < 1) {
                lines = this.reader.readNextChunkFrom(filePos - (long)i);
                ++i;
            }
            ((FVTableModel)this.table.getModel()).addRowsToTop(lines);
            this.viewportUtility.moveViewportToTop();
        }
        catch (IOException e) {
            Msg.error((Object)this, (Object)"Error reading next chunk of data", (Throwable)e);
        }
    }

    private void reloadFile() {
        int savedSliderPos = this.slider.getValue();
        try {
            this.reader.reload();
            this.slider.setMaximum(this.reader.getFileSize());
        }
        catch (IOException e) {
            Msg.error((Object)this, (Object)"Error reading file size", (Throwable)e);
        }
        if (!this.toolbar.isScrollLockOn()) {
            FVEvent endEvt = new FVEvent(FVEvent.EventType.SCROLL_END, true);
            this.eventListener.send(endEvt);
            return;
        }
        long filePos = this.slider.getFilePosition(savedSliderPos);
        this.updateViewToFilePos(filePos);
    }
}

