/*
 * Decompiled with CFR 0.152.
 */
package ghidra.framework.plugintool.mgr;

import docking.DialogComponentProvider;
import docking.options.OptionsService;
import docking.options.editor.OptionsDialog;
import ghidra.framework.options.EditorStateFactory;
import ghidra.framework.options.Options;
import ghidra.framework.options.OptionsChangeListener;
import ghidra.framework.options.OptionsEditor;
import ghidra.framework.options.ToolOptions;
import ghidra.framework.plugintool.Plugin;
import ghidra.framework.plugintool.PluginTool;
import ghidra.framework.plugintool.dialog.KeyBindingsPanel;
import ghidra.util.HelpLocation;
import ghidra.util.Msg;
import ghidra.util.exception.AssertException;
import java.awt.Component;
import java.beans.PropertyChangeListener;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Comparator;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import javax.swing.JComponent;
import javax.swing.tree.TreePath;
import org.jdom.Content;
import org.jdom.Element;

public class OptionsManager
implements OptionsService,
OptionsChangeListener {
    private OptionsDialog optionsDialog;
    private PluginTool tool;
    private Map<String, ToolOptions> optionsMap;

    public OptionsManager(PluginTool tool) {
        this.tool = tool;
        this.optionsMap = new HashMap<String, ToolOptions>();
    }

    public void dispose() {
        if (this.optionsDialog != null) {
            this.optionsDialog.dispose();
        }
        this.optionsMap.values().forEach(options -> options.dispose());
    }

    public ToolOptions getOptions(String category) {
        if (category.contains(Options.DELIMITER_STRING)) {
            throw new AssertException("Options category cannot contain the options path delimiter '.'");
        }
        ToolOptions opt = this.optionsMap.get(category);
        if (opt == null) {
            opt = new ToolOptions(category);
            opt.addOptionsChangeListener((OptionsChangeListener)this);
            this.optionsMap.put(category, opt);
        }
        return opt;
    }

    public void registerOptionNameChanged(String oldName, String newName) {
        if (this.optionsMap.containsKey(oldName)) {
            ToolOptions toolOptions = this.optionsMap.remove(oldName);
            toolOptions.setName(newName);
            this.optionsMap.put(newName, toolOptions);
        }
    }

    public boolean hasOptions(String category) {
        return this.optionsMap.containsKey(category);
    }

    public void showOptionsDialog(String category, String filterText) {
        if (this.optionsDialog != null && this.optionsDialog.isVisible()) {
            this.optionsDialog.toFront();
            return;
        }
        this.optionsDialog = this.createOptionsDialog();
        this.optionsDialog.displayCategory(category, filterText);
        this.tool.showDialog((DialogComponentProvider)this.optionsDialog);
    }

    public ToolOptions[] getOptions() {
        ToolOptions[] opt = new ToolOptions[this.optionsMap.size()];
        int idx = 0;
        for (String key : this.optionsMap.keySet()) {
            opt[idx] = this.optionsMap.get(key);
            ++idx;
        }
        Arrays.sort(opt, new OptionsComparator());
        return opt;
    }

    public void deregisterOwner(Plugin ownerPlugin) {
        ArrayList<String> deleteList = new ArrayList<String>();
        for (String key : this.optionsMap.keySet()) {
            ToolOptions opt = this.optionsMap.get(key);
            if (!opt.getOptionNames().isEmpty()) continue;
            deleteList.add(opt.getName());
        }
        this.removeUnusedOptions(deleteList);
    }

    public Element getConfigState() {
        Element root = new Element("OPTIONS");
        for (String key : this.optionsMap.keySet()) {
            ToolOptions opt = this.optionsMap.get(key);
            if (!this.hasNonDefaultValues((Options)opt)) continue;
            root.addContent((Content)opt.getXmlRoot(false));
        }
        return root;
    }

    private boolean hasNonDefaultValues(Options options) {
        List optionNames = options.getOptionNames();
        for (String string : optionNames) {
            if (options.isDefaultValue(string)) continue;
            return true;
        }
        return false;
    }

    public void removeUnusedOptions() {
        ArrayList<String> deleteList = new ArrayList<String>();
        for (String key : this.optionsMap.keySet()) {
            ToolOptions opt = this.optionsMap.get(key);
            opt.removeUnusedOptions();
            if (!opt.getOptionNames().isEmpty()) continue;
            deleteList.add(opt.getName());
        }
        this.removeUnusedOptions(deleteList);
    }

    public void setConfigState(Element root) {
        Iterator iter = root.getChildren().iterator();
        while (iter.hasNext()) {
            ToolOptions opt = new ToolOptions((Element)iter.next());
            ToolOptions oldOptions = this.optionsMap.get(opt.getName());
            if (oldOptions == null) {
                opt.addOptionsChangeListener((OptionsChangeListener)this);
            } else {
                opt.takeListeners(oldOptions);
                opt.registerOptions(oldOptions);
            }
            this.optionsMap.put(opt.getName(), opt);
        }
    }

    public void editOptions() {
        if (this.optionsMap.isEmpty()) {
            Msg.showInfo(this.getClass(), (Component)this.tool.getToolFrame(), (String)"No Options", (Object)"No Options set in this tool");
            return;
        }
        if (this.optionsDialog != null && this.optionsDialog.isVisible()) {
            this.optionsDialog.toFront();
            return;
        }
        this.optionsDialog = this.createOptionsDialog();
        this.tool.showDialog((DialogComponentProvider)this.optionsDialog);
    }

    public void validateOptions() {
        for (ToolOptions options : this.optionsMap.values()) {
            options.validateOptions();
        }
    }

    private OptionsDialog createOptionsDialog() {
        if (this.optionsMap.size() == 0) {
            return null;
        }
        ToolOptions keyBindingOptions = this.getOptions("Key Bindings");
        TreePath path = null;
        if (this.optionsDialog != null) {
            path = this.optionsDialog.getSelectedPath();
            this.optionsDialog.dispose();
            OptionsEditor oldEditor = keyBindingOptions.getOptionsEditor();
            oldEditor.dispose();
        }
        keyBindingOptions.registerOptionsEditor(() -> new KeyBindingOptionsEditor());
        OptionsDialog dialog = new OptionsDialog("Options for " + this.tool.getName(), "Options", this.getEditableOptions(), null, true);
        dialog.setSelectedPath(path);
        dialog.setHelpLocation(new HelpLocation("Tool", "ToolOptions_Dialog"));
        return dialog;
    }

    private Options[] getEditableOptions() {
        return this.tool.getOptions();
    }

    private void removeUnusedOptions(List<String> deleteList) {
        for (String name : deleteList) {
            ToolOptions options = this.optionsMap.remove(name);
            options.removeOptionsChangeListener((OptionsChangeListener)this);
        }
    }

    public void optionsChanged(ToolOptions options, String name, Object oldValue, Object newValue) {
        this.tool.setConfigChanged(true);
    }

    private class OptionsComparator
    implements Comparator<ToolOptions> {
        private OptionsComparator() {
        }

        @Override
        public int compare(ToolOptions o1, ToolOptions o2) {
            return o1.getName().compareTo(o2.getName());
        }
    }

    private class KeyBindingOptionsEditor
    implements OptionsEditor {
        private KeyBindingsPanel panel;

        KeyBindingOptionsEditor() {
            this.panel = new KeyBindingsPanel(OptionsManager.this.tool, (Options)OptionsManager.this.getOptions("Key Bindings"));
        }

        public void apply() {
            this.panel.apply();
        }

        public void cancel() {
            this.panel.cancel();
        }

        public void reload() {
            this.panel.reload();
        }

        public void dispose() {
            this.panel.dispose();
        }

        public JComponent getEditorComponent(Options options, EditorStateFactory editorStateFactory) {
            return this.panel;
        }

        public void setOptionsPropertyChangeListener(PropertyChangeListener listener) {
            this.panel.setOptionsPropertyChangeListener(listener);
        }
    }
}

