/*
 * Decompiled with CFR 0.152.
 */
package ghidra.framework.plugintool.mgr;

import ghidra.framework.plugintool.ServiceInterfaceImplementationPair;
import ghidra.framework.plugintool.util.ServiceListener;
import ghidra.util.datastruct.WeakDataStructureFactory;
import ghidra.util.datastruct.WeakSet;
import ghidra.util.exception.AssertException;
import java.lang.reflect.Array;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;

public class ServiceManager {
    private Map<Class<?>, List<Object>> servicesByInterface;
    private WeakSet<ServiceListener> serviceListeners;
    private boolean notifyAdd = true;
    private List<Object[]> notifications = new ArrayList<Object[]>();

    public ServiceManager() {
        this.servicesByInterface = new HashMap();
        this.serviceListeners = WeakDataStructureFactory.createSingleThreadAccessWeakSet();
    }

    public void addServiceListener(ServiceListener listener) {
        this.serviceListeners.add((Object)listener);
    }

    public void removeServiceListener(ServiceListener listener) {
        this.serviceListeners.remove((Object)listener);
    }

    public synchronized void setServiceAddedNotificationsOn(boolean b) {
        this.notifyAdd = b;
        if (this.notifyAdd) {
            Iterator<Object[]> it = this.notifications.iterator();
            while (it.hasNext()) {
                Object[] arr = it.next();
                this.notifyServiceAdded((Class)arr[0], arr[1]);
                it.remove();
            }
        }
    }

    private void notifyServiceAdded(Class<?> interfaceClass, Object service) {
        Iterator it = this.serviceListeners.iterator();
        while (it.hasNext()) {
            ((ServiceListener)it.next()).serviceAdded(interfaceClass, service);
        }
    }

    public synchronized <T> void addService(Class<? extends T> interfaceClass, T service) {
        List list = this.servicesByInterface.computeIfAbsent(interfaceClass, k -> new ArrayList());
        if (list.contains(service)) {
            throw new AssertException("The same Service implementation cannot be added more than once.  Interface: " + interfaceClass + ". Service: " + service);
        }
        list.add(service);
        if (this.notifyAdd) {
            this.notifyServiceAdded(interfaceClass, service);
        } else {
            this.notifications.add(new Object[]{interfaceClass, service});
        }
    }

    public void removeService(Class<?> interfaceClass, Object service) {
        List<Object> list = this.servicesByInterface.get(interfaceClass);
        if (list != null) {
            list.remove(service);
            if (list.size() == 0) {
                this.servicesByInterface.remove(interfaceClass);
            }
        }
        for (ServiceListener serviceListener : this.serviceListeners) {
            serviceListener.serviceRemoved(interfaceClass, service);
        }
    }

    public <T> T getService(Class<T> interfaceClass) {
        List<Object> list = this.servicesByInterface.get(interfaceClass);
        if (list == null) {
            return null;
        }
        Object object = list.get(0);
        return interfaceClass.cast(object);
    }

    public <T> T[] getServices(Class<T> interfaceClass) {
        List<Object> list = this.servicesByInterface.get(interfaceClass);
        if (list == null) {
            return (Object[])Array.newInstance(interfaceClass, 0);
        }
        Object[] objs = (Object[])Array.newInstance(interfaceClass, list.size());
        return list.toArray(objs);
    }

    public boolean isService(Class<?> serviceInterface) {
        for (Class<?> serviceClass : this.servicesByInterface.keySet()) {
            if (!serviceClass.equals(serviceInterface)) continue;
            return true;
        }
        return false;
    }

    public List<ServiceInterfaceImplementationPair> getAllServices() {
        ArrayList<ServiceInterfaceImplementationPair> list = new ArrayList<ServiceInterfaceImplementationPair>();
        for (Class<?> serviceClass : this.servicesByInterface.keySet()) {
            for (Object serviceImpl : this.servicesByInterface.get(serviceClass)) {
                list.add(new ServiceInterfaceImplementationPair(serviceClass, serviceImpl));
            }
        }
        return list;
    }
}

