/*
 * Decompiled with CFR 0.152.
 */
package ghidra.framework.task.gui.taskview;

import docking.util.GraphicsUtils;
import generic.theme.GThemeDefaults;
import generic.theme.Gui;
import ghidra.framework.task.GScheduledTask;
import ghidra.framework.task.GTaskGroup;
import ghidra.framework.task.GTaskListenerAdapter;
import ghidra.framework.task.GTaskManager;
import ghidra.framework.task.GTaskMonitor;
import ghidra.framework.task.GTaskResult;
import ghidra.framework.task.gui.GProgressBar;
import ghidra.framework.task.gui.taskview.AbstractTaskInfo;
import ghidra.framework.task.gui.taskview.GroupInfo;
import ghidra.framework.task.gui.taskview.TaskInfo;
import ghidra.framework.task.gui.taskview.TaskViewerComponent;
import ghidra.util.SystemUtilities;
import ghidra.util.exception.AssertException;
import ghidra.util.task.CancelledListener;
import ghidra.util.task.SwingUpdateManager;
import java.awt.AlphaComposite;
import java.awt.Color;
import java.awt.Component;
import java.awt.Composite;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Insets;
import java.awt.LayoutManager;
import java.awt.Rectangle;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Deque;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.ListIterator;
import java.util.Queue;
import java.util.concurrent.ConcurrentLinkedQueue;
import javax.swing.JComponent;
import javax.swing.JLayeredPane;
import javax.swing.JScrollPane;
import javax.swing.JSeparator;
import javax.swing.SwingUtilities;
import org.jdesktop.animation.timing.Animator;
import org.jdesktop.animation.timing.TimingTarget;
import org.jdesktop.animation.timing.TimingTargetAdapter;

public class TaskViewer {
    private final Composite SCROLLED_TEXT_ALPHA_COMPOSITE = AlphaComposite.getInstance(AlphaComposite.SrcOver.getRule(), 0.1f);
    private static final String TEXT = "PAUSED...";
    private static final int MIN_DELAY = 250;
    private static final int MAX_DELAY = 1000;
    private Deque<AbstractTaskInfo> runningList = new LinkedList<AbstractTaskInfo>();
    private LinkedList<AbstractTaskInfo> waitingList = new LinkedList();
    private LinkedList<AbstractTaskInfo> scrollAwayList = new LinkedList();
    private Queue<Runnable> runnableQueue = new ConcurrentLinkedQueue<Runnable>();
    private SwingUpdateManager updateManager;
    private GTaskManager taskManager;
    private TaskViewerTaskListener taskListener;
    private JLayeredPane layeredPane;
    private TaskViewerComponent taskViewerComponent;
    private boolean useAnimations = true;
    private Animator scrollAwayAnimator;
    private TimingTarget completedTimingTarget;
    private Runnable animationRunnable;
    private Runnable updateComponentsRunnable;

    public TaskViewer(GTaskManager taskManager) {
        this.taskManager = taskManager;
        this.buildComponent();
        this.taskListener = new TaskViewerTaskListener();
        this.updateComponentsRunnable = () -> {
            while (!this.runnableQueue.isEmpty()) {
                Runnable runnable = this.runnableQueue.poll();
                runnable.run();
            }
            this.updateComponent();
        };
        this.updateManager = new SwingUpdateManager(250, 1000, this.updateComponentsRunnable);
        this.animationRunnable = () -> this.startScrollingAwayAnimation(0);
        this.completedTimingTarget = new TimingTargetAdapter(){

            public void timingEvent(float fraction) {
                TaskViewer.this.scrollAwayList.getFirst().setScrollFraction(fraction);
                TaskViewer.this.taskViewerComponent.getParent().validate();
                int desiredDuration = TaskViewer.this.getDesiredDuration();
                if (TaskViewer.this.scrollAwayAnimator.getDuration() != desiredDuration) {
                    TaskViewer.this.scrollAwayAnimator.cancel();
                    TaskViewer.this.scrollAwayAnimator.setDuration(desiredDuration);
                    TaskViewer.this.scrollAwayAnimator.setStartFraction(fraction);
                    TaskViewer.this.scrollAwayAnimator.start();
                }
            }

            public void end() {
                AbstractTaskInfo element = TaskViewer.this.scrollAwayList.pop();
                TaskViewer.this.runningList.remove(element);
                TaskViewer.this.updateComponent();
                SwingUtilities.invokeLater(TaskViewer.this.animationRunnable);
            }
        };
        this.scrollAwayAnimator = new Animator(3000, this.completedTimingTarget);
        this.scrollAwayAnimator.setStartDelay(2000);
        taskManager.addTaskListener(this.taskListener);
    }

    public void setUseAnimations(boolean b) {
        this.useAnimations = b;
    }

    private void buildComponent() {
        this.taskViewerComponent = new TaskViewerComponent();
        this.layeredPane = new JLayeredPane();
        this.layeredPane.setLayout(new CustomLayoutManager());
        JScrollPane scroll = new JScrollPane(this.taskViewerComponent);
        this.layeredPane.add((Component)scroll, JLayeredPane.DEFAULT_LAYER);
        this.layeredPane.add((Component)new MessageCanvas(), JLayeredPane.PALETTE_LAYER);
    }

    private int getDesiredDuration() {
        int size = this.scrollAwayList.size();
        if (size < 4) {
            return 3000;
        }
        if (size < 6) {
            return 2000;
        }
        if (size < 8) {
            return 1000;
        }
        if (size < 10) {
            return 500;
        }
        if (size < 15) {
            return 250;
        }
        return 100;
    }

    private void updateComponent() {
        if (!SystemUtilities.isEventDispatchThread()) {
            throw new AssertException("Must be in swing thread");
        }
        this.taskViewerComponent.removeAll();
        for (AbstractTaskInfo element : this.runningList) {
            this.taskViewerComponent.add(element.getComponent());
        }
        if (this.waitingList.size() > 0 && this.runningList.size() > 0) {
            this.taskViewerComponent.add(new JSeparator());
        }
        for (AbstractTaskInfo element : this.waitingList) {
            this.taskViewerComponent.add(element.getComponent());
        }
        Container parent = this.taskViewerComponent.getParent();
        if (parent != null) {
            parent.validate();
        }
    }

    private void initializeRunningElement(TaskInfo taskInfo) {
        GProgressBar bar = taskInfo.setRunning();
        GTaskMonitor taskMonitor = taskInfo.getScheduledTask().getTaskMonitor();
        taskMonitor.setProgressBar(bar);
        if (taskInfo.getGroup().wasCancelled()) {
            bar.initialize(1L);
            bar.setMessage("CANCELLED!");
        }
        this.runningList.add(taskInfo);
    }

    public JComponent getComponent() {
        return this.layeredPane;
    }

    void startScrollingAwayAnimation(int startDelay) {
        if (this.scrollAwayList.isEmpty()) {
            return;
        }
        if (this.scrollAwayAnimator.isRunning()) {
            return;
        }
        this.scrollAwayAnimator.setStartFraction(0.0f);
        this.scrollAwayAnimator.setDuration(this.getDesiredDuration());
        this.scrollAwayAnimator.setStartDelay(startDelay);
        this.scrollAwayAnimator.start();
    }

    private class TaskViewerTaskListener
    extends GTaskListenerAdapter {
        private TaskViewerTaskListener() {
        }

        @Override
        public void initialize() {
            TaskViewer.this.runnableQueue.add(new InitializeRunnable());
            TaskViewer.this.updateManager.updateNow();
        }

        @Override
        public void taskStarted(GScheduledTask task) {
            TaskViewer.this.runnableQueue.add(new TaskStartedRunnable(task));
            TaskViewer.this.updateManager.update();
        }

        @Override
        public void taskCompleted(GScheduledTask task, GTaskResult result) {
            TaskViewer.this.runnableQueue.add(new TaskCompletedRunnable(task));
            TaskViewer.this.updateManager.update();
        }

        @Override
        public void taskGroupScheduled(GTaskGroup group) {
            TaskViewer.this.runnableQueue.add(new TaskGroupScheduledRunnable(group));
            TaskViewer.this.updateManager.update();
        }

        @Override
        public void taskScheduled(GScheduledTask scheduledTask) {
            TaskViewer.this.runnableQueue.add(new TaskScheduledRunnable(scheduledTask));
            TaskViewer.this.updateManager.update();
        }

        @Override
        public void taskGroupStarted(GTaskGroup taskGroup) {
            TaskViewer.this.runnableQueue.add(new TaskGroupStartedRunnable(taskGroup));
            TaskViewer.this.updateManager.update();
        }

        @Override
        public void taskGroupCompleted(GTaskGroup taskGroup) {
            TaskViewer.this.runnableQueue.add(new TaskGroupCompletedRunnable(taskGroup));
            TaskViewer.this.updateManager.update();
        }

        @Override
        public void suspendedStateChanged(boolean isSuspended) {
            SystemUtilities.runSwingLater(() -> {
                TaskViewer.this.layeredPane.invalidate();
                TaskViewer.this.layeredPane.repaint();
            });
        }
    }

    private class CustomLayoutManager
    implements LayoutManager {
        private CustomLayoutManager() {
        }

        @Override
        public void addLayoutComponent(String name, Component comp) {
        }

        @Override
        public void removeLayoutComponent(Component comp) {
        }

        @Override
        public Dimension preferredLayoutSize(Container parent) {
            Insets insets = parent.getInsets();
            Dimension d = new Dimension();
            for (Component comp : parent.getComponents()) {
                Dimension size = comp.getPreferredSize();
                d.width = Math.max(d.width, size.width);
                d.height = Math.max(d.height, size.height);
            }
            d.width += insets.left + insets.right;
            d.height += insets.top + insets.bottom;
            return d;
        }

        @Override
        public Dimension minimumLayoutSize(Container parent) {
            return this.preferredLayoutSize(parent);
        }

        @Override
        public void layoutContainer(Container parent) {
            Dimension size = parent.getSize();
            Insets insets = parent.getInsets();
            int width = size.width - insets.left - insets.right;
            int height = size.height - insets.top - insets.bottom;
            int x = insets.left;
            int y = insets.top;
            for (Component comp : parent.getComponents()) {
                comp.setBounds(x, y, width, height);
            }
        }
    }

    private class MessageCanvas
    extends JComponent {
        private static final String FONT_ID = "font.task.viewer";
        private Rectangle messageDimension;

        private MessageCanvas() {
        }

        @Override
        protected void paintComponent(Graphics g) {
            if (!TaskViewer.this.taskManager.isSuspended()) {
                return;
            }
            Graphics2D g2 = (Graphics2D)g;
            g2.setComposite(TaskViewer.this.SCROLLED_TEXT_ALPHA_COMPOSITE);
            Font font = Gui.getFont((String)FONT_ID);
            g.setFont(font);
            g.setColor((Color)GThemeDefaults.Colors.Palette.BLUE);
            if (this.messageDimension == null) {
                FontMetrics fontMetrics = this.getFontMetrics(font);
                this.messageDimension = fontMetrics.getStringBounds(TaskViewer.TEXT, g2).getBounds();
            }
            Dimension size = this.getSize();
            int centerY = size.height / 2;
            int centerX = size.width / 2;
            int x = centerX - this.messageDimension.width / 2;
            int y = centerY + this.messageDimension.height / 2;
            GraphicsUtils.drawString((JComponent)this, (Graphics)g, (String)TaskViewer.TEXT, (int)x, (int)y);
        }
    }

    private class GroupCancelledListener
    implements CancelledListener {
        private GTaskGroup group;

        GroupCancelledListener(GTaskGroup group) {
            this.group = group;
        }

        public void cancelled() {
            TaskViewer.this.taskManager.cancelRunningGroup(this.group);
        }
    }

    private class TaskGroupCompletedRunnable
    implements Runnable {
        private GTaskGroup completedGroup;

        TaskGroupCompletedRunnable(GTaskGroup group) {
            this.completedGroup = group;
        }

        @Override
        public void run() {
            GTaskGroup group;
            AbstractTaskInfo info;
            Iterator<AbstractTaskInfo> it = TaskViewer.this.runningList.iterator();
            while (it.hasNext()) {
                info = it.next();
                group = info.getGroup();
                if (group != this.completedGroup || !(info instanceof GroupInfo)) continue;
                if (TaskViewer.this.useAnimations) {
                    TaskViewer.this.scrollAwayList.add(info);
                    TaskViewer.this.startScrollingAwayAnimation(2000);
                } else {
                    it.remove();
                }
                return;
            }
            it = TaskViewer.this.waitingList.iterator();
            while (it.hasNext()) {
                info = it.next();
                group = info.getGroup();
                if (group != this.completedGroup || !(info instanceof GroupInfo)) continue;
                it.remove();
                return;
            }
        }
    }

    private class TaskGroupStartedRunnable
    implements Runnable {
        private GTaskGroup group;

        TaskGroupStartedRunnable(GTaskGroup group) {
            this.group = group;
        }

        @Override
        public void run() {
            AbstractTaskInfo first = TaskViewer.this.waitingList.removeFirst();
            if (first.getGroup() != this.group) {
                first = TaskViewer.this.waitingList.removeFirst();
            }
            if (first.getGroup() != this.group) {
                throw new AssertException("Top waiting item should have been new group");
            }
            GProgressBar progressBar = first.setRunning();
            this.group.getTaskMonitor().setProgressBar(progressBar);
            progressBar.setCancelledListener(new GroupCancelledListener(this.group));
            if (this.group.wasCancelled()) {
                progressBar.initialize(1L);
                progressBar.setMessage("CANCELLED!");
            }
            TaskViewer.this.runningList.add(first);
        }
    }

    private class TaskScheduledRunnable
    implements Runnable {
        private GScheduledTask task;

        TaskScheduledRunnable(GScheduledTask task) {
            this.task = task;
        }

        @Override
        public void run() {
            boolean animateBackground = TaskViewer.this.useAnimations && (!TaskViewer.this.waitingList.isEmpty() || !TaskViewer.this.runningList.isEmpty());
            TaskInfo element = new TaskInfo(this.task, animateBackground);
            ListIterator<TaskInfo> listIterator = TaskViewer.this.waitingList.listIterator();
            while (listIterator.hasNext()) {
                AbstractTaskInfo nextElement = (AbstractTaskInfo)listIterator.next();
                if (element.compareTo(nextElement) >= 0) continue;
                listIterator.previous();
                listIterator.add(element);
                return;
            }
            TaskViewer.this.waitingList.addLast(element);
        }
    }

    private class TaskGroupScheduledRunnable
    implements Runnable {
        private GTaskGroup group;
        private List<GScheduledTask> tasks;

        TaskGroupScheduledRunnable(GTaskGroup group) {
            this.group = group;
            this.tasks = group.getTasks();
        }

        @Override
        public void run() {
            TaskViewer.this.waitingList.add(new GroupInfo(this.group));
            for (GScheduledTask gScheduledTask : this.tasks) {
                TaskViewer.this.waitingList.add(new TaskInfo(gScheduledTask));
            }
        }
    }

    private class TaskCompletedRunnable
    implements Runnable {
        private final GScheduledTask scheduledTask;

        public TaskCompletedRunnable(GScheduledTask task) {
            this.scheduledTask = task;
        }

        @Override
        public void run() {
            GScheduledTask task;
            AbstractTaskInfo info;
            Iterator<AbstractTaskInfo> it = TaskViewer.this.runningList.iterator();
            while (it.hasNext()) {
                info = it.next();
                if (!(info instanceof TaskInfo) || (task = ((TaskInfo)info).getScheduledTask()) != this.scheduledTask) continue;
                if (TaskViewer.this.useAnimations) {
                    TaskViewer.this.scrollAwayList.add(info);
                    TaskViewer.this.startScrollingAwayAnimation(2000);
                } else {
                    it.remove();
                }
                return;
            }
            it = TaskViewer.this.waitingList.iterator();
            while (it.hasNext()) {
                info = it.next();
                if (!(info instanceof TaskInfo) || (task = ((TaskInfo)info).getScheduledTask()) != this.scheduledTask) continue;
                it.remove();
                return;
            }
        }
    }

    private class TaskStartedRunnable
    implements Runnable {
        private GScheduledTask task;

        TaskStartedRunnable(GScheduledTask task) {
            this.task = task;
        }

        @Override
        public void run() {
            Iterator it = TaskViewer.this.waitingList.iterator();
            while (it.hasNext()) {
                TaskInfo taskInfo;
                AbstractTaskInfo info = (AbstractTaskInfo)it.next();
                if (!(info instanceof TaskInfo) || (taskInfo = (TaskInfo)info).getScheduledTask() != this.task) continue;
                it.remove();
                TaskViewer.this.initializeRunningElement(taskInfo);
            }
        }
    }

    private class InitializeRunnable
    implements Runnable {
        private GTaskGroup currentGroup;
        private List<GScheduledTask> scheduledTasks = new ArrayList<GScheduledTask>();
        private List<GScheduledTask> delayedTasks;
        private GScheduledTask runningTask;
        private List<TaskGroupScheduledRunnable> groupRunnables;

        public InitializeRunnable() {
            this.currentGroup = TaskViewer.this.taskManager.getCurrentGroup();
            this.delayedTasks = TaskViewer.this.taskManager.getDelayedTasks();
            this.scheduledTasks = TaskViewer.this.taskManager.getScheduledTasks();
            this.runningTask = TaskViewer.this.taskManager.getRunningTask();
            List<GTaskGroup> groups = TaskViewer.this.taskManager.getScheduledGroups();
            this.groupRunnables = new ArrayList<TaskGroupScheduledRunnable>();
            for (GTaskGroup gTaskGroup : groups) {
                this.groupRunnables.add(new TaskGroupScheduledRunnable(gTaskGroup));
            }
        }

        @Override
        public void run() {
            TaskViewer.this.waitingList.clear();
            if (this.currentGroup != null) {
                TaskViewer.this.runningList.add(new GroupInfo(this.currentGroup));
                for (GScheduledTask gScheduledTask : this.delayedTasks) {
                    TaskViewer.this.initializeRunningElement(new TaskInfo(gScheduledTask));
                }
                if (this.runningTask != null) {
                    TaskViewer.this.initializeRunningElement(new TaskInfo(this.runningTask));
                }
                for (GScheduledTask gScheduledTask : this.scheduledTasks) {
                    TaskViewer.this.waitingList.add(new TaskInfo(gScheduledTask));
                }
            }
            for (TaskGroupScheduledRunnable runnable : this.groupRunnables) {
                runnable.run();
            }
            Collections.sort(TaskViewer.this.waitingList);
            TaskViewer.this.updateComponent();
        }
    }
}

