/*
 * Decompiled with CFR 0.152.
 */
package ghidra.python;

import docking.widgets.label.GDLabel;
import generic.theme.GColor;
import ghidra.app.plugin.core.console.CodeCompletion;
import ghidra.framework.options.Options;
import ghidra.python.PythonPlugin;
import ghidra.util.Msg;
import java.awt.Color;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.swing.JComponent;
import org.python.core.PyInstance;
import org.python.core.PyObject;

public class PythonCodeCompletionFactory {
    private static List<Class<?>> classes = new ArrayList();
    private static Map<Class<?>, Color> classToColorMap = new HashMap();
    private static Map<String, Class<?>> simpleNameToClass = new HashMap();
    private static Map<Class<?>, String> classDescription = new HashMap();
    public static final String COMPLETION_LABEL = "Code Completion Colors";
    static final String INCLUDE_TYPES_LABEL = "Include type names in code completion popup?";
    private static final String INCLUDE_TYPES_DESCRIPTION = "Whether or not to include the type names (classes) of the possible completions in the code completion window.  The class name will be parenthesized after the completion.";
    private static final boolean INCLUDE_TYPES_DEFAULT = true;
    private static boolean includeTypes = true;
    public static final Color NULL_COLOR = new GColor("color.fg.plugin.python.syntax.null");
    public static final Color FUNCTION_COLOR = new GColor("color.fg.plugin.python.syntax.function");
    public static final Color PACKAGE_COLOR = new GColor("color.fg.plugin.python.syntax.package");
    public static final Color CLASS_COLOR = new GColor("color.fg.plugin.python.syntax.class");
    public static final Color METHOD_COLOR = new GColor("color.fg.plugin.python.syntax.method");
    public static final Color CODE_COLOR = new GColor("color.fg.plugin.python.syntax.code");
    public static final Color INSTANCE_COLOR = new GColor("color.fg.plugin.python.syntax.instance");
    public static final Color SEQUENCE_COLOR = new GColor("color.fg.plugin.python.syntax.sequence");
    public static final Color MAP_COLOR = new GColor("color.fg.plugin.python.syntax.map");
    public static final Color NUMBER_COLOR = new GColor("color.fg.plugin.python.syntax.number");
    public static final Color SPECIAL_COLOR = new GColor("color.fg.plugin.python.syntax.special");

    private static String getSimpleName(Class<?> klass) {
        return PythonCodeCompletionFactory.getSimpleName(klass.getName());
    }

    private static String getSimpleName(String className) {
        return className.substring(className.lastIndexOf(46) + 1);
    }

    private static void setupClass(String className, Color defaultColor, String description) {
        try {
            Class<?> klass = Class.forName(className);
            classes.add(klass);
            classToColorMap.put(klass, defaultColor);
            simpleNameToClass.put(PythonCodeCompletionFactory.getSimpleName(klass), klass);
            classDescription.put(klass, description);
        }
        catch (ClassNotFoundException cnfe) {
            Msg.debug(PythonCodeCompletionFactory.class, (Object)("Unable to find class: " + className), (Throwable)cnfe);
        }
    }

    @Deprecated
    public static CodeCompletion newCodeCompletion(String description, String insertion, PyObject pyObj) {
        return PythonCodeCompletionFactory.newCodeCompletion(description, insertion, pyObj, "");
    }

    public static CodeCompletion newCodeCompletion(String description, String insertion, PyObject pyObj, String userInput) {
        GDLabel comp = null;
        if (pyObj != null) {
            if (includeTypes) {
                String className = PythonCodeCompletionFactory.getSimpleName(pyObj.getClass());
                if (pyObj instanceof PyInstance) {
                    className = PythonCodeCompletionFactory.getSimpleName(((PyInstance)pyObj).instclass.__name__);
                } else if (className.startsWith("Py")) {
                    className = className.substring("Py".length());
                }
                description = (String)description + " (" + className + ")";
            }
            comp = new GDLabel((String)description);
            for (Class<?> testClass : classes) {
                if (!testClass.isInstance(pyObj)) continue;
                comp.setForeground(classToColorMap.get(testClass));
                break;
            }
        }
        int charsToRemove = userInput.length();
        return new CodeCompletion((String)description, insertion, (JComponent)comp, charsToRemove);
    }

    public static void setupOptions(PythonPlugin plugin, Options options) {
        includeTypes = options.getBoolean(INCLUDE_TYPES_LABEL, true);
        options.registerOption(INCLUDE_TYPES_LABEL, (Object)true, null, INCLUDE_TYPES_DESCRIPTION);
    }

    public static void changeOptions(Options options, String name, Object oldValue, Object newValue) {
        if (name.equals(INCLUDE_TYPES_LABEL)) {
            includeTypes = (Boolean)newValue;
        } else {
            Msg.error(PythonCodeCompletionFactory.class, (Object)("unknown option '" + name + "'"));
        }
    }

    public static Object[] getCallMethods(PyObject obj) {
        Method[] declaredMethods;
        ArrayList<Method> callMethodList = new ArrayList<Method>();
        for (Method declaredMethod : declaredMethods = obj.getClass().getDeclaredMethods()) {
            if (!declaredMethod.getName().equals("__call__")) continue;
            callMethodList.add(declaredMethod);
        }
        return callMethodList.toArray();
    }

    static {
        PythonCodeCompletionFactory.setupClass("org.python.core.PyNone", NULL_COLOR, "'None' (null) Objects");
        PythonCodeCompletionFactory.setupClass("org.python.core.PyReflectedFunction", FUNCTION_COLOR, "Python functions written in Java");
        PythonCodeCompletionFactory.setupClass("org.python.core.__builtin__", FUNCTION_COLOR, "Python's built-in functions collection (note that many are re-implemented in Java)");
        PythonCodeCompletionFactory.setupClass("org.python.core.PyFunction", FUNCTION_COLOR, "functions written in Python");
        PythonCodeCompletionFactory.setupClass("org.python.core.PyMethodDescr", FUNCTION_COLOR, "unbound Python builtin instance methods (they take an Object as the first argument)");
        PythonCodeCompletionFactory.setupClass("org.python.core.PyJavaPackage", PACKAGE_COLOR, "Java packages");
        PythonCodeCompletionFactory.setupClass("org.python.core.PyModule", PACKAGE_COLOR, "Python modules");
        PythonCodeCompletionFactory.setupClass("org.python.core.PyJavaType", CLASS_COLOR, "Java classes");
        PythonCodeCompletionFactory.setupClass("org.python.core.PyClass", CLASS_COLOR, "Python classes");
        PythonCodeCompletionFactory.setupClass("org.python.core.PyType", CLASS_COLOR, "core Python types");
        PythonCodeCompletionFactory.setupClass("org.python.core.PyMethod", METHOD_COLOR, "methods");
        PythonCodeCompletionFactory.setupClass("org.python.core.PyBuiltinFunction", METHOD_COLOR, "core Python methods, often inherited from Python's Object (overriding these methods is very powerful)");
        PythonCodeCompletionFactory.setupClass("org.python.core.PySequence", SEQUENCE_COLOR, "iterable sequences, including arrays, list, and strings");
        PythonCodeCompletionFactory.setupClass("org.python.core.PyDictionary", MAP_COLOR, "arbitrary Python mapping type");
        PythonCodeCompletionFactory.setupClass("org.python.core.PyStringMap", MAP_COLOR, "Python String->Object mapping type");
        PythonCodeCompletionFactory.setupClass("org.python.core.PyInteger", NUMBER_COLOR, "integers");
        PythonCodeCompletionFactory.setupClass("org.python.core.PyLong", NUMBER_COLOR, "long integers");
        PythonCodeCompletionFactory.setupClass("org.python.core.PyFloat", NUMBER_COLOR, "floating-point (decimal) numbers");
        PythonCodeCompletionFactory.setupClass("org.python.core.PyComplex", NUMBER_COLOR, "complex numbers");
        PythonCodeCompletionFactory.setupClass("org.python.core.PyCompoundCallable", SPECIAL_COLOR, "special Python properties for assigning Python functions as EventListeners on Java objects");
        PythonCodeCompletionFactory.setupClass("org.python.core.PyObjectDerived", INSTANCE_COLOR, "Java Objects");
        PythonCodeCompletionFactory.setupClass("org.python.core.PyInstance", INSTANCE_COLOR, "Python Objects");
        PythonCodeCompletionFactory.setupClass("org.python.core.PyCode", CODE_COLOR, "chunks of Python code");
    }
}

