/*
 * Decompiled with CFR 0.152.
 */
package ghidra.trace.database.program;

import ghidra.program.database.ProgramDB;
import ghidra.program.database.function.OverlappingFunctionException;
import ghidra.program.model.address.Address;
import ghidra.program.model.address.AddressSetView;
import ghidra.program.model.lang.PrototypeModel;
import ghidra.program.model.listing.Function;
import ghidra.program.model.listing.FunctionIterator;
import ghidra.program.model.listing.FunctionManager;
import ghidra.program.model.listing.FunctionTagManager;
import ghidra.program.model.listing.Program;
import ghidra.program.model.listing.Variable;
import ghidra.program.model.symbol.Namespace;
import ghidra.program.model.symbol.SourceType;
import ghidra.trace.database.program.DBTraceProgramView;
import ghidra.trace.database.symbol.DBTraceNamespaceSymbol;
import ghidra.trace.util.EmptyFunctionIterator;
import ghidra.util.exception.CancelledException;
import ghidra.util.exception.InvalidInputException;
import ghidra.util.task.TaskMonitor;
import java.io.IOException;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.stream.Stream;

public class DBTraceProgramViewFunctionManager
implements FunctionManager {
    protected final DBTraceProgramView program;
    protected final DBTraceNamespaceSymbol global;

    public DBTraceProgramViewFunctionManager(DBTraceProgramView program) {
        this.program = program;
        this.global = program.trace.getSymbolManager().getGlobalNamespace();
    }

    public Program getProgram() {
        return this.program;
    }

    public FunctionTagManager getFunctionTagManager() {
        throw new UnsupportedOperationException();
    }

    public Collection<String> getCallingConventionNames() {
        return Stream.of(this.program.trace.getBaseCompilerSpec().getCallingConventions()).map(PrototypeModel::getName).toList();
    }

    public PrototypeModel getDefaultCallingConvention() {
        return this.program.trace.getBaseCompilerSpec().getDefaultCallingConvention();
    }

    public PrototypeModel getCallingConvention(String name) {
        return this.program.trace.getBaseCompilerSpec().getCallingConvention(name);
    }

    public Function createFunction(String name, Address entryPoint, AddressSetView body, SourceType source) throws InvalidInputException, OverlappingFunctionException {
        throw new UnsupportedOperationException();
    }

    public Function createFunction(String name, Namespace nameSpace, Address entryPoint, AddressSetView body, SourceType source) throws InvalidInputException, OverlappingFunctionException {
        throw new UnsupportedOperationException();
    }

    public Function createThunkFunction(String name, Namespace nameSpace, Address entryPoint, AddressSetView body, Function thunkedFunction, SourceType source) throws OverlappingFunctionException {
        throw new UnsupportedOperationException();
    }

    public int getFunctionCount() {
        return 0;
    }

    public boolean removeFunction(Address entryPoint) {
        return false;
    }

    public Function getFunctionAt(Address entryPoint) {
        return null;
    }

    public Function getReferencedFunction(Address address) {
        return null;
    }

    public Function getFunctionContaining(Address addr) {
        return null;
    }

    public FunctionIterator getFunctions(boolean forward) {
        return this.getFunctions((AddressSetView)this.program.getAddressFactory().getAddressSet(), forward);
    }

    public FunctionIterator getFunctions(Address start, boolean forward) {
        return EmptyFunctionIterator.INSTANCE;
    }

    public FunctionIterator getFunctions(AddressSetView asv, boolean forward) {
        return EmptyFunctionIterator.INSTANCE;
    }

    public FunctionIterator getFunctionsNoStubs(boolean forward) {
        return EmptyFunctionIterator.INSTANCE;
    }

    public FunctionIterator getFunctionsNoStubs(Address start, boolean forward) {
        return EmptyFunctionIterator.INSTANCE;
    }

    public FunctionIterator getFunctionsNoStubs(AddressSetView asv, boolean forward) {
        return EmptyFunctionIterator.INSTANCE;
    }

    public FunctionIterator getExternalFunctions() {
        return EmptyFunctionIterator.INSTANCE;
    }

    public boolean isInFunction(Address addr) {
        return false;
    }

    public void moveAddressRange(Address fromAddr, Address toAddr, long length, TaskMonitor monitor) throws CancelledException {
        throw new UnsupportedOperationException();
    }

    public void deleteAddressRange(Address startAddr, Address endAddr, TaskMonitor monitor) throws CancelledException {
    }

    public void setProgram(ProgramDB program) {
        throw new UnsupportedOperationException();
    }

    public void programReady(int openMode, int currentRevision, TaskMonitor monitor) throws IOException, CancelledException {
        throw new UnsupportedOperationException();
    }

    public void invalidateCache(boolean all) {
    }

    public Iterator<Function> getFunctionsOverlapping(AddressSetView set) {
        return Collections.emptyIterator();
    }

    public Variable getReferencedVariable(Address instrAddr, Address storageAddr, int size, boolean isRead) {
        return null;
    }

    public Function getFunction(long key) {
        return null;
    }
}

