/*
 * Decompiled with CFR 0.152.
 */
package ghidra.trace.database.target.visitors;

import ghidra.dbg.util.PathPredicates;
import ghidra.trace.database.target.visitors.TreeTraversal;
import ghidra.trace.model.Lifespan;
import ghidra.trace.model.target.TraceObject;
import ghidra.trace.model.target.TraceObjectValPath;
import ghidra.trace.model.target.TraceObjectValue;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.stream.Stream;

public class CanonicalSuccessorsRelativeVisitor
implements TreeTraversal.Visitor {
    protected final PathPredicates predicates;
    protected final Set<TraceObject> seen = new HashSet<TraceObject>();

    public CanonicalSuccessorsRelativeVisitor(PathPredicates predicates) {
        this.predicates = predicates;
    }

    @Override
    public Lifespan composeSpan(Lifespan pre, TraceObjectValue value) {
        return Lifespan.ALL;
    }

    @Override
    public TraceObjectValPath composePath(TraceObjectValPath pre, TraceObjectValue value) {
        return pre == null ? TraceObjectValPath.of() : pre.append(value);
    }

    @Override
    public TreeTraversal.VisitResult visitValue(TraceObjectValue value, TraceObjectValPath path) {
        List<String> keyList = path.getKeyList();
        return TreeTraversal.VisitResult.result(this.predicates.matches(keyList), this.predicates.successorCouldMatch(keyList, true) && value.isObject());
    }

    @Override
    public TraceObject continueObject(TraceObjectValue value) {
        return value.isObject() ? value.getChild() : null;
    }

    protected TraceObjectValue getCanonicalValue(TraceObject parent, String key) {
        return parent.getOrderedValues(Lifespan.ALL, key, true).filter(TraceObjectValue::isCanonical).findFirst().orElse(null);
    }

    @Override
    public Stream<? extends TraceObjectValue> continueValues(TraceObject object, Lifespan span, TraceObjectValPath pre) {
        Set nextKeys = this.predicates.getNextKeys(pre.getKeyList());
        if (nextKeys.isEmpty()) {
            return Stream.empty();
        }
        Stream<Object> attrStream = nextKeys.contains("") ? object.getAttributes(span).stream().filter(TraceObjectValue::isCanonical) : Stream.empty();
        Stream<Object> elemStream = nextKeys.contains("[]") ? object.getElements(span).stream().filter(TraceObjectValue::isCanonical) : Stream.empty();
        Stream<TraceObjectValue> restStream = nextKeys.stream().filter(k -> !"".equals(k) && !"[]".equals(k)).map(k -> this.getCanonicalValue(object, (String)k)).filter(v -> v != null);
        return Stream.concat(Stream.concat(attrStream, elemStream), restStream);
    }
}

