/*
 * Decompiled with CFR 0.152.
 */
package docking.dnd;

import docking.dnd.GenericDataFlavor;
import ghidra.util.Msg;
import java.awt.datatransfer.Clipboard;
import java.awt.datatransfer.ClipboardOwner;
import java.awt.datatransfer.DataFlavor;
import java.awt.datatransfer.Transferable;
import java.awt.datatransfer.UnsupportedFlavorException;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;

public class GhidraTransferable
implements Transferable,
ClipboardOwner {
    public static DataFlavor localGhidraFlavor = GhidraTransferable.createLocalGhidraFlavor();
    private static DataFlavor[] flavors = new DataFlavor[]{localGhidraFlavor};
    private static List<DataFlavor> flavorList = Arrays.asList(flavors);
    private List<Object> dataList;

    private static DataFlavor createLocalGhidraFlavor() {
        try {
            return new GenericDataFlavor("application/x-java-jvm-local-objectref; class=java.util.ArrayList", "Local list of Drag/Drop User objects");
        }
        catch (Exception e) {
            Msg.showError(GhidraTransferable.class, null, null, null, (Throwable)e);
            return null;
        }
    }

    public GhidraTransferable(List<?> dataList) {
        this.dataList = new ArrayList(dataList);
    }

    @Override
    public synchronized DataFlavor[] getTransferDataFlavors() {
        return flavors;
    }

    @Override
    public boolean isDataFlavorSupported(DataFlavor f) {
        return flavorList.contains(f);
    }

    @Override
    public synchronized Object getTransferData(DataFlavor f) throws UnsupportedFlavorException, IOException {
        if (f.equals(localGhidraFlavor)) {
            return this.dataList;
        }
        throw new UnsupportedFlavorException(f);
    }

    public String toString() {
        return "GhidraTransferable";
    }

    @Override
    public void lostOwnership(Clipboard clipboard, Transferable contents) {
    }
}

