/*
 * Decompiled with CFR 0.152.
 */
package docking.widgets.fieldpanel.support;

import docking.widgets.fieldpanel.Layout;
import docking.widgets.fieldpanel.field.EmptyTextField;
import docking.widgets.fieldpanel.field.Field;
import docking.widgets.fieldpanel.internal.LayoutBackgroundColorManager;
import docking.widgets.fieldpanel.internal.LayoutBackgroundColorManagerAdapter;
import docking.widgets.fieldpanel.internal.PaintContext;
import docking.widgets.fieldpanel.support.FieldLocation;
import docking.widgets.fieldpanel.support.RowLayout;
import java.awt.Graphics;
import java.awt.Rectangle;
import java.util.ArrayList;
import javax.swing.JComponent;

public class MultiRowLayout
implements Layout {
    private RowLayout[] layouts;
    private int[] offsets;
    private int numFields;
    private int heightAbove;
    private int heightBelow;
    private int primaryOffset = -1;
    private int indexSize = 1;

    public MultiRowLayout(RowLayout layout, int indexSize) {
        this.indexSize = indexSize;
        this.numFields = layout.getNumFields();
        this.layouts = new RowLayout[1];
        this.layouts[0] = layout;
        this.heightAbove = this.layouts[0].getHeightAbove();
        this.heightBelow = this.layouts[0].getHeightBelow();
        this.buildOffsets();
    }

    public MultiRowLayout(RowLayout[] layouts, int indexSize) {
        this.indexSize = indexSize;
        this.layouts = layouts;
        int height = 0;
        for (RowLayout layout : layouts) {
            this.numFields += layout.getNumFields();
            height += layout.getHeight();
        }
        this.heightAbove = layouts[0].getHeightAbove();
        this.heightBelow = height - this.heightAbove;
        this.buildOffsets();
    }

    private void buildOffsets() {
        this.offsets = new int[this.layouts.length + 1];
        int soFar = 0;
        for (int i = 0; i < this.layouts.length; ++i) {
            this.offsets[i] = soFar;
            soFar += this.layouts[i].getNumFields();
        }
        this.offsets[this.layouts.length] = soFar;
    }

    @Override
    public int getHeight() {
        return this.heightAbove + this.heightBelow;
    }

    @Override
    public int getCompressableWidth() {
        int max = 0;
        for (RowLayout layout : this.layouts) {
            max = Math.max(max, layout.getCompressableWidth());
        }
        return max;
    }

    @Override
    public int getNumFields() {
        return this.numFields;
    }

    @Override
    public Field getField(int index) {
        for (int i = 0; i < this.layouts.length; ++i) {
            if (index >= this.offsets[i + 1]) continue;
            return this.layouts[i].getField(index - this.offsets[i]);
        }
        return null;
    }

    @Override
    public void paint(JComponent c, Graphics g, PaintContext context, Rectangle rect, LayoutBackgroundColorManager colorManager, FieldLocation cursorLocation) {
        int totalShift = 0;
        int offset = 0;
        LayoutBackgroundColorManagerAdapter shiftedColorManager = new LayoutBackgroundColorManagerAdapter(colorManager);
        for (int i = 0; i < this.layouts.length; ++i) {
            int shiftedFieldNum;
            g.translate(0, offset);
            totalShift += offset;
            rect.y -= offset;
            shiftedColorManager.setRange(this.offsets[i], this.offsets[i + 1], i == this.layouts.length - 1);
            FieldLocation shiftedCursorLocation = null;
            if (cursorLocation != null && (shiftedFieldNum = cursorLocation.fieldNum - this.offsets[i]) >= 0 && shiftedFieldNum < this.offsets[i + 1]) {
                shiftedCursorLocation = new FieldLocation(cursorLocation);
                shiftedCursorLocation.fieldNum = shiftedFieldNum;
            }
            this.layouts[i].paint(c, g, context, rect, shiftedColorManager, shiftedCursorLocation);
            offset = this.layouts[i].getHeight();
        }
        g.translate(0, -totalShift);
        rect.y += totalShift;
    }

    @Override
    public int setCursor(FieldLocation cursorLoc, int x, int y) {
        int offset = 0;
        for (int i = 0; i < this.layouts.length; ++i) {
            if (this.layouts[i].contains(y - offset)) {
                int lastX = this.layouts[i].setCursor(cursorLoc, x, y - offset);
                cursorLoc.fieldNum += this.offsets[i];
                return lastX;
            }
            offset += this.layouts[i].getHeight();
        }
        return this.layouts[0].setCursor(cursorLoc, x, y);
    }

    @Override
    public int getFieldIndex(int x, int y) {
        int offset = 0;
        for (int i = 0; i < this.layouts.length; ++i) {
            if (this.layouts[i].contains(y - offset)) {
                return this.layouts[i].getFieldIndex(x, y - offset) + this.offsets[i];
            }
            offset += this.layouts[i].getHeight();
        }
        return this.layouts[0].getFieldIndex(x, y);
    }

    @Override
    public Rectangle getCursorRect(int fieldNum, int row, int col) {
        int offset = 0;
        for (int i = 0; i < this.layouts.length; ++i) {
            if (fieldNum < this.offsets[i + 1]) {
                Rectangle rect = this.layouts[i].getCursorRect(fieldNum - this.offsets[i], row, col);
                if (rect != null) {
                    rect.y += offset;
                }
                return rect;
            }
            offset += this.layouts[i].getHeight();
        }
        return null;
    }

    @Override
    public boolean cursorUp(FieldLocation cursorLoc, int lastX) {
        int row = this.findRow(cursorLoc);
        cursorLoc.fieldNum -= this.offsets[row];
        boolean result = this.layouts[row].cursorUp(cursorLoc, lastX);
        cursorLoc.fieldNum += this.offsets[row];
        if (!result) {
            if (row == 0) {
                return false;
            }
            cursorLoc.fieldNum -= this.offsets[--row];
            result = this.layouts[row].enterLayout(cursorLoc, lastX, false);
            cursorLoc.fieldNum += this.offsets[row];
        }
        return result;
    }

    @Override
    public boolean cursorDown(FieldLocation cursorLoc, int lastX) {
        int row = this.findRow(cursorLoc);
        cursorLoc.fieldNum -= this.offsets[row];
        boolean result = this.layouts[row].cursorDown(cursorLoc, lastX);
        cursorLoc.fieldNum += this.offsets[row];
        if (!result) {
            if (row >= this.layouts.length - 1) {
                return false;
            }
            cursorLoc.fieldNum -= this.offsets[++row];
            result = this.layouts[row].enterLayout(cursorLoc, lastX, true);
            cursorLoc.fieldNum += this.offsets[row];
        }
        return result;
    }

    @Override
    public int cursorBeginning(FieldLocation cursorLoc) {
        int row = this.findRow(cursorLoc);
        cursorLoc.fieldNum -= this.offsets[row];
        int lastX = this.layouts[row].cursorBeginning(cursorLoc);
        cursorLoc.fieldNum += this.offsets[row];
        return lastX;
    }

    @Override
    public int cursorEnd(FieldLocation cursorLoc) {
        int row = this.findRow(cursorLoc);
        cursorLoc.fieldNum -= this.offsets[row];
        int lastX = this.layouts[row].cursorEnd(cursorLoc);
        cursorLoc.fieldNum += this.offsets[row];
        return lastX;
    }

    @Override
    public int cursorLeft(FieldLocation cursorLoc) {
        int row = this.findRow(cursorLoc);
        cursorLoc.fieldNum -= this.offsets[row];
        int returnVal = this.layouts[row].cursorLeft(cursorLoc);
        cursorLoc.fieldNum += this.offsets[row];
        if (returnVal < 0) {
            if (row == 0) {
                return -1;
            }
            cursorLoc.fieldNum -= this.offsets[--row];
            returnVal = this.layouts[row].cursorEnd(cursorLoc);
            cursorLoc.fieldNum += this.offsets[row];
        }
        return returnVal;
    }

    @Override
    public int cursorRight(FieldLocation cursorLoc) {
        int row = this.findRow(cursorLoc);
        cursorLoc.fieldNum -= this.offsets[row];
        int returnVal = this.layouts[row].cursorRight(cursorLoc);
        cursorLoc.fieldNum += this.offsets[row];
        if (returnVal < 0) {
            if (row >= this.layouts.length - 1) {
                return -1;
            }
            cursorLoc.fieldNum -= this.offsets[++row];
            returnVal = this.layouts[row].cursorBeginning(cursorLoc);
            cursorLoc.fieldNum += this.offsets[row];
        }
        return returnVal;
    }

    @Override
    public boolean enterLayout(FieldLocation cursorLoc, int lastX, boolean fromTop) {
        if (fromTop) {
            return this.layouts[0].enterLayout(cursorLoc, lastX, fromTop);
        }
        cursorLoc.fieldNum -= this.offsets[this.layouts.length - 1];
        boolean result = this.layouts[this.layouts.length - 1].enterLayout(cursorLoc, lastX, fromTop);
        cursorLoc.fieldNum += this.offsets[this.layouts.length - 1];
        return result;
    }

    @Override
    public int getScrollableUnitIncrement(int topOfScreen, int direction) {
        int searchPoint = topOfScreen;
        if (direction < 0) {
            --searchPoint;
        }
        int offset = 0;
        for (int i = 0; i < this.layouts.length - 1; ++i) {
            if (this.layouts[i].contains(searchPoint - offset)) {
                return this.layouts[i].getScrollableUnitIncrement(topOfScreen - offset, direction);
            }
            offset += this.layouts[i].getHeight();
        }
        return this.layouts[this.layouts.length - 1].getScrollableUnitIncrement(topOfScreen - offset, direction);
    }

    @Override
    public boolean contains(int yPos) {
        return yPos >= 0 && yPos < this.heightAbove + this.heightBelow;
    }

    private int findRow(FieldLocation loc) {
        for (int i = 0; i < this.layouts.length; ++i) {
            if (loc.fieldNum >= this.offsets[i + 1]) continue;
            return i;
        }
        return 0;
    }

    @Override
    public int getPrimaryOffset() {
        if (this.primaryOffset == -1) {
            this.findPrimaryOffset();
        }
        return this.primaryOffset;
    }

    private void findPrimaryOffset() {
        this.primaryOffset = 0;
        for (RowLayout layout : this.layouts) {
            if (layout.isPrimary()) {
                return;
            }
            this.primaryOffset += layout.getHeight();
        }
        this.primaryOffset = 0;
    }

    @Override
    public Rectangle getFieldBounds(int index) {
        int offset = 0;
        for (int i = 0; i < this.layouts.length; ++i) {
            if (index < this.offsets[i + 1]) {
                Rectangle rect = this.layouts[i].getFieldBounds(index - this.offsets[i]);
                rect.y += offset;
                return rect;
            }
            offset += this.layouts[i].getHeight();
        }
        return null;
    }

    @Override
    public void insertSpaceAbove(int size) {
        this.layouts[0].insertSpaceAbove(size);
        this.heightAbove += size;
    }

    @Override
    public void insertSpaceBelow(int size) {
        this.layouts[this.layouts.length - 1].insertSpaceBelow(size);
        this.heightBelow += size;
    }

    public void fillHeights(int[] rowHeights) {
        int lastId = -1;
        int height = 0;
        for (RowLayout layout : this.layouts) {
            int id = layout.getRowID();
            if (id == lastId) {
                height += layout.getHeight();
                continue;
            }
            if (lastId >= 0) {
                rowHeights[lastId] = Math.max(rowHeights[lastId], height);
            }
            lastId = id;
            height = layout.getHeight();
        }
        if (lastId >= 0) {
            rowHeights[lastId] = Math.max(rowHeights[lastId], height);
        }
    }

    public void align(int[] rowHeights) {
        int row = 0;
        ArrayList<RowLayout> updatedRows = new ArrayList<RowLayout>();
        for (RowLayout layout : this.layouts) {
            int id = layout.getRowID();
            while (row <= id) {
                if (rowHeights[row] != 0) {
                    if (row == id) {
                        layout.insertSpaceBelow(rowHeights[id] - layout.getHeight());
                        updatedRows.add(layout);
                    } else {
                        updatedRows.add(new EmptyRowLayout(row, rowHeights[row]));
                    }
                }
                ++row;
            }
        }
        while (row < rowHeights.length) {
            if (rowHeights[row] != 0) {
                updatedRows.add(new EmptyRowLayout(row, rowHeights[row]));
            }
            ++row;
        }
        int height = 0;
        this.layouts = new RowLayout[updatedRows.size()];
        for (int i = 0; i < this.layouts.length; ++i) {
            this.layouts[i] = (RowLayout)updatedRows.get(i);
            height += this.layouts[i].getHeight();
        }
        this.heightAbove = this.layouts[0].getHeightAbove();
        this.heightBelow = height - this.heightAbove;
        this.buildOffsets();
    }

    @Override
    public int getIndexSize() {
        return this.indexSize;
    }

    @Override
    public int getBeginRowFieldNum(int fieldIndex) {
        for (int i = 0; i < this.layouts.length; ++i) {
            if (fieldIndex >= this.offsets[i + 1]) continue;
            return this.offsets[i];
        }
        return this.offsets[this.layouts.length - 1];
    }

    @Override
    public int getEndRowFieldNum(int fieldIndex) {
        for (int i = 0; i < this.layouts.length; ++i) {
            if (fieldIndex >= this.offsets[i + 1]) continue;
            return this.offsets[i + 1];
        }
        return this.offsets[this.layouts.length];
    }

    public int getFirstRowID() {
        return this.layouts[0].getRowID();
    }

    private class EmptyRowLayout
    extends RowLayout {
        public EmptyRowLayout(int rowId, int height) {
            super(EmptyRowLayout.getEmptyFields(height), rowId);
        }

        private static Field[] getEmptyFields(int height) {
            return new Field[]{new EmptyTextField(height, 0, 0, 0)};
        }
    }
}

