/*
 * Decompiled with CFR 0.152.
 */
package docking.widgets.table;

import docking.widgets.table.AbstractSortedTableModel;
import docking.widgets.table.ColumnSortState;
import docking.widgets.table.GTableHeader;
import docking.widgets.table.RowObjectFilterModel;
import docking.widgets.table.SortedTableModel;
import docking.widgets.table.TableFilter;
import docking.widgets.table.TableSortState;
import docking.widgets.table.VariableColumnTableModel;
import generic.theme.GColor;
import generic.theme.GIcon;
import generic.theme.Gui;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Insets;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.font.TextAttribute;
import java.text.AttributedString;
import javax.swing.Icon;
import javax.swing.JLabel;
import javax.swing.JTable;
import javax.swing.SwingUtilities;
import javax.swing.border.Border;
import javax.swing.table.DefaultTableCellRenderer;
import javax.swing.table.JTableHeader;
import javax.swing.table.TableCellRenderer;
import javax.swing.table.TableModel;
import resources.Icons;
import resources.MultiIcon;
import resources.ResourceManager;
import resources.icons.EmptyIcon;
import resources.icons.TranslateIcon;

public class GTableHeaderRenderer
extends DefaultTableCellRenderer {
    private static final Color SORT_NUMBER_FG_COLOR = new GColor("color.fg");
    private static final int PADDING_FOR_COLUMN_NUMBER = 8;
    private static final Icon UP_ICON = ResourceManager.getScaledIcon((Icon)Icons.SORT_ASCENDING_ICON, (int)14, (int)14);
    private static final Icon DOWN_ICON = ResourceManager.getScaledIcon((Icon)Icons.SORT_DESCENDING_ICON, (int)14, (int)14);
    private static final int DEFAULT_MIN_HEIGHT = UP_ICON.getIconHeight();
    private static final Icon EMPTY_ICON = new EmptyIcon(0, 0);
    private static final Icon FILTER_ICON = ResourceManager.getScaledIcon((Icon)new GIcon("icon.widget.filterpanel.filter.off"), (int)12, (int)12);
    private static final Icon PENDING_ICON = new GIcon("icon.widget.table.header.pending");
    private Icon primaryIcon = EMPTY_ICON;
    private Icon helpIcon = EMPTY_ICON;
    protected boolean isPaintingPrimarySortColumn;
    private Component rendererComponent;

    @Override
    public Component getTableCellRendererComponent(JTable table, Object value, boolean isSelected, boolean hasFocus, int row, int column) {
        if (table == null) {
            return this;
        }
        JTableHeader header = table.getTableHeader();
        TableCellRenderer delegate = header.getDefaultRenderer();
        this.rendererComponent = delegate.getTableCellRendererComponent(table, value, isSelected, hasFocus, row, column);
        int modelIndex = table.convertColumnIndexToModel(column);
        TableModel model = table.getModel();
        VariableColumnTableModel variableModel = VariableColumnTableModel.from(model);
        if (variableModel != null) {
            String text = variableModel.getColumnDisplayName(modelIndex);
            if (this.rendererComponent instanceof JLabel) {
                ((JLabel)this.rendererComponent).setText(text);
            }
        }
        this.primaryIcon = this.getIcon(model, modelIndex);
        this.helpIcon = this.getHelpIcon(table, column);
        return this;
    }

    @Override
    public void setBounds(int x, int y, int w, int h) {
        super.setBounds(x, y, w, h);
        this.rendererComponent.setBounds(x, y, w, h);
    }

    @Override
    public void paint(Graphics g) {
        this.updateClipping();
        this.rendererComponent.paint(g);
        super.paint(g);
    }

    private void updateClipping() {
        Component component = this.rendererComponent;
        if (!(component instanceof JLabel)) {
            return;
        }
        JLabel label = (JLabel)component;
        String text = label.getText();
        String clippedText = this.checkForClipping(label, text);
        if (!text.equals(clippedText)) {
            label.setText(clippedText);
            this.setToolTipText(text);
        }
    }

    private String checkForClipping(JLabel label, String text) {
        Point helpPoint = this.getHelpIconLocation();
        int padding = 5;
        int iconWidth = this.primaryIcon.getIconWidth();
        if (iconWidth == 0) {
            padding = 0;
        }
        int iconStartX = helpPoint.x - iconWidth - padding;
        FontMetrics metrics = label.getFontMetrics(label.getFont());
        Rectangle bounds = label.getBounds();
        int availableTextWidth = iconStartX - padding;
        Rectangle viewBounds = new Rectangle(0, 0, availableTextWidth, bounds.height);
        Rectangle iconResult = new Rectangle();
        Rectangle textResult = new Rectangle();
        String clippedText = SwingUtilities.layoutCompoundLabel(label, metrics, text, this.primaryIcon, label.getVerticalAlignment(), label.getHorizontalAlignment(), label.getVerticalTextPosition(), label.getHorizontalTextPosition(), viewBounds, iconResult, textResult, label.getIconTextGap());
        return clippedText;
    }

    @Override
    protected void paintChildren(Graphics g) {
        Point helpPoint = this.getHelpIconLocation();
        int offset = 4;
        int x = helpPoint.x - this.primaryIcon.getIconWidth() - offset;
        int y = this.getIconStartY(this.primaryIcon.getIconHeight());
        this.primaryIcon.paintIcon(this, g, x, y);
        this.helpIcon.paintIcon(this, g, helpPoint.x, helpPoint.y);
    }

    private Point getHelpIconLocation() {
        int right = this.getWidth();
        int offset = 2;
        int helpIconWidth = 8;
        int x = right - helpIconWidth - offset;
        int y = offset;
        return new Point(x, y);
    }

    @Override
    public Dimension getPreferredSize() {
        Dimension preferredSize = super.getPreferredSize();
        if (this.rendererComponent != null) {
            return this.rendererComponent.getPreferredSize();
        }
        Border currentBorder = this.getBorder();
        int minHeight = DEFAULT_MIN_HEIGHT;
        if (currentBorder != null) {
            Insets borderInsets = currentBorder.getBorderInsets(this);
            minHeight += borderInsets.top + borderInsets.bottom;
        }
        preferredSize.height = Math.max(preferredSize.height, minHeight);
        return preferredSize;
    }

    private Icon getIcon(TableModel model, int columnModelIndex) {
        Icon icon = null;
        if (model instanceof SortedTableModel) {
            icon = this.getSortIcon(icon, columnModelIndex, model);
        }
        if (this.isColumnFiltered(model, columnModelIndex)) {
            icon = this.combineIcons(FILTER_ICON, icon);
        }
        if (icon != null) {
            return icon;
        }
        return EMPTY_ICON;
    }

    private Icon combineIcons(Icon icon1, Icon icon2) {
        if (icon1 == null) {
            return icon2;
        }
        if (icon2 == null) {
            return icon1;
        }
        int padding = 2;
        int w1 = icon1.getIconWidth();
        int w2 = icon2.getIconWidth();
        int h1 = icon1.getIconHeight();
        int fullWidth = w1 + padding + w2;
        MultiIcon icon = new MultiIcon((Icon)new EmptyIcon(fullWidth, h1));
        icon.addIcon(icon1);
        int rightShift = w1 + padding;
        icon.addIcon((Icon)new TranslateIcon(icon2, rightShift, 0));
        return icon;
    }

    private boolean isColumnFiltered(TableModel model, int columnModelIndex) {
        if (!(model instanceof RowObjectFilterModel)) {
            return false;
        }
        RowObjectFilterModel filterModel = (RowObjectFilterModel)model;
        TableFilter tableFilter = filterModel.getTableFilter();
        if (tableFilter == null) {
            return false;
        }
        return tableFilter.hasColumnFilter(columnModelIndex);
    }

    private Icon getHelpIcon(JTable table, int currentColumnIndex) {
        JTableHeader tableHeader = table.getTableHeader();
        if (!(tableHeader instanceof GTableHeader)) {
            return EMPTY_ICON;
        }
        GTableHeader tooltipTableHeader = (GTableHeader)tableHeader;
        int hoveredColumnIndex = tooltipTableHeader.getHoveredHeaderColumnIndex();
        if (hoveredColumnIndex != currentColumnIndex) {
            return EMPTY_ICON;
        }
        Icon icon = tooltipTableHeader.getHelpIcon();
        if (icon != null) {
            return icon;
        }
        return EMPTY_ICON;
    }

    private Icon getSortIcon(Icon icon, int realIndex, TableModel model) {
        TableSortState pendingTableState;
        ColumnSortState pendingColumnState;
        AbstractSortedTableModel abstractSortedModel;
        SortedTableModel sortedModel = (SortedTableModel)model;
        TableSortState columnSortStates = sortedModel.getTableSortState();
        boolean sortPending = false;
        if (model instanceof AbstractSortedTableModel && (sortPending = (abstractSortedModel = (AbstractSortedTableModel)model).isSortPending()) && (pendingColumnState = (pendingTableState = abstractSortedModel.getPendingSortState()).getColumnSortState(realIndex)) != null) {
            return this.getColumnIconForSortState(columnSortStates, pendingColumnState, true);
        }
        ColumnSortState sortState = columnSortStates.getColumnSortState(realIndex);
        if (sortState == null) {
            return null;
        }
        icon = this.getColumnIconForSortState(columnSortStates, sortState, false);
        if (sortPending) {
            icon = ResourceManager.getDisabledIcon((Icon)icon, (int)65);
        }
        return icon;
    }

    private Icon getColumnIconForSortState(TableSortState columnSortStates, ColumnSortState sortState, boolean isPendingSort) {
        Icon icon;
        Icon icon2 = icon = sortState.isAscending() ? UP_ICON : DOWN_ICON;
        if (columnSortStates.getSortedColumnCount() != 1) {
            MultiIcon multiIcon = new MultiIcon(icon);
            int sortOrder = sortState.getSortOrder();
            if (sortOrder == 1) {
                this.isPaintingPrimarySortColumn = true;
            }
            String numberString = Integer.toString(sortOrder);
            multiIcon.addIcon((Icon)new NumberPainterIcon(icon.getIconWidth() + 8, icon.getIconHeight(), numberString));
            icon = multiIcon;
        } else {
            this.isPaintingPrimarySortColumn = true;
        }
        if (isPendingSort) {
            icon = PENDING_ICON;
        }
        return icon;
    }

    private int getIconStartY(int iconHeight) {
        int height = this.getHeight();
        int middle = height / 2;
        int halfHeight = iconHeight / 2;
        int y = middle - halfHeight;
        return y;
    }

    private class NumberPainterIcon
    implements Icon {
        private static final String FONT_ID = "font.table.header.number";
        private final int iconWidth;
        private int numberWidth;
        private final int iconHeight;
        private final String numberText;

        public NumberPainterIcon(int width, int height, String numberText) {
            this.iconWidth = width;
            this.iconHeight = height;
            this.numberText = numberText;
            Font font = Gui.getFont((String)FONT_ID);
            FontMetrics fontMetrics = GTableHeaderRenderer.this.getFontMetrics(font);
            this.numberWidth = fontMetrics.stringWidth(numberText);
        }

        @Override
        public int getIconHeight() {
            return this.iconHeight;
        }

        @Override
        public int getIconWidth() {
            return this.iconWidth + this.numberWidth;
        }

        @Override
        public void paintIcon(Component c, Graphics g, int x, int y) {
            Font font = Gui.getFont((String)FONT_ID);
            g.setFont(font);
            FontMetrics fontMetrics = g.getFontMetrics();
            int numberHeight = fontMetrics.getAscent();
            int padding = 2;
            int startX = x + (this.iconWidth - this.numberWidth) + padding;
            int iconY = GTableHeaderRenderer.this.getIconStartY(this.iconHeight);
            int textBaseline = iconY + numberHeight - padding;
            AttributedString as = new AttributedString(this.numberText);
            as.addAttribute(TextAttribute.FOREGROUND, SORT_NUMBER_FG_COLOR);
            as.addAttribute(TextAttribute.WEIGHT, TextAttribute.WEIGHT_BOLD);
            as.addAttribute(TextAttribute.FAMILY, font.getFamily());
            as.addAttribute(TextAttribute.SIZE, Float.valueOf(font.getSize2D()));
            g.drawString(as.getIterator(), startX, textBaseline);
        }
    }
}

