/*
 * Decompiled with CFR 0.152.
 */
package docking.widgets.tree;

import docking.widgets.filter.FilterOptions;
import docking.widgets.filter.TermSplitter;
import docking.widgets.filter.TextFilter;
import docking.widgets.tree.GTreeNode;
import docking.widgets.tree.InvertedTreeFilter;
import docking.widgets.tree.MultiTextFilterTreeFilter;
import docking.widgets.tree.TreeTextFilter;
import docking.widgets.tree.support.GTreeFilter;
import ghidra.util.FilterTransformer;
import java.util.ArrayList;
import java.util.List;
import javax.swing.Icon;
import javax.swing.tree.TreePath;

public class GTreeFilterFactory {
    private FilterOptions filterOptions;

    public GTreeFilterFactory() {
        this(new FilterOptions());
    }

    public GTreeFilterFactory(FilterOptions filterOptions) {
        this.filterOptions = filterOptions;
    }

    public FilterOptions getFilterOptions() {
        return this.filterOptions;
    }

    public GTreeFilter getTreeFilter(String text, FilterTransformer<GTreeNode> transformer) {
        GTreeFilter treeFilter = this.getBaseFilter(text, transformer);
        if (this.filterOptions.isInverted() && treeFilter != null) {
            treeFilter = new InvertedTreeFilter(treeFilter);
        }
        return treeFilter;
    }

    private GTreeFilter getBaseFilter(String text, FilterTransformer<GTreeNode> clientTransformer) {
        PrependPathWrappingTransformer transformer = clientTransformer;
        if (this.filterOptions.shouldUsePath()) {
            transformer = new PrependPathWrappingTransformer(clientTransformer);
        }
        if (this.filterOptions.isMultiterm() && text.trim().length() > 0) {
            return this.getMultiWordFilter(text, transformer);
        }
        TextFilter textFilter = this.filterOptions.getTextFilterFactory().getTextFilter(text);
        if (textFilter != null) {
            return new TreeTextFilter(textFilter, transformer);
        }
        return null;
    }

    private GTreeFilter getMultiWordFilter(String text, FilterTransformer<GTreeNode> transformer) {
        ArrayList<TextFilter> filters = new ArrayList<TextFilter>();
        TermSplitter splitter = this.filterOptions.getTermSplitter();
        for (String term : splitter.split(text)) {
            TextFilter textFilter = this.filterOptions.getTextFilterFactory().getTextFilter(term);
            if (textFilter == null) continue;
            filters.add(textFilter);
        }
        return new MultiTextFilterTreeFilter(filters, transformer, this.filterOptions.getMultitermEvaluationMode());
    }

    public Icon getFilterStateIcon() {
        return this.filterOptions.getFilterStateIcon();
    }

    private class PrependPathWrappingTransformer
    implements FilterTransformer<GTreeNode> {
        private ThreadLocal<List<String>> localizedResults = new ThreadLocal<List<String>>(){

            @Override
            protected List<String> initialValue() {
                return new ArrayList<String>();
            }
        };
        private FilterTransformer<GTreeNode> delegate;

        PrependPathWrappingTransformer(FilterTransformer<GTreeNode> delegate) {
            this.delegate = delegate;
        }

        public List<String> transform(GTreeNode t) {
            List<String> results = this.localizedResults.get();
            results.clear();
            TreePath treePath = t.getTreePath();
            Object[] elements = treePath.getPath();
            StringBuilder buffy = new StringBuilder();
            int n = elements.length - 1;
            for (int i = 0; i < n; ++i) {
                GTreeNode node = (GTreeNode)elements[i];
                buffy.append(node.getDisplayText()).append('/');
            }
            String parentPath = buffy.toString();
            List delegateFilters = this.delegate.transform((Object)t);
            for (String filterPiece : delegateFilters) {
                results.add(parentPath + filterPiece);
            }
            return results;
        }
    }
}

