/*
 * Decompiled with CFR 0.152.
 */
package docking.widgets.tree.support;

import docking.widgets.tree.GTreeNode;
import docking.widgets.tree.support.DirectoryNode;
import docking.widgets.tree.support.FileData;
import docking.widgets.tree.support.GTreeDragNDropHandler;
import ghidra.util.Msg;
import java.awt.datatransfer.DataFlavor;
import java.awt.datatransfer.Transferable;
import java.awt.datatransfer.UnsupportedFlavorException;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;

class DragNDropHandler
implements GTreeDragNDropHandler {
    public static DataFlavor[] supportedFlavors = new DataFlavor[]{DataFlavor.stringFlavor, DataFlavor.javaFileListFlavor};

    DragNDropHandler() {
    }

    @Override
    public void drop(GTreeNode destUserData, Transferable transferable, int dropAction) {
        Msg.info((Object)this, (Object)("Dropped the following Files onto " + destUserData));
        try {
            List list = (List)transferable.getTransferData(DataFlavor.javaFileListFlavor);
            Iterator it = list.iterator();
            while (it.hasNext()) {
                Msg.info((Object)this, (Object)("\t" + it.next()));
            }
        }
        catch (UnsupportedFlavorException unsupportedFlavorException) {
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    @Override
    public DataFlavor[] getSupportedDataFlavors(List<GTreeNode> dragUserData) {
        return supportedFlavors;
    }

    @Override
    public int getSupportedDragActions() {
        return 1;
    }

    @Override
    public Object getTransferData(List<GTreeNode> dragUserData, DataFlavor flavor) {
        if (flavor.equals(DataFlavor.javaFileListFlavor)) {
            ArrayList<File> fileList = new ArrayList<File>();
            for (GTreeNode node : dragUserData) {
                FileData fileData = (FileData)((Object)node);
                fileList.add(fileData.getFile());
            }
            return fileList;
        }
        if (flavor.equals(DataFlavor.stringFlavor)) {
            StringBuffer buf = new StringBuffer();
            Iterator<GTreeNode> it = dragUserData.iterator();
            while (it.hasNext()) {
                buf.append(((Object)it.next()).toString());
                buf.append("\n");
            }
            return buf.toString();
        }
        return null;
    }

    @Override
    public boolean isDropSiteOk(GTreeNode destUserData, DataFlavor[] flavors, int dropAction) {
        if (this.containsFlavor(flavors, DataFlavor.javaFileListFlavor)) {
            return destUserData instanceof DirectoryNode;
        }
        return false;
    }

    private boolean containsFlavor(DataFlavor[] flavors, DataFlavor flavor) {
        for (DataFlavor flavor2 : flavors) {
            if (!flavor2.equals(flavor)) continue;
            return true;
        }
        return false;
    }

    @Override
    public boolean isStartDragOk(List<GTreeNode> dragUserData, int dragAction) {
        return true;
    }
}

