/*
 * Decompiled with CFR 0.152.
 */
package docking.widgets.tree.tasks;

import docking.widgets.tree.GTree;
import docking.widgets.tree.GTreeTask;
import docking.widgets.tree.internal.GTreeSelectionModel;
import docking.widgets.tree.support.GTreeSelectionEvent;
import ghidra.util.task.TaskMonitor;
import java.util.ArrayList;
import java.util.List;
import javax.swing.JTree;
import javax.swing.tree.TreePath;

public class GTreeSelectPathsTask
extends GTreeTask {
    private final GTreeSelectionEvent.EventOrigin origin;
    private boolean expandingDisabled;
    private final List<TreePath> paths;

    public GTreeSelectPathsTask(GTree gtree, JTree tree, List<TreePath> paths, GTreeSelectionEvent.EventOrigin origin) {
        super(gtree);
        this.origin = origin;
        this.paths = paths;
    }

    public void setExpandingDisabled(boolean disabled) {
        this.expandingDisabled = disabled;
    }

    public void run(TaskMonitor monitor) {
        monitor.setMessage("Selecting paths");
        monitor.initialize((long)this.paths.size());
        ArrayList<TreePath> translatedPaths = new ArrayList<TreePath>();
        for (TreePath path : this.paths) {
            if (monitor.isCancelled()) {
                return;
            }
            TreePath xPath = this.translatePath(path, monitor);
            if (xPath != null) {
                translatedPaths.add(xPath);
            }
            monitor.incrementProgress(1L);
        }
        this.selectPaths(translatedPaths.toArray(new TreePath[translatedPaths.size()]), monitor);
    }

    private void selectPaths(TreePath[] treePaths, TaskMonitor monitor) {
        this.runOnSwingThread(() -> {
            if (monitor.isCancelled()) {
                return;
            }
            boolean wasEnabled = this.jTree.getExpandsSelectedPaths();
            if (this.expandingDisabled) {
                this.jTree.setExpandsSelectedPaths(false);
            }
            try {
                this.doSelectPaths(treePaths);
            }
            finally {
                if (this.expandingDisabled) {
                    this.jTree.setExpandsSelectedPaths(wasEnabled);
                }
            }
        });
    }

    private void doSelectPaths(TreePath[] treePaths) {
        GTreeSelectionModel selectionModel = this.tree.getGTSelectionModel();
        selectionModel.setSelectionPaths(treePaths, this.origin);
        if (treePaths != null && treePaths.length > 0) {
            this.jTree.scrollPathToVisible(treePaths[treePaths.length - 1]);
        }
    }
}

