/*
 * Decompiled with CFR 0.152.
 */
package ghidra.util.task;

import docking.DialogComponentProvider;
import docking.DockingWindowManager;
import docking.widgets.OptionDialog;
import ghidra.util.HelpLocation;
import ghidra.util.Msg;
import ghidra.util.Swing;
import ghidra.util.exception.CancelledException;
import ghidra.util.task.CancelledListener;
import ghidra.util.task.ChompingBitsAnimationPanel;
import ghidra.util.task.SwingUpdateManager;
import ghidra.util.task.Task;
import ghidra.util.task.TaskMonitor;
import ghidra.util.task.TaskMonitorComponent;
import ghidra.util.timer.GTimer;
import ghidra.util.timer.GTimerMonitor;
import java.awt.BorderLayout;
import java.awt.Component;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicReference;
import javax.swing.JPanel;

public class TaskDialog
extends DialogComponentProvider
implements TaskMonitor {
    private static final int MAX_DELAY = 200000;
    public static final int DEFAULT_WIDTH = 275;
    private Runnable closeDialog = () -> {
        this.close();
        this.cleanup();
    };
    private Runnable verifyCancel = () -> {
        if (this.promptToVerifyCancel()) {
            this.internalCancel();
        }
    };
    private GTimerMonitor showTimer = GTimerMonitor.DUMMY;
    private CountDownLatch finished;
    private boolean supportsProgress;
    private JPanel mainPanel;
    private JPanel activityPanel;
    private TaskMonitorComponent monitorComponent;
    private Component centerOnComponent;
    private AtomicReference<String> newMessage = new AtomicReference();
    private SwingUpdateManager messageUpdater = new SwingUpdateManager(100, 250, () -> this.setStatusText(this.newMessage.getAndSet(null)));
    private AtomicBoolean shown = new AtomicBoolean();

    TaskDialog(Component centerOnComp, Task task, CountDownLatch finished) {
        this(centerOnComp, task.getTaskTitle(), task.isModal(), task.canCancel(), task.hasProgress(), finished);
    }

    public TaskDialog(Task task) {
        this(task.getTaskTitle(), task.canCancel(), task.isModal(), task.hasProgress());
    }

    public TaskDialog(String title, boolean canCancel, boolean isModal, boolean hasProgress) {
        this(title, isModal, canCancel, hasProgress, new CountDownLatch(1));
    }

    public TaskDialog(String title, boolean canCancel, boolean isModal, boolean hasProgress, CountDownLatch finished) {
        this(null, title, isModal, canCancel, hasProgress, finished);
    }

    private TaskDialog(Component centerOnComp, String title, boolean isModal, boolean canCancel, boolean hasProgress, CountDownLatch finished) {
        super(title, isModal, true, canCancel, true);
        this.centerOnComponent = centerOnComp;
        this.supportsProgress = hasProgress;
        this.finished = finished;
        this.setup(canCancel);
    }

    private void setup(boolean canCancel) {
        this.monitorComponent = new TaskMonitorComponent(false, false);
        this.activityPanel = new ChompingBitsAnimationPanel();
        this.setCancelEnabled(canCancel);
        this.setRememberLocation(false);
        this.setRememberSize(false);
        this.setTransient(true);
        this.mainPanel = new JPanel(new BorderLayout());
        this.addWorkPanel(this.mainPanel);
        if (this.supportsProgress) {
            this.installProgressMonitor();
        } else {
            this.installActivityDisplay();
        }
        if (canCancel) {
            this.addCancelButton();
        }
        this.setHelpLocation(new HelpLocation("Tool", "TaskDialog"));
    }

    private boolean promptToVerifyCancel() {
        boolean userSaysYes = OptionDialog.showYesNoDialog(this.getComponent(), "Cancel?", "Do you really want to cancel \"" + this.getTitle() + "\"?") == 1;
        return userSaysYes;
    }

    private boolean isInstalled(Component c) {
        Component[] components;
        for (Component component : components = this.mainPanel.getComponents()) {
            if (c != component) continue;
            return true;
        }
        return false;
    }

    private void installProgressMonitor() {
        Swing.runIfSwingOrRunLater(() -> {
            if (this.isInstalled(this.monitorComponent)) {
                return;
            }
            this.mainPanel.removeAll();
            this.mainPanel.add((Component)this.monitorComponent, "Center");
            this.repack();
        });
    }

    private void installActivityDisplay() {
        Swing.runIfSwingOrRunLater(() -> {
            if (this.isInstalled(this.activityPanel)) {
                return;
            }
            this.mainPanel.removeAll();
            this.mainPanel.add((Component)this.activityPanel, "Center");
            this.repack();
        });
    }

    @Override
    protected void cancelCallback() {
        Swing.runLater((Runnable)this.verifyCancel);
    }

    @Override
    public void setCancelEnabled(boolean enable) {
        this.monitorComponent.setCancelEnabled(enable);
        Swing.runLater(() -> super.setCancelEnabled(enable));
    }

    @Override
    public boolean isCancelEnabled() {
        return this.monitorComponent.isCancelEnabled();
    }

    public void taskProcessed() {
        this.finished.countDown();
        Swing.runLater((Runnable)this.closeDialog);
    }

    public boolean isCompleted() {
        return this.finished.getCount() == 0L || this.isCancelled();
    }

    public void show(int delay) {
        if (delay < 0) {
            throw new IllegalArgumentException("Task Dialog delay cannot be negative");
        }
        if (this.isModal()) {
            this.doShowModal(delay);
        } else {
            this.doShowNonModal(delay);
        }
    }

    public boolean wasShown() {
        return this.shown.get();
    }

    private void doShowModal(int delay) {
        this.giveTheTaskThreadAChanceToComplete(delay);
        if (this.isCompleted()) {
            return;
        }
        this.doShow();
    }

    private void doShowNonModal(int delay) {
        int waitTime = Math.min(delay, 200000);
        this.showTimer = GTimer.scheduleRunnable((long)waitTime, () -> {
            if (this.isCompleted()) {
                return;
            }
            this.doShow();
        });
    }

    protected void doShow() {
        Swing.runIfSwingOrRunLater(() -> {
            if (!this.isCompleted()) {
                this.shown.set(true);
                DockingWindowManager.showDialog(this.centerOnComponent, this);
            }
        });
    }

    private void giveTheTaskThreadAChanceToComplete(int delay) {
        int waitTime = Math.min(delay, 200000);
        try {
            this.finished.await(waitTime, TimeUnit.MILLISECONDS);
        }
        catch (InterruptedException e) {
            Msg.debug((Object)this, (Object)("Interrupted waiting for task '" + this.getTitle() + "'"), (Throwable)e);
        }
    }

    @Override
    public void dispose() {
        this.internalCancel();
        super.dispose();
    }

    private void cleanup() {
        this.showTimer.cancel();
        this.messageUpdater.dispose();
    }

    public void setMessage(String str) {
        this.newMessage.set(str);
        this.messageUpdater.update();
    }

    public String getMessage() {
        return this.getStatusText();
    }

    public void setShowProgressValue(boolean showProgressValue) {
        this.monitorComponent.setShowProgressValue(showProgressValue);
    }

    public void setProgress(long progress) {
        this.monitorComponent.setProgress(progress);
    }

    public void initialize(long max) {
        if (max <= 0L) {
            return;
        }
        this.monitorComponent.initialize(max);
        if (!this.supportsProgress) {
            this.supportsProgress = true;
            this.setIndeterminate(false);
        }
        this.installProgressMonitor();
    }

    public void setMaximum(long max) {
        this.monitorComponent.setMaximum(max);
    }

    public long getMaximum() {
        return this.monitorComponent.getMaximum();
    }

    public void setIndeterminate(boolean indeterminate) {
        this.supportsProgress = !indeterminate;
        this.monitorComponent.setIndeterminate(indeterminate);
        if (this.supportsProgress) {
            this.installProgressMonitor();
        } else {
            this.installActivityDisplay();
        }
    }

    public boolean isIndeterminate() {
        return this.monitorComponent.isIndeterminate();
    }

    public boolean isCancelled() {
        return this.monitorComponent.isCancelled();
    }

    public synchronized void cancel() {
        this.internalCancel();
    }

    private void internalCancel() {
        if (this.monitorComponent.isCancelled()) {
            return;
        }
        this.monitorComponent.cancel();
    }

    public synchronized void clearCanceled() {
        this.monitorComponent.clearCancelled();
    }

    public void checkCanceled() throws CancelledException {
        this.monitorComponent.checkCancelled();
    }

    public void incrementProgress(long incrementAmount) {
        this.monitorComponent.incrementProgress(incrementAmount);
    }

    public long getProgress() {
        return this.monitorComponent.getProgress();
    }

    public void addCancelledListener(CancelledListener listener) {
        this.monitorComponent.addCancelledListener(listener);
    }

    public void removeCancelledListener(CancelledListener listener) {
        this.monitorComponent.removeCancelledListener(listener);
    }
}

