/*
 * Decompiled with CFR 0.152.
 */
package ghidra.pcode.exec;

import ghidra.pcode.exec.AbstractLongOffsetPcodeExecutorStatePiece;
import ghidra.pcode.exec.AccessPcodeExecutionException;
import ghidra.pcode.exec.BytesPcodeArithmetic;
import ghidra.pcode.exec.BytesPcodeExecutorStateSpace;
import ghidra.pcode.exec.PcodeArithmetic;
import ghidra.pcode.exec.PcodeExecutorStatePiece;
import ghidra.program.model.address.Address;
import ghidra.program.model.address.AddressSpace;
import ghidra.program.model.lang.Language;
import ghidra.program.model.lang.Register;
import ghidra.program.model.mem.MemBuffer;
import ghidra.program.model.mem.MemBufferMixin;
import ghidra.program.model.mem.Memory;
import ghidra.util.Msg;
import java.nio.ByteBuffer;
import java.util.List;
import java.util.Map;

public abstract class AbstractBytesPcodeExecutorStatePiece<S extends BytesPcodeExecutorStateSpace<?>>
extends AbstractLongOffsetPcodeExecutorStatePiece<byte[], byte[], S> {
    protected final AbstractLongOffsetPcodeExecutorStatePiece.AbstractSpaceMap<S> spaceMap;

    public AbstractBytesPcodeExecutorStatePiece(Language language) {
        this(language, BytesPcodeArithmetic.forLanguage(language));
    }

    protected AbstractBytesPcodeExecutorStatePiece(Language language, AbstractLongOffsetPcodeExecutorStatePiece.AbstractSpaceMap<S> spaceMap) {
        this(language, BytesPcodeArithmetic.forLanguage(language), spaceMap);
    }

    public AbstractBytesPcodeExecutorStatePiece(Language language, PcodeArithmetic<byte[]> arithmetic) {
        super(language, arithmetic, arithmetic);
        this.spaceMap = this.newSpaceMap();
    }

    protected AbstractBytesPcodeExecutorStatePiece(Language language, PcodeArithmetic<byte[]> arithmetic, AbstractLongOffsetPcodeExecutorStatePiece.AbstractSpaceMap<S> spaceMap) {
        super(language, arithmetic, arithmetic);
        this.spaceMap = spaceMap;
    }

    protected abstract AbstractLongOffsetPcodeExecutorStatePiece.AbstractSpaceMap<S> newSpaceMap();

    @Override
    protected S getForSpace(AddressSpace space, boolean toWrite) {
        return (S)((BytesPcodeExecutorStateSpace)this.spaceMap.getForSpace(space, toWrite));
    }

    @Override
    protected void setInSpace(S space, long offset, int size, byte[] val) {
        if (val.length > size) {
            throw new IllegalArgumentException("Value is larger than variable: " + val.length + " > " + size);
        }
        if (val.length < size) {
            Msg.warn((Object)this, (Object)("Value is smaller than variable: " + val.length + " < " + size + ". Zero extending"));
            val = this.arithmetic.unaryOp(17, size, val.length, val);
        }
        ((BytesPcodeExecutorStateSpace)space).write(offset, val, 0, size);
    }

    @Override
    protected byte[] getFromSpace(S space, long offset, int size, PcodeExecutorStatePiece.Reason reason) {
        byte[] read = ((BytesPcodeExecutorStateSpace)space).read(offset, size, reason);
        if (read.length != size) {
            throw new AccessPcodeExecutionException("Incomplete read (" + read.length + " of " + size + " bytes)");
        }
        return read;
    }

    @Override
    protected Map<Register, byte[]> getRegisterValuesFromSpace(S s, List<Register> registers) {
        return ((BytesPcodeExecutorStateSpace)s).getRegisterValues(registers);
    }

    @Override
    public MemBuffer getConcreteBuffer(Address address, PcodeArithmetic.Purpose purpose) {
        return new StateMemBuffer(address, (BytesPcodeExecutorStateSpace<?>)this.getForSpace(address.getAddressSpace(), false), purpose.reason());
    }

    @Override
    public void clear() {
        for (BytesPcodeExecutorStateSpace space : this.spaceMap.values()) {
            space.clear();
        }
    }

    protected class StateMemBuffer
    implements MemBufferMixin {
        protected final Address address;
        protected final BytesPcodeExecutorStateSpace<?> source;
        protected final PcodeExecutorStatePiece.Reason reason;

        public StateMemBuffer(Address address, BytesPcodeExecutorStateSpace<?> source, PcodeExecutorStatePiece.Reason reason) {
            this.address = address;
            this.source = source;
            this.reason = reason;
        }

        public Address getAddress() {
            return this.address;
        }

        public Memory getMemory() {
            throw new UnsupportedOperationException();
        }

        public boolean isBigEndian() {
            return AbstractBytesPcodeExecutorStatePiece.this.language.isBigEndian();
        }

        public int getBytes(ByteBuffer buffer, int addressOffset) {
            byte[] data = this.source.read(this.address.getOffset() + (long)addressOffset, buffer.remaining(), this.reason);
            buffer.put(data);
            return data.length;
        }
    }
}

