/*
 * Decompiled with CFR 0.152.
 */
package ghidra.pcode.exec;

import ghidra.pcode.exec.PcodeExecutionException;
import ghidra.pcode.exec.PcodeExecutor;
import ghidra.pcode.exec.PcodeExecutorState;
import ghidra.pcode.exec.PcodeExecutorStatePiece;
import ghidra.pcode.exec.PcodeUseropLibrary;
import ghidra.program.model.pcode.Varnode;
import java.lang.annotation.Annotation;
import java.lang.annotation.ElementType;
import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;
import java.lang.annotation.Target;
import java.lang.invoke.MethodHandle;
import java.lang.invoke.MethodHandles;
import java.lang.reflect.Array;
import java.lang.reflect.Method;
import java.lang.reflect.Parameter;
import java.lang.reflect.Type;
import java.lang.reflect.TypeVariable;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.apache.commons.lang3.reflect.TypeUtils;
import utilities.util.AnnotationUtilities;

public abstract class AnnotatedPcodeUseropLibrary<T>
implements PcodeUseropLibrary<T> {
    private static final Map<Class<?>, Set<Method>> CACHE_BY_CLASS = new HashMap();
    protected Map<String, PcodeUseropLibrary.PcodeUseropDefinition<T>> ops = new HashMap<String, PcodeUseropLibrary.PcodeUseropDefinition<T>>();
    private Map<String, PcodeUseropLibrary.PcodeUseropDefinition<T>> unmodifiableOps = Collections.unmodifiableMap(this.ops);

    private static Set<Method> collectDefinitions(Class<? extends AnnotatedPcodeUseropLibrary<?>> cls) {
        return AnnotationUtilities.collectAnnotatedMethods(PcodeUserop.class, cls);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public AnnotatedPcodeUseropLibrary() {
        Set methods;
        MethodHandles.Lookup lookup = this.getMethodLookup();
        Type opType = this.getOperandType();
        Class<?> cls = this.getClass();
        Map<Class<?>, Set<Method>> map = CACHE_BY_CLASS;
        synchronized (map) {
            methods = CACHE_BY_CLASS.computeIfAbsent(cls, __ -> AnnotatedPcodeUseropLibrary.collectDefinitions(cls));
        }
        for (Method m : methods) {
            this.ops.put(m.getName(), AnnotatedPcodeUseropDefinition.create(m.getAnnotation(PcodeUserop.class), this, opType, lookup, m));
        }
    }

    protected Type getOperandType() {
        return PcodeUseropLibrary.getOperandType(this.getClass());
    }

    protected MethodHandles.Lookup getMethodLookup() {
        return MethodHandles.lookup();
    }

    @Override
    public Map<String, PcodeUseropLibrary.PcodeUseropDefinition<T>> getUserops() {
        return this.unmodifiableOps;
    }

    @Retention(value=RetentionPolicy.RUNTIME)
    @Target(value={ElementType.METHOD})
    public static @interface PcodeUserop {
        public boolean variadic() default false;
    }

    protected static abstract class AnnotatedPcodeUseropDefinition<T>
    implements PcodeUseropLibrary.PcodeUseropDefinition<T> {
        protected final Method method;
        private final MethodHandle handle;
        private int posExecutor = -1;
        private int posState = -1;
        private int posLib = -1;
        private int posOut = -1;

        protected static <T> AnnotatedPcodeUseropDefinition<T> create(PcodeUserop annot, AnnotatedPcodeUseropLibrary<T> library, Type opType, MethodHandles.Lookup lookup, Method method) {
            if (annot.variadic()) {
                return new VariadicAnnotatedPcodeUseropDefinition<T>(library, opType, lookup, method);
            }
            return new FixedArgsAnnotatedPcodeUseropDefinition<T>(library, opType, lookup, method);
        }

        public AnnotatedPcodeUseropDefinition(AnnotatedPcodeUseropLibrary<T> library, Type opType, MethodHandles.Lookup lookup, Method method) {
            this.initStarting();
            this.method = method;
            try {
                this.handle = lookup.unreflect(method).bindTo(library);
            }
            catch (IllegalAccessException e) {
                throw new IllegalArgumentException("Cannot access " + method + " having @" + PcodeUserop.class.getSimpleName() + " annotation. Override getMethodLookup()");
            }
            Type declClsOpType = PcodeUseropLibrary.getOperandType(method.getDeclaringClass());
            Type rType = method.getGenericReturnType();
            if (rType != Void.TYPE && !TypeUtils.isAssignable((Type)rType, (Type)declClsOpType)) {
                throw new IllegalArgumentException("Method " + method.getName() + " with @" + PcodeUserop.class.getSimpleName() + " annotation must return void or a type assignable to " + declClsOpType);
            }
            Parameter[] params = method.getParameters();
            for (int i = 0; i < params.length; ++i) {
                Parameter p = params[i];
                boolean processed = ParamAnnotProc.processParameter(this, declClsOpType, i, p);
                if (processed) continue;
                this.processNonAnnotatedParameter(declClsOpType, opType, i, p);
            }
            this.initFinished();
        }

        @Override
        public String getName() {
            return this.method.getName();
        }

        @Override
        public void execute(PcodeExecutor<T> executor, PcodeUseropLibrary<T> library, Varnode outVar, List<Varnode> inVars) {
            this.validateInputs(inVars);
            PcodeExecutorState<Object> state = executor.getState();
            List<Object> args = Arrays.asList(new Object[this.method.getParameterCount()]);
            if (this.posExecutor != -1) {
                args.set(this.posExecutor, executor);
            }
            if (this.posState != -1) {
                args.set(this.posState, state);
            }
            if (this.posLib != -1) {
                args.set(this.posLib, library);
            }
            if (this.posOut != -1) {
                args.set(this.posOut, outVar);
            }
            this.placeInputs(executor, args, inVars);
            try {
                Object result = this.handle.invokeWithArguments(args);
                if (result != null && outVar != null) {
                    state.setVar(outVar, result);
                }
            }
            catch (PcodeExecutionException e) {
                throw e;
            }
            catch (Throwable e) {
                throw new PcodeExecutionException("Error executing userop", null, e);
            }
        }

        protected void initStarting() {
        }

        protected abstract void processNonAnnotatedParameter(Type var1, Type var2, int var3, Parameter var4);

        protected void initFinished() {
        }

        protected void validateInputs(List<Varnode> inVars) throws PcodeExecutionException {
        }

        protected abstract void placeInputs(PcodeExecutor<T> var1, List<Object> var2, List<Varnode> var3);
    }

    @Retention(value=RetentionPolicy.RUNTIME)
    @Target(value={ElementType.PARAMETER})
    public static @interface OpOutput {
    }

    @Retention(value=RetentionPolicy.RUNTIME)
    @Target(value={ElementType.PARAMETER})
    public static @interface OpLibrary {
    }

    @Retention(value=RetentionPolicy.RUNTIME)
    @Target(value={ElementType.PARAMETER})
    public static @interface OpState {
    }

    @Retention(value=RetentionPolicy.RUNTIME)
    @Target(value={ElementType.PARAMETER})
    public static @interface OpExecutor {
    }

    protected static class VariadicAnnotatedPcodeUseropDefinition<T>
    extends AnnotatedPcodeUseropDefinition<T> {
        private int posIns;
        private Class<?> opRawType;

        public VariadicAnnotatedPcodeUseropDefinition(AnnotatedPcodeUseropLibrary<T> library, Type opType, MethodHandles.Lookup lookup, Method method) {
            super(library, opType, lookup, method);
        }

        @Override
        protected void initStarting() {
            this.posIns = -1;
            this.opRawType = null;
        }

        @Override
        protected void processNonAnnotatedParameter(Type declClsOpType, Type opType, int i, Parameter p) {
            if (this.posIns != -1) {
                throw new IllegalArgumentException("Only one non-annotated parameter is allowed to receive the inputs");
            }
            Type pType = p.getParameterizedType();
            Type eType = TypeUtils.getArrayComponentType((Type)pType);
            if (eType == null) {
                throw new IllegalArgumentException("Variadic userop must receive inputs as " + declClsOpType + "[] or " + Varnode.class.getSimpleName() + "[]");
            }
            if (!pType.equals(Varnode[].class)) {
                if (TypeUtils.isAssignable((Type)declClsOpType, (Type)eType)) {
                    this.opRawType = TypeUtils.getRawType((Type)opType, this.getClass());
                } else {
                    throw new IllegalArgumentException("Variadic userop must receive inputs as " + declClsOpType + "[] or " + Varnode.class.getSimpleName() + "[]");
                }
            }
            this.posIns = i;
        }

        @Override
        protected void initFinished() {
            if (this.posIns == -1) {
                throw new IllegalArgumentException("Variadic userop must have a parameter for the inputs");
            }
        }

        protected Object[] readVars(PcodeExecutorState<T> state, List<Varnode> vars, PcodeExecutorStatePiece.Reason reason) {
            Object[] vals = (Object[])Array.newInstance(this.opRawType, vars.size());
            for (int i = 0; i < vals.length; ++i) {
                vals[i] = state.getVar(vars.get(i), reason);
            }
            return vals;
        }

        @Override
        protected void placeInputs(PcodeExecutor<T> executor, List<Object> args, List<Varnode> inVars) {
            if (this.opRawType != null) {
                args.set(this.posIns, this.readVars(executor.getState(), inVars, executor.getReason()));
            } else {
                args.set(this.posIns, inVars.toArray(Varnode[]::new));
            }
        }

        @Override
        public int getInputCount() {
            return -1;
        }
    }

    protected static class FixedArgsAnnotatedPcodeUseropDefinition<T>
    extends AnnotatedPcodeUseropDefinition<T> {
        private List<Integer> posIns;
        private Set<Integer> posTs;

        public FixedArgsAnnotatedPcodeUseropDefinition(AnnotatedPcodeUseropLibrary<T> library, Type opType, MethodHandles.Lookup lookup, Method method) {
            super(library, opType, lookup, method);
        }

        @Override
        protected void initStarting() {
            this.posIns = new ArrayList<Integer>();
            this.posTs = new HashSet<Integer>();
        }

        @Override
        protected void processNonAnnotatedParameter(Type declClsOpType, Type opType, int i, Parameter p) {
            Type pType = p.getParameterizedType();
            if (!TypeUtils.isAssignable(Varnode.class, (Type)pType)) {
                if (TypeUtils.isAssignable((Type)declClsOpType, (Type)pType)) {
                    this.posTs.add(i);
                } else {
                    throw new IllegalArgumentException("Input parameter " + p.getName() + " of userop " + this.method.getName() + " must be " + Varnode.class.getSimpleName() + " or accept " + declClsOpType);
                }
            }
            this.posIns.add(i);
        }

        @Override
        protected void validateInputs(List<Varnode> inVars) throws PcodeExecutionException {
            if (inVars.size() != this.posIns.size()) {
                throw new PcodeExecutionException("Incorrect input parameter count for userop " + this.method.getName() + ". Expected " + this.posIns.size() + " but got " + inVars.size());
            }
        }

        @Override
        protected void placeInputs(PcodeExecutor<T> executor, List<Object> args, List<Varnode> inVars) {
            PcodeExecutorState<T> state = executor.getState();
            for (int i = 0; i < this.posIns.size(); ++i) {
                int pos = this.posIns.get(i);
                if (this.posTs.contains(pos)) {
                    args.set(pos, state.getVar(inVars.get(i), executor.getReason()));
                    continue;
                }
                args.set(pos, inVars.get(i));
            }
        }

        @Override
        public int getInputCount() {
            return this.posIns.size();
        }
    }

    /*
     * Uses 'sealed' constructs - enablewith --sealed true
     */
    private static enum ParamAnnotProc {
        EXECUTOR(OpExecutor.class, (Class)PcodeExecutor.class){

            @Override
            int getPos(AnnotatedPcodeUseropDefinition<?> opdef) {
                return opdef.posExecutor;
            }

            @Override
            void setPos(AnnotatedPcodeUseropDefinition<?> opdef, int pos) {
                opdef.posExecutor = pos;
            }
        }
        ,
        STATE(OpState.class, (Class)PcodeExecutorState.class){

            @Override
            int getPos(AnnotatedPcodeUseropDefinition<?> opdef) {
                return opdef.posState;
            }

            @Override
            void setPos(AnnotatedPcodeUseropDefinition<?> opdef, int pos) {
                opdef.posState = pos;
            }
        }
        ,
        LIBRARY(OpLibrary.class, (Class)PcodeUseropLibrary.class){

            @Override
            int getPos(AnnotatedPcodeUseropDefinition<?> opdef) {
                return opdef.posLib;
            }

            @Override
            void setPos(AnnotatedPcodeUseropDefinition<?> opdef, int pos) {
                opdef.posLib = pos;
            }
        }
        ,
        OUTPUT(OpOutput.class, (Class)Varnode.class){

            @Override
            int getPos(AnnotatedPcodeUseropDefinition<?> opdef) {
                return opdef.posOut;
            }

            @Override
            void setPos(AnnotatedPcodeUseropDefinition<?> opdef, int pos) {
                opdef.posOut = pos;
            }
        };

        private final Class<? extends Annotation> annotCls;
        private final Class<?> paramCls;

        static boolean processParameter(AnnotatedPcodeUseropDefinition<?> opdef, Type declClsOpType, int i, Parameter p) {
            ParamAnnotProc only = null;
            for (ParamAnnotProc proc : ParamAnnotProc.values()) {
                if (!proc.hasAnnot(p)) continue;
                if (only != null) {
                    throw new IllegalArgumentException("Parameter can have at most one of " + Stream.of(ParamAnnotProc.values()).map(pr -> "@" + pr.annotCls.getSimpleName()).collect(Collectors.toList()));
                }
                only = proc;
            }
            if (only == null) {
                return false;
            }
            only.processParameterPerAnnot(opdef, declClsOpType, i, p);
            return true;
        }

        private ParamAnnotProc(Class<? extends Annotation> annotCls, Class<?> paramCls) {
            this.annotCls = annotCls;
            this.paramCls = paramCls;
        }

        abstract int getPos(AnnotatedPcodeUseropDefinition<?> var1);

        abstract void setPos(AnnotatedPcodeUseropDefinition<?> var1, int var2);

        boolean hasAnnot(Parameter p) {
            return p.getAnnotation(this.annotCls) != null;
        }

        Type getArgumentType(Type opType) {
            TypeVariable<Class<?>>[] typeParams = this.paramCls.getTypeParameters();
            if (typeParams.length == 0) {
                return this.paramCls;
            }
            if (typeParams.length == 1) {
                return TypeUtils.parameterize(this.paramCls, (Type[])new Type[]{opType});
            }
            throw new AssertionError();
        }

        void processParameterPerAnnot(AnnotatedPcodeUseropDefinition<?> opdef, Type declClsOpType, int i, Parameter p) {
            if (this.getPos(opdef) != -1) {
                throw new IllegalArgumentException("Can only have one parameter with @" + this.annotCls.getSimpleName());
            }
            Type pType = p.getParameterizedType();
            Map typeArgs = TypeUtils.getTypeArguments((Type)pType, this.paramCls);
            if (typeArgs == null) {
                throw new IllegalArgumentException("Parameter " + p.getName() + " with @" + this.annotCls.getSimpleName() + " must acccept " + this.getArgumentType(declClsOpType));
            }
            if (!typeArgs.isEmpty()) {
                if (typeArgs.size() == 1) {
                    Type declMthOpType = (Type)typeArgs.get(this.paramCls.getTypeParameters()[0]);
                    if (!Objects.equals(declClsOpType, declMthOpType)) {
                        throw new IllegalArgumentException("Parameter " + p.getName() + " with @" + this.annotCls.getSimpleName() + " must acccept " + this.getArgumentType(declClsOpType));
                    }
                } else {
                    throw new AssertionError((Object)("Internal: paramCls for @" + this.annotCls.getSimpleName() + "should only have one type parameter <T>"));
                }
            }
            this.setPos(opdef, i);
        }
    }
}

