/*
 * Decompiled with CFR 0.152.
 */
package ghidra.pcode.exec;

import ghidra.app.plugin.processors.sleigh.template.OpTpl;
import ghidra.app.util.pcode.AbstractAppender;
import ghidra.app.util.pcode.AbstractPcodeFormatter;
import ghidra.app.util.pcode.Appender;
import ghidra.pcode.error.LowlevelError;
import ghidra.program.model.lang.Language;
import ghidra.program.model.pcode.PcodeOp;
import java.util.List;
import java.util.Map;

public class PcodeFrame {
    private final Language language;
    private final List<PcodeOp> code;
    private final Map<Integer, String> useropNames;
    private int count = 0;
    private int index = 0;
    private int branched = -1;

    public PcodeFrame(Language language, List<PcodeOp> code, Map<Integer, String> useropNames) {
        this.language = language;
        this.code = code;
        this.useropNames = useropNames;
    }

    public String toString() {
        return (String)new MyFormatter().formatOps(this.language, this.code);
    }

    public int count() {
        return this.count;
    }

    public int index() {
        return this.index;
    }

    public PcodeOp nextOp() {
        return this.code.get(this.advance());
    }

    public int advance() {
        ++this.count;
        return this.index++;
    }

    public int stepBack() {
        --this.count;
        return this.index--;
    }

    public String getUseropName(int userop) {
        return this.useropNames.get(userop);
    }

    public Map<Integer, String> getUseropNames() {
        return this.useropNames;
    }

    public boolean isFallThrough() {
        return this.index == this.code.size();
    }

    public boolean isBranch() {
        return this.index == -1;
    }

    public boolean isFinished() {
        return 0 > this.index || this.index >= this.code.size();
    }

    public void branch(int rel) {
        this.index += rel - 1;
        if (0 > this.index || this.index > this.code.size()) {
            throw new LowlevelError("Bad p-code branch");
        }
    }

    public void finishAsBranch() {
        this.branched = this.index - 1;
        this.index = -1;
    }

    public List<PcodeOp> getCode() {
        return this.code;
    }

    public PcodeOp[] copyCode() {
        return (PcodeOp[])this.code.toArray(PcodeOp[]::new);
    }

    public int getBranched() {
        return this.branched;
    }

    protected class MyFormatter
    extends AbstractPcodeFormatter<String, MyAppender> {
        protected MyFormatter() {
        }

        protected MyAppender createAppender(Language language, boolean indent) {
            return new MyAppender(language);
        }

        protected AbstractPcodeFormatter.FormatResult formatOpTemplate(MyAppender appender, OpTpl op) {
            appender.isLineLabel = MyFormatter.isLineLabel((OpTpl)op);
            AbstractPcodeFormatter.FormatResult result = super.formatOpTemplate((Appender)appender, op);
            appender.endLine();
            return result;
        }
    }

    protected class MyAppender
    extends AbstractAppender<String> {
        protected final StringBuffer buf;
        protected boolean isLineLabel;
        protected int i;

        public MyAppender(Language language) {
            super(language, true);
            this.buf = new StringBuffer();
            this.isLineLabel = false;
            this.i = 0;
            this.buf.append("<p-code frame: index=" + PcodeFrame.this.index);
            if (PcodeFrame.this.branched != -1) {
                this.buf.append(" branched=" + PcodeFrame.this.branched);
            }
            this.buf.append(" {\n");
        }

        protected void appendString(String string) {
            this.buf.append(string);
        }

        public void appendLineLabel(long label) {
            this.buf.append("  " + this.stringifyLineLabel(label));
        }

        public void appendIndent() {
            if (this.isLineLabel) {
                this.buf.append("    ");
            }
            if (this.i == PcodeFrame.this.branched) {
                this.buf.append(" *> ");
            } else if (this.i == PcodeFrame.this.index) {
                this.buf.append(" -> ");
            } else {
                this.buf.append("    ");
            }
        }

        protected void endLine() {
            if (!this.isLineLabel) {
                ++this.i;
            }
            this.buf.append("\n");
        }

        protected String stringifyUseropUnchecked(Language language, int id) {
            String name = super.stringifyUseropUnchecked(language, id);
            if (name != null) {
                return name;
            }
            return PcodeFrame.this.useropNames.get(id);
        }

        public String finish() {
            if (PcodeFrame.this.index == PcodeFrame.this.code.size()) {
                this.buf.append(" *> fall-through\n");
            }
            this.buf.append("}>");
            return this.buf.toString();
        }
    }
}

