/*
 * Decompiled with CFR 0.152.
 */
package ghidra.features.bsim.gui.search.dialog;

import docking.DialogComponentProvider;
import docking.widgets.OptionDialog;
import docking.widgets.button.BrowseButton;
import docking.widgets.button.GRadioButton;
import docking.widgets.filechooser.GhidraFileChooser;
import docking.widgets.filechooser.GhidraFileChooserMode;
import ghidra.features.bsim.query.BSimClientFactory;
import ghidra.features.bsim.query.BSimServerInfo;
import ghidra.features.bsim.query.FunctionDatabase;
import ghidra.util.HelpLocation;
import ghidra.util.filechooser.GhidraFileChooserModel;
import ghidra.util.filechooser.GhidraFileFilter;
import ghidra.util.layout.HorizontalLayout;
import ghidra.util.layout.MiddleLayout;
import ghidra.util.layout.PairLayout;
import java.awt.BorderLayout;
import java.awt.CardLayout;
import java.awt.Component;
import java.awt.LayoutManager;
import java.awt.event.ActionListener;
import java.io.File;
import javax.swing.AbstractButton;
import javax.swing.BorderFactory;
import javax.swing.ButtonGroup;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextField;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;

public class CreateBsimServerInfoDialog
extends DialogComponentProvider {
    protected static final String FILE_DB_EXT = ".mv.db";
    private static final String POSTGRES = "Postgres";
    private static final String ELASTIC = "Elastic";
    private static final String FILE_H2 = "File";
    private GRadioButton postgresButton;
    private GRadioButton elasticButton;
    private GRadioButton fileButton;
    private JPanel cardPanel;
    private PostgresPanel postgresPanel;
    private ElasticPanel elasticPanel;
    private FilePanel filePanel;
    private ServerPanel activePanel;
    private BSimServerInfo result;

    public CreateBsimServerInfoDialog() {
        super("Add BSim Server");
        this.addWorkPanel(this.buildMainPanel());
        this.addOKButton();
        this.addCancelButton();
        this.setOkEnabled(false);
        this.setHelpLocation(new HelpLocation("BSimSearchPlugin", "Add_Server_Definition_Dialog"));
    }

    public BSimServerInfo getBsimServerInfo() {
        return this.result;
    }

    public void setHelpLocation(HelpLocation helpLocation) {
        super.setHelpLocation(helpLocation);
    }

    protected void okCallback() {
        BSimServerInfo serverInfo = this.activePanel.getServerInfo();
        if (this.acceptServer(serverInfo)) {
            this.result = serverInfo;
            this.close();
        }
    }

    public boolean acceptServer(BSimServerInfo serverInfo) {
        String errorMessage = null;
        try {
            FunctionDatabase database = BSimClientFactory.buildClient(serverInfo, true);
            if (database.initialize()) {
                return true;
            }
            errorMessage = database.getLastError().toString();
        }
        catch (Exception e) {
            errorMessage = e.getMessage();
        }
        int answer = OptionDialog.showYesNoDialog(null, (String)"Connection Test Failed!", (String)("Can't connect to server: " + errorMessage + "\nDo you want create anyway?"));
        return answer == 1;
    }

    private JComponent buildMainPanel() {
        JPanel panel = new JPanel(new BorderLayout());
        panel.add(this.buildTypePanel(), "North");
        panel.add(this.buildCardPanel(), "Center");
        return panel;
    }

    private Component buildCardPanel() {
        this.postgresPanel = new PostgresPanel();
        this.elasticPanel = new ElasticPanel();
        this.filePanel = new FilePanel();
        this.cardPanel = new JPanel(new CardLayout());
        this.cardPanel.add((Component)this.postgresPanel, POSTGRES);
        this.cardPanel.add((Component)this.elasticPanel, ELASTIC);
        this.cardPanel.add((Component)this.filePanel, FILE_H2);
        this.activePanel = this.postgresPanel;
        return this.cardPanel;
    }

    private Component buildTypePanel() {
        JPanel panel = new JPanel((LayoutManager)new MiddleLayout());
        panel.setBorder(BorderFactory.createEmptyBorder(20, 10, 10, 10));
        JPanel innerPanel = new JPanel((LayoutManager)new HorizontalLayout(20));
        ButtonGroup group = new ButtonGroup();
        this.postgresButton = new GRadioButton(POSTGRES);
        this.elasticButton = new GRadioButton(ELASTIC);
        this.fileButton = new GRadioButton(FILE_H2);
        this.postgresButton.setSelected(true);
        ActionListener actionListener = e -> this.radioChanged();
        this.postgresButton.addActionListener(actionListener);
        this.elasticButton.addActionListener(actionListener);
        this.fileButton.addActionListener(actionListener);
        group.add((AbstractButton)this.postgresButton);
        group.add((AbstractButton)this.elasticButton);
        group.add((AbstractButton)this.fileButton);
        innerPanel.add((Component)this.postgresButton);
        innerPanel.add((Component)this.elasticButton);
        innerPanel.add((Component)this.fileButton);
        panel.add(innerPanel);
        return panel;
    }

    private void radioChanged() {
        CardLayout cardLayout = (CardLayout)this.cardPanel.getLayout();
        if (this.postgresButton.isSelected()) {
            cardLayout.show(this.cardPanel, POSTGRES);
            this.activePanel = this.postgresPanel;
        } else if (this.elasticButton.isSelected()) {
            cardLayout.show(this.cardPanel, ELASTIC);
            this.activePanel = this.elasticPanel;
        } else if (this.fileButton.isSelected()) {
            cardLayout.show(this.cardPanel, FILE_H2);
            this.activePanel = this.filePanel;
        }
        this.checkForValidDialog();
    }

    private int getPort(String portString) {
        try {
            return Integer.parseInt(portString);
        }
        catch (Throwable t) {
            return -1;
        }
    }

    private void checkForValidDialog() {
        BSimServerInfo serverInfo = this.activePanel.getServerInfo();
        this.setOkEnabled(serverInfo != null);
    }

    private abstract class ServerPanel
    extends JPanel {
        ServerPanel(LayoutManager layout) {
            super(layout);
            this.setBorder(BorderFactory.createEmptyBorder(20, 10, 10, 10));
        }

        abstract BSimServerInfo getServerInfo();
    }

    private class PostgresPanel
    extends ServerPanel {
        private JTextField nameField;
        private JTextField hostField;
        private JTextField portField;

        PostgresPanel() {
            super((LayoutManager)new PairLayout(10, 10));
            this.nameField = new NotifyingTextField();
            this.hostField = new NotifyingTextField();
            this.portField = new NotifyingTextField(Integer.toString(5432));
            this.add(new JLabel("DB Name:", 4));
            this.add(this.nameField);
            this.add(new JLabel("Host:", 4));
            this.add(this.hostField);
            this.add(new JLabel("Port:", 4));
            this.add(this.portField);
        }

        @Override
        BSimServerInfo getServerInfo() {
            String name = this.nameField.getText().trim();
            String host = this.hostField.getText().trim();
            int port = CreateBsimServerInfoDialog.this.getPort(this.portField.getText().trim());
            if (name.isBlank() || host.isBlank() || port < 0) {
                return null;
            }
            return new BSimServerInfo(BSimServerInfo.DBType.postgres, host, port, name);
        }
    }

    private class ElasticPanel
    extends ServerPanel {
        private JTextField nameField;
        private JTextField hostField;
        private JTextField portField;

        ElasticPanel() {
            super((LayoutManager)new PairLayout(10, 10));
            this.nameField = new NotifyingTextField();
            this.hostField = new NotifyingTextField();
            this.portField = new NotifyingTextField(Integer.toString(9200));
            this.add(new JLabel("DB Name:", 4));
            this.add(this.nameField);
            this.add(new JLabel("Host:", 4));
            this.add(this.hostField);
            this.add(new JLabel("Port:", 4));
            this.add(this.portField);
        }

        @Override
        BSimServerInfo getServerInfo() {
            String name = this.nameField.getText().trim();
            String host = this.hostField.getText().trim();
            int port = CreateBsimServerInfoDialog.this.getPort(this.portField.getText().trim());
            if (name.isBlank() || host.isBlank() || port < 0) {
                return null;
            }
            return new BSimServerInfo(BSimServerInfo.DBType.elastic, host, port, name);
        }
    }

    private class FilePanel
    extends ServerPanel {
        private JTextField fileField;

        FilePanel() {
            super((LayoutManager)new PairLayout());
            this.add(new JLabel("File: "));
            this.add(this.buildFileField());
        }

        private JPanel buildFileField() {
            JPanel panel = new JPanel(new BorderLayout());
            this.fileField = new NotifyingTextField();
            this.fileField.setEditable(false);
            panel.add((Component)this.fileField, "Center");
            JPanel subpanel = new JPanel((LayoutManager)new MiddleLayout());
            subpanel.setBorder(BorderFactory.createEmptyBorder(0, 10, 0, 0));
            BrowseButton browseButton = new BrowseButton();
            browseButton.addActionListener(e -> this.showFileChooser());
            subpanel.add((Component)browseButton);
            panel.add((Component)subpanel, "East");
            return panel;
        }

        private void showFileChooser() {
            GhidraFileChooser chooser = new GhidraFileChooser((Component)this);
            chooser.setFileSelectionMode(GhidraFileChooserMode.FILES_ONLY);
            chooser.setFileFilter(new GhidraFileFilter(){

                public String getDescription() {
                    return "*.mv.db";
                }

                public boolean accept(File file, GhidraFileChooserModel chooserModel) {
                    return file.isDirectory() || file.getName().endsWith(CreateBsimServerInfoDialog.FILE_DB_EXT);
                }
            });
            File selectedFile = chooser.getSelectedFile();
            if (selectedFile != null) {
                this.fileField.setText(selectedFile.getAbsolutePath());
            }
        }

        @Override
        BSimServerInfo getServerInfo() {
            String path = this.fileField.getText().trim();
            if (path.isBlank()) {
                return null;
            }
            File file = new File(path);
            if (file.isDirectory()) {
                return null;
            }
            return new BSimServerInfo(BSimServerInfo.DBType.file, null, -1, path);
        }
    }

    class NotifyingTextField
    extends JTextField {
        public NotifyingTextField() {
            this("");
        }

        public NotifyingTextField(String initialText) {
            super(20);
            this.setText(initialText);
            this.getDocument().addDocumentListener(new DocumentListener(){

                @Override
                public void insertUpdate(DocumentEvent e) {
                    CreateBsimServerInfoDialog.this.checkForValidDialog();
                }

                @Override
                public void removeUpdate(DocumentEvent e) {
                    CreateBsimServerInfoDialog.this.checkForValidDialog();
                }

                @Override
                public void changedUpdate(DocumentEvent e) {
                    CreateBsimServerInfoDialog.this.checkForValidDialog();
                }
            });
        }
    }
}

