/*
 * Decompiled with CFR 0.152.
 */
package ghidra.features.bsim.gui.search.dialog;

import docking.DialogComponentProvider;
import docking.widgets.table.AbstractDynamicTableColumn;
import docking.widgets.table.DiscoverableTableUtils;
import docking.widgets.table.DynamicTableColumn;
import docking.widgets.table.GDynamicColumnTableModel;
import docking.widgets.table.RowObjectTableModel;
import docking.widgets.table.TableColumnDescriptor;
import ghidra.app.services.GoToService;
import ghidra.docking.settings.Settings;
import ghidra.framework.plugintool.ServiceProvider;
import ghidra.framework.plugintool.ServiceProviderStub;
import ghidra.program.database.symbol.FunctionSymbol;
import ghidra.program.model.address.Address;
import ghidra.program.model.listing.Program;
import ghidra.util.HelpLocation;
import ghidra.util.datastruct.Accumulator;
import ghidra.util.exception.CancelledException;
import ghidra.util.table.AddressBasedTableModel;
import ghidra.util.table.GhidraFilterTable;
import ghidra.util.table.field.AbstractProgramBasedDynamicTableColumn;
import ghidra.util.table.field.FunctionSignatureTableColumn;
import ghidra.util.task.TaskMonitor;
import java.awt.BorderLayout;
import java.awt.Component;
import java.util.Map;
import java.util.Set;
import javax.swing.BorderFactory;
import javax.swing.JComponent;
import javax.swing.JPanel;

public class SelectedFunctionsTableDialog
extends DialogComponentProvider {
    private Set<FunctionSymbol> functions;
    private FunctionsTableModel model;
    private Map<Address, Integer> matchCounts;

    public SelectedFunctionsTableDialog(Set<FunctionSymbol> functionSymbols, GoToService gotoService, HelpLocation help) {
        this(functionSymbols, gotoService, help, null);
    }

    public SelectedFunctionsTableDialog(Set<FunctionSymbol> functionSymbols, GoToService gotoService, HelpLocation help, Map<Address, Integer> matchCounts) {
        super("Selected Functions For Bsim Search");
        this.functions = functionSymbols;
        this.matchCounts = matchCounts;
        this.addWorkPanel(this.buildMainPanel(gotoService));
        this.addDismissButton();
        this.setHelpLocation(help);
    }

    private Program getProgram() {
        if (this.functions.isEmpty()) {
            return null;
        }
        FunctionSymbol next = this.functions.iterator().next();
        return next.getProgram();
    }

    private JComponent buildMainPanel(GoToService goToService) {
        JPanel panel = new JPanel(new BorderLayout());
        panel.setBorder(BorderFactory.createEmptyBorder(10, 10, 10, 10));
        panel.add((Component)this.buildFunctionsTable(this.getProgram(), goToService), "Center");
        return panel;
    }

    private JComponent buildFunctionsTable(Program program, GoToService goToService) {
        this.model = new FunctionsTableModel(program);
        GhidraFilterTable table = new GhidraFilterTable((RowObjectTableModel)this.model);
        table.setNavigateOnSelectionEnabled(true);
        table.installNavigation(goToService);
        return table;
    }

    private class FunctionsTableModel
    extends AddressBasedTableModel<FunctionSymbol> {
        public FunctionsTableModel(Program program) {
            super("Selected Functions", (ServiceProvider)new ServiceProviderStub(), program, TaskMonitor.DUMMY);
        }

        protected TableColumnDescriptor<FunctionSymbol> createTableColumnDescriptor() {
            TableColumnDescriptor descriptor = new TableColumnDescriptor();
            descriptor.addVisibleColumn((DynamicTableColumn)new SymbolNameColumn());
            descriptor.addVisibleColumn((DynamicTableColumn)new SymbolAddressColumn(), 1, true);
            descriptor.addVisibleColumn(DiscoverableTableUtils.adaptColumForModel((GDynamicColumnTableModel)this, (AbstractDynamicTableColumn)new FunctionSignatureTableColumn()));
            if (SelectedFunctionsTableDialog.this.matchCounts != null) {
                descriptor.addVisibleColumn((DynamicTableColumn)new MatchCountColumn());
            }
            return descriptor;
        }

        public Address getAddress(int row) {
            return ((FunctionSymbol)this.getModelData().get(row)).getAddress();
        }

        protected void doLoad(Accumulator<FunctionSymbol> accumulator, TaskMonitor monitor) throws CancelledException {
            accumulator.addAll(SelectedFunctionsTableDialog.this.functions);
        }

        private class SymbolNameColumn
        extends AbstractProgramBasedDynamicTableColumn<FunctionSymbol, String> {
            private SymbolNameColumn() {
            }

            public String getColumnName() {
                return "Name";
            }

            public String getValue(FunctionSymbol symbol, Settings settings, Program data, ServiceProvider provider) throws IllegalArgumentException {
                return symbol.getName();
            }

            public int getColumnPreferredWidth() {
                return 150;
            }
        }

        private class SymbolAddressColumn
        extends AbstractProgramBasedDynamicTableColumn<FunctionSymbol, String> {
            private SymbolAddressColumn() {
            }

            public String getColumnName() {
                return "Address";
            }

            public String getValue(FunctionSymbol symbol, Settings settings, Program data, ServiceProvider provider) throws IllegalArgumentException {
                Address addr = symbol.getAddress();
                return addr.toString();
            }

            public int getColumnPreferredWidth() {
                return 150;
            }
        }

        private class MatchCountColumn
        extends AbstractProgramBasedDynamicTableColumn<FunctionSymbol, Integer> {
            private MatchCountColumn() {
            }

            public String getColumnName() {
                return "Matches";
            }

            public Integer getValue(FunctionSymbol symbol, Settings settings, Program data, ServiceProvider provider) throws IllegalArgumentException {
                Integer count = SelectedFunctionsTableDialog.this.matchCounts.get(symbol.getAddress());
                return count != null ? count : 0;
            }

            public int getColumnPreferredWidth() {
                return 100;
            }
        }
    }
}

