/*
 * Decompiled with CFR 0.152.
 */
package ghidra.features.bsim.query;

import generic.cache.BasicFactory;
import generic.cache.CachingPool;
import generic.cache.CountingBasicFactory;
import generic.concurrent.QCallback;
import ghidra.app.decompiler.DecompileException;
import ghidra.app.util.DecompilerConcurrentQ;
import ghidra.features.bsim.query.DecompileFunctionTask;
import ghidra.program.model.listing.Function;
import ghidra.program.model.listing.Program;
import ghidra.util.Msg;
import ghidra.util.task.TaskMonitor;
import java.util.Iterator;

public class ParallelDecompileTask {
    private Program program;
    private TaskMonitor taskMonitor = TaskMonitor.DUMMY;
    private DecompileFunctionTask ftask_template;
    private DecompilerConcurrentQ<Function, Function> queue;

    public ParallelDecompileTask(Program prog, TaskMonitor mon, DecompileFunctionTask ftask) {
        this.program = prog;
        if (mon != null) {
            this.taskMonitor = mon;
        }
        this.ftask_template = ftask;
        this.ftask_template.initializeGlobal(this.program);
    }

    public void decompile(Iterator<Function> iter, int functionCount) throws DecompileException {
        try {
            this.doDecompile(iter, functionCount);
        }
        catch (InterruptedException e) {
            Msg.error((Object)this, (Object)"Problem with decompiler worker thread", (Throwable)e);
            throw new DecompileException("interrupted", e.getMessage());
        }
        catch (Exception t) {
            Msg.error((Object)this, (Object)"Problem with decompiler worker thread", (Throwable)t);
            DecompileException decompileException = new DecompileException("execution", t.getMessage());
            decompileException.initCause((Throwable)t);
            throw decompileException;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void doDecompile(Iterator<Function> iter, int functionCount) throws InterruptedException, Exception {
        this.taskMonitor.setMessage("Analyzing functions...");
        this.taskMonitor.initialize((long)functionCount);
        CachingPool decompilerPool = new CachingPool((BasicFactory)new DecompilerTaskFactory(this.ftask_template));
        ParallelDecompilerCallback callback = new ParallelDecompilerCallback((CachingPool<DecompileFunctionTask>)decompilerPool);
        this.queue = new DecompilerConcurrentQ((QCallback)callback, this.taskMonitor);
        this.queue.addAll(iter);
        try {
            this.queue.waitUntilDone();
        }
        finally {
            this.queue.dispose();
            decompilerPool.dispose();
        }
    }

    void shutdown() {
        if (this.queue == null) {
            return;
        }
        this.queue.dispose(5L);
    }

    private class DecompilerTaskFactory
    extends CountingBasicFactory<DecompileFunctionTask> {
        private DecompileFunctionTask taskFactory;

        DecompilerTaskFactory(DecompileFunctionTask taskFactory) {
            this.taskFactory = taskFactory;
        }

        public DecompileFunctionTask doCreate(int itemNumber) throws DecompileException {
            int zeroBasedNumber = itemNumber - 1;
            return this.taskFactory.clone(zeroBasedNumber);
        }

        public void doDispose(DecompileFunctionTask task) {
            task.shutdown();
        }
    }

    private class ParallelDecompilerCallback
    implements QCallback<Function, Function> {
        private CachingPool<DecompileFunctionTask> pool;

        ParallelDecompilerCallback(CachingPool<DecompileFunctionTask> decompilerPool) {
            this.pool = decompilerPool;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public Function process(Function func, TaskMonitor monitor) throws Exception {
            monitor.setMessage("Decompiling " + func.getName());
            DecompileFunctionTask task = (DecompileFunctionTask)this.pool.get();
            try {
                task.decompile(func, monitor);
            }
            finally {
                this.pool.release((Object)task);
            }
            return null;
        }
    }
}

