/*
 * Decompiled with CFR 0.152.
 */
package ghidra.features.bsim.query.elastic;

import ghidra.features.bsim.query.elastic.ElasticException;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.OutputStreamWriter;
import java.io.Reader;
import java.io.Writer;
import java.net.HttpURLConnection;
import java.net.URL;
import org.json.simple.JSONObject;
import org.json.simple.parser.JSONParser;
import org.json.simple.parser.ParseException;

public class ElasticConnection {
    public static final String POST = "POST";
    public static final String PUT = "PUT";
    public static final String GET = "GET";
    public static final String DELETE = "DELETE";
    protected String hostURL;
    protected String httpURLbase;
    private HttpURLConnection connection = null;
    private Writer writer;
    private int lastResponseCode;

    public ElasticConnection(String url, String repo) {
        this.hostURL = url;
        this.httpURLbase = url + "/" + repo + "_";
    }

    public void close() {
        if (this.connection != null) {
            this.connection.disconnect();
        }
    }

    public boolean lastRequestSuccessful() {
        return this.lastResponseCode >= 200 && this.lastResponseCode < 300;
    }

    public void startHttpRequest(String command, String path) throws IOException {
        URL httpURL = new URL(this.httpURLbase + path);
        this.connection = (HttpURLConnection)httpURL.openConnection();
        this.connection.setRequestMethod(command);
        this.connection.setRequestProperty("Content-Type", "application/json");
        this.connection.setDoOutput(true);
        this.writer = new OutputStreamWriter(this.connection.getOutputStream());
    }

    public void startHttpBulkRequest(String bulkCommand) throws IOException {
        URL httpURL = new URL(this.hostURL + bulkCommand);
        this.connection = (HttpURLConnection)httpURL.openConnection();
        this.connection.setRequestMethod(POST);
        this.connection.setRequestProperty("Content-Type", "application/x-ndjson");
        this.connection.setDoOutput(true);
        this.writer = new OutputStreamWriter(this.connection.getOutputStream());
    }

    public void startHttpRawRequest(String command, String path) throws IOException {
        URL httpURL = new URL(this.hostURL + path);
        this.connection = (HttpURLConnection)httpURL.openConnection();
        this.connection.setRequestMethod(command);
        this.connection.setRequestProperty("Content-Type", "application/json");
        this.connection.setDoOutput(true);
        this.writer = new OutputStreamWriter(this.connection.getOutputStream());
    }

    public void startHttpURICommand(String command, String path) throws IOException {
        URL httpURL = new URL(this.httpURLbase + path);
        this.connection = (HttpURLConnection)httpURL.openConnection();
        this.connection.setRequestMethod(command);
        this.connection.setDoOutput(true);
    }

    private JSONObject grabResponse() throws IOException, ParseException {
        JSONParser parser = new JSONParser();
        InputStreamReader reader = this.lastRequestSuccessful() ? new InputStreamReader(this.connection.getInputStream()) : new InputStreamReader(this.connection.getErrorStream());
        JSONObject jsonObject = (JSONObject)parser.parse((Reader)reader);
        return jsonObject;
    }

    private String parseErrorJSON(JSONObject resp) {
        Object errorObj = resp.get((Object)"error");
        if (errorObj == null) {
            return "Unknown error format";
        }
        if (errorObj instanceof String) {
            return (String)errorObj;
        }
        if (!(errorObj instanceof JSONObject)) {
            return "Unknown error format";
        }
        JSONObject jsonObj = (JSONObject)errorObj;
        String typeString = (String)jsonObj.get((Object)"type");
        String reasonString = (String)jsonObj.get((Object)"reason");
        if (typeString == null) {
            typeString = "Unknown Error";
        }
        if (reasonString == null) {
            reasonString = "Unknown reason";
        }
        return typeString + " : " + reasonString;
    }

    public JSONObject executeRawStatement(String command, String path, String body) throws ElasticException {
        try {
            this.startHttpRawRequest(command, path);
            this.writer.write(body);
            this.writer.close();
            this.lastResponseCode = this.connection.getResponseCode();
            JSONObject resp = this.grabResponse();
            if (!this.lastRequestSuccessful()) {
                throw new ElasticException(this.parseErrorJSON(resp));
            }
            return resp;
        }
        catch (IOException e) {
            throw new ElasticException("Error sending request: " + e.getMessage());
        }
        catch (ParseException e) {
            throw new ElasticException("Error parsing response: " + e.getMessage());
        }
    }

    public void executeStatementNoResponse(String command, String path, String body) throws ElasticException {
        try {
            this.startHttpRequest(command, path);
            this.writer.write(body);
            this.writer.close();
            this.lastResponseCode = this.connection.getResponseCode();
            JSONObject resp = this.grabResponse();
            if (!this.lastRequestSuccessful()) {
                throw new ElasticException(this.parseErrorJSON(resp));
            }
        }
        catch (IOException e) {
            throw new ElasticException("Error sending request: " + e.getMessage());
        }
        catch (ParseException e) {
            throw new ElasticException("Error parsing response: " + e.getMessage());
        }
    }

    public JSONObject executeStatement(String command, String path, String body) throws ElasticException {
        try {
            this.startHttpRequest(command, path);
            this.writer.write(body);
            this.writer.close();
            this.lastResponseCode = this.connection.getResponseCode();
            JSONObject resp = this.grabResponse();
            if (!this.lastRequestSuccessful()) {
                throw new ElasticException(this.parseErrorJSON(resp));
            }
            return resp;
        }
        catch (IOException e) {
            throw new ElasticException("Error sending request: " + e.getMessage());
        }
        catch (ParseException e) {
            throw new ElasticException("Error parsing response: " + e.getMessage());
        }
    }

    public JSONObject executeStatementExpectFailure(String command, String path, String body) throws ElasticException {
        try {
            this.startHttpRequest(command, path);
            this.writer.write(body);
            this.writer.close();
            this.lastResponseCode = this.connection.getResponseCode();
            JSONObject resp = this.grabResponse();
            return resp;
        }
        catch (IOException e) {
            throw new ElasticException("Error sending request: " + e.getMessage());
        }
        catch (ParseException e) {
            throw new ElasticException("Error parsing response: " + e.getMessage());
        }
    }

    public JSONObject executeBulk(String path, String body) throws ElasticException {
        try {
            this.startHttpBulkRequest(path);
            this.writer.write(body);
            this.writer.close();
            this.lastResponseCode = this.connection.getResponseCode();
            JSONObject resp = this.grabResponse();
            if (!this.lastRequestSuccessful()) {
                throw new ElasticException(this.parseErrorJSON(resp));
            }
            return resp;
        }
        catch (IOException e) {
            throw new ElasticException("Error sending request: " + e.getMessage());
        }
        catch (ParseException e) {
            throw new ElasticException("Error parsing response: " + e.getMessage());
        }
    }

    public JSONObject executeURIOnly(String command, String path) throws ElasticException {
        try {
            this.startHttpURICommand(command, path);
            this.lastResponseCode = this.connection.getResponseCode();
            JSONObject resp = this.grabResponse();
            if (!this.lastRequestSuccessful()) {
                throw new ElasticException(this.parseErrorJSON(resp));
            }
            return resp;
        }
        catch (IOException e) {
            throw new ElasticException("Error sending request: " + e.getMessage());
        }
        catch (ParseException e) {
            throw new ElasticException("Error parsing response: " + e.getMessage());
        }
    }
}

