/*
 * Decompiled with CFR 0.152.
 */
package ghidra;

import generic.jar.ResourceFile;
import ghidra.framework.ApplicationProperties;
import ghidra.framework.GModule;
import ghidra.util.SystemUtilities;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import utilities.util.FileUtilities;
import utility.application.ApplicationLayout;
import utility.application.ApplicationUtilities;
import utility.module.ModuleUtilities;

public class GhidraApplicationLayout
extends ApplicationLayout {
    public GhidraApplicationLayout() throws FileNotFoundException, IOException {
        this.applicationRootDirs = this.findGhidraApplicationRootDirs();
        this.applicationProperties = new ApplicationProperties(this.applicationRootDirs);
        this.applicationInstallationDir = this.findGhidraApplicationInstallationDir();
        this.userTempDir = ApplicationUtilities.getDefaultUserTempDir(this.getApplicationProperties());
        this.userCacheDir = ApplicationUtilities.getDefaultUserCacheDir(this.getApplicationProperties());
        this.userSettingsDir = ApplicationUtilities.getDefaultUserSettingsDir(this.getApplicationProperties(), this.getApplicationInstallationDir());
        this.extensionInstallationDirs = this.findExtensionInstallationDirectories();
        this.extensionArchiveDir = this.findExtensionArchiveDirectory();
        this.patchDir = this.findPatchDirectory();
        this.modules = this.findGhidraModules();
    }

    public GhidraApplicationLayout(File applicationInstallationDir) throws FileNotFoundException, IOException {
        this.applicationInstallationDir = new ResourceFile(applicationInstallationDir);
        this.applicationRootDirs = Arrays.asList(new ResourceFile(this.applicationInstallationDir, "Ghidra"));
        this.applicationProperties = new ApplicationProperties(this.applicationRootDirs);
        this.userTempDir = ApplicationUtilities.getDefaultUserTempDir(this.getApplicationProperties());
        this.userCacheDir = ApplicationUtilities.getDefaultUserCacheDir(this.getApplicationProperties());
        this.userSettingsDir = ApplicationUtilities.getDefaultUserSettingsDir(this.getApplicationProperties(), this.getApplicationInstallationDir());
        this.extensionInstallationDirs = this.findExtensionInstallationDirectories();
        this.extensionArchiveDir = this.findExtensionArchiveDirectory();
        this.patchDir = this.findPatchDirectory();
        this.modules = this.findGhidraModules();
    }

    protected Collection<ResourceFile> findGhidraApplicationRootDirs() {
        return ApplicationUtilities.findDefaultApplicationRootDirs();
    }

    protected ResourceFile findGhidraApplicationInstallationDir() {
        if (this.applicationRootDirs.isEmpty()) {
            return null;
        }
        ResourceFile dir = ((ResourceFile)this.applicationRootDirs.iterator().next()).getParentFile();
        if (SystemUtilities.isInDevelopmentMode()) {
            dir = dir.getParentFile();
        }
        return dir;
    }

    protected Map<String, GModule> findGhidraModules() throws IOException {
        Collection<ResourceFile> moduleRootDirectories = ModuleUtilities.findModuleRootDirectories(this.applicationRootDirs, new LinkedHashSet<ResourceFile>());
        for (ResourceFile extensionInstallDir : this.extensionInstallationDirs) {
            FileUtilities.forEachFile(extensionInstallDir, extensionDir -> {
                if (FileUtilities.isPathContainedWithin(this.applicationRootDirs, extensionDir)) {
                    return;
                }
                if (ModuleUtilities.isUninstalled(extensionDir)) {
                    return;
                }
                moduleRootDirectories.add((ResourceFile)extensionDir);
            });
        }
        for (String entry : System.getProperty("java.class.path", "").split(File.pathSeparator)) {
            ResourceFile classpathEntryParent;
            ResourceFile classpathEntry = new ResourceFile(entry);
            if (!classpathEntry.isDirectory() || FileUtilities.isPathContainedWithin(this.applicationRootDirs, classpathEntry) || (classpathEntryParent = classpathEntry.getParentFile()) == null || !ModuleUtilities.isModuleDirectory(classpathEntryParent)) continue;
            moduleRootDirectories.add(classpathEntryParent);
        }
        return ModuleUtilities.findModules(this.applicationRootDirs, moduleRootDirectories);
    }

    protected ResourceFile findPatchDirectory() {
        if (SystemUtilities.isInDevelopmentMode()) {
            return null;
        }
        if (this.applicationInstallationDir == null) {
            return null;
        }
        return new ResourceFile(this.applicationInstallationDir, "Ghidra/patch");
    }

    protected ResourceFile findExtensionArchiveDirectory() {
        if (SystemUtilities.isInDevelopmentMode()) {
            return null;
        }
        if (this.applicationInstallationDir == null) {
            return null;
        }
        return new ResourceFile(this.applicationInstallationDir, "Extensions/Ghidra");
    }

    protected List<ResourceFile> findExtensionInstallationDirectories() {
        ArrayList<ResourceFile> dirs = new ArrayList<ResourceFile>();
        dirs.add(new ResourceFile(new File(this.userSettingsDir, "Extensions")));
        if (SystemUtilities.isInDevelopmentMode()) {
            ResourceFile rootDir = this.getApplicationRootDirs().iterator().next();
            File temp = new File(rootDir.getFile(false), "Extensions");
            if (temp.exists()) {
                dirs.add(new ResourceFile(temp));
            }
        } else {
            dirs.add(new ResourceFile(this.applicationInstallationDir, "Ghidra/Extensions"));
        }
        return dirs;
    }
}

