/*
 * Decompiled with CFR 0.152.
 */
package ghidra.framework;

import generic.jar.ResourceFile;
import ghidra.util.Msg;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import utility.module.ModuleManifestFile;

public class GModule {
    private final String BUILD_OUTPUT_DIR = "build";
    private static final HashSet<String> EXCLUDED_DIRECTORY_NAMES = new HashSet();
    private ResourceFile moduleRoot;
    private List<ResourceFile> searchRootsByPriority = new ArrayList<ResourceFile>();
    private Set<String> dataSearchIgnoreDirs = new HashSet<String>();
    private Set<String> fatJars = new HashSet<String>();

    public GModule(Collection<ResourceFile> appRoots, ResourceFile moduleRoot) {
        if (!moduleRoot.exists()) {
            Msg.error(this, "Attempted to create module for non-existent directory: " + moduleRoot);
        }
        this.moduleRoot = moduleRoot;
        this.searchRootsByPriority.add(moduleRoot);
        ResourceFile buildDir = new ResourceFile(moduleRoot, "build");
        if (buildDir.exists()) {
            this.searchRootsByPriority.add(buildDir);
        }
        List<ResourceFile> shadowModules = this.getShadowModuleAcrossRepos(appRoots);
        this.searchRootsByPriority.addAll(shadowModules);
        this.loadModuleInfo();
    }

    private void loadModuleInfo() {
        try {
            ModuleManifestFile manifestFile = new ModuleManifestFile(this.moduleRoot);
            this.dataSearchIgnoreDirs = manifestFile.getDataSearchIgnoreDirs();
            this.fatJars = manifestFile.getFatJars();
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    private List<ResourceFile> getShadowModuleAcrossRepos(Collection<ResourceFile> appRoots) {
        ArrayList<ResourceFile> list = new ArrayList<ResourceFile>();
        String relativeModulePath = this.getRelativeModulePath(appRoots);
        if (relativeModulePath == null) {
            return list;
        }
        for (ResourceFile appRoot : appRoots) {
            ResourceFile moduleInAppRoot = new ResourceFile(appRoot, relativeModulePath);
            if (moduleInAppRoot.equals(this.moduleRoot) || !moduleInAppRoot.exists()) continue;
            list.add(moduleInAppRoot);
        }
        return list;
    }

    private String getRelativeModulePath(Collection<ResourceFile> appRoots) {
        String moduleRootPath = this.moduleRoot.getAbsolutePath();
        for (ResourceFile appRoot : appRoots) {
            String appRootPath = appRoot.getAbsolutePath() + File.separator;
            if (moduleRootPath.equals(appRootPath)) {
                return null;
            }
            if (!moduleRootPath.startsWith(appRootPath)) continue;
            return moduleRootPath.substring(appRootPath.length());
        }
        return null;
    }

    public void collectExistingModuleDirs(List<ResourceFile> accumulator, String moduleRelativePath) {
        for (ResourceFile moduleSearchRoot : this.searchRootsByPriority) {
            ResourceFile dir = new ResourceFile(moduleSearchRoot, moduleRelativePath);
            if (!dir.exists()) continue;
            accumulator.add(dir);
        }
    }

    public ResourceFile getModuleRoot() {
        return this.moduleRoot;
    }

    public void accumulateDataFilesByExtension(List<ResourceFile> accumulator, String extension) {
        for (ResourceFile moduleSearchRoot : this.searchRootsByPriority) {
            ResourceFile dataDir = new ResourceFile(moduleSearchRoot, "data");
            if (!dataDir.exists()) continue;
            this.accumulateFilesByExtension(extension, dataDir, accumulator);
        }
    }

    public ResourceFile findModuleFile(String relativeDataFilePath) {
        for (ResourceFile moduleSearchRoot : this.searchRootsByPriority) {
            ResourceFile file = new ResourceFile(moduleSearchRoot, relativeDataFilePath);
            if (!file.exists()) continue;
            return file;
        }
        return null;
    }

    public Set<String> getFatJars() {
        return this.fatJars;
    }

    private void accumulateFilesByExtension(String extension, ResourceFile dir, List<ResourceFile> accumulator) {
        ResourceFile[] children;
        for (ResourceFile child : children = dir.listFiles()) {
            if (child.isDirectory()) {
                if (!this.shouldSearch(child)) continue;
                this.accumulateFilesByExtension(extension, child, accumulator);
                continue;
            }
            if (child.getName().startsWith("._") || !child.getName().endsWith(extension)) continue;
            accumulator.add(child);
        }
    }

    private boolean shouldSearch(ResourceFile child) {
        String childName = child.getName();
        if (EXCLUDED_DIRECTORY_NAMES.contains(childName)) {
            return false;
        }
        return !this.dataSearchIgnoreDirs.contains(childName);
    }

    public String getName() {
        return this.moduleRoot.getName();
    }

    public String toString() {
        return this.getName();
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.moduleRoot == null ? 0 : this.moduleRoot.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        GModule other = (GModule)obj;
        return !(this.moduleRoot == null ? other.moduleRoot != null : !this.moduleRoot.equals(other.moduleRoot));
    }

    static {
        EXCLUDED_DIRECTORY_NAMES.add(".svn");
        EXCLUDED_DIRECTORY_NAMES.add("bin");
        EXCLUDED_DIRECTORY_NAMES.add("classes");
        EXCLUDED_DIRECTORY_NAMES.add("developer_scripts");
        EXCLUDED_DIRECTORY_NAMES.add("ghidra_scripts");
        EXCLUDED_DIRECTORY_NAMES.add("help");
        EXCLUDED_DIRECTORY_NAMES.add("os");
        EXCLUDED_DIRECTORY_NAMES.add("resources");
        EXCLUDED_DIRECTORY_NAMES.add("src");
        EXCLUDED_DIRECTORY_NAMES.add("test");
    }
}

