/*
 * Decompiled with CFR 0.152.
 */
package ghidra.app.plugin.core.debug.gui.breakpoint;

import ghidra.app.plugin.core.debug.gui.breakpoint.DebuggerBreakpointsProvider;
import ghidra.debug.api.breakpoint.LogicalBreakpoint;
import ghidra.framework.model.DomainFile;
import ghidra.framework.model.DomainObject;
import ghidra.program.model.address.Address;
import ghidra.program.model.listing.Program;
import ghidra.trace.model.breakpoint.TraceBreakpointKind;
import java.util.Collection;
import java.util.concurrent.CompletableFuture;

public class LogicalBreakpointRow {
    private final DebuggerBreakpointsProvider provider;
    private final LogicalBreakpoint lb;

    public LogicalBreakpointRow(DebuggerBreakpointsProvider provider, LogicalBreakpoint lb) {
        this.provider = provider;
        this.lb = lb;
    }

    public String toString() {
        return "<Row " + this.lb + ">";
    }

    public LogicalBreakpoint getLogicalBreakpoint() {
        return this.lb;
    }

    public LogicalBreakpoint.State getState() {
        return this.provider.isFilterByCurrentTrace() && this.provider.currentTrace != null ? this.lb.computeStateForTrace(this.provider.currentTrace) : this.lb.computeState();
    }

    public void setState(LogicalBreakpoint.State state) {
        assert (state.isNormal());
        this.setEnabled(state.isEnabled());
    }

    public LogicalBreakpoint.Mode getMode() {
        return this.getState().mode;
    }

    public void setEnabled(boolean enabled) {
        boolean filter = this.provider.isFilterByCurrentTrace();
        if (enabled) {
            String status = this.lb.generateStatusEnable(filter ? this.provider.currentTrace : null);
            if (status != null) {
                this.provider.getTool().setStatusInfo(status, true);
            }
            this.lb.enableForProgram();
            CompletableFuture future = filter ? this.lb.enableForTrace(this.provider.currentTrace) : this.lb.enable();
            future.exceptionally(ex -> {
                this.provider.breakpointError("Toggle Breakpoint", "Could not enable breakpoint", (Throwable)ex);
                return null;
            });
        } else {
            this.lb.disableForProgram();
            CompletableFuture future = filter ? this.lb.disableForTrace(this.provider.currentTrace) : this.lb.disable();
            future.exceptionally(ex -> {
                this.provider.breakpointError("Toggle Breakpoint", "Could not disable breakpoint", (Throwable)ex);
                return null;
            });
        }
    }

    public String getName() {
        return this.lb.getName();
    }

    public void setName(String name) {
        this.lb.setName(name);
    }

    public boolean isNamable() {
        return this.lb.getProgramBookmark() != null;
    }

    public String getImageName() {
        Program program = this.lb.getProgram();
        if (program == null) {
            return "";
        }
        DomainFile df = program.getDomainFile();
        if (df == null) {
            return program.getName();
        }
        return df.getName();
    }

    public Address getAddress() {
        return this.lb.getAddress();
    }

    public long getLength() {
        return this.lb.getLength();
    }

    public DomainObject getDomainObject() {
        return this.lb.getDomainObject();
    }

    public String getKinds() {
        return TraceBreakpointKind.TraceBreakpointKindSet.encode((Collection)this.lb.getKinds());
    }

    public int getLocationCount() {
        if (this.provider.isFilterByCurrentTrace()) {
            return this.lb.getTraceBreakpoints(this.provider.currentTrace).size();
        }
        return this.lb.getTraceBreakpoints().size();
    }

    public boolean hasSleigh() {
        String sleigh = this.lb.getEmuSleigh();
        return sleigh != null && !"emu_swi();\nemu_exec_decoded();\n".equals(sleigh);
    }

    public boolean isMapped() {
        if (this.provider.isFilterByCurrentTrace()) {
            if (this.provider.currentTrace == null) {
                return false;
            }
            return this.lb.getMappedTraces().contains(this.provider.currentTrace);
        }
        return !this.lb.getMappedTraces().isEmpty();
    }
}

