/*
 * Decompiled with CFR 0.152.
 */
package ghidra.app.plugin.core.debug.gui.memory;

import ghidra.debug.api.tracemgr.DebuggerCoordinates;
import ghidra.program.model.address.Address;
import java.nio.ByteBuffer;

public class CachedBytePage {
    private boolean valid = true;
    private DebuggerCoordinates coordinates;
    private Address start;
    private byte[] page = new byte[4096];
    private ByteBuffer buf = ByteBuffer.wrap(this.page);

    public byte getByte(DebuggerCoordinates coordinates, Address address) {
        long offset;
        if (!(this.valid && this.coordinates != null && this.coordinates.equals((Object)coordinates) && this.start != null && this.start.hasSameAddressSpace(address))) {
            offset = this.refresh(coordinates, address);
        } else {
            offset = address.subtract(this.start);
            if (offset < 0L || 4096L <= offset) {
                offset = this.refresh(coordinates, address);
            }
        }
        return this.page[(int)offset];
    }

    public void invalidate() {
        this.valid = false;
    }

    private long refresh(DebuggerCoordinates coordinates, Address address) {
        this.valid = false;
        this.buf.clear();
        Address min = address.getAddressSpace().getMinAddress();
        this.start = address.subtractWrap((long)(this.page.length / 2));
        if (this.start.compareTo((Object)min) < 0 || this.start.compareTo((Object)address) > 0) {
            this.start = min;
        }
        coordinates.getTrace().getMemoryManager().getViewBytes(coordinates.getViewSnap(), this.start, this.buf);
        this.valid = true;
        return address.subtract(this.start);
    }
}

