/*
 * Decompiled with CFR 0.152.
 */
package ghidra.app.plugin.core.debug.gui.memory;

import docking.widgets.table.CellEditorUtils;
import docking.widgets.table.CustomToStringCellRenderer;
import docking.widgets.table.DefaultEnumeratedColumnTableModel;
import docking.widgets.table.GTableFilterPanel;
import ghidra.app.plugin.core.debug.gui.AbstractDebuggerMapProposalDialog;
import ghidra.app.plugin.core.debug.gui.DebuggerResources;
import ghidra.app.plugin.core.debug.gui.memory.DebuggerRegionsProvider;
import ghidra.debug.api.modules.RegionMapProposal;
import ghidra.framework.plugintool.PluginTool;
import ghidra.program.model.address.Address;
import ghidra.program.model.listing.Program;
import ghidra.program.model.mem.MemoryBlock;
import ghidra.util.Swing;
import java.util.List;
import java.util.Map;
import java.util.function.BiConsumer;
import java.util.function.Function;
import javax.swing.Icon;
import javax.swing.JTable;
import javax.swing.table.TableCellRenderer;
import javax.swing.table.TableColumn;
import javax.swing.table.TableColumnModel;

public class DebuggerRegionMapProposalDialog
extends AbstractDebuggerMapProposalDialog<RegionMapProposal.RegionMapEntry> {
    static final int BUTTON_SIZE = 32;
    private final DebuggerRegionsProvider provider;

    public DebuggerRegionMapProposalDialog(DebuggerRegionsProvider provider) {
        super(provider.getTool(), "Map Regions");
        this.provider = provider;
    }

    protected RegionMapPropsalTableModel createTableModel(PluginTool tool) {
        return new RegionMapPropsalTableModel(tool);
    }

    @Override
    protected void populateComponents() {
        super.populateComponents();
        this.setPreferredSize(600, 300);
        TableColumnModel columnModel = this.table.getColumnModel();
        TableColumn removeCol = columnModel.getColumn(RegionMapTableColumns.REMOVE.ordinal());
        CellEditorUtils.installButton((JTable)this.table, (GTableFilterPanel)this.filterPanel, (TableColumn)removeCol, (Icon)DebuggerResources.ICON_DELETE, (int)32, x$0 -> this.removeEntry(x$0));
        TableColumn dynBaseCol = columnModel.getColumn(RegionMapTableColumns.DYNAMIC_BASE.ordinal());
        dynBaseCol.setCellRenderer((TableCellRenderer)CustomToStringCellRenderer.MONO_OBJECT);
        TableColumn chooseCol = columnModel.getColumn(RegionMapTableColumns.CHOOSE.ordinal());
        CellEditorUtils.installButton((JTable)this.table, (GTableFilterPanel)this.filterPanel, (TableColumn)chooseCol, (Icon)DebuggerResources.ICON_PROGRAM, (int)32, this::chooseAndSetBlock);
        TableColumn stBaseCol = columnModel.getColumn(RegionMapTableColumns.STATIC_BASE.ordinal());
        stBaseCol.setCellRenderer((TableCellRenderer)CustomToStringCellRenderer.MONO_OBJECT);
        TableColumn sizeCol = columnModel.getColumn(RegionMapTableColumns.SIZE.ordinal());
        sizeCol.setCellRenderer((TableCellRenderer)CustomToStringCellRenderer.MONO_ULONG_HEX);
    }

    private void chooseAndSetBlock(RegionMapProposal.RegionMapEntry entry) {
        Map.Entry<Program, MemoryBlock> choice = this.provider.askBlock(entry.getRegion(), entry.getToProgram(), entry.getBlock());
        if (choice == null) {
            return;
        }
        Swing.runIfSwingOrRunLater(() -> {
            entry.setBlock((Program)choice.getKey(), (MemoryBlock)choice.getValue());
            this.tableModel.notifyUpdated((Object)entry);
        });
    }

    protected static class RegionMapPropsalTableModel
    extends DefaultEnumeratedColumnTableModel<RegionMapTableColumns, RegionMapProposal.RegionMapEntry> {
        public RegionMapPropsalTableModel(PluginTool tool) {
            super(tool, "Region Map", RegionMapTableColumns.class);
        }

        public List<RegionMapTableColumns> defaultSortOrder() {
            return List.of(RegionMapTableColumns.REGION_NAME);
        }
    }

    protected static enum RegionMapTableColumns implements DefaultEnumeratedColumnTableModel.EnumeratedTableColumn<RegionMapTableColumns, RegionMapProposal.RegionMapEntry>
    {
        REMOVE("Remove", String.class, e -> "Remove Proposed Entry", (e, v) -> RegionMapTableColumns.nop()),
        REGION_NAME("Region", String.class, e -> e.getRegion().getName()),
        DYNAMIC_BASE("Dynamic Base", Address.class, e -> e.getRegion().getMinAddress()),
        CHOOSE("Choose", String.class, e -> "Choose Block", (e, s) -> RegionMapTableColumns.nop()),
        PROGRAM_NAME("Program", String.class, e -> e.getToProgram().getName()),
        BLOCK_NAME("Block", String.class, e -> e.getBlock().getName()),
        STATIC_BASE("Static Base", Address.class, e -> e.getBlock().getStart()),
        SIZE("Size", Long.class, e -> e.getMappingLength());

        private final String header;
        private final Class<?> cls;
        private final Function<RegionMapProposal.RegionMapEntry, ?> getter;
        private final BiConsumer<RegionMapProposal.RegionMapEntry, Object> setter;

        private static void nop() {
        }

        private <T> RegionMapTableColumns(String header, Class<T> cls, Function<RegionMapProposal.RegionMapEntry, T> getter, BiConsumer<RegionMapProposal.RegionMapEntry, T> setter) {
            this.header = header;
            this.cls = cls;
            this.getter = getter;
            this.setter = setter;
        }

        private <T> RegionMapTableColumns(String header, Class<T> cls, Function<RegionMapProposal.RegionMapEntry, T> getter) {
            this(header, cls, getter, null);
        }

        public String getHeader() {
            return this.header;
        }

        public Class<?> getValueClass() {
            return this.cls;
        }

        public Object getValueOf(RegionMapProposal.RegionMapEntry row) {
            return this.getter.apply(row);
        }

        public boolean isEditable(RegionMapProposal.RegionMapEntry row) {
            return this.setter != null;
        }

        public void setValueOf(RegionMapProposal.RegionMapEntry row, Object value) {
            this.setter.accept(row, value);
        }
    }
}

