/*
 * Decompiled with CFR 0.152.
 */
package ghidra.app.plugin.core.debug.gui.memory;

import docking.ComponentProvider;
import docking.widgets.table.DynamicTableColumn;
import docking.widgets.table.TableColumnDescriptor;
import ghidra.app.plugin.core.debug.gui.memory.DebuggerRegionsProvider;
import ghidra.app.plugin.core.debug.gui.model.AbstractObjectsTableBasedPanel;
import ghidra.app.plugin.core.debug.gui.model.DebuggerObjectActionContext;
import ghidra.app.plugin.core.debug.gui.model.ModelQuery;
import ghidra.app.plugin.core.debug.gui.model.ObjectTableModel;
import ghidra.app.plugin.core.debug.gui.model.columns.AbstractTraceValueObjectAddressColumn;
import ghidra.app.plugin.core.debug.gui.model.columns.AbstractTraceValueObjectLengthColumn;
import ghidra.app.plugin.core.debug.gui.model.columns.TraceValueKeyColumn;
import ghidra.app.plugin.core.debug.gui.model.columns.TraceValueObjectAttributeColumn;
import ghidra.app.plugin.core.debug.gui.model.columns.TraceValueValColumn;
import ghidra.dbg.target.TargetMemory;
import ghidra.dbg.target.TargetMemoryRegion;
import ghidra.dbg.target.TargetProcess;
import ghidra.dbg.target.schema.TargetObjectSchema;
import ghidra.dbg.util.PathPredicates;
import ghidra.docking.settings.Settings;
import ghidra.framework.plugintool.Plugin;
import ghidra.framework.plugintool.ServiceProvider;
import ghidra.program.model.address.Address;
import ghidra.program.model.address.AddressRange;
import ghidra.trace.model.Trace;
import ghidra.trace.model.memory.TraceMemoryRegion;
import ghidra.trace.model.memory.TraceObjectMemoryRegion;
import ghidra.trace.model.target.TraceObject;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;

public class DebuggerRegionsPanel
extends AbstractObjectsTableBasedPanel<TraceObjectMemoryRegion> {
    protected static ModelQuery successorRegions(TargetObjectSchema rootSchema, List<String> path) {
        TargetObjectSchema schema = rootSchema.getSuccessorSchema(path);
        return new ModelQuery((PathPredicates)schema.searchFor(TargetMemoryRegion.class, path, true));
    }

    protected static Set<TraceMemoryRegion> getSelectedRegions(DebuggerObjectActionContext ctx) {
        return ctx == null ? null : AbstractObjectsTableBasedPanel.getSelected(ctx, TraceObjectMemoryRegion.class).collect(Collectors.toSet());
    }

    public DebuggerRegionsPanel(DebuggerRegionsProvider provider) {
        super(provider.plugin, (ComponentProvider)provider, TraceObjectMemoryRegion.class);
    }

    @Override
    protected ObjectTableModel createModel(Plugin plugin) {
        return new RegionTableModel(plugin);
    }

    @Override
    protected ModelQuery computeQuery(TraceObject object) {
        List seedPath;
        TargetObjectSchema rootSchema = object.getRoot().getTargetSchema();
        List processPath = rootSchema.searchForAncestor(TargetProcess.class, seedPath = object.getCanonicalPath().getKeyList());
        if (processPath != null) {
            return DebuggerRegionsPanel.successorRegions(rootSchema, processPath);
        }
        List memoryPath = rootSchema.searchForSuitable(TargetMemory.class, seedPath);
        if (memoryPath != null) {
            return DebuggerRegionsPanel.successorRegions(rootSchema, memoryPath);
        }
        return DebuggerRegionsPanel.successorRegions(rootSchema, List.of());
    }

    public void setSelectedRegions(Set<TraceMemoryRegion> sel) {
        this.setSelected(sel);
    }

    private static class RegionTableModel
    extends ObjectTableModel {
        protected RegionTableModel(Plugin plugin) {
            super(plugin);
        }

        @Override
        protected TableColumnDescriptor<ObjectTableModel.ValueRow> createTableColumnDescriptor() {
            TableColumnDescriptor descriptor = new TableColumnDescriptor();
            descriptor.addHiddenColumn((DynamicTableColumn)new RegionKeyColumn());
            descriptor.addHiddenColumn((DynamicTableColumn)new RegionPathColumn());
            descriptor.addVisibleColumn((DynamicTableColumn)new RegionNameColumn());
            descriptor.addVisibleColumn((DynamicTableColumn)new RegionStartColumn(), 1, true);
            descriptor.addVisibleColumn((DynamicTableColumn)new RegionEndColumn());
            descriptor.addVisibleColumn((DynamicTableColumn)new RegionLengthColumn());
            descriptor.addVisibleColumn((DynamicTableColumn)new RegionReadColumn());
            descriptor.addVisibleColumn((DynamicTableColumn)new RegionWriteColumn());
            descriptor.addVisibleColumn((DynamicTableColumn)new RegionExecuteColumn());
            return descriptor;
        }
    }

    public static class RegionExecuteColumn
    extends RegionFlagColumn {
        public RegionExecuteColumn() {
            super("_executable");
        }

        @Override
        public String getColumnName() {
            return "Execute";
        }
    }

    public static class RegionWriteColumn
    extends RegionFlagColumn {
        public RegionWriteColumn() {
            super("_writable");
        }

        @Override
        public String getColumnName() {
            return "Write";
        }
    }

    public static class RegionReadColumn
    extends RegionFlagColumn {
        public RegionReadColumn() {
            super("_readable");
        }

        @Override
        public String getColumnName() {
            return "Read";
        }
    }

    public static abstract class RegionFlagColumn
    extends TraceValueObjectAttributeColumn<Boolean> {
        public RegionFlagColumn(String attributeName) {
            super(attributeName, Boolean.class);
        }

        public int getColumnPreferredWidth() {
            return 80;
        }
    }

    private static class RegionLengthColumn
    extends AbstractTraceValueObjectLengthColumn {
        public RegionLengthColumn() {
            super("_range");
        }

        public String getColumnName() {
            return "Length";
        }
    }

    private static class RegionEndColumn
    extends AbstractTraceValueObjectAddressColumn {
        public RegionEndColumn() {
            super("_range");
        }

        public String getColumnName() {
            return "End";
        }

        @Override
        protected Address fromRange(AddressRange range) {
            return range.getMaxAddress();
        }
    }

    private static class RegionStartColumn
    extends AbstractTraceValueObjectAddressColumn {
        public RegionStartColumn() {
            super("_range");
        }

        public String getColumnName() {
            return "Start";
        }

        @Override
        protected Address fromRange(AddressRange range) {
            return range.getMinAddress();
        }
    }

    private static class RegionNameColumn
    extends TraceValueValColumn {
        private RegionNameColumn() {
        }

        @Override
        public String getColumnName() {
            return "Name";
        }
    }

    private static class RegionPathColumn
    extends TraceValueKeyColumn {
        private RegionPathColumn() {
        }

        @Override
        public String getColumnName() {
            return "Path";
        }

        @Override
        public String getValue(ObjectTableModel.ValueRow rowObject, Settings settings, Trace data, ServiceProvider serviceProvider) throws IllegalArgumentException {
            return rowObject.getValue().getCanonicalPath().toString();
        }
    }

    private static class RegionKeyColumn
    extends TraceValueKeyColumn {
        private RegionKeyColumn() {
        }

        @Override
        public String getColumnName() {
            return "Key";
        }
    }
}

