/*
 * Decompiled with CFR 0.152.
 */
package ghidra.app.plugin.core.debug.gui.model.columns;

import docking.widgets.table.AbstractDynamicTableColumn;
import docking.widgets.table.GTableHeaderRenderer;
import docking.widgets.table.RangeCursorTableHeaderRenderer;
import docking.widgets.table.SpanTableCellRenderer;
import generic.Span;
import ghidra.app.plugin.core.debug.gui.model.PathTableModel;
import ghidra.docking.settings.Settings;
import ghidra.framework.plugintool.ServiceProvider;
import ghidra.trace.model.Lifespan;
import ghidra.trace.model.Trace;
import ghidra.trace.model.target.TraceObjectValue;
import ghidra.util.table.column.GColumnRenderer;

public class TracePathLastLifespanPlotColumn
extends AbstractDynamicTableColumn<PathTableModel.PathRow, Span<Long, ?>, Trace> {
    private final SpanTableCellRenderer<Long> cellRenderer = new SpanTableCellRenderer();
    private final RangeCursorTableHeaderRenderer<Long> headerRenderer = new RangeCursorTableHeaderRenderer((Number)0L);

    public String getColumnName() {
        return "Plot";
    }

    public Lifespan getValue(PathTableModel.PathRow rowObject, Settings settings, Trace data, ServiceProvider serviceProvider) throws IllegalArgumentException {
        TraceObjectValue lastEntry = rowObject.getPath().getLastEntry();
        if (lastEntry == null) {
            return Lifespan.ALL;
        }
        return lastEntry.getLifespan();
    }

    public GColumnRenderer<Span<Long, ?>> getColumnRenderer() {
        return this.cellRenderer;
    }

    public GTableHeaderRenderer getHeaderRenderer() {
        return this.headerRenderer;
    }

    public void setFullRange(Lifespan fullRange) {
        this.cellRenderer.setFullRange((Span)fullRange);
        this.headerRenderer.setFullRange((Span)fullRange);
    }

    public void setSnap(long snap) {
        this.headerRenderer.setCursorPosition((Number)snap);
    }

    public void addSeekListener(RangeCursorTableHeaderRenderer.SeekListener listener) {
        this.headerRenderer.addSeekListener(listener);
    }
}

