/*
 * Decompiled with CFR 0.152.
 */
package ghidra.app.plugin.core.debug.gui.modules;

import docking.ReusableDialogComponentProvider;
import docking.widgets.model.GAddressRangeField;
import docking.widgets.model.GSpanField;
import ghidra.app.plugin.core.debug.utils.MiscellaneousUtils;
import ghidra.app.services.DebuggerStaticMappingService;
import ghidra.framework.model.DomainFile;
import ghidra.program.model.address.Address;
import ghidra.program.model.address.AddressOverflowException;
import ghidra.program.model.address.AddressRange;
import ghidra.program.model.address.AddressRangeImpl;
import ghidra.program.model.listing.Program;
import ghidra.program.util.ProgramLocation;
import ghidra.trace.model.DefaultTraceLocation;
import ghidra.trace.model.Lifespan;
import ghidra.trace.model.Trace;
import ghidra.trace.model.TraceLocation;
import ghidra.trace.model.modules.TraceConflictedMappingException;
import ghidra.util.MessageType;
import ghidra.util.layout.PairLayout;
import java.awt.Component;
import java.awt.Font;
import java.awt.LayoutManager;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextField;
import javax.swing.border.EmptyBorder;

public class DebuggerAddMappingDialog
extends ReusableDialogComponentProvider {
    private DebuggerStaticMappingService mappingService;
    private Program program;
    private Trace trace;
    private final JLabel labelProg = new JLabel();
    private final GAddressRangeField fieldProgRange = new GAddressRangeField();
    private final JLabel labelTrace = new JLabel();
    private final GAddressRangeField fieldTraceRange = new GAddressRangeField();
    private final JTextField fieldLength = new JTextField();
    private final GSpanField fieldSpan = new GSpanField();

    public DebuggerAddMappingDialog() {
        super("Add Static Mapping", false, true, true, false);
        this.populateComponents();
    }

    protected void populateComponents() {
        JPanel panel = new JPanel((LayoutManager)new PairLayout(5, 5));
        panel.setBorder(new EmptyBorder(10, 10, 10, 10));
        panel.add(new JLabel("Program: "));
        panel.add(this.labelProg);
        panel.add(new JLabel("Static Range: "));
        panel.add((Component)this.fieldProgRange);
        panel.add(new JLabel("Trace: "));
        panel.add(this.labelTrace);
        panel.add(new JLabel("Dynamic Range: "));
        panel.add((Component)this.fieldTraceRange);
        panel.add(new JLabel("Length: "));
        this.fieldLength.setFont(Font.decode("monospaced"));
        panel.add(this.fieldLength);
        panel.add(new JLabel("Lifespan: "));
        panel.add((Component)this.fieldSpan);
        MiscellaneousUtils.rigFocusAndEnter((Component)this.fieldProgRange, this::progRangeChanged);
        MiscellaneousUtils.rigFocusAndEnter((Component)this.fieldTraceRange, this::traceRangeChanged);
        MiscellaneousUtils.rigFocusAndEnter(this.fieldLength, this::lengthChanged);
        MiscellaneousUtils.rigFocusAndEnter((Component)this.fieldSpan, this::spanChanged);
        this.fieldSpan.setLifespan(Lifespan.nowOn((long)0L));
        this.addWorkPanel(panel);
        this.addApplyButton();
        this.addDismissButton();
        this.setDefaultButton(null);
    }

    public void setMappingService(DebuggerStaticMappingService mappingService) {
        this.mappingService = mappingService;
    }

    protected static void revalidateByLength(GAddressRangeField adjusted, GAddressRangeField other) {
        AddressRange adjRange = adjusted.getRange();
        if (adjRange == null) {
            return;
        }
        long lengthMinus1 = adjRange.getMaxAddress().subtract(adjRange.getMinAddress());
        AddressRange otherRange = other.getRange();
        if (otherRange == null) {
            return;
        }
        long maxLengthMinus1 = otherRange.getAddressSpace().getMaxAddress().subtract(otherRange.getMinAddress());
        if (Long.compareUnsigned(lengthMinus1, maxLengthMinus1) > 0) {
            adjusted.setRange(DebuggerAddMappingDialog.range(adjRange.getMinAddress(), maxLengthMinus1));
        }
    }

    protected void revalidateProgRange() {
        DebuggerAddMappingDialog.revalidateByLength(this.fieldProgRange, this.fieldTraceRange);
    }

    protected void revalidateTraceRange() {
        DebuggerAddMappingDialog.revalidateByLength(this.fieldTraceRange, this.fieldProgRange);
    }

    protected void setFieldLength(long length) {
        this.fieldLength.setText(MiscellaneousUtils.lengthToString(length));
    }

    public long getLength() {
        return MiscellaneousUtils.parseLength(this.fieldLength.getText(), 1L);
    }

    protected void revalidateLength() {
        long length = this.fieldLength.getText().trim().startsWith("-") ? 1L : this.getLength();
        length = MiscellaneousUtils.revalidateLengthByRange(this.fieldProgRange.getRange(), length);
        length = MiscellaneousUtils.revalidateLengthByRange(this.fieldTraceRange.getRange(), length);
        this.setFieldLength(length);
    }

    protected void revalidateSpan() {
    }

    protected static AddressRange range(Address min, long lengthMinus1) {
        return new AddressRangeImpl(min, min.addWrap(lengthMinus1));
    }

    protected void adjustLengthToProgRange() {
        long length = this.fieldProgRange.getRange().getLength();
        this.setFieldLength(length);
    }

    protected void adjustLengthToTraceRange() {
        long length = this.fieldTraceRange.getRange().getLength();
        this.setFieldLength(length);
    }

    protected void adjustRangeToLength(GAddressRangeField field) {
        AddressRange range = field.getRange();
        if (range == null) {
            return;
        }
        Address min = range.getMinAddress();
        field.setRange(DebuggerAddMappingDialog.range(min, this.getLength() - 1L));
    }

    protected void adjustProgRangeToLength() {
        this.adjustRangeToLength(this.fieldProgRange);
    }

    protected void adjustTraceRangeToLength() {
        this.adjustRangeToLength(this.fieldTraceRange);
    }

    protected void progRangeChanged() {
        this.revalidateProgRange();
        this.adjustLengthToProgRange();
        this.adjustTraceRangeToLength();
    }

    protected void traceRangeChanged() {
        this.revalidateTraceRange();
        this.adjustLengthToTraceRange();
        this.adjustProgRangeToLength();
    }

    protected void lengthChanged() {
        this.revalidateLength();
        this.adjustProgRangeToLength();
        this.adjustTraceRangeToLength();
    }

    protected void spanChanged() {
        this.revalidateSpan();
    }

    protected void dialogShown() {
        super.dialogShown();
        this.setStatusText("");
    }

    protected void applyCallback() {
        DefaultTraceLocation from = new DefaultTraceLocation(this.trace, null, this.fieldSpan.getLifespan(), this.fieldTraceRange.getRange().getMinAddress());
        ProgramLocation to = new ProgramLocation(this.program, this.fieldProgRange.getRange().getMinAddress());
        try {
            this.mappingService.addMapping((TraceLocation)from, to, this.getLength(), false);
            this.setStatusText("");
        }
        catch (TraceConflictedMappingException e) {
            this.setStatusText(e.getMessage(), MessageType.ERROR);
        }
    }

    protected void dismissCallback() {
        this.setStatusText("");
        super.dismissCallback();
    }

    public void setValues(Program program, Trace trace, Address progStart, Address traceStart, long length, Lifespan lifespan) throws AddressOverflowException {
        this.program = program;
        this.trace = trace;
        this.fieldProgRange.setAddressFactory(program.getAddressFactory());
        this.fieldProgRange.setRange(DebuggerAddMappingDialog.range(progStart, length - 1L));
        this.fieldTraceRange.setAddressFactory(trace.getBaseAddressFactory());
        this.fieldTraceRange.setRange(DebuggerAddMappingDialog.range(traceStart, length - 1L));
        this.setFieldLength(length);
        this.fieldSpan.setLifespan(lifespan);
    }

    protected void setEnabled(boolean enabled) {
        this.applyButton.setEnabled(enabled);
        this.fieldProgRange.setEnabled(enabled);
        this.fieldTraceRange.setEnabled(enabled);
        this.fieldLength.setEnabled(enabled);
        this.fieldSpan.setEnabled(enabled);
    }

    public void setTrace(Trace trace) {
        this.trace = trace;
        if (trace != null) {
            this.labelTrace.setText(trace.getName());
            this.fieldTraceRange.setAddressFactory(trace.getBaseAddressFactory());
        } else {
            this.labelTrace.setText("[No Trace]");
            this.fieldTraceRange.setAddressFactory(null);
        }
        if (this.program != null && trace != null) {
            this.traceRangeChanged();
            this.setEnabled(true);
        } else {
            this.setEnabled(false);
        }
    }

    public void setProgram(Program program) {
        this.program = program;
        if (program != null) {
            DomainFile df = program.getDomainFile();
            String name = df != null ? df.getName() : program.getName();
            this.labelProg.setText(name);
            this.fieldProgRange.setAddressFactory(program.getAddressFactory());
        } else {
            this.labelProg.setText("[No Program]");
            this.fieldProgRange.setAddressFactory(null);
        }
        if (program != null && this.trace != null) {
            this.progRangeChanged();
            this.setEnabled(true);
        } else {
            this.setEnabled(false);
        }
    }
}

