/*
 * Decompiled with CFR 0.152.
 */
package ghidra.app.plugin.core.debug.gui.stack;

import docking.widgets.table.CustomToStringCellRenderer;
import docking.widgets.table.DefaultEnumeratedColumnTableModel;
import docking.widgets.table.GTableCellRenderingData;
import docking.widgets.table.RowObjectTableModel;
import ghidra.app.plugin.core.debug.gui.stack.DebuggerStackActionContext;
import ghidra.app.plugin.core.debug.gui.stack.DebuggerStackPlugin;
import ghidra.app.plugin.core.debug.gui.stack.DebuggerStackProvider;
import ghidra.app.plugin.core.debug.gui.stack.StackFrameRow;
import ghidra.app.services.DebuggerListingService;
import ghidra.app.services.DebuggerStaticMappingService;
import ghidra.app.services.DebuggerTraceManagerService;
import ghidra.app.services.MarkerService;
import ghidra.debug.api.modules.DebuggerStaticMappingChangeListener;
import ghidra.debug.api.tracemgr.DebuggerCoordinates;
import ghidra.docking.settings.Settings;
import ghidra.framework.model.DomainObjectListener;
import ghidra.framework.plugintool.AutoService;
import ghidra.framework.plugintool.Plugin;
import ghidra.framework.plugintool.PluginTool;
import ghidra.framework.plugintool.annotation.AutoServiceConsumed;
import ghidra.program.model.address.Address;
import ghidra.program.model.lang.Register;
import ghidra.program.model.lang.RegisterValue;
import ghidra.program.model.listing.Program;
import ghidra.trace.model.Trace;
import ghidra.trace.model.TraceAddressSnapRange;
import ghidra.trace.model.TraceDomainObjectListener;
import ghidra.trace.model.memory.TraceMemorySpace;
import ghidra.trace.model.program.TraceProgramView;
import ghidra.trace.model.stack.TraceStack;
import ghidra.trace.model.stack.TraceStackFrame;
import ghidra.trace.model.thread.TraceThread;
import ghidra.trace.util.TraceAddressSpace;
import ghidra.trace.util.TraceChangeType;
import ghidra.trace.util.TraceRegisterUtils;
import ghidra.util.Swing;
import ghidra.util.table.GhidraTable;
import ghidra.util.table.GhidraTableFilterPanel;
import ghidra.util.table.column.AbstractGColumnRenderer;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;
import java.util.function.BiConsumer;
import java.util.function.Function;
import java.util.function.Predicate;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.table.TableCellRenderer;
import javax.swing.table.TableColumn;
import javax.swing.table.TableColumnModel;
import javax.swing.table.TableModel;

public class DebuggerLegacyStackPanel
extends JPanel {
    final DebuggerStackProvider provider;
    @AutoServiceConsumed
    private DebuggerTraceManagerService traceManager;
    DebuggerStaticMappingService mappingService;
    @AutoServiceConsumed
    private DebuggerListingService listingService;
    @AutoServiceConsumed
    private MarkerService markerService;
    private final AutoService.Wiring autoServiceWiring;
    final TableCellRenderer boldCurrentRenderer = new AbstractGColumnRenderer<Object>(){

        public String getFilterString(Object t, Settings settings) {
            return t == null ? "<null>" : t.toString();
        }

        public Component getTableCellRendererComponent(GTableCellRenderingData data) {
            super.getTableCellRendererComponent(data);
            StackFrameRow row = (StackFrameRow)data.getRowObject();
            if (row != null && row.getFrameLevel() == DebuggerLegacyStackPanel.this.current.getFrame()) {
                this.setBold();
            }
            return this;
        }
    };
    DebuggerCoordinates current = DebuggerCoordinates.NOWHERE;
    private Trace currentTrace;
    private TraceStack currentStack;
    private ForStackListener forStackListener = new ForStackListener();
    private ForFunctionsListener forFunctionsListener = new ForFunctionsListener();
    protected final StackTableModel stackTableModel;
    protected GhidraTable stackTable;
    protected GhidraTableFilterPanel<StackFrameRow> stackFilterPanel;
    private DebuggerStackActionContext myActionContext;

    public DebuggerLegacyStackPanel(DebuggerStackPlugin plugin, DebuggerStackProvider provider) {
        super(new BorderLayout());
        this.provider = provider;
        this.autoServiceWiring = AutoService.wireServicesConsumed((Plugin)plugin, (Object)this);
        this.stackTableModel = new StackTableModel(provider.getTool());
        this.stackTable = new GhidraTable((TableModel)((Object)this.stackTableModel));
        this.add(new JScrollPane((Component)this.stackTable));
        this.stackFilterPanel = new GhidraTableFilterPanel((JTable)this.stackTable, (RowObjectTableModel)this.stackTableModel);
        this.add((Component)this.stackFilterPanel, "South");
        this.stackTable.getSelectionModel().addListSelectionListener(evt -> {
            if (evt.getValueIsAdjusting()) {
                return;
            }
            this.contextChanged();
        });
        this.stackTable.addMouseListener((MouseListener)new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent e) {
                if (e.getClickCount() == 2 && e.getButton() == 1) {
                    DebuggerLegacyStackPanel.this.activateSelectedFrame();
                }
            }
        });
        this.stackTable.addKeyListener((KeyListener)new KeyAdapter(){

            @Override
            public void keyPressed(KeyEvent e) {
                if (e.getKeyCode() == 10) {
                    DebuggerLegacyStackPanel.this.activateSelectedFrame();
                    e.consume();
                }
            }
        });
        TableColumnModel columnModel = this.stackTable.getColumnModel();
        TableColumn levelCol = columnModel.getColumn(StackTableColumns.LEVEL.ordinal());
        levelCol.setPreferredWidth(25);
        levelCol.setCellRenderer(this.boldCurrentRenderer);
        TableColumn pcCol = columnModel.getColumn(StackTableColumns.PC.ordinal());
        pcCol.setCellRenderer((TableCellRenderer)CustomToStringCellRenderer.MONO_OBJECT);
        pcCol.setCellRenderer(this.boldCurrentRenderer);
        TableColumn funcCol = columnModel.getColumn(StackTableColumns.FUNCTION.ordinal());
        funcCol.setCellRenderer(this.boldCurrentRenderer);
        TableColumn commCol = columnModel.getColumn(StackTableColumns.COMMENT.ordinal());
        commCol.setCellRenderer(this.boldCurrentRenderer);
    }

    protected void contextChanged() {
        StackFrameRow row = (StackFrameRow)this.stackFilterPanel.getSelectedItem();
        this.myActionContext = row == null ? null : new DebuggerStackActionContext(this.provider, row, (Component)this.stackTable);
        this.provider.contextChanged();
    }

    protected void activateSelectedFrame() {
        if (this.myActionContext == null) {
            return;
        }
        if (this.traceManager == null) {
            return;
        }
        this.traceManager.activateFrame(this.myActionContext.getFrame().getFrameLevel());
    }

    protected void updateStack() {
        LinkedHashSet toAdd = new LinkedHashSet(this.currentStack.getFrames(this.current.getSnap()));
        Iterator it = this.stackTableModel.getModelData().iterator();
        while (it.hasNext()) {
            StackFrameRow row = (StackFrameRow)it.next();
            if (!toAdd.remove(row.frame)) {
                it.remove();
                continue;
            }
            row.update();
        }
        for (TraceStackFrame frame : toAdd) {
            this.stackTableModel.add(new StackFrameRow(this, frame));
        }
        this.stackTableModel.fireTableDataChanged();
    }

    protected void doSetCurrentStack(TraceStack stack) {
        if (stack == null) {
            this.currentStack = null;
            this.stackTableModel.clear();
            this.contextChanged();
            return;
        }
        if (this.currentStack == stack && stack.hasFixedFrames()) {
            this.stackTableModel.fireTableDataChanged();
            return;
        }
        this.currentStack = stack;
        this.stackTableModel.clear();
        for (TraceStackFrame frame : this.currentStack.getFrames(this.current.getSnap())) {
            this.stackTableModel.add(new StackFrameRow(this, frame));
        }
    }

    protected void doSetSyntheticStack() {
        TraceMemorySpace regs;
        this.stackTableModel.clear();
        this.currentStack = null;
        Trace curTrace = this.current.getTrace();
        Register pc = curTrace.getBaseLanguage().getProgramCounter();
        if (pc == null) {
            this.contextChanged();
            return;
        }
        TraceMemorySpace traceMemorySpace = regs = pc.getAddressSpace().isRegisterSpace() ? curTrace.getMemoryManager().getMemoryRegisterSpace(this.current.getThread(), false) : curTrace.getMemoryManager().getMemorySpace(pc.getAddressSpace(), false);
        if (regs == null) {
            this.contextChanged();
            return;
        }
        RegisterValue value = regs.getViewValue(this.current.getViewSnap(), pc);
        if (value == null) {
            this.contextChanged();
            return;
        }
        Address address = curTrace.getBaseLanguage().getDefaultSpace().getAddress(value.getUnsignedValue().longValue(), true);
        this.stackTableModel.add(new StackFrameRow.Synthetic(this, address));
    }

    protected void loadStack() {
        TraceThread curThread = this.current.getThread();
        if (curThread == null) {
            this.doSetCurrentStack(null);
            return;
        }
        TraceStack stack = this.current.getTrace().getStackManager().getLatestStack(curThread, this.current.getViewSnap());
        if (stack == null) {
            this.doSetSyntheticStack();
        } else {
            this.doSetCurrentStack(stack);
        }
    }

    private void removeOldListeners() {
        if (this.currentTrace == null) {
            return;
        }
        this.currentTrace.removeListener((DomainObjectListener)this.forStackListener);
    }

    private void addNewListeners() {
        if (this.currentTrace == null) {
            return;
        }
        this.currentTrace.addListener((DomainObjectListener)this.forStackListener);
    }

    private void doSetTrace(Trace trace) {
        if (this.currentTrace == trace) {
            return;
        }
        this.removeOldListeners();
        this.currentTrace = trace;
        this.addNewListeners();
    }

    public void coordinatesActivated(DebuggerCoordinates coordinates) {
        this.current = coordinates;
        this.doSetTrace(this.current.getTrace());
        this.loadStack();
        this.selectCurrentFrame();
    }

    protected void selectCurrentFrame() {
        StackFrameRow row = (StackFrameRow)this.stackTableModel.findFirst(r -> r.getFrameLevel() == this.current.getFrame());
        if (row == null) {
            this.stackTable.clearSelection();
        } else {
            this.stackFilterPanel.setSelectedItem((Object)row);
        }
    }

    public DebuggerStackActionContext getActionContext() {
        return this.myActionContext;
    }

    @AutoServiceConsumed
    private void setMappingService(DebuggerStaticMappingService mappingService) {
        if (this.mappingService != null) {
            this.mappingService.removeChangeListener((DebuggerStaticMappingChangeListener)this.forFunctionsListener);
        }
        this.mappingService = mappingService;
        if (this.mappingService != null) {
            this.mappingService.addChangeListener((DebuggerStaticMappingChangeListener)this.forFunctionsListener);
        }
    }

    class ForStackListener
    extends TraceDomainObjectListener {
        public ForStackListener() {
            this.listenFor((TraceChangeType)Trace.TraceStackChangeType.ADDED, this::stackAdded);
            this.listenFor((TraceChangeType)Trace.TraceStackChangeType.CHANGED, this::stackChanged);
            this.listenFor((TraceChangeType)Trace.TraceStackChangeType.DELETED, this::stackDeleted);
            this.listenFor((TraceChangeType)Trace.TraceMemoryBytesChangeType.CHANGED, this::bytesChanged);
        }

        private void stackAdded(TraceStack stack) {
            if (stack.getSnap() != DebuggerLegacyStackPanel.this.current.getViewSnap()) {
                return;
            }
            TraceThread curThread = DebuggerLegacyStackPanel.this.current.getThread();
            if (curThread != stack.getThread()) {
                return;
            }
            DebuggerLegacyStackPanel.this.loadStack();
        }

        private void stackChanged(TraceStack stack) {
            if (DebuggerLegacyStackPanel.this.currentStack != stack) {
                return;
            }
            DebuggerLegacyStackPanel.this.updateStack();
        }

        private void stackDeleted(TraceStack stack) {
            if (DebuggerLegacyStackPanel.this.currentStack != stack) {
                return;
            }
            DebuggerLegacyStackPanel.this.loadStack();
        }

        private void bytesChanged(TraceAddressSpace space, TraceAddressSnapRange range) {
            TraceThread curThread = DebuggerLegacyStackPanel.this.current.getThread();
            if (space.getThread() != curThread || space.getFrameLevel() != 0) {
                return;
            }
            TraceProgramView view = DebuggerLegacyStackPanel.this.current.getView();
            if (view == null) {
                return;
            }
            if (!view.getViewport().containsAnyUpper(range.getLifespan())) {
                return;
            }
            List stackData = DebuggerLegacyStackPanel.this.stackTableModel.getModelData();
            if (stackData.isEmpty() || !(stackData.get(0) instanceof StackFrameRow.Synthetic)) {
                return;
            }
            StackFrameRow.Synthetic frameRow = (StackFrameRow.Synthetic)stackData.get(0);
            Trace trace = DebuggerLegacyStackPanel.this.current.getTrace();
            Register pc = trace.getBaseLanguage().getProgramCounter();
            if (!TraceRegisterUtils.rangeForRegister((Register)pc).intersects(range.getRange())) {
                return;
            }
            TraceMemorySpace regs = trace.getMemoryManager().getMemoryRegisterSpace(curThread, false);
            RegisterValue value = regs.getViewValue(DebuggerLegacyStackPanel.this.current.getViewSnap(), pc);
            Address address = trace.getBaseLanguage().getDefaultSpace().getAddress(value.getUnsignedValue().longValue());
            frameRow.updateProgramCounter(address);
            DebuggerLegacyStackPanel.this.stackTableModel.fireTableDataChanged();
        }
    }

    class ForFunctionsListener
    implements DebuggerStaticMappingChangeListener {
        ForFunctionsListener() {
        }

        public void mappingsChanged(Set<Trace> affectedTraces, Set<Program> affectedPrograms) {
            Trace curTrace = DebuggerLegacyStackPanel.this.current.getTrace();
            if (curTrace == null || !affectedTraces.contains(curTrace)) {
                return;
            }
            Swing.runIfSwingOrRunLater(() -> DebuggerLegacyStackPanel.this.stackTableModel.fireTableDataChanged());
        }
    }

    protected static class StackTableModel
    extends DefaultEnumeratedColumnTableModel<StackTableColumns, StackFrameRow> {
        public StackTableModel(PluginTool tool) {
            super(tool, "Stack", StackTableColumns.class);
        }

        public List<StackTableColumns> defaultSortOrder() {
            return List.of(StackTableColumns.LEVEL);
        }
    }

    protected static enum StackTableColumns implements DefaultEnumeratedColumnTableModel.EnumeratedTableColumn<StackTableColumns, StackFrameRow>
    {
        LEVEL("Level", Integer.class, StackFrameRow::getFrameLevel),
        PC("PC", Address.class, StackFrameRow::getProgramCounter),
        FUNCTION("Function", ghidra.program.model.listing.Function.class, StackFrameRow::getFunction),
        COMMENT("Comment", String.class, StackFrameRow::getComment, StackFrameRow::setComment, StackFrameRow::isCommentable);

        private final String header;
        private final Function<StackFrameRow, ?> getter;
        private final BiConsumer<StackFrameRow, Object> setter;
        private final Predicate<StackFrameRow> editable;
        private final Class<?> cls;

        private <T> StackTableColumns(String header, Class<T> cls, Function<StackFrameRow, T> getter, BiConsumer<StackFrameRow, T> setter, Predicate<StackFrameRow> editable) {
            this.header = header;
            this.cls = cls;
            this.getter = getter;
            this.setter = setter;
            this.editable = editable;
        }

        private <T> StackTableColumns(String header, Class<T> cls, Function<StackFrameRow, T> getter) {
            this(header, cls, getter, null, null);
        }

        public Class<?> getValueClass() {
            return this.cls;
        }

        public Object getValueOf(StackFrameRow row) {
            return this.getter.apply(row);
        }

        public void setValueOf(StackFrameRow row, Object value) {
            this.setter.accept(row, value);
        }

        public String getHeader() {
            return this.header;
        }

        public boolean isEditable(StackFrameRow row) {
            return this.setter != null && this.editable.test(row);
        }
    }
}

