/*
 * Decompiled with CFR 0.152.
 */
package ghidra.app.plugin.core.debug.gui.stack;

import docking.ComponentProvider;
import docking.widgets.table.AbstractDynamicTableColumn;
import docking.widgets.table.DynamicTableColumn;
import docking.widgets.table.TableColumnDescriptor;
import ghidra.app.plugin.core.debug.gui.model.AbstractObjectsTableBasedPanel;
import ghidra.app.plugin.core.debug.gui.model.AbstractQueryTablePanel;
import ghidra.app.plugin.core.debug.gui.model.ModelQuery;
import ghidra.app.plugin.core.debug.gui.model.ObjectTableModel;
import ghidra.app.plugin.core.debug.gui.model.columns.TraceValueKeyColumn;
import ghidra.app.plugin.core.debug.gui.model.columns.TraceValueObjectAttributeColumn;
import ghidra.app.plugin.core.debug.gui.stack.DebuggerStackProvider;
import ghidra.app.services.DebuggerTraceManagerService;
import ghidra.dbg.target.TargetStack;
import ghidra.dbg.target.TargetStackFrame;
import ghidra.dbg.target.schema.TargetObjectSchema;
import ghidra.dbg.util.PathMatcher;
import ghidra.dbg.util.PathPredicates;
import ghidra.debug.api.tracemgr.DebuggerCoordinates;
import ghidra.docking.settings.Settings;
import ghidra.framework.plugintool.Plugin;
import ghidra.framework.plugintool.ServiceProvider;
import ghidra.framework.plugintool.annotation.AutoServiceConsumed;
import ghidra.program.model.address.Address;
import ghidra.program.model.listing.Function;
import ghidra.trace.model.Trace;
import ghidra.trace.model.stack.TraceObjectStackFrame;
import ghidra.trace.model.target.TraceObject;
import ghidra.trace.model.target.TraceObjectValue;
import java.util.List;
import javax.swing.JTable;
import javax.swing.event.ListSelectionListener;

public class DebuggerStackPanel
extends AbstractObjectsTableBasedPanel<TraceObjectStackFrame>
implements ListSelectionListener,
AbstractQueryTablePanel.CellActivationListener {
    private final DebuggerStackProvider provider;
    @AutoServiceConsumed
    protected DebuggerTraceManagerService traceManager;

    public DebuggerStackPanel(DebuggerStackProvider provider) {
        super(provider.plugin, (ComponentProvider)provider, TraceObjectStackFrame.class);
        this.provider = provider;
    }

    @Override
    protected ObjectTableModel createModel(Plugin plugin) {
        return new StackTableModel(plugin);
    }

    @Override
    protected ModelQuery computeQuery(TraceObject object) {
        TargetObjectSchema rootSchema = object.getRoot().getTargetSchema();
        List stackPath = rootSchema.searchForSuitable(TargetStack.class, object.getCanonicalPath().getKeyList());
        if (stackPath == null) {
            return ModelQuery.EMPTY;
        }
        TargetObjectSchema stackSchema = rootSchema.getSuccessorSchema(stackPath);
        PathMatcher matcher = stackSchema.searchFor(TargetStackFrame.class, stackPath, true);
        return new ModelQuery((PathPredicates)matcher);
    }

    @Override
    public void coordinatesActivated(DebuggerCoordinates coordinates) {
        super.coordinatesActivated(coordinates);
        TraceObject object = coordinates.getObject();
        if (object != null) {
            this.trySelectAncestor(object);
        }
    }

    @Override
    public void cellActivated(JTable table) {
        ObjectTableModel.ValueRow item = (ObjectTableModel.ValueRow)this.getSelectedItem();
        if (item != null) {
            this.traceManager.activateObject(item.getValue().getChild());
        }
    }

    private class StackTableModel
    extends ObjectTableModel {
        protected StackTableModel(Plugin plugin) {
            super(plugin);
        }

        @Override
        protected TableColumnDescriptor<ObjectTableModel.ValueRow> createTableColumnDescriptor() {
            TableColumnDescriptor descriptor = new TableColumnDescriptor();
            descriptor.addVisibleColumn((DynamicTableColumn)new FrameLevelColumn(), 1, true);
            descriptor.addVisibleColumn((DynamicTableColumn)new FramePcColumn());
            descriptor.addVisibleColumn((DynamicTableColumn)new FrameFunctionColumn());
            return descriptor;
        }
    }

    private class FrameFunctionColumn
    extends AbstractDynamicTableColumn<ObjectTableModel.ValueRow, Function, Trace> {
        private FrameFunctionColumn() {
        }

        public String getColumnName() {
            return "Function";
        }

        public Function getValue(ObjectTableModel.ValueRow rowObject, Settings settings, Trace data, ServiceProvider serviceProvider) throws IllegalArgumentException {
            TraceObjectValue value = rowObject.getAttributeEntry("_pc");
            return value == null ? null : DebuggerStackPanel.this.provider.getFunction((Address)value.getValue());
        }
    }

    private static class FramePcColumn
    extends TraceValueObjectAttributeColumn<Address> {
        public FramePcColumn() {
            super("_pc", Address.class);
        }

        @Override
        public String getColumnName() {
            return "PC";
        }
    }

    private static class FrameLevelColumn
    extends TraceValueKeyColumn {
        private FrameLevelColumn() {
        }

        @Override
        public String getColumnName() {
            return "Level";
        }

        public int getColumnPreferredWidth() {
            return 48;
        }
    }
}

