/*
 * Decompiled with CFR 0.152.
 */
package ghidra.app.plugin.core.debug.gui.thread;

import docking.ActionContext;
import docking.widgets.table.DefaultEnumeratedColumnTableModel;
import docking.widgets.table.GTable;
import docking.widgets.table.GTableCellRenderingData;
import docking.widgets.table.RangeCursorTableHeaderRenderer;
import docking.widgets.table.RowObjectTableModel;
import docking.widgets.table.RowWrappedEnumeratedColumnTableModel;
import docking.widgets.table.SpanTableCellRenderer;
import generic.Span;
import ghidra.app.plugin.core.debug.gui.DebuggerSnapActionContext;
import ghidra.app.plugin.core.debug.gui.thread.DebuggerThreadActionContext;
import ghidra.app.plugin.core.debug.gui.thread.DebuggerThreadsPlugin;
import ghidra.app.plugin.core.debug.gui.thread.DebuggerThreadsProvider;
import ghidra.app.plugin.core.debug.gui.thread.ThreadRow;
import ghidra.app.plugin.core.debug.gui.thread.ThreadState;
import ghidra.app.services.DebuggerTraceManagerService;
import ghidra.debug.api.tracemgr.DebuggerCoordinates;
import ghidra.docking.settings.Settings;
import ghidra.framework.model.DomainObjectChangeRecord;
import ghidra.framework.model.DomainObjectListener;
import ghidra.framework.plugintool.AutoService;
import ghidra.framework.plugintool.Plugin;
import ghidra.framework.plugintool.annotation.AutoServiceConsumed;
import ghidra.trace.model.Lifespan;
import ghidra.trace.model.Trace;
import ghidra.trace.model.TraceDomainObjectListener;
import ghidra.trace.model.TraceUniqueObject;
import ghidra.trace.model.thread.TraceThread;
import ghidra.trace.model.thread.TraceThreadManager;
import ghidra.trace.model.time.TraceSnapshot;
import ghidra.trace.util.TraceChangeType;
import ghidra.util.database.ObjectKey;
import ghidra.util.table.GhidraTable;
import ghidra.util.table.GhidraTableFilterPanel;
import ghidra.util.table.column.AbstractGColumnRenderer;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.event.FocusAdapter;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.util.function.BiConsumer;
import java.util.function.Function;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.event.ListSelectionEvent;
import javax.swing.table.TableCellRenderer;
import javax.swing.table.TableColumn;
import javax.swing.table.TableColumnModel;
import javax.swing.table.TableModel;

public class DebuggerLegacyThreadsPanel
extends JPanel {
    private final DebuggerThreadsProvider provider;
    DebuggerCoordinates current = DebuggerCoordinates.NOWHERE;
    private Trace currentTrace;
    @AutoServiceConsumed
    private DebuggerTraceManagerService traceManager;
    private final AutoService.Wiring autoServiceWiring;
    private final ForThreadsListener forThreadsListener = new ForThreadsListener();
    final SpanTableCellRenderer<Long> spanRenderer = new SpanTableCellRenderer();
    final RangeCursorTableHeaderRenderer<Long> headerRenderer = new RangeCursorTableHeaderRenderer((Number)0L);
    final TableCellRenderer boldCurrentRenderer = new AbstractGColumnRenderer<Object>(){

        public String getFilterString(Object t, Settings settings) {
            return t == null ? "<null>" : t.toString();
        }

        public Component getTableCellRendererComponent(GTableCellRenderingData data) {
            super.getTableCellRendererComponent(data);
            ThreadRow row = (ThreadRow)data.getRowObject();
            if (row != null && row.getThread() == DebuggerLegacyThreadsPanel.this.current.getThread()) {
                this.setBold();
            }
            return this;
        }
    };
    final ThreadTableModel threadTableModel;
    final GTable threadTable;
    final GhidraTableFilterPanel<ThreadRow> threadFilterPanel;
    private ActionContext myActionContext;
    RangeCursorTableHeaderRenderer.SeekListener seekListener;

    protected static long orZero(Long l) {
        return l == null ? 0L : l;
    }

    public DebuggerLegacyThreadsPanel(DebuggerThreadsPlugin plugin, DebuggerThreadsProvider provider) {
        super(new BorderLayout());
        this.provider = provider;
        this.autoServiceWiring = AutoService.wireServicesConsumed((Plugin)plugin, (Object)this);
        this.threadTableModel = new ThreadTableModel(provider);
        this.threadTable = new GhidraTable((TableModel)((Object)this.threadTableModel));
        this.threadTable.setSelectionMode(0);
        this.add(new JScrollPane((Component)this.threadTable));
        this.threadFilterPanel = new GhidraTableFilterPanel((JTable)this.threadTable, (RowObjectTableModel)this.threadTableModel);
        this.add((Component)this.threadFilterPanel, "South");
        this.myActionContext = new DebuggerSnapActionContext(this.current.getTrace(), this.current.getViewSnap());
        this.threadTable.getSelectionModel().addListSelectionListener(this::threadRowSelected);
        this.threadTable.addMouseListener((MouseListener)new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent e) {
                if (e.getClickCount() == 2 && e.getButton() == 1) {
                    DebuggerLegacyThreadsPanel.this.activateSelectedThread();
                }
            }
        });
        this.threadTable.addKeyListener((KeyListener)new KeyAdapter(){

            @Override
            public void keyPressed(KeyEvent e) {
                if (e.getKeyCode() == 10) {
                    DebuggerLegacyThreadsPanel.this.activateSelectedThread();
                    e.consume();
                }
            }
        });
        this.threadTable.addFocusListener((FocusListener)new FocusAdapter(){

            @Override
            public void focusGained(FocusEvent e) {
                DebuggerLegacyThreadsPanel.this.setThreadRowActionContext();
            }
        });
        this.threadTable.addMouseListener((MouseListener)new MouseAdapter(){

            @Override
            public void mousePressed(MouseEvent e) {
                DebuggerLegacyThreadsPanel.this.setThreadRowActionContext();
            }
        });
        TableColumnModel columnModel = this.threadTable.getColumnModel();
        TableColumn colName = columnModel.getColumn(ThreadTableColumns.NAME.ordinal());
        colName.setPreferredWidth(100);
        colName.setCellRenderer(this.boldCurrentRenderer);
        TableColumn colCreated = columnModel.getColumn(ThreadTableColumns.CREATED.ordinal());
        colCreated.setPreferredWidth(10);
        colCreated.setCellRenderer(this.boldCurrentRenderer);
        TableColumn colDestroyed = columnModel.getColumn(ThreadTableColumns.DESTROYED.ordinal());
        colDestroyed.setPreferredWidth(10);
        colDestroyed.setCellRenderer(this.boldCurrentRenderer);
        TableColumn colState = columnModel.getColumn(ThreadTableColumns.STATE.ordinal());
        colState.setPreferredWidth(20);
        colState.setCellRenderer(this.boldCurrentRenderer);
        TableColumn colComment = columnModel.getColumn(ThreadTableColumns.COMMENT.ordinal());
        colComment.setPreferredWidth(100);
        colComment.setCellRenderer(this.boldCurrentRenderer);
        TableColumn colPlot = columnModel.getColumn(ThreadTableColumns.PLOT.ordinal());
        colPlot.setPreferredWidth(200);
        colPlot.setCellRenderer((TableCellRenderer)this.spanRenderer);
        colPlot.setHeaderRenderer((TableCellRenderer)this.headerRenderer);
        this.seekListener = pos -> {
            long snap = Math.round(pos);
            if (this.current.getTrace() == null || snap < 0L) {
                snap = 0L;
            }
            this.traceManager.activateSnap(snap);
            this.myActionContext = new DebuggerSnapActionContext(this.current.getTrace(), snap);
            provider.legacyThreadsPanelContextChanged();
        };
        this.headerRenderer.addSeekListener(this.seekListener);
    }

    private void removeOldListeners() {
        if (this.currentTrace == null) {
            return;
        }
        this.currentTrace.removeListener((DomainObjectListener)this.forThreadsListener);
    }

    private void addNewListeners() {
        if (this.currentTrace == null) {
            return;
        }
        this.currentTrace.addListener((DomainObjectListener)this.forThreadsListener);
    }

    private void doSetTrace(Trace trace) {
        if (this.currentTrace == trace) {
            return;
        }
        this.removeOldListeners();
        this.currentTrace = trace;
        this.addNewListeners();
        this.loadThreads();
    }

    protected void coordinatesActivated(DebuggerCoordinates coordinates) {
        this.current = coordinates;
        this.doSetTrace(coordinates.getTrace());
        this.doSetThread(coordinates.getThread());
        this.doSetSnap(coordinates.getSnap());
    }

    private void doSetThread(TraceThread thread) {
        if (thread != null) {
            this.threadFilterPanel.setSelectedItem((Object)((ThreadRow)this.threadTableModel.getRow(thread)));
        } else {
            this.threadTable.clearSelection();
        }
        this.threadTableModel.fireTableDataChanged();
    }

    private void doSetSnap(long snap) {
        this.headerRenderer.setCursorPosition((Number)snap);
        this.threadTable.getTableHeader().repaint();
    }

    protected void loadThreads() {
        this.threadTableModel.clear();
        Trace curTrace = this.current.getTrace();
        if (curTrace == null) {
            return;
        }
        TraceThreadManager manager = curTrace.getThreadManager();
        this.threadTableModel.addAllItems(manager.getAllThreads());
        this.updateTimelineMax();
    }

    protected void updateTimelineMax() {
        Trace trace = this.current.getTrace();
        long max = DebuggerLegacyThreadsPanel.orZero(trace == null ? null : trace.getTimeManager().getMaxSnap());
        Lifespan fullRange = Lifespan.span((long)0L, (long)(max + 1L));
        this.spanRenderer.setFullRange((Span)fullRange);
        this.headerRenderer.setFullRange((Span)fullRange);
        this.threadTable.getTableHeader().repaint();
    }

    private void threadRowSelected(ListSelectionEvent e) {
        if (e.getValueIsAdjusting()) {
            return;
        }
        this.setThreadRowActionContext();
    }

    private void activateSelectedThread() {
        ThreadRow row = this.setThreadRowActionContext();
        if (row != null && this.traceManager != null) {
            this.traceManager.activateThread(row.getThread());
        }
    }

    public ActionContext getActionContext() {
        return this.myActionContext;
    }

    private ThreadRow setThreadRowActionContext() {
        ThreadRow row = (ThreadRow)this.threadFilterPanel.getSelectedItem();
        this.myActionContext = new DebuggerThreadActionContext(this.current.getTrace(), row == null ? null : row.getThread());
        this.provider.legacyThreadsPanelContextChanged();
        return row;
    }

    private class ForThreadsListener
    extends TraceDomainObjectListener {
        public ForThreadsListener() {
            this.listenForUntyped(4, this::objectRestored);
            this.listenFor((TraceChangeType)Trace.TraceThreadChangeType.ADDED, this::threadAdded);
            this.listenFor((TraceChangeType)Trace.TraceThreadChangeType.CHANGED, this::threadChanged);
            this.listenFor((TraceChangeType)Trace.TraceThreadChangeType.LIFESPAN_CHANGED, this::threadChanged);
            this.listenFor((TraceChangeType)Trace.TraceThreadChangeType.DELETED, this::threadDeleted);
            this.listenFor((TraceChangeType)Trace.TraceSnapshotChangeType.ADDED, this::snapAdded);
            this.listenFor((TraceChangeType)Trace.TraceSnapshotChangeType.DELETED, this::snapDeleted);
        }

        private void objectRestored(DomainObjectChangeRecord rec) {
            DebuggerLegacyThreadsPanel.this.loadThreads();
        }

        private void threadAdded(TraceThread thread) {
            DebuggerLegacyThreadsPanel.this.threadTableModel.addItem(thread);
        }

        private void threadChanged(TraceThread thread) {
            DebuggerLegacyThreadsPanel.this.threadTableModel.updateItem(thread);
        }

        private void threadDeleted(TraceThread thread) {
            DebuggerLegacyThreadsPanel.this.threadTableModel.deleteItem(thread);
        }

        private void snapAdded(TraceSnapshot snapshot) {
            DebuggerLegacyThreadsPanel.this.updateTimelineMax();
        }

        private void snapDeleted() {
            DebuggerLegacyThreadsPanel.this.updateTimelineMax();
        }
    }

    protected static class ThreadTableModel
    extends RowWrappedEnumeratedColumnTableModel<ThreadTableColumns, ObjectKey, ThreadRow, TraceThread> {
        public ThreadTableModel(DebuggerThreadsProvider provider) {
            super(provider.getTool(), "Threads", ThreadTableColumns.class, TraceUniqueObject::getObjectKey, t -> new ThreadRow(provider, (TraceThread)t), ThreadRow::getThread);
        }
    }

    protected static enum ThreadTableColumns implements DefaultEnumeratedColumnTableModel.EnumeratedTableColumn<ThreadTableColumns, ThreadRow>
    {
        NAME("Name", String.class, ThreadRow::getName, ThreadRow::setName, true),
        CREATED("Created", Long.class, ThreadRow::getCreationSnap, true),
        DESTROYED("Destroyed", String.class, ThreadRow::getDestructionSnap, true),
        STATE("State", ThreadState.class, ThreadRow::getState, true),
        COMMENT("Comment", String.class, ThreadRow::getComment, ThreadRow::setComment, true),
        PLOT("Plot", Lifespan.class, ThreadRow::getLifespan, false);

        private final String header;
        private final Function<ThreadRow, ?> getter;
        private final BiConsumer<ThreadRow, Object> setter;
        private final boolean sortable;
        private final Class<?> cls;

        private <T> ThreadTableColumns(String header, Class<T> cls, Function<ThreadRow, T> getter, boolean sortable) {
            this(header, cls, getter, null, sortable);
        }

        private <T> ThreadTableColumns(String header, Class<T> cls, Function<ThreadRow, T> getter, BiConsumer<ThreadRow, T> setter, boolean sortable) {
            this.header = header;
            this.cls = cls;
            this.getter = getter;
            this.setter = setter;
            this.sortable = sortable;
        }

        public String getHeader() {
            return this.header;
        }

        public Class<?> getValueClass() {
            return this.cls;
        }

        public Object getValueOf(ThreadRow row) {
            return this.getter.apply(row);
        }

        public boolean isEditable(ThreadRow row) {
            return this.setter != null;
        }

        public boolean isSortable() {
            return this.sortable;
        }

        public void setValueOf(ThreadRow row, Object value) {
            this.setter.accept(row, value);
        }
    }
}

