/*
 * Decompiled with CFR 0.152.
 */
package ghidra.app.plugin.core.debug.platform.frida;

import ghidra.app.plugin.core.debug.mapping.DefaultDebuggerMappingOffer;
import ghidra.dbg.target.TargetEnvironment;
import ghidra.dbg.target.TargetObject;
import ghidra.dbg.target.TargetProcess;
import ghidra.debug.api.model.DebuggerMappingOffer;
import ghidra.debug.api.model.DebuggerMappingOpinion;
import ghidra.program.model.lang.CompilerSpecID;
import ghidra.program.model.lang.LanguageID;
import ghidra.util.Msg;
import java.util.Set;

public class FridaX86DebuggerMappingOpinion
implements DebuggerMappingOpinion {
    protected static final LanguageID LANG_ID_X86 = new LanguageID("x86:LE:32:default");
    protected static final LanguageID LANG_ID_X86_64 = new LanguageID("x86:LE:64:default");
    protected static final CompilerSpecID COMP_ID_DEFAULT = new CompilerSpecID("default");
    protected static final CompilerSpecID COMP_ID_GCC = new CompilerSpecID("gcc");
    protected static final CompilerSpecID COMP_ID_VS = new CompilerSpecID("windows");

    public Set<DebuggerMappingOffer> offersForEnv(TargetEnvironment env, TargetObject target, boolean includeOverrides) {
        if (!(target instanceof TargetProcess)) {
            return Set.of();
        }
        TargetProcess process = (TargetProcess)target;
        if (!env.getDebugger().toLowerCase().contains("frida")) {
            return Set.of();
        }
        String arch = env.getArchitecture();
        boolean is32Bit = arch.contains("ia32") || arch.contains("x86-32") || arch.contains("i386") || arch.contains("x86_32");
        boolean is64Bit = arch.contains("x64") || arch.contains("x86-64") || arch.contains("x64-32") || arch.contains("x86_64") || arch.contains("x64_32") || arch.contains("i686");
        String os = env.getOperatingSystem();
        if (os.contains("darwin")) {
            if (is64Bit) {
                Msg.info((Object)this, (Object)("Using os=" + os + " arch=" + arch));
                return Set.of(new FridaI386X86_64MacosOffer(process));
            }
            if (is32Bit) {
                Msg.info((Object)this, (Object)("Using os=" + os + " arch=" + arch));
                return Set.of(new FridaI386MacosOffer(process));
            }
            return Set.of();
        }
        if (os.contains("Linux") || os.contains("linux")) {
            if (is64Bit) {
                Msg.info((Object)this, (Object)("Using os=" + os + " arch=" + arch));
                return Set.of(new FridaI386X86_64LinuxOffer(process));
            }
            if (is32Bit) {
                Msg.info((Object)this, (Object)("Using os=" + os + " arch=" + arch));
                return Set.of(new FridaI386LinuxOffer(process));
            }
            return Set.of();
        }
        if (os.contains("windows")) {
            if (is64Bit) {
                Msg.info((Object)this, (Object)("Using os=" + os + " arch=" + arch));
                return Set.of(new FridaI386X86_64WindowsOffer(process));
            }
            if (is32Bit) {
                Msg.info((Object)this, (Object)("Using os=" + os + " arch=" + arch));
                return Set.of(new FridaI386WindowsOffer(process));
            }
            return Set.of();
        }
        return Set.of();
    }

    protected static class FridaI386X86_64MacosOffer
    extends DefaultDebuggerMappingOffer {
        public FridaI386X86_64MacosOffer(TargetProcess process) {
            super((TargetObject)process, 100, "Frida on macOS x86_64", LANG_ID_X86_64, COMP_ID_GCC, Set.of());
        }
    }

    protected static class FridaI386MacosOffer
    extends DefaultDebuggerMappingOffer {
        public FridaI386MacosOffer(TargetProcess process) {
            super((TargetObject)process, 100, "Frida on macOS i386", LANG_ID_X86, COMP_ID_GCC, Set.of());
        }
    }

    protected static class FridaI386X86_64LinuxOffer
    extends DefaultDebuggerMappingOffer {
        public FridaI386X86_64LinuxOffer(TargetProcess process) {
            super((TargetObject)process, 100, "Frida on Linux x86_64", LANG_ID_X86_64, COMP_ID_GCC, Set.of());
        }
    }

    protected static class FridaI386LinuxOffer
    extends DefaultDebuggerMappingOffer {
        public FridaI386LinuxOffer(TargetProcess process) {
            super((TargetObject)process, 100, "Frida on Linux i386", LANG_ID_X86, COMP_ID_GCC, Set.of());
        }
    }

    protected static class FridaI386X86_64WindowsOffer
    extends DefaultDebuggerMappingOffer {
        public FridaI386X86_64WindowsOffer(TargetProcess process) {
            super((TargetObject)process, 100, "Frida on Windows x64", LANG_ID_X86_64, COMP_ID_VS, Set.of());
        }
    }

    protected static class FridaI386WindowsOffer
    extends DefaultDebuggerMappingOffer {
        public FridaI386WindowsOffer(TargetProcess process) {
            super((TargetObject)process, 100, "Frida on Windows i386", LANG_ID_X86, COMP_ID_VS, Set.of());
        }
    }
}

