/*
 * Decompiled with CFR 0.152.
 */
package ghidra.app.plugin.core.debug.platform.jdi;

import ghidra.app.plugin.core.debug.mapping.DefaultDebuggerMappingOffer;
import ghidra.app.plugin.core.debug.mapping.DefaultDebuggerMemoryMapper;
import ghidra.app.plugin.core.debug.mapping.DefaultDebuggerRegisterMapper;
import ghidra.app.plugin.core.debug.mapping.DefaultDebuggerTargetTraceMapper;
import ghidra.dbg.target.TargetEnvironment;
import ghidra.dbg.target.TargetMemory;
import ghidra.dbg.target.TargetObject;
import ghidra.dbg.target.TargetProcess;
import ghidra.dbg.target.TargetRegisterContainer;
import ghidra.debug.api.model.DebuggerMappingOffer;
import ghidra.debug.api.model.DebuggerMappingOpinion;
import ghidra.debug.api.model.DebuggerMemoryMapper;
import ghidra.debug.api.model.DebuggerRegisterMapper;
import ghidra.debug.api.model.DebuggerTargetTraceMapper;
import ghidra.program.model.lang.CompilerSpecID;
import ghidra.program.model.lang.CompilerSpecNotFoundException;
import ghidra.program.model.lang.LanguageID;
import ghidra.program.model.lang.LanguageNotFoundException;
import java.util.Collection;
import java.util.Set;

public class JdiJvmDebuggerMappingOpinion
implements DebuggerMappingOpinion {
    protected static final LanguageID LANG_ID_JAVA = new LanguageID("JVM:BE:32:default");
    protected static final CompilerSpecID COMP_ID_VS = new CompilerSpecID("default");
    protected static final Set<String> JVM_NAMES = Set.of("OpenJDK");

    protected static boolean containsRecognizedJvmName(String name) {
        return JVM_NAMES.stream().anyMatch(name::contains);
    }

    public Set<DebuggerMappingOffer> offersForEnv(TargetEnvironment env, TargetObject target, boolean includeOverrides) {
        if (!(target instanceof TargetProcess)) {
            return Set.of();
        }
        if (!env.getDebugger().contains("Java Debug Interface")) {
            return Set.of();
        }
        if (!JdiJvmDebuggerMappingOpinion.containsRecognizedJvmName(env.getArchitecture())) {
            return Set.of();
        }
        return Set.of(new JavaDebuggerMappingOffer((TargetProcess)target));
    }

    protected static class JavaDebuggerMappingOffer
    extends DefaultDebuggerMappingOffer {
        public JavaDebuggerMappingOffer(TargetProcess process) {
            super((TargetObject)process, 100, "Java Virtual Machine", LANG_ID_JAVA, COMP_ID_VS, Set.of());
        }

        @Override
        public DebuggerTargetTraceMapper createMapper() throws LanguageNotFoundException, CompilerSpecNotFoundException {
            return new JavaDebuggerTargetTraceMapper(this.target, this.langID, this.csID, this.extraRegNames);
        }
    }

    protected static class JavaDebuggerTargetTraceMapper
    extends DefaultDebuggerTargetTraceMapper {
        public JavaDebuggerTargetTraceMapper(TargetObject target, LanguageID langID, CompilerSpecID csId, Collection<String> extraRegNames) throws LanguageNotFoundException, CompilerSpecNotFoundException {
            super(target, langID, csId, extraRegNames);
        }

        @Override
        protected DebuggerMemoryMapper createMemoryMapper(TargetMemory memory) {
            return new DefaultDebuggerMemoryMapper(this.language, memory.getModel());
        }

        @Override
        protected DebuggerRegisterMapper createRegisterMapper(TargetRegisterContainer registers) {
            return new DefaultDebuggerRegisterMapper(this.cSpec, registers, false);
        }
    }
}

