/*
 * Decompiled with CFR 0.152.
 */
package ghidra.app.plugin.core.debug.service.breakpoint;

import ghidra.app.plugin.core.debug.service.breakpoint.BreakpointActionSet;
import ghidra.app.plugin.core.debug.service.breakpoint.LogicalBreakpointInternal;
import ghidra.app.plugin.core.debug.service.breakpoint.ProgramBreakpoint;
import ghidra.app.plugin.core.debug.service.breakpoint.TraceBreakpointSet;
import ghidra.app.plugin.core.debug.service.breakpoint.TrackedTooSoonException;
import ghidra.async.AsyncUtils;
import ghidra.debug.api.breakpoint.LogicalBreakpoint;
import ghidra.debug.api.target.Target;
import ghidra.framework.model.DomainObject;
import ghidra.framework.plugintool.PluginTool;
import ghidra.program.model.address.Address;
import ghidra.program.model.listing.Bookmark;
import ghidra.program.model.listing.Program;
import ghidra.program.util.ProgramLocation;
import ghidra.trace.model.Trace;
import ghidra.trace.model.breakpoint.TraceBreakpoint;
import ghidra.trace.model.breakpoint.TraceBreakpointKind;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.concurrent.CompletableFuture;

public class MappedLogicalBreakpoint
implements LogicalBreakpointInternal {
    private final PluginTool tool;
    private final Set<TraceBreakpointKind> kinds;
    private final long length;
    private final ProgramBreakpoint progBreak;
    private final Map<Trace, TraceBreakpointSet> traceBreaks = new HashMap<Trace, TraceBreakpointSet>();

    protected MappedLogicalBreakpoint(PluginTool tool, Program program, Address progAddr, long length, Collection<TraceBreakpointKind> kinds) {
        this.tool = tool;
        this.kinds = Set.copyOf(kinds);
        this.length = length;
        this.progBreak = new ProgramBreakpoint(program, progAddr, length, this.kinds);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String toString() {
        Map<Trace, TraceBreakpointSet> map = this.traceBreaks;
        synchronized (map) {
            return String.format("<%s prog=%s, traces=%s>", this.getClass().getSimpleName(), this.progBreak, this.traceBreaks.values());
        }
    }

    protected boolean hasProgramBreakpoint() {
        return this.progBreak.getBookmark() != null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean isEmpty() {
        if (!this.progBreak.isEmpty()) {
            return false;
        }
        Map<Trace, TraceBreakpointSet> map = this.traceBreaks;
        synchronized (map) {
            for (TraceBreakpointSet breaks : this.traceBreaks.values()) {
                if (breaks.isEmpty()) continue;
                return false;
            }
        }
        return true;
    }

    public void enableForProgram() {
        this.progBreak.enable();
    }

    public void enableForProgramWithName(String name) {
        this.progBreak.toggleWithComment(true, name);
    }

    public void disableForProgram() {
        this.progBreak.disable();
    }

    public void deleteForProgram() {
        this.progBreak.deleteFromProgram();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public CompletableFuture<Void> enableForTrace(Trace trace) {
        TraceBreakpointSet breaks;
        BreakpointActionSet actions = new BreakpointActionSet();
        Map<Trace, TraceBreakpointSet> map = this.traceBreaks;
        synchronized (map) {
            breaks = this.traceBreaks.get(trace);
        }
        if (breaks == null) {
            return AsyncUtils.nil();
        }
        breaks.planEnable(actions, this.length, this.kinds);
        return actions.execute();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public CompletableFuture<Void> disableForTrace(Trace trace) {
        TraceBreakpointSet breaks;
        BreakpointActionSet actions = new BreakpointActionSet();
        Map<Trace, TraceBreakpointSet> map = this.traceBreaks;
        synchronized (map) {
            breaks = this.traceBreaks.get(trace);
        }
        if (breaks == null) {
            return AsyncUtils.nil();
        }
        breaks.planDisable(actions, this.length, this.kinds);
        return actions.execute();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public CompletableFuture<Void> deleteForTrace(Trace trace) {
        TraceBreakpointSet breaks;
        BreakpointActionSet actions = new BreakpointActionSet();
        Map<Trace, TraceBreakpointSet> map = this.traceBreaks;
        synchronized (map) {
            breaks = this.traceBreaks.get(trace);
        }
        if (breaks == null) {
            return AsyncUtils.nil();
        }
        breaks.planDelete(actions, this.length, this.kinds);
        return actions.execute();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void planEnable(BreakpointActionSet actions, Trace trace) {
        if (trace != null) {
            TraceBreakpointSet breaks;
            Map<Trace, TraceBreakpointSet> map = this.traceBreaks;
            synchronized (map) {
                breaks = this.traceBreaks.get(trace);
            }
            if (breaks == null) {
                return;
            }
            breaks.planEnable(actions, this.length, this.kinds);
            return;
        }
        Map<Trace, TraceBreakpointSet> map = this.traceBreaks;
        synchronized (map) {
            for (TraceBreakpointSet breaks : this.traceBreaks.values()) {
                breaks.planEnable(actions, this.length, this.kinds);
            }
        }
    }

    public CompletableFuture<Void> enableForTraces() {
        BreakpointActionSet actions = new BreakpointActionSet();
        this.planEnable(actions, null);
        return actions.execute();
    }

    public CompletableFuture<Void> enableWithName(String name) {
        this.enableForProgramWithName(name);
        return this.enableForTraces();
    }

    public String generateStatusEnable(Trace trace) {
        if (trace == null) {
            if (!this.traceBreaks.values().isEmpty()) {
                return null;
            }
            return "A breakpoint is not mapped to any trace. Cannot enable it. Is there a target? Check your module map.";
        }
        TraceBreakpointSet breaks = this.traceBreaks.get(trace);
        if (breaks != null) {
            return null;
        }
        return "A breakpoint is not mapped to the trace. Cannot enable it. Is there a target? Check your module map.";
    }

    public CompletableFuture<Void> enable() {
        this.enableForProgram();
        return this.enableForTraces();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void planDisable(BreakpointActionSet actions, Trace trace) {
        if (trace != null) {
            TraceBreakpointSet breaks;
            Map<Trace, TraceBreakpointSet> map = this.traceBreaks;
            synchronized (map) {
                breaks = this.traceBreaks.get(trace);
            }
            if (breaks == null) {
                return;
            }
            breaks.planDisable(actions, this.length, this.kinds);
            return;
        }
        Map<Trace, TraceBreakpointSet> map = this.traceBreaks;
        synchronized (map) {
            for (TraceBreakpointSet breaks : this.traceBreaks.values()) {
                breaks.planDisable(actions, this.length, this.kinds);
            }
        }
    }

    public CompletableFuture<Void> disable() {
        this.progBreak.disable();
        BreakpointActionSet actions = new BreakpointActionSet();
        this.planDisable(actions, null);
        return actions.execute();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void planDelete(BreakpointActionSet actions, Trace trace) {
        if (trace != null) {
            TraceBreakpointSet breaks;
            Map<Trace, TraceBreakpointSet> map = this.traceBreaks;
            synchronized (map) {
                breaks = this.traceBreaks.get(trace);
            }
            if (breaks == null) {
                return;
            }
            breaks.planDelete(actions, this.length, this.kinds);
            return;
        }
        Map<Trace, TraceBreakpointSet> map = this.traceBreaks;
        synchronized (map) {
            for (TraceBreakpointSet breaks : this.traceBreaks.values()) {
                breaks.planDelete(actions, this.length, this.kinds);
            }
        }
    }

    public CompletableFuture<Void> delete() {
        this.progBreak.deleteFromProgram();
        BreakpointActionSet actions = new BreakpointActionSet();
        this.planDelete(actions, null);
        return actions.execute();
    }

    public Bookmark getProgramBookmark() {
        return this.progBreak.getBookmark();
    }

    public String getName() {
        return this.progBreak.getName();
    }

    public void setName(String name) {
        this.progBreak.setName(name);
    }

    public ProgramLocation getProgramLocation() {
        return this.progBreak.getLocation();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void setTraceAddress(Trace trace, Address address) {
        Map<Trace, TraceBreakpointSet> map = this.traceBreaks;
        synchronized (map) {
            TraceBreakpointSet newSet = new TraceBreakpointSet(this.tool, trace, address);
            newSet.setEmuSleigh(this.progBreak.getEmuSleigh());
            this.traceBreaks.put(trace, newSet);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void setTarget(Trace trace, Target target) {
        Map<Trace, TraceBreakpointSet> map = this.traceBreaks;
        synchronized (map) {
            this.traceBreaks.get(trace).setTarget(target);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void removeTrace(Trace trace) {
        Map<Trace, TraceBreakpointSet> map = this.traceBreaks;
        synchronized (map) {
            this.traceBreaks.remove(trace);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Set<TraceBreakpoint> getTraceBreakpoints() {
        HashSet<TraceBreakpoint> result = new HashSet<TraceBreakpoint>();
        Map<Trace, TraceBreakpointSet> map = this.traceBreaks;
        synchronized (map) {
            for (TraceBreakpointSet breaks : this.traceBreaks.values()) {
                result.addAll(breaks.getBreakpoints());
            }
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Set<TraceBreakpoint> getTraceBreakpoints(Trace trace) {
        TraceBreakpointSet breaks;
        Map<Trace, TraceBreakpointSet> map = this.traceBreaks;
        synchronized (map) {
            breaks = this.traceBreaks.get(trace);
        }
        return breaks == null ? Set.of() : breaks.getBreakpoints();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Set<Trace> getMappedTraces() {
        Map<Trace, TraceBreakpointSet> map = this.traceBreaks;
        synchronized (map) {
            return Set.copyOf(this.traceBreaks.keySet());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Set<Trace> getParticipatingTraces() {
        HashSet<Trace> result = new HashSet<Trace>();
        Map<Trace, TraceBreakpointSet> map = this.traceBreaks;
        synchronized (map) {
            for (TraceBreakpointSet breaks : this.traceBreaks.values()) {
                if (breaks.isEmpty()) continue;
                result.add(breaks.getTrace());
            }
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Address getTraceAddress(Trace trace) {
        TraceBreakpointSet breaks;
        Map<Trace, TraceBreakpointSet> map = this.traceBreaks;
        synchronized (map) {
            breaks = this.traceBreaks.get(trace);
        }
        if (breaks == null) {
            return null;
        }
        return breaks.getAddress();
    }

    public DomainObject getDomainObject() {
        return this.progBreak.getProgram();
    }

    public Address getAddress() {
        return this.progBreak.getLocation().getByteAddress();
    }

    public long getLength() {
        return this.length;
    }

    public Set<TraceBreakpointKind> getKinds() {
        return this.kinds;
    }

    public LogicalBreakpoint.State computeStateForProgram(Program program) {
        if (this.progBreak.getProgram() != program) {
            return LogicalBreakpoint.State.NONE;
        }
        return this.computeState();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public LogicalBreakpoint.State computeStateForTrace(Trace trace) {
        TraceBreakpointSet breaks;
        Map<Trace, TraceBreakpointSet> map = this.traceBreaks;
        synchronized (map) {
            breaks = this.traceBreaks.get(trace);
        }
        LogicalBreakpoint.ProgramMode progMode = this.progBreak.computeMode();
        LogicalBreakpoint.TraceMode traceMode = breaks == null ? LogicalBreakpoint.TraceMode.NONE : breaks.computeMode();
        return progMode.combineTrace(traceMode, LogicalBreakpoint.Perspective.TRACE);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected LogicalBreakpoint.TraceMode computeTraceModeForLocation(TraceBreakpoint loc) {
        TraceBreakpointSet breaks;
        Map<Trace, TraceBreakpointSet> map = this.traceBreaks;
        synchronized (map) {
            breaks = this.traceBreaks.get(loc.getTrace());
        }
        if (breaks == null || !breaks.getBreakpoints().contains(loc)) {
            return LogicalBreakpoint.TraceMode.NONE;
        }
        return breaks.computeMode(loc);
    }

    public LogicalBreakpoint.State computeStateForLocation(TraceBreakpoint loc) {
        LogicalBreakpoint.ProgramMode progMode = this.progBreak.computeMode();
        LogicalBreakpoint.TraceMode traceMode = this.computeTraceModeForLocation(loc);
        return progMode.combineTrace(traceMode, LogicalBreakpoint.Perspective.TRACE);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected LogicalBreakpoint.TraceMode computeTraceMode() {
        LogicalBreakpoint.TraceMode traceMode = LogicalBreakpoint.TraceMode.NONE;
        Map<Trace, TraceBreakpointSet> map = this.traceBreaks;
        synchronized (map) {
            TraceBreakpointSet breaks;
            LogicalBreakpoint.TraceMode tm;
            Iterator<TraceBreakpointSet> iterator = this.traceBreaks.values().iterator();
            while (iterator.hasNext() && (traceMode = traceMode.combine(tm = (breaks = iterator.next()).computeMode())) != LogicalBreakpoint.TraceMode.MISSING) {
            }
        }
        return traceMode;
    }

    public LogicalBreakpoint.State computeState() {
        LogicalBreakpoint.ProgramMode progMode = this.progBreak.computeMode();
        LogicalBreakpoint.TraceMode traceMode = this.computeTraceMode();
        return progMode.combineTrace(traceMode, LogicalBreakpoint.Perspective.LOGICAL);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected String computeTraceSleigh() {
        String sleigh = null;
        Map<Trace, TraceBreakpointSet> map = this.traceBreaks;
        synchronized (map) {
            for (TraceBreakpointSet breaks : this.traceBreaks.values()) {
                String s = breaks.computeSleigh();
                if (sleigh != null && !sleigh.equals(s)) {
                    return null;
                }
                sleigh = s;
            }
            return sleigh;
        }
    }

    public String getEmuSleigh() {
        return this.progBreak.getEmuSleigh();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void setTraceBreakEmuSleigh(String sleigh) {
        Map<Trace, TraceBreakpointSet> map = this.traceBreaks;
        synchronized (map) {
            for (TraceBreakpointSet breaks : this.traceBreaks.values()) {
                breaks.setEmuSleigh(sleigh);
            }
        }
    }

    public void setEmuSleigh(String sleigh) {
        this.progBreak.setEmuSleigh(sleigh);
        this.setTraceBreakEmuSleigh(sleigh);
    }

    @Override
    public boolean canMerge(Program program, Bookmark bookmark) {
        return this.progBreak.canMerge(program, bookmark);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean canMerge(TraceBreakpoint breakpoint) throws TrackedTooSoonException {
        TraceBreakpointSet breaks;
        Map<Trace, TraceBreakpointSet> map = this.traceBreaks;
        synchronized (map) {
            breaks = this.traceBreaks.get(breakpoint.getTrace());
        }
        if (breaks == null) {
            throw new TrackedTooSoonException();
        }
        if (this.length != breakpoint.getLength()) {
            return false;
        }
        if (!Objects.equals(this.kinds, breakpoint.getKinds())) {
            return false;
        }
        return breaks.canMerge(breakpoint);
    }

    @Override
    public boolean trackBreakpoint(Bookmark bookmark) {
        if (this.progBreak.add(bookmark)) {
            String sleigh = this.progBreak.getEmuSleigh();
            if (sleigh != null && !"emu_swi();\nemu_exec_decoded();\n".equals(sleigh)) {
                this.setEmuSleigh(sleigh);
            }
            return true;
        }
        return false;
    }

    protected void makeBookmarkConsistent() {
        LogicalBreakpoint.TraceMode traceMode = this.computeTraceMode();
        if (traceMode == LogicalBreakpoint.TraceMode.ENABLED) {
            this.progBreak.enable();
        } else if (traceMode == LogicalBreakpoint.TraceMode.DISABLED) {
            this.progBreak.disable();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean trackBreakpoint(TraceBreakpoint breakpoint) {
        String progSleigh;
        String traceSleigh;
        TraceBreakpointSet breaks;
        Map<Trace, TraceBreakpointSet> map = this.traceBreaks;
        synchronized (map) {
            breaks = this.traceBreaks.get(breakpoint.getTrace());
        }
        boolean result = breaks.add(breakpoint);
        if (result && (traceSleigh = this.computeTraceSleigh()) != null && !"emu_swi();\nemu_exec_decoded();\n".equals(traceSleigh) && ((progSleigh = this.progBreak.getEmuSleigh()) == null || "emu_swi();\nemu_exec_decoded();\n".equals(progSleigh))) {
            this.progBreak.setEmuSleigh(traceSleigh);
        }
        this.makeBookmarkConsistent();
        return result;
    }

    @Override
    public boolean untrackBreakpoint(Program program, Bookmark bookmark) {
        assert (this.progBreak.getProgram() == program);
        return this.progBreak.remove(bookmark);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean untrackBreakpoint(TraceBreakpoint breakpoint) {
        TraceBreakpointSet breaks;
        Map<Trace, TraceBreakpointSet> map = this.traceBreaks;
        synchronized (map) {
            breaks = this.traceBreaks.get(breakpoint.getTrace());
        }
        if (breaks == null) {
            return false;
        }
        boolean result = breaks.remove(breakpoint);
        this.makeBookmarkConsistent();
        return result;
    }

    public boolean appliesTo(Program program) {
        return this.progBreak.getProgram() == Objects.requireNonNull(program);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean appliesTo(Trace trace) {
        TraceBreakpointSet breaks;
        Map<Trace, TraceBreakpointSet> map = this.traceBreaks;
        synchronized (map) {
            breaks = this.traceBreaks.get(Objects.requireNonNull(trace));
        }
        return !breaks.isEmpty();
    }
}

