/*
 * Decompiled with CFR 0.152.
 */
package ghidra.app.plugin.core.debug.service.emulation;

import generic.ULongSpan;
import ghidra.debug.api.emulation.PcodeDebuggerDataAccess;
import ghidra.generic.util.datastruct.SemisparseByteArray;
import ghidra.pcode.exec.AbstractLongOffsetPcodeExecutorStatePiece;
import ghidra.pcode.exec.AccessPcodeExecutionException;
import ghidra.pcode.exec.trace.BytesTracePcodeExecutorStatePiece;
import ghidra.pcode.exec.trace.data.PcodeTraceDataAccess;
import ghidra.program.model.address.AddressSet;
import ghidra.program.model.address.AddressSpace;
import ghidra.program.model.lang.Language;
import java.util.Map;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;

public abstract class AbstractRWTargetPcodeExecutorStatePiece
extends BytesTracePcodeExecutorStatePiece {
    protected final PcodeDebuggerDataAccess data;

    public AbstractRWTargetPcodeExecutorStatePiece(PcodeDebuggerDataAccess data) {
        super((PcodeTraceDataAccess)data);
        this.data = data;
    }

    protected abstract class TargetBackedSpaceMap
    extends AbstractLongOffsetPcodeExecutorStatePiece.CacheingSpaceMap<PcodeDebuggerDataAccess, BytesTracePcodeExecutorStatePiece.CachedSpace> {
        public TargetBackedSpaceMap() {
        }

        protected TargetBackedSpaceMap(Map<AddressSpace, BytesTracePcodeExecutorStatePiece.CachedSpace> spaces) {
            super(spaces);
        }

        public BytesTracePcodeExecutorStatePiece.CachedSpace fork(BytesTracePcodeExecutorStatePiece.CachedSpace s) {
            return s.fork();
        }

        protected PcodeDebuggerDataAccess getBacking(AddressSpace space) {
            return AbstractRWTargetPcodeExecutorStatePiece.this.data;
        }
    }

    abstract class AbstractRWTargetCachedSpace
    extends BytesTracePcodeExecutorStatePiece.CachedSpace {
        public AbstractRWTargetCachedSpace(Language language, AddressSpace space, PcodeDebuggerDataAccess backing) {
            super(language, space, (PcodeTraceDataAccess)backing);
        }

        protected AbstractRWTargetCachedSpace(Language language, AddressSpace space, PcodeTraceDataAccess backing, SemisparseByteArray bytes, AddressSet written) {
            super(language, space, backing, bytes, written);
        }

        protected abstract ULongSpan.ULongSpanSet readUninitializedFromTarget(ULongSpan.ULongSpanSet var1);

        protected ULongSpan.ULongSpanSet readUninitializedFromBacking(ULongSpan.ULongSpanSet uninitialized) {
            if ((uninitialized = this.readUninitializedFromTarget(uninitialized)).isEmpty()) {
                return uninitialized;
            }
            return super.readUninitializedFromBacking(uninitialized);
        }

        protected <T> T waitTimeout(CompletableFuture<T> future) {
            try {
                return future.get(1L, TimeUnit.SECONDS);
            }
            catch (TimeoutException e) {
                throw new AccessPcodeExecutionException("Timed out reading or writing target", (Exception)e);
            }
            catch (InterruptedException | ExecutionException e) {
                throw new AccessPcodeExecutionException("Error reading or writing target", e);
            }
        }
    }
}

