/*
 * Decompiled with CFR 0.152.
 */
package ghidra.app.plugin.core.debug.service.model.record;

import ghidra.app.plugin.core.debug.service.model.RecorderPermanentTransaction;
import ghidra.async.AsyncFence;
import ghidra.async.AsyncUtils;
import ghidra.dbg.attributes.TargetDataType;
import ghidra.dbg.target.TargetDataTypeNamespace;
import ghidra.dbg.target.TargetModule;
import ghidra.dbg.target.TargetNamedDataType;
import ghidra.dbg.util.PathUtils;
import ghidra.dbg.util.TargetDataTypeConverter;
import ghidra.debug.api.model.TraceRecorder;
import ghidra.framework.model.UndoableDomainObject;
import ghidra.program.model.data.Category;
import ghidra.program.model.data.CategoryPath;
import ghidra.program.model.data.DataType;
import ghidra.program.model.data.DataTypeConflictHandler;
import ghidra.program.model.data.DataTypeManager;
import ghidra.trace.model.Trace;
import ghidra.util.task.TaskMonitor;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.CompletableFuture;

public class DataTypeRecorder {
    private final Trace trace;
    private final TargetDataTypeConverter typeConverter;

    public DataTypeRecorder(TraceRecorder recorder) {
        this.trace = recorder.getTrace();
        this.typeConverter = new TargetDataTypeConverter((DataTypeManager)this.trace.getDataTypeManager());
    }

    public CompletableFuture<Void> captureDataTypes(TargetDataTypeNamespace namespace, TaskMonitor monitor) {
        String path = PathUtils.toString((List)namespace.getPath());
        monitor.setMessage("Capturing data types for " + path);
        return ((CompletableFuture)namespace.getTypes().thenCompose(types -> {
            monitor.initialize((long)types.size());
            AsyncFence fence = new AsyncFence();
            ArrayList converted = new ArrayList();
            for (TargetNamedDataType type : types) {
                if (monitor.isCancelled()) {
                    fence.ready().cancel(false);
                    return AsyncUtils.nil();
                }
                monitor.incrementProgress(1L);
                fence.include((CompletableFuture)this.typeConverter.convertTargetDataType((TargetDataType)type).thenAccept(converted::add));
            }
            return fence.ready().thenApply(__ -> converted);
        })).thenAccept(converted -> {
            if (converted == null) {
                return;
            }
            try (RecorderPermanentTransaction tid = RecorderPermanentTransaction.start((UndoableDomainObject)this.trace, "Capture data types for " + path);){
                Category category = this.trace.getDataTypeManager().createCategory(new CategoryPath("/" + path));
                for (DataType dataType : converted) {
                    category.addDataType(dataType, DataTypeConflictHandler.DEFAULT_HANDLER);
                }
            }
        });
    }

    public CompletableFuture<Void> captureDataTypes(TargetModule targetModule, TaskMonitor monitor) {
        CompletableFuture future = targetModule.fetchChildrenSupporting(TargetDataTypeNamespace.class);
        return future.thenCompose(namespaces -> {
            AsyncFence fence = new AsyncFence();
            for (TargetDataTypeNamespace ns : namespaces.values()) {
                fence.include(this.captureDataTypes(ns, monitor));
            }
            return fence.ready();
        });
    }
}

