/*
 * Decompiled with CFR 0.152.
 */
package org.python.bouncycastle.cms;

import java.util.Hashtable;
import java.util.Map;
import org.python.bouncycastle.asn1.ASN1Encodable;
import org.python.bouncycastle.asn1.ASN1ObjectIdentifier;
import org.python.bouncycastle.asn1.ASN1Set;
import org.python.bouncycastle.asn1.DEROctetString;
import org.python.bouncycastle.asn1.DERSet;
import org.python.bouncycastle.asn1.cms.Attribute;
import org.python.bouncycastle.asn1.cms.AttributeTable;
import org.python.bouncycastle.asn1.cms.CMSAlgorithmProtection;
import org.python.bouncycastle.asn1.cms.CMSAttributes;
import org.python.bouncycastle.asn1.x509.AlgorithmIdentifier;
import org.python.bouncycastle.cms.CMSAttributeTableGenerator;

public class DefaultAuthenticatedAttributeTableGenerator
implements CMSAttributeTableGenerator {
    private final Hashtable table;

    public DefaultAuthenticatedAttributeTableGenerator() {
        this.table = new Hashtable();
    }

    public DefaultAuthenticatedAttributeTableGenerator(AttributeTable attributeTable) {
        this.table = attributeTable != null ? attributeTable.toHashtable() : new Hashtable();
    }

    protected Hashtable createStandardAttributeTable(Map map) {
        Object object;
        Hashtable hashtable = new Hashtable();
        Object object2 = this.table.keys();
        while (object2.hasMoreElements()) {
            object = object2.nextElement();
            hashtable.put(object, this.table.get(object));
        }
        if (!hashtable.containsKey(CMSAttributes.contentType)) {
            object2 = ASN1ObjectIdentifier.getInstance(map.get("contentType"));
            object = new Attribute(CMSAttributes.contentType, (ASN1Set)new DERSet((ASN1Encodable)object2));
            hashtable.put(object.getAttrType(), object);
        }
        if (!hashtable.containsKey(CMSAttributes.messageDigest)) {
            object2 = (byte[])map.get("digest");
            object = new Attribute(CMSAttributes.messageDigest, (ASN1Set)new DERSet(new DEROctetString((byte[])object2)));
            hashtable.put(object.getAttrType(), object);
        }
        if (!hashtable.contains(CMSAttributes.cmsAlgorithmProtect)) {
            object2 = new Attribute(CMSAttributes.cmsAlgorithmProtect, (ASN1Set)new DERSet((ASN1Encodable)new CMSAlgorithmProtection((AlgorithmIdentifier)map.get("digestAlgID"), 2, (AlgorithmIdentifier)map.get("macAlgID"))));
            hashtable.put(object2.getAttrType(), object2);
        }
        return hashtable;
    }

    @Override
    public AttributeTable getAttributes(Map map) {
        return new AttributeTable(this.createStandardAttributeTable(map));
    }
}

