/*
 * Decompiled with CFR 0.152.
 */
package ghidra.app.cmd.disassemble;

import ghidra.app.plugin.core.analysis.AutoAnalysisManager;
import ghidra.framework.cmd.BackgroundCommand;
import ghidra.framework.model.DomainObject;
import ghidra.program.disassemble.Disassembler;
import ghidra.program.disassemble.DisassemblerContextImpl;
import ghidra.program.disassemble.DisassemblerMessageListener;
import ghidra.program.model.address.Address;
import ghidra.program.model.address.AddressRange;
import ghidra.program.model.address.AddressRangeIterator;
import ghidra.program.model.address.AddressSet;
import ghidra.program.model.address.AddressSetView;
import ghidra.program.model.lang.Register;
import ghidra.program.model.lang.RegisterValue;
import ghidra.program.model.listing.Data;
import ghidra.program.model.listing.Listing;
import ghidra.program.model.listing.Program;
import ghidra.program.model.mem.Memory;
import ghidra.program.model.mem.MemoryBlock;
import ghidra.util.exception.CancelledException;
import ghidra.util.task.TaskMonitor;

public class DisassembleCommand
extends BackgroundCommand {
    protected AddressSetView startSet;
    protected boolean useDefaultRepeatPatternBehavior = false;
    private AddressSetView restrictedSet;
    private AddressSetView exectuableSet;
    private AddressSet disassembledAddrs;
    private boolean followFlow = true;
    private boolean enableAnalysis = true;
    private DisassemblerContextImpl seedContext;
    private RegisterValue initialContextValue;
    private int alignment;
    protected boolean disassemblyPerformed;
    protected String languageError;
    protected boolean unalignedStart;
    protected boolean nonExecutableStart;

    public DisassembleCommand(Address start, AddressSetView restrictedSet, boolean followFlow) {
        this((AddressSetView)new AddressSet(start, start), restrictedSet, followFlow);
        this.useDefaultRepeatPatternBehavior = true;
    }

    public DisassembleCommand(AddressSetView startSet, AddressSetView restrictedSet) {
        this(startSet, restrictedSet, true);
    }

    public DisassembleCommand(AddressSetView startSet, AddressSetView restrictedSet, boolean followFlow) {
        this("Disassemble", startSet, restrictedSet, followFlow);
    }

    protected DisassembleCommand(String name, AddressSetView startSet, AddressSetView restrictedSet, boolean followFlow) {
        super(name, true, true, false);
        this.startSet = startSet;
        this.restrictedSet = restrictedSet;
        this.followFlow = followFlow;
    }

    public void setSeedContext(DisassemblerContextImpl seedContext) {
        this.seedContext = seedContext;
    }

    public void setInitialContext(RegisterValue initialContextValue) {
        if (initialContextValue != null) {
            Register reg = initialContextValue.getRegister();
            initialContextValue = initialContextValue.getRegisterValue(reg.getBaseRegister());
        }
        this.initialContextValue = initialContextValue;
    }

    public void enableCodeAnalysis(boolean enable) {
        this.enableAnalysis = enable;
    }

    public String getStatusMsg() {
        if (this.disassemblyPerformed) {
            return null;
        }
        if (this.languageError != null) {
            return "The program's language is not supported: " + this.languageError;
        }
        if (this.nonExecutableStart) {
            return "Disassembly of non-executable memory is disabled";
        }
        if (this.unalignedStart) {
            return "Disassembler requires a start which is " + this.alignment + "-byte aligned and on an undefined code unit";
        }
        return "Disassembler requires a start which is an undefined code unit";
    }

    public synchronized boolean applyTo(DomainObject obj, TaskMonitor monitor) {
        Program program = (Program)obj;
        return this.doDisassembly(monitor, program, program.getLanguage().getInstructionAlignment());
    }

    private AddressSetView getExecutableSet(Program program) {
        Memory memory = program.getMemory();
        AddressSet set = new AddressSet();
        for (MemoryBlock block : memory.getBlocks()) {
            if (!block.isExecute()) continue;
            set.add(block.getStart(), block.getEnd());
        }
        return set;
    }

    protected boolean doDisassembly(TaskMonitor monitor, Program program, int instructionAlignment) {
        long startNumAddr;
        this.exectuableSet = Disassembler.isRestrictToExecuteMemory((Program)program) ? (this.exectuableSet = this.getExecutableSet(program)) : null;
        this.alignment = instructionAlignment;
        this.disassemblyPerformed = false;
        this.unalignedStart = false;
        this.nonExecutableStart = false;
        this.disassembledAddrs = new AddressSet();
        Listing listing = program.getListing();
        Disassembler disassembler = Disassembler.getDisassembler((Program)program, (TaskMonitor)monitor, (DisassemblerMessageListener)new MyListener(monitor));
        disassembler.setSeedContext(this.seedContext);
        if (this.startSet == null || this.startSet.isEmpty()) {
            return true;
        }
        AddressSet set = new AddressSet(this.startSet);
        if (!this.useDefaultRepeatPatternBehavior) {
            if (this.startSet != this.restrictedSet && !this.startSet.equals(this.restrictedSet)) {
                disassembler.setRepeatPatternLimitIgnored(this.startSet);
            } else {
                disassembler.setRepeatPatternLimit(-1);
            }
        }
        AutoAnalysisManager mgr = null;
        if (this.enableAnalysis) {
            mgr = AutoAnalysisManager.getAnalysisManager(program);
        }
        if ((startNumAddr = set.getNumAddresses()) > 1L) {
            monitor.initialize(startNumAddr);
        }
        long doneNumAddr = 0L;
        AddressSet seedSet = new AddressSet();
        AddressRangeIterator addressRanges = this.startSet.getAddressRanges();
        for (AddressRange addressRange : addressRanges) {
            if (monitor.isCancelled()) break;
            AddressSet subRangeSet = new AddressSet(addressRange);
            if (startNumAddr > 1L) {
                monitor.setProgress(doneNumAddr);
            }
            doneNumAddr += subRangeSet.getNumAddresses();
            while (!subRangeSet.isEmpty() && !monitor.isCancelled()) {
                long addrsLeft;
                Address nextAddr = subRangeSet.getMinAddress();
                if (this.disassembledAddrs.contains(nextAddr)) {
                    AddressRange doneRange = this.disassembledAddrs.getRangeContaining(nextAddr);
                    subRangeSet.delete(doneRange);
                    continue;
                }
                subRangeSet.delete(nextAddr, nextAddr);
                if (this.exectuableSet != null && !this.exectuableSet.contains(nextAddr) && !program.getMemory().getLoadedAndInitializedAddressSet().contains(nextAddr)) {
                    this.nonExecutableStart = true;
                }
                if (nextAddr.getOffset() % (long)this.alignment != 0L) {
                    nextAddr = nextAddr.subtract(nextAddr.getOffset() % (long)this.alignment);
                }
                if ((addrsLeft = subRangeSet.getNumAddresses()) <= 4L) {
                    seedSet.add(nextAddr);
                    continue;
                }
                Data data = listing.getUndefinedDataAt(nextAddr);
                if (data == null) {
                    try {
                        AddressSetView undefRanges = program.getListing().getUndefinedRanges((AddressSetView)subRangeSet, true, monitor);
                        subRangeSet = new AddressSet(undefRanges);
                    }
                    catch (CancelledException undefRanges) {}
                    continue;
                }
                this.doDisassemblySeeds(disassembler, seedSet, mgr);
                seedSet = new AddressSet();
                AddressSet localDisAddrs = this.doDisassemblySeeds(disassembler, new AddressSet(nextAddr), mgr);
                DisassembleCommand.analyzeIfNeeded(mgr, (AddressSetView)subRangeSet, (AddressSetView)localDisAddrs, monitor);
                subRangeSet.delete((AddressSetView)localDisAddrs);
                if (startNumAddr <= 1L) continue;
                monitor.setMaximum(startNumAddr);
                monitor.setProgress(doneNumAddr - subRangeSet.getNumAddresses());
            }
        }
        if (!seedSet.isEmpty()) {
            this.doDisassemblySeeds(disassembler, seedSet, mgr);
        }
        return this.disassemblyPerformed || !this.nonExecutableStart & !this.unalignedStart;
    }

    protected AddressSet doDisassemblySeeds(Disassembler disassembler, AddressSet seedSet, AutoAnalysisManager mgr) {
        AddressSet newDisassembledAddrs = disassembler.disassemble((AddressSetView)seedSet, this.restrictedSet, this.initialContextValue, this.followFlow);
        if (!newDisassembledAddrs.isEmpty()) {
            this.disassemblyPerformed = true;
            this.disassembledAddrs.add((AddressSetView)newDisassembledAddrs);
            if (mgr != null) {
                mgr.codeDefined((AddressSetView)newDisassembledAddrs);
            }
        }
        return newDisassembledAddrs;
    }

    private static void analyzeIfNeeded(AutoAnalysisManager mgr, AddressSetView startSet, AddressSetView disassembledSet, TaskMonitor monitor) {
        if (disassembledSet == null || disassembledSet.isEmpty()) {
            return;
        }
        if (mgr == null || monitor.isCancelled()) {
            return;
        }
        AddressRange firstRange = disassembledSet.getFirstRange();
        Address rangeEnd = firstRange.getMaxAddress();
        Address nextAddr = rangeEnd.next();
        if (nextAddr != null && startSet.contains(rangeEnd) && startSet.contains(nextAddr)) {
            mgr.startAnalysis(monitor, false);
        }
    }

    public AddressSet getDisassembledAddressSet() {
        return this.disassembledAddrs;
    }

    private class MyListener
    implements DisassemblerMessageListener {
        private TaskMonitor monitor;

        MyListener(TaskMonitor monitor) {
            this.monitor = monitor;
        }

        public void disassembleMessageReported(String msg) {
            if (this.monitor != null) {
                this.monitor.setMessage(msg);
            }
        }
    }
}

