/*
 * Decompiled with CFR 0.152.
 */
package ghidra.app.merge.listing;

import generic.stl.Pair;
import ghidra.app.merge.listing.AbstractFunctionMerger;
import ghidra.app.merge.listing.ConflictInfoPanel;
import ghidra.app.merge.listing.ConflictPanel;
import ghidra.app.merge.listing.ExternalAddConflictPanel;
import ghidra.app.merge.listing.ExternalConflictInfoPanel;
import ghidra.app.merge.listing.ExternalsAddressTranslator;
import ghidra.app.merge.listing.FunctionVariableStorageConflicts;
import ghidra.app.merge.listing.ListingMergeManager;
import ghidra.app.merge.listing.ListingMerger;
import ghidra.app.merge.listing.ResolveConflictChangeEvent;
import ghidra.app.merge.listing.ScrollingListChoicesPanel;
import ghidra.app.merge.listing.VariousChoicesPanel;
import ghidra.app.merge.listing.VerticalChoicesPanel;
import ghidra.app.merge.tool.ListingMergePanel;
import ghidra.app.merge.util.ConflictUtility;
import ghidra.app.util.NamespaceUtils;
import ghidra.program.model.address.Address;
import ghidra.program.model.address.AddressFactory;
import ghidra.program.model.address.AddressIterator;
import ghidra.program.model.address.AddressSet;
import ghidra.program.model.address.AddressSetView;
import ghidra.program.model.address.AddressSpace;
import ghidra.program.model.data.DataType;
import ghidra.program.model.data.DataTypeManager;
import ghidra.program.model.data.ProgramBasedDataTypeManager;
import ghidra.program.model.listing.CircularDependencyException;
import ghidra.program.model.listing.Function;
import ghidra.program.model.listing.Parameter;
import ghidra.program.model.listing.Program;
import ghidra.program.model.listing.ProgramChangeSet;
import ghidra.program.model.listing.Variable;
import ghidra.program.model.mem.MemoryAccessException;
import ghidra.program.model.symbol.ExternalLocation;
import ghidra.program.model.symbol.ExternalManager;
import ghidra.program.model.symbol.Namespace;
import ghidra.program.model.symbol.SourceType;
import ghidra.program.model.symbol.Symbol;
import ghidra.program.model.symbol.SymbolTable;
import ghidra.program.model.symbol.SymbolType;
import ghidra.program.util.DiffUtility;
import ghidra.program.util.ProgramConflictException;
import ghidra.program.util.ProgramDiff;
import ghidra.program.util.ProgramMerge;
import ghidra.program.util.SimpleDiffUtility;
import ghidra.util.HTMLUtilities;
import ghidra.util.HelpLocation;
import ghidra.util.Msg;
import ghidra.util.SystemUtilities;
import ghidra.util.datastruct.LongLongHashtable;
import ghidra.util.datastruct.ObjectIntHashtable;
import ghidra.util.exception.AssertException;
import ghidra.util.exception.CancelledException;
import ghidra.util.exception.DuplicateNameException;
import ghidra.util.exception.InvalidInputException;
import ghidra.util.exception.NoValueException;
import ghidra.util.task.TaskMonitor;
import java.awt.Component;
import java.lang.reflect.InvocationTargetException;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import javax.swing.JPanel;
import javax.swing.SwingUtilities;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;

public class ExternalFunctionMerger
extends AbstractFunctionMerger
implements ListingMerger {
    static final String EXTERNALS_PHASE = "Externals";
    private static final String CONFLICT_TYPE = "Externals";
    private static final String INFO_TITLE = "Externals Merge Information";
    private static final String ERROR_TITLE = "Externals Merge Errors";
    protected static final int EXTERNAL_NAMESPACE = 1;
    protected static final int EXTERNAL_LABEL = 2;
    protected static final int EXTERNAL_ADDRESS = 4;
    protected static final int EXTERNAL_SYMBOL_TYPE = 16;
    protected static final int EXTERNAL_DATA_TYPE = 32;
    protected static final int EXTERNAL_FUNCTION = 64;
    protected static final int HIGHEST_DETAIL_BIT_SHIFT = 6;
    protected static final int ALL_EXTERNAL_DIFFERENCES = 119;
    public static final int KEEP_LATEST_ADD = 1;
    public static final int KEEP_MY_ADD = 2;
    public static final int KEEP_BOTH_ADDS = 4;
    public static final int MERGE_BOTH_ADDS = 8;
    public static final String KEEP_BOTH_BUTTON_NAME = "KeepBothVersionsRB";
    public static final String MERGE_BOTH_BUTTON_NAME = "MergeBothVersionsRB";
    private ExternalAddConflictPanel addConflictPanel;
    private ExternalConflictInfoPanel conflictInfoPanel;
    private int totalConflicts = 0;
    private int conflictIndex = 0;
    private ProgramChangeSet latestChanges;
    private ProgramChangeSet myChanges;
    private LongLongHashtable originalToLatestHash;
    private LongLongHashtable latestToOriginalHash;
    private LongLongHashtable originalToMyHash;
    private LongLongHashtable myToOriginalHash;
    LongLongHashtable originalResolvedSymbols;
    LongLongHashtable latestResolvedSymbols;
    LongLongHashtable myResolvedSymbols;
    private ProgramMerge mergeMy;
    private ProgramMerge mergeLatest;
    private ProgramMerge mergeOriginal;
    HashSet<Long> latestAddIDs = new HashSet();
    HashSet<Long> latestRemovedOriginalIDs = new HashSet();
    HashSet<Long> latestModifiedIDs = new HashSet();
    HashSet<Long> myAddIDs = new HashSet();
    HashSet<Long> myRemovedOriginalIDs = new HashSet();
    HashSet<Long> myModifiedIDs = new HashSet();
    HashSet<Long> removeConflictIDs = new HashSet();
    HashSet<Long> removeFunctionConflictIDs = new HashSet();
    HashSet<Long> renamedConflictIDs = new HashSet();
    private SymbolTable[] symbolTables = new SymbolTable[4];
    private ExternalManager[] externalManagers = new ExternalManager[4];
    private ConflictListener conflictListener = null;
    AddressSetView latestExternalSet;
    AddressSetView myExternalSet;
    protected ObjectIntHashtable<Address> externalDetailConflicts = new ObjectIntHashtable();
    protected AddressSet externalDataTypeConflicts;
    protected AddressSet externalFunctionVersusDataTypeConflicts;
    protected LongLongHashtable externalAddConflicts = new LongLongHashtable();
    ExternalsAddressTranslator myAddressTranslator;
    ExternalsAddressTranslator latestAddressTranslator;
    ExternalsAddressTranslator originalAddressTranslator;
    protected int totalChanges = 0;
    protected int changeNum;
    private boolean showListingPanel;
    protected int externalFunctionRemovalChoice = 0;
    protected int externalFunctionChoice = 0;
    protected int externalDetailsChoice = 0;
    protected int externalDataTypeChoice = 0;
    protected int externalFunctionVsDataTypeChoice = 0;
    protected int externalAddChoice = 0;
    protected int externalRemoveChoice = 0;
    ExternalConflictType currentExternalConflictType = null;

    public ExternalFunctionMerger(ListingMergeManager listingMergeManager, boolean showListingPanel) {
        super(listingMergeManager.mergeManager, listingMergeManager.programs);
        this.listingMergeManager = listingMergeManager;
        this.showListingPanel = showListingPanel;
        this.listingMergePanel = listingMergeManager.getListingMergePanel();
        this.latestChanges = listingMergeManager.latestChanges;
        this.myChanges = listingMergeManager.myChanges;
        this.init();
    }

    public void init() {
        this.initializeSymbolTables();
        this.initializeExternalManagers();
        this.initializeMessages();
        this.initializeChangeSets();
        this.initializeProgramMerges();
        this.initializeConflictSets();
        this.originalToLatestHash = new LongLongHashtable();
        this.latestToOriginalHash = new LongLongHashtable();
        this.originalToMyHash = new LongLongHashtable();
        this.myToOriginalHash = new LongLongHashtable();
    }

    private void setupSymbolChanges(TaskMonitor monitor) throws CancelledException {
        this.fillExternalAddSymbolSet(this.symbolTables[2], this.myChanges.getSymbolAdditions(), this.myAddIDs);
        this.fillExternalChangeSymbolSets(this.symbolTables[2], this.myChanges.getSymbolChanges(), this.myRemovedOriginalIDs, this.myModifiedIDs);
        this.fillExternalAddSymbolSet(this.symbolTables[1], this.latestChanges.getSymbolAdditions(), this.latestAddIDs);
        this.fillExternalChangeSymbolSets(this.symbolTables[1], this.latestChanges.getSymbolChanges(), this.latestRemovedOriginalIDs, this.latestModifiedIDs);
    }

    private void fillExternalAddSymbolSet(SymbolTable symbolTable, long[] symbolIDs, HashSet<Long> externalAddSet) {
        for (long symbolID : symbolIDs) {
            Symbol symbol = symbolTable.getSymbol(symbolID);
            if (symbol == null) continue;
            SymbolType symbolType = symbol.getSymbolType();
            if (!symbol.isExternal() || symbolType != SymbolType.FUNCTION && symbolType != SymbolType.LABEL) continue;
            externalAddSet.add(symbolID);
        }
    }

    private void fillExternalChangeSymbolSets(SymbolTable symbolTable, long[] symbolIDs, HashSet<Long> externalRemoveSet, HashSet<Long> externalModifySet) {
        for (long symbolID : symbolIDs) {
            Symbol symbol = symbolTable.getSymbol(symbolID);
            if (symbol == null) {
                Symbol originalSymbol = this.symbolTables[3].getSymbol(symbolID);
                if (originalSymbol == null) continue;
                SymbolType symbolType = originalSymbol.getSymbolType();
                if (!originalSymbol.isExternal() || symbolType != SymbolType.FUNCTION && symbolType != SymbolType.LABEL) continue;
                externalRemoveSet.add(symbolID);
                continue;
            }
            SymbolType symbolType = symbol.getSymbolType();
            if (!symbol.isExternal() || symbolType != SymbolType.FUNCTION && symbolType != SymbolType.LABEL) continue;
            externalModifySet.add(symbolID);
        }
    }

    private void initializeSymbolTables() {
        this.symbolTables[1] = this.programs[1].getSymbolTable();
        this.symbolTables[2] = this.programs[2].getSymbolTable();
        this.symbolTables[3] = this.programs[3].getSymbolTable();
        this.symbolTables[0] = this.programs[0].getSymbolTable();
    }

    private void initializeExternalManagers() {
        this.externalManagers[0] = this.programs[0].getExternalManager();
        this.externalManagers[1] = this.programs[1].getExternalManager();
        this.externalManagers[2] = this.programs[2].getExternalManager();
        this.externalManagers[3] = this.programs[3].getExternalManager();
    }

    private void initializeMessages() {
        this.errorBuf = new StringBuffer();
        this.infoBuf = new StringBuffer();
    }

    private void initializeChangeSets() {
        Address minExternalAddress = AddressSpace.EXTERNAL_SPACE.getMinAddress();
        Address maxExternalAddress = AddressSpace.EXTERNAL_SPACE.getMaxAddress();
        AddressSet resultExternalSet = new AddressSet(minExternalAddress, maxExternalAddress);
        this.latestExternalSet = this.latestChanges.getAddressSet().intersect((AddressSetView)resultExternalSet);
        this.myExternalSet = this.myChanges.getAddressSet().intersect((AddressSetView)resultExternalSet);
    }

    private void initializeProgramMerges() {
        this.myAddressTranslator = new ExternalsAddressTranslator(this.programs[0], this.programs[2]);
        this.latestAddressTranslator = new ExternalsAddressTranslator(this.programs[0], this.programs[1]);
        this.originalAddressTranslator = new ExternalsAddressTranslator(this.programs[0], this.programs[3]);
        this.mergeMy = new ProgramMerge(this.myAddressTranslator);
        this.mergeLatest = new ProgramMerge(this.latestAddressTranslator);
        this.mergeOriginal = new ProgramMerge(this.originalAddressTranslator);
    }

    private void initializeConflictSets() {
        AddressFactory myAddressFactory = this.programs[2].getAddressFactory();
        this.externalDataTypeConflicts = new AddressSet();
        this.externalFunctionVersusDataTypeConflicts = new AddressSet();
        this.removeSet = new AddressSet();
        this.funcConflicts = new ObjectIntHashtable();
        this.funcSet = new AddressSet();
    }

    public String getName() {
        return "Externals Merger";
    }

    public String getDescription() {
        return "Merge Externals";
    }

    public boolean allChoicesAreResolved() {
        if (this.currentConflictPanel != null) {
            if (this.currentConflictPanel.allChoicesAreResolved()) {
                this.currentConflictPanel.removeAllListeners();
                return true;
            }
            return false;
        }
        return true;
    }

    @Override
    public boolean apply() {
        if (this.mergeManager == null) {
            return false;
        }
        boolean resolvedAll = this.allChoicesAreResolved();
        if (resolvedAll) {
            if (this.conflictListener != null) {
                this.conflictListener.resolveConflict();
                this.conflictListener = null;
            }
            int useForAllChoice = this.currentConflictPanel.getUseForAllChoice();
            if (this.currentConflictPanel.getUseForAll()) {
                this.setChoiceForExternalConflictType(this.currentExternalConflictType, useForAllChoice);
            }
            this.mergeManager.setApplyEnabled(false);
            return true;
        }
        this.mergeManager.setStatusText("Please select an option to resolve each conflict.");
        return false;
    }

    private void setChoiceForExternalConflictType(ExternalConflictType externalConflictType, int choiceForFunctionConflict) {
        switch (externalConflictType) {
            case EXTERNAL_FUNCTION_REMOVE_CONFLICT: {
                this.externalFunctionRemovalChoice = choiceForFunctionConflict;
                break;
            }
            case EXTERNAL_FUNCTION_CONFLICT: {
                this.externalFunctionChoice = choiceForFunctionConflict;
                break;
            }
            case EXTERNAL_DETAILS_CONFLICT: {
                this.externalDetailsChoice = this.getOptionForChoice(choiceForFunctionConflict);
                break;
            }
            case EXTERNAL_DATA_TYPE_CONFLICT: {
                this.externalDataTypeChoice = choiceForFunctionConflict;
                break;
            }
            case EXTERNAL_FUNCTION_VS_DATA_TYPE_CONFLICT: {
                this.externalFunctionVsDataTypeChoice = choiceForFunctionConflict;
                break;
            }
            case EXTERNAL_ADD_CONFLICT: {
                this.externalAddChoice = choiceForFunctionConflict;
                break;
            }
            case EXTERNAL_REMOVE_CONFLICT: {
                this.externalRemoveChoice = choiceForFunctionConflict;
                break;
            }
            case FUNCTION_OVERLAP_CONFLICT: {
                this.overlapChoice = choiceForFunctionConflict;
                break;
            }
            case FUNCTION_BODY_CONFLICT: {
                this.bodyChoice = choiceForFunctionConflict;
                break;
            }
            case FUNCTION_REMOVE_CONFLICT: {
                this.removeChoice = choiceForFunctionConflict;
                break;
            }
            case FUNCTION_RETURN_CONFLICT: {
                this.functionReturnChoice = choiceForFunctionConflict;
                break;
            }
            case FUNCTION_DETAILS_CONFLICT: {
                this.detailsChoice = this.getOptionForChoice(choiceForFunctionConflict);
                break;
            }
            case VARIABLE_STORAGE_CONFLICT: {
                this.variableStorageChoice = this.getOptionForChoice(choiceForFunctionConflict);
                break;
            }
            case PARAMETER_SIGNATURE_CONFLICT: {
                this.parameterSignatureChoice = choiceForFunctionConflict;
                break;
            }
            case PARAMETER_INFO_CONFLICT: {
                this.parameterInfoChoice = this.getOptionForChoice(choiceForFunctionConflict);
                break;
            }
            case REMOVED_LOCAL_VARIABLE_CONFLICT: {
                this.removedLocalVariableChoice = choiceForFunctionConflict;
                break;
            }
            case LOCAL_VARIABLE_DETAIL_CONFLICT: {
                this.localVariableDetailChoice = this.getOptionForChoice(choiceForFunctionConflict);
                break;
            }
            case THUNK_CONFLICT: {
                this.thunkChoice = choiceForFunctionConflict;
                break;
            }
            default: {
                Msg.showError((Object)this, (Component)this.listingMergePanel, (String)"Unrecognized External Conflict Type", (Object)("Unrecognized indicator (" + externalConflictType + ") for external conflict type to merge."));
            }
        }
    }

    @Override
    public void cancel() {
    }

    @Override
    public void autoMerge(int progressMin, int progressMax, TaskMonitor monitor) throws ProgramConflictException, MemoryAccessException, CancelledException {
        if (this.mergeManager != null) {
            this.latestResolvedDts = (Map)this.mergeManager.getResolveInformation("ResolvedLatestDataTypes");
            this.myResolvedDts = (Map)this.mergeManager.getResolveInformation("ResolvedMyDataTypes");
            this.origResolvedDts = (Map)this.mergeManager.getResolveInformation("ResolvedOriginalDataTypes");
            this.latestResolvedSymbols = (LongLongHashtable)this.mergeManager.getResolveInformation("ResolvedLatestSymbols");
            this.myResolvedSymbols = (LongLongHashtable)this.mergeManager.getResolveInformation("ResolvedMySymbols");
            this.originalResolvedSymbols = (LongLongHashtable)this.mergeManager.getResolveInformation("ResolvedOriginalSymbols");
        }
        this.initializeAutoMerge("Auto-merging External Labels and Functions and determining conflicts.", progressMin, progressMax, monitor);
        monitor.checkCancelled();
        this.clearResolveInfo();
        this.setupSymbolChanges(monitor);
        monitor.setMessage("Auto-merging Externals and determining conflicts.");
        this.getAddsRemovesChangesForExternals(monitor);
        this.saveInitialIDHashInfo();
        this.determineExternalRemoveConflicts(monitor);
        this.determineExternalChangeConflicts(monitor);
        this.determineExternalAddConflicts(monitor);
        this.mergeManager.updateProgress(100, "Done auto-merging Externals and determining conflicts.");
        this.showResolveErrors(ERROR_TITLE);
        this.showResolveInfo(INFO_TITLE);
    }

    protected void initializeAutoMerge(String progressMessage, int progressMin, int progressMax, TaskMonitor monitor) {
        this.totalChanges = 0;
        this.changeNum = 0;
        this.mergeManager.updateProgress(0, progressMessage);
        monitor.setMessage(progressMessage);
    }

    private void saveInitialIDHashInfo() {
        Long latestID;
        for (Long originalID : this.latestRemovedOriginalIDs) {
            long resultID = -1L;
            this.originalResolvedSymbols.put(originalID.longValue(), resultID);
            long myID = this.resolveMyIDFromOriginalID(originalID);
            if (myID == -1L) continue;
            this.myResolvedSymbols.put(myID, resultID);
        }
        Iterator<Long> iterator = this.latestAddIDs.iterator();
        while (iterator.hasNext()) {
            Long resultID = latestID = iterator.next();
            this.latestResolvedSymbols.put(latestID.longValue(), resultID.longValue());
        }
        iterator = this.latestModifiedIDs.iterator();
        while (iterator.hasNext()) {
            Long resultID = latestID = iterator.next();
            this.latestResolvedSymbols.put(latestID.longValue(), resultID.longValue());
            long originalID = this.resolveOriginalIDFromLatestID(latestID);
            this.originalResolvedSymbols.put(originalID, resultID.longValue());
        }
    }

    private void getAddsRemovesChangesForExternals(TaskMonitor monitor) throws CancelledException {
        this.mergeManager.updateProgress(0, "Finding changes to Externals in Latest...");
        this.fixupLatestChangeIDsMarkedAsRemovesAndAdds(monitor);
        this.getNonSymbolChangesForLatestExternals(monitor);
        this.mergeManager.updateProgress(5, "Finding changes to Externals in Checked Out...");
        this.fixupMyChangeIDsMarkedAsRemovesAndAdds(monitor);
        this.getNonSymbolChangesForMyExternals(monitor);
        this.totalChanges = this.latestAddIDs.size() + this.latestModifiedIDs.size() + this.latestRemovedOriginalIDs.size() + this.myAddIDs.size() + this.myModifiedIDs.size() + this.myRemovedOriginalIDs.size();
    }

    private void fixupLatestChangeIDsMarkedAsRemovesAndAdds(TaskMonitor monitor) {
        HashSet latestRemovedIDs = (HashSet)this.latestRemovedOriginalIDs.clone();
        for (Long id : latestRemovedIDs) {
            Address latestAddress;
            long originalID = id;
            Symbol originalSymbol = this.symbolTables[3].getSymbol(originalID);
            Address originalAddress = originalSymbol.getAddress();
            Symbol latestSymbol = SimpleDiffUtility.getMatchingExternalSymbol((Program)this.programs[3], (Symbol)originalSymbol, (Program)this.programs[1], this.latestAddIDs);
            if (latestSymbol == null || !originalAddress.equals((Object)(latestAddress = latestSymbol.getAddress()))) continue;
            long latestID = latestSymbol.getID();
            this.fixupLatestExternalTypeChanges(originalID, latestID);
        }
    }

    private void fixupMyChangeIDsMarkedAsRemovesAndAdds(TaskMonitor monitor) {
        HashSet myRemovedIDs = (HashSet)this.myRemovedOriginalIDs.clone();
        for (Long id : myRemovedIDs) {
            Address myAddress;
            long originalID = id;
            Symbol originalSymbol = this.symbolTables[3].getSymbol(originalID);
            Address originalAddress = originalSymbol.getAddress();
            Symbol mySymbol = SimpleDiffUtility.getMatchingExternalSymbol((Program)this.programs[3], (Symbol)originalSymbol, (Program)this.programs[2], this.myAddIDs);
            if (mySymbol == null || !originalAddress.equals((Object)(myAddress = mySymbol.getAddress()))) continue;
            long myID = mySymbol.getID();
            this.fixupMyExternalTypeChanges(originalID, myID);
        }
    }

    private void getNonSymbolChangesForLatestExternals(TaskMonitor monitor) throws CancelledException {
        AddressIterator latestModifiedAddressIterator = this.latestExternalSet.getAddresses(true);
        while (latestModifiedAddressIterator.hasNext()) {
            long latestID;
            monitor.checkCancelled();
            Address externalAddress = latestModifiedAddressIterator.next();
            Symbol latestSymbol = this.symbolTables[1].getPrimarySymbol(externalAddress);
            if (latestSymbol == null || this.latestModifiedIDs.contains(latestID = latestSymbol.getID()) || this.latestAddIDs.contains(latestID)) continue;
            long originalID = this.resolveOriginalIDFromLatestID(latestID);
            Symbol originalSymbol = this.symbolTables[3].getSymbol(originalID);
            if (originalSymbol != null) {
                ExternalLocation originalExternalLocation;
                ExternalLocation latestExternalLocation = this.externalManagers[1].getExternalLocation(latestSymbol);
                if (this.equivalentExternals(latestExternalLocation, originalExternalLocation = this.externalManagers[3].getExternalLocation(originalSymbol))) continue;
                this.latestModifiedIDs.add(latestID);
                continue;
            }
            Msg.error((Object)this, (Object)("Why is there a change to LATEST external without an ORIGINAL at " + externalAddress.toString(true) + "?"));
        }
    }

    private void getNonSymbolChangesForMyExternals(TaskMonitor monitor) throws CancelledException {
        AddressIterator myModifiedAddressIterator = this.myExternalSet.getAddresses(true);
        while (myModifiedAddressIterator.hasNext()) {
            long myID;
            monitor.checkCancelled();
            Address externalAddress = myModifiedAddressIterator.next();
            Symbol mySymbol = this.symbolTables[2].getPrimarySymbol(externalAddress);
            if (mySymbol == null || this.myModifiedIDs.contains(myID = mySymbol.getID()) || this.myAddIDs.contains(myID)) continue;
            long originalID = this.resolveOriginalIDFromMyID(myID);
            Symbol originalSymbol = this.symbolTables[3].getSymbol(originalID);
            if (originalSymbol != null) {
                ExternalLocation originalExternalLocation;
                ExternalLocation myExternalLocation = this.externalManagers[2].getExternalLocation(mySymbol);
                if (this.equivalentExternals(myExternalLocation, originalExternalLocation = this.externalManagers[3].getExternalLocation(originalSymbol))) continue;
                this.myModifiedIDs.add(myID);
                continue;
            }
            Msg.error((Object)this, (Object)("Why is there a change to MY external without an ORIGINAL at " + externalAddress.toString(true) + "?"));
        }
    }

    private void fixupLatestExternalTypeChanges(long originalID, long latestID) {
        this.latestModifiedIDs.add(latestID);
        this.latestRemovedOriginalIDs.remove(originalID);
        this.latestAddIDs.remove(latestID);
        this.originalToLatestHash.put(originalID, latestID);
        this.latestToOriginalHash.put(latestID, originalID);
    }

    private void fixupMyExternalTypeChanges(long originalID, long myID) {
        this.myModifiedIDs.add(myID);
        this.myRemovedOriginalIDs.remove(originalID);
        this.myAddIDs.remove(myID);
        this.originalToMyHash.put(originalID, myID);
        this.myToOriginalHash.put(myID, originalID);
    }

    private void saveExternalDetailConflict(ExternalLocation[] locations, int externalConflictFlags) {
        Address myEntry = locations[2].getExternalSpaceAddress();
        this.externalDetailConflicts.put((Object)myEntry, externalConflictFlags);
    }

    private int determineBasicExternalConflict(ExternalLocation[] locations, int type, int latestMyChanges, int originalLatestChanges, int originalMyChanges, TaskMonitor monitor) throws CancelledException {
        if ((latestMyChanges & type) != 0 && (originalMyChanges & type) != 0) {
            if ((originalLatestChanges & type) != 0) {
                return type;
            }
            this.mergeExternalDetail(type, locations[0], locations[2], monitor);
        }
        return 0;
    }

    private void mergeExternalDetail(int type, ExternalLocation resultExternalLocation, ExternalLocation fromExternalLocation, TaskMonitor monitor) throws CancelledException {
        monitor.checkCancelled();
        switch (type) {
            case 1: {
                this.replaceNamespace(resultExternalLocation, fromExternalLocation, monitor);
                return;
            }
            case 2: {
                String fromLabel = fromExternalLocation.getLabel();
                SourceType resultSource = resultExternalLocation.getSource();
                SourceType fromSource = fromExternalLocation.getSource();
                if (resultSource == SourceType.DEFAULT && fromSource == SourceType.DEFAULT) {
                    return;
                }
                try {
                    resultExternalLocation.getSymbol().setName(fromLabel, fromSource);
                }
                catch (DuplicateNameException e) {
                    throw new AssertException("Can't happen now that duplicates are allowed");
                }
                catch (InvalidInputException e) {
                    Msg.error((Object)this, (Object)("Couldn't merge external location name '" + fromLabel + "'. " + e));
                    return;
                }
                return;
            }
            case 4: {
                Address address = fromExternalLocation.getAddress();
                try {
                    resultExternalLocation.setAddress(address);
                }
                catch (InvalidInputException e) {
                    String message = "Couldn't set memory address " + (address != null ? address.toString(true) : "(null)") + " for external '" + resultExternalLocation.getLabel() + "'.";
                    this.errorBuf.append(message);
                    Msg.error((Object)this, (Object)message, (Throwable)e);
                }
                return;
            }
            case 32: {
                this.replaceExternalDataType(resultExternalLocation, fromExternalLocation, monitor);
                return;
            }
        }
    }

    private DataType getResultDataType(ExternalLocation fromExternalLocation) {
        long originalID;
        DataType originalResultDT;
        long myID;
        DataType myResultDT;
        long latestID;
        DataType latestResultDT;
        if (fromExternalLocation == null) {
            return null;
        }
        DataType fromDataType = fromExternalLocation.getDataType();
        if (fromDataType == null || fromDataType == DataType.DEFAULT) {
            return fromDataType;
        }
        ProgramBasedDataTypeManager latestDTM = this.programs[1].getDataTypeManager();
        ProgramBasedDataTypeManager myDTM = this.programs[2].getDataTypeManager();
        ProgramBasedDataTypeManager originalDTM = this.programs[3].getDataTypeManager();
        DataTypeManager fromDataTypeManager = fromDataType.getDataTypeManager();
        if (fromDataTypeManager == latestDTM && (latestResultDT = this.getResultDataType(latestID = latestDTM.getID(fromDataType), this.programs[1])) != null) {
            return latestResultDT;
        }
        if (fromDataTypeManager == myDTM && (myResultDT = this.getResultDataType(myID = myDTM.getID(fromDataType), this.programs[2])) != null) {
            return myResultDT;
        }
        if (fromDataTypeManager == originalDTM && (originalResultDT = this.getResultDataType(originalID = originalDTM.getID(fromDataType), this.programs[3])) != null) {
            return originalResultDT;
        }
        return fromDataType;
    }

    private DataType getResultDataType(DataType fromDataType) {
        long originalID;
        DataType originalResultDT;
        long myID;
        DataType myResultDT;
        long latestID;
        DataType latestResultDT;
        if (fromDataType == null) {
            return null;
        }
        if (fromDataType == DataType.DEFAULT) {
            return fromDataType;
        }
        ProgramBasedDataTypeManager latestDTM = this.programs[1].getDataTypeManager();
        ProgramBasedDataTypeManager myDTM = this.programs[2].getDataTypeManager();
        ProgramBasedDataTypeManager originalDTM = this.programs[3].getDataTypeManager();
        DataTypeManager fromDataTypeManager = fromDataType.getDataTypeManager();
        if (fromDataTypeManager == latestDTM && (latestResultDT = this.getResultDataType(latestID = latestDTM.getID(fromDataType), this.programs[1])) != null) {
            return latestResultDT;
        }
        if (fromDataTypeManager == myDTM && (myResultDT = this.getResultDataType(myID = myDTM.getID(fromDataType), this.programs[2])) != null) {
            return myResultDT;
        }
        if (fromDataTypeManager == originalDTM && (originalResultDT = this.getResultDataType(originalID = originalDTM.getID(fromDataType), this.programs[3])) != null) {
            return originalResultDT;
        }
        return fromDataType;
    }

    private int getBasicExternalDiffs(ExternalLocation externalLocation1, ExternalLocation externalLocation2) {
        int conflicts = 0;
        if (externalLocation1 == null || externalLocation2 == null) {
            throw new IllegalArgumentException("External location can't be null.");
        }
        Namespace namespace1 = externalLocation1.getParentNameSpace();
        String label1 = externalLocation1.getLabel();
        DataType dataType1 = this.getResultDataType(externalLocation1);
        Address address1 = externalLocation1.getAddress();
        SourceType sourceType1 = externalLocation1.getSource();
        Symbol symbol1 = externalLocation1.getSymbol();
        SymbolType symbolType1 = symbol1.getSymbolType();
        Function function1 = externalLocation1.getFunction();
        Namespace namespace2 = externalLocation2.getParentNameSpace();
        String label2 = externalLocation2.getLabel();
        DataType dataType2 = this.getResultDataType(externalLocation2);
        Address address2 = externalLocation2.getAddress();
        SourceType sourceType2 = externalLocation2.getSource();
        Symbol symbol2 = externalLocation2.getSymbol();
        SymbolType symbolType2 = symbol2.getSymbolType();
        Function function2 = externalLocation2.getFunction();
        if (!this.equivalentNamespaces(namespace1, namespace2)) {
            conflicts |= 1;
        }
        if (!this.isSameLabel(label1, label2, sourceType1, sourceType2)) {
            conflicts |= 2;
        }
        if (!SystemUtilities.isEqual((Object)address1, (Object)address2)) {
            conflicts |= 4;
        }
        if (!this.isSameDataType(dataType1, dataType2)) {
            conflicts |= 0x20;
        }
        if (symbolType1 != symbolType2) {
            conflicts |= 0x10;
        }
        if (!ProgramDiff.equivalentFunctions(function1, function2)) {
            conflicts |= 0x40;
        }
        return conflicts;
    }

    private boolean isSameDataType(DataType dt1, DataType dt2) {
        if (dt1 == dt2) {
            return true;
        }
        if (dt1 == null) {
            return dt2 == null;
        }
        if (dt2 == null) {
            return false;
        }
        return dt1.isEquivalent(dt2);
    }

    private boolean isSameLabel(String label1, String label2, SourceType sourceType1, SourceType sourceType2) {
        if (sourceType1 == SourceType.DEFAULT && sourceType2 == SourceType.DEFAULT) {
            return true;
        }
        return SystemUtilities.isEqual((Object)label1, (Object)label2);
    }

    private boolean hasExternalAddConflicts(ExternalLocation externalLocation1, ExternalLocation externalLocation2) {
        boolean external2IsFunction;
        if (externalLocation1 == null || externalLocation2 == null) {
            throw new IllegalArgumentException("External location can't be null.");
        }
        Namespace namespace1 = externalLocation1.getParentNameSpace();
        String label1 = externalLocation1.getLabel();
        boolean label1IsDefault = this.hasDefaultExternalName(externalLocation1);
        DataType dataType1 = this.getResultDataType(externalLocation1);
        boolean dataType1IsDefined = this.hasDefinedDataType(externalLocation1);
        Address address1 = externalLocation1.getAddress();
        Function function1 = externalLocation1.getFunction();
        String originalName1 = externalLocation1.getOriginalImportedName();
        boolean external1IsFunction = function1 != null;
        Namespace namespace2 = externalLocation2.getParentNameSpace();
        String label2 = externalLocation2.getLabel();
        boolean label2IsDefault = this.hasDefaultExternalName(externalLocation2);
        DataType dataType2 = this.getResultDataType(externalLocation2);
        boolean dataType2IsDefined = this.hasDefinedDataType(externalLocation2);
        Address address2 = externalLocation2.getAddress();
        String originalName2 = externalLocation2.getOriginalImportedName();
        Function function2 = externalLocation2.getFunction();
        boolean bl = external2IsFunction = function2 != null;
        if (!this.equivalentNamespaces(namespace1, namespace2)) {
            return true;
        }
        if (!label1IsDefault && !label2IsDefault && this.isNameConflict(label1, label2, originalName1, originalName2)) {
            return true;
        }
        if (address1 != null && address2 != null && !SystemUtilities.isEqual((Object)address1, (Object)address2)) {
            return true;
        }
        if (dataType1IsDefined && dataType2IsDefined && !this.isSameDataType(dataType1, dataType2)) {
            return true;
        }
        if (dataType1IsDefined && external2IsFunction || dataType2IsDefined && external1IsFunction) {
            return true;
        }
        return external1IsFunction && external2IsFunction && this.hasExternalFunctionAddConflicts(function1, function2);
    }

    private boolean isNameConflict(String name1, String name2, String originalName1, String originalName2) {
        boolean hasOriginalName2;
        boolean hasOriginalName1 = originalName1 != null;
        boolean bl = hasOriginalName2 = originalName2 != null;
        if (hasOriginalName1 && hasOriginalName2) {
            if (!originalName1.equals(originalName2)) {
                return true;
            }
            if (!name1.equals(name2)) {
                return true;
            }
        } else if (hasOriginalName1 ? !name2.equals(name1) && !name2.equals(originalName1) : (hasOriginalName2 ? !name1.equals(name2) && !name1.equals(originalName2) : !name1.equals(name2))) {
            return true;
        }
        return false;
    }

    private boolean hasExternalFunctionAddConflicts(Function function1, Function function2) {
        return !ProgramDiff.equivalentFunctions(function1, function2, true);
    }

    private boolean hasDefaultExternalName(ExternalLocation externalLocation) {
        Symbol symbol = externalLocation.getSymbol();
        SourceType source = symbol.getSource();
        return source == SourceType.DEFAULT;
    }

    private boolean hasDefinedDataType(ExternalLocation externalLocation) {
        DataType dataType = externalLocation.getDataType();
        return dataType != null && dataType != DataType.DEFAULT;
    }

    private boolean equivalentNamespaces(Namespace namespace1, Namespace namespace2) {
        SymbolType symbolType2;
        String name2;
        if (namespace1 == null) {
            return namespace2 == null;
        }
        if (namespace1.getID() == 0L) {
            return namespace2.getID() == 0L;
        }
        String name1 = namespace1.getName();
        if (!SystemUtilities.isEqual((Object)name1, (Object)(name2 = namespace2.getName()))) {
            return false;
        }
        SymbolType symbolType1 = namespace1.getSymbol().getSymbolType();
        if (!SystemUtilities.isEqual((Object)symbolType1, (Object)(symbolType2 = namespace2.getSymbol().getSymbolType()))) {
            return false;
        }
        Namespace parent1 = namespace1.getParentNamespace();
        Namespace parent2 = namespace2.getParentNamespace();
        return this.equivalentNamespaces(parent1, parent2);
    }

    private boolean equivalentExternals(ExternalLocation externalLocation1, ExternalLocation externalLocation2) {
        if (externalLocation1 == null) {
            return externalLocation2 == null;
        }
        if (externalLocation2 == null) {
            return false;
        }
        Namespace namespace1 = externalLocation1.getParentNameSpace();
        String label1 = externalLocation1.getLabel();
        DataType dataType1 = this.getResultDataType(externalLocation1);
        Address address1 = externalLocation1.getAddress();
        Symbol symbol1 = externalLocation1.getSymbol();
        SymbolType symbolType1 = symbol1.getSymbolType();
        Function function1 = externalLocation1.getFunction();
        Namespace namespace2 = externalLocation2.getParentNameSpace();
        String label2 = externalLocation2.getLabel();
        DataType dataType2 = this.getResultDataType(externalLocation2);
        Address address2 = externalLocation2.getAddress();
        Symbol symbol2 = externalLocation2.getSymbol();
        SymbolType symbolType2 = symbol2.getSymbolType();
        Function function2 = externalLocation2.getFunction();
        if (!this.equivalentNamespaces(namespace1, namespace2)) {
            return false;
        }
        if (!label1.equals(label2)) {
            return false;
        }
        if (!this.isSameDataType(dataType1, dataType2)) {
            return false;
        }
        if (!SystemUtilities.isEqual((Object)address1, (Object)address2)) {
            return false;
        }
        if (symbolType1 != symbolType2) {
            return false;
        }
        return symbolType1 != SymbolType.FUNCTION || ProgramDiff.equivalentFunctions(function1, function2);
    }

    private void determineExternalRemoveConflicts(TaskMonitor monitor) throws CancelledException {
        monitor.checkCancelled();
        if (this.totalChanges <= 0) {
            return;
        }
        this.mergeManager.updateProgress(this.changeNum / this.totalChanges * 100, "Finding conflicts for removed externals.");
        for (long originalID : this.latestRemovedOriginalIDs) {
            long myID = this.resolveMyIDFromOriginalID(originalID);
            if (this.myRemovedOriginalIDs.contains(originalID)) continue;
            if (this.myModifiedIDs.contains(myID)) {
                this.removeConflictIDs.add(originalID);
            }
            this.mergeManager.updateProgress(++this.changeNum / this.totalChanges * 100);
        }
        for (long originalID : this.myRemovedOriginalIDs) {
            long latestID = this.resolveLatestIDFromOriginalID(originalID);
            if (this.latestRemovedOriginalIDs.contains(originalID)) continue;
            if (this.latestModifiedIDs.contains(latestID)) {
                this.removeConflictIDs.add(originalID);
            } else {
                long resultID = this.getResultIDfromOriginalID(originalID);
                if (resultID != -1L) {
                    this.removeExternal(resultID);
                }
                this.originalResolvedSymbols.put(originalID, -1L);
                this.latestResolvedSymbols.put(latestID, -1L);
            }
            this.mergeManager.updateProgress(++this.changeNum / this.totalChanges * 100);
        }
    }

    private void determineExternalChangeConflicts(TaskMonitor monitor) throws CancelledException {
        monitor.checkCancelled();
        if (this.totalChanges <= 0) {
            return;
        }
        this.mergeManager.updateProgress(this.changeNum / this.totalChanges * 100, "Finding conflicts for changed externals.");
        this.processExternalsChangedInLatest(monitor);
        this.processExternalsChangedInMy(monitor);
    }

    private void processExternalsChangedInLatest(TaskMonitor monitor) throws CancelledException {
        Iterator<Long> latestIterator = this.latestModifiedIDs.iterator();
        while (latestIterator.hasNext()) {
            monitor.checkCancelled();
            long latestID = latestIterator.next();
            long originalID = this.resolveOriginalIDFromLatestID(latestID);
            long myID = this.resolveMyIDFromOriginalID(originalID);
            if (this.removeConflictIDs.contains(originalID)) continue;
            if (this.myModifiedIDs.contains(myID)) {
                Symbol latestSymbol = this.symbolTables[1].getSymbol(latestID);
                Symbol mySymbol = this.symbolTables[2].getSymbol(myID);
                Symbol originalSymbol = this.symbolTables[3].getSymbol(originalID);
                long resultID = this.getResultIDfromLatestID(latestID);
                Symbol resultSymbol = this.symbolTables[0].getSymbol(resultID);
                ExternalLocation[] externalLocations = new ExternalLocation[4];
                externalLocations[1] = this.externalManagers[1].getExternalLocation(latestSymbol);
                externalLocations[2] = this.externalManagers[2].getExternalLocation(mySymbol);
                externalLocations[3] = this.externalManagers[3].getExternalLocation(originalSymbol);
                externalLocations[0] = this.externalManagers[0].getExternalLocation(resultSymbol);
                this.myResolvedSymbols.put(myID, resultID);
                this.mergeChangesAndDetermineConflicts(externalLocations, monitor);
            }
            this.mergeManager.updateProgress(++this.changeNum / this.totalChanges * 100);
        }
    }

    private void processExternalsChangedInMy(TaskMonitor monitor) throws CancelledException {
        Iterator<Long> myIterator = this.myModifiedIDs.iterator();
        while (myIterator.hasNext()) {
            monitor.checkCancelled();
            long myID = myIterator.next();
            long originalID = this.resolveOriginalIDFromMyID(myID);
            long latestID = this.resolveLatestIDFromOriginalID(originalID);
            long resultID = this.getResultIDfromLatestID(latestID);
            if (this.latestModifiedIDs.contains(latestID) || this.removeConflictIDs.contains(originalID)) continue;
            Symbol myExternalSymbol = this.symbolTables[2].getSymbol(myID);
            ExternalLocation myExternalLocation = this.externalManagers[2].getExternalLocation(myExternalSymbol);
            Symbol resultExternalSymbol = this.symbolTables[0].getSymbol(resultID);
            ExternalLocation resultExternalLocation = this.externalManagers[0].getExternalLocation(resultExternalSymbol);
            this.myAddressTranslator.setPair(resultExternalSymbol.getAddress(), myExternalSymbol.getAddress());
            try {
                resultExternalLocation = this.replaceExternalLocation(resultExternalLocation, myExternalLocation, this.getMergeMy(), monitor);
                this.myResolvedSymbols.put(myID, resultID);
                this.originalResolvedSymbols.put(originalID, resultID);
            }
            catch (DuplicateNameException e) {
                Msg.showError((Object)this, (Component)this.mergeManager.getMergeTool().getToolFrame(), (String)"Error Merging External Location", (Object)e.getMessage());
            }
            catch (InvalidInputException e) {
                Msg.showError((Object)this, (Component)this.mergeManager.getMergeTool().getToolFrame(), (String)"Error Merging External Location", (Object)e.getMessage());
            }
            this.mergeManager.updateProgress(++this.changeNum / this.totalChanges * 100);
        }
    }

    private long getResultIDfromLatestID(long latestID) {
        long resultID;
        try {
            resultID = this.latestResolvedSymbols.get(latestID);
        }
        catch (NoValueException e) {
            resultID = latestID;
        }
        return resultID;
    }

    private long getResultIDfromOriginalID(long originalID) {
        long resultID;
        try {
            resultID = this.originalResolvedSymbols.get(originalID);
        }
        catch (NoValueException e) {
            resultID = originalID;
        }
        return resultID;
    }

    private void mergeChangesAndDetermineConflicts(ExternalLocation[] externalLocations, TaskMonitor monitor) throws CancelledException {
        if (!this.equivalentExternals(externalLocations[1], externalLocations[2])) {
            this.updateAddressTranslators(externalLocations);
            int latestMyChanges = this.getBasicExternalDiffs(externalLocations[1], externalLocations[2]);
            if (latestMyChanges == 0) {
                return;
            }
            int originalLatestChanges = this.getBasicExternalDiffs(externalLocations[3], externalLocations[1]);
            int originalMyChanges = this.getBasicExternalDiffs(externalLocations[3], externalLocations[2]);
            int detailConflictFlags = 0;
            detailConflictFlags |= this.determineBasicExternalConflict(externalLocations, 1, latestMyChanges, originalLatestChanges, originalMyChanges, monitor);
            detailConflictFlags |= this.determineBasicExternalConflict(externalLocations, 2, latestMyChanges, originalLatestChanges, originalMyChanges, monitor);
            if ((detailConflictFlags |= this.determineBasicExternalConflict(externalLocations, 4, latestMyChanges, originalLatestChanges, originalMyChanges, monitor)) != 0) {
                this.saveExternalDetailConflict(externalLocations, detailConflictFlags);
            }
            this.determineExternalDataTypeConflict(externalLocations, latestMyChanges, originalLatestChanges, originalMyChanges, monitor);
            this.determineExternalFunctionConflict(externalLocations, latestMyChanges, originalLatestChanges, originalMyChanges, monitor);
        }
    }

    private void determineExternalDataTypeConflict(ExternalLocation[] externalLocations, int latestMyChanges, int originalLatestChanges, int originalMyChanges, TaskMonitor monitor) throws CancelledException {
        boolean myChangedFunction;
        Address myExternalAddress = externalLocations[2].getExternalSpaceAddress();
        DataType latestDataType = this.getResultDataType(externalLocations[1]);
        DataType myDataType = this.getResultDataType(externalLocations[2]);
        boolean latestHasDataType = latestDataType != null && latestDataType != DataType.DEFAULT;
        boolean myHasDataType = myDataType != null && myDataType != DataType.DEFAULT;
        boolean differentDataTypes = (latestMyChanges & 0x20) != 0;
        boolean latestChangedDataType = (originalLatestChanges & 0x20) != 0;
        boolean myChangedDataType = (originalMyChanges & 0x20) != 0;
        boolean latestIsFunction = externalLocations[1].isFunction();
        boolean myIsFunction = externalLocations[2].isFunction();
        boolean latestChangedFunction = (originalLatestChanges & 0x40) != 0;
        boolean bl = myChangedFunction = (originalMyChanges & 0x40) != 0;
        if (differentDataTypes) {
            if (myChangedDataType) {
                if (latestChangedDataType) {
                    this.saveExternalDataTypeConflict(myExternalAddress);
                } else if (myHasDataType && latestChangedFunction && latestIsFunction) {
                    this.saveExternalFunctionVersusDataTypeConflict(myExternalAddress);
                } else {
                    this.replaceExternalDataType(externalLocations[0], externalLocations[2], monitor);
                }
            } else if (latestChangedDataType) {
                if (myChangedDataType) {
                    throw new AssertException("Shouldn't be here!");
                }
                if (latestHasDataType && myChangedFunction && myIsFunction) {
                    this.saveExternalFunctionVersusDataTypeConflict(myExternalAddress);
                }
            }
        }
    }

    private void mergeExternalDataType(ExternalLocation[] externalLocations, int chosenConflictOption, TaskMonitor monitor) throws CancelledException {
        ExternalLocation chosenExternalLocation;
        if ((chosenConflictOption & 1) != 0) {
            Msg.showError((Object)this, (Component)this.mergeManager.getMergeTool().getToolFrame(), (String)"Error Merging External Location", (Object)("Can't currently merge external data type from ORIGINAL program." + (String)(externalLocations[3] != null ? " ORIGINAL external was " + externalLocations[3].getLabel() + "." : "")));
            return;
        }
        if ((chosenConflictOption & 2) != 0) {
            chosenExternalLocation = externalLocations[1];
        } else if ((chosenConflictOption & 4) != 0) {
            chosenExternalLocation = externalLocations[2];
        } else {
            Msg.showError((Object)this, (Component)this.mergeManager.getMergeTool().getToolFrame(), (String)"Error Merging External Location", (Object)("Can only merge external data type from LATEST or MY program." + (String)(externalLocations[0] != null ? " RESULT external was " + externalLocations[0].getLabel() + "." : "")));
            return;
        }
        this.replaceExternalDataType(externalLocations[0], chosenExternalLocation, monitor);
    }

    public void replaceExternalDataType(ExternalLocation resultExternalLocation, ExternalLocation fromExternalLocation, TaskMonitor monitor) throws CancelledException {
        monitor.checkCancelled();
        if (fromExternalLocation != null && resultExternalLocation != null) {
            DataType resultDataType;
            DataType fromDataTypeForResult = this.getResultDataType(fromExternalLocation);
            if (this.isSameDataType(fromDataTypeForResult, resultDataType = resultExternalLocation.getDataType())) {
                return;
            }
            resultExternalLocation.setDataType(fromDataTypeForResult);
        }
    }

    private void saveExternalDataTypeConflict(Address myExternalAddress) {
        this.externalDataTypeConflicts.add(myExternalAddress);
    }

    private void saveExternalFunctionVersusDataTypeConflict(Address myExternalAddress) {
        this.externalFunctionVersusDataTypeConflicts.add(myExternalAddress);
    }

    private void saveExternalRemoveFunctionConflict(long originalID) {
        this.removeFunctionConflictIDs.add(originalID);
    }

    private void determineExternalFunctionConflict(ExternalLocation[] externalLocations, int latestMyChanges, int originalLatestChanges, int originalMyChanges, TaskMonitor monitor) throws CancelledException {
        boolean differentFunctions;
        boolean myChangedFunction;
        Address myExternalAddress = externalLocations[2].getExternalSpaceAddress();
        if (this.externalFunctionVersusDataTypeConflicts.contains(myExternalAddress)) {
            return;
        }
        boolean latestIsFunction = externalLocations[1].isFunction();
        boolean myIsFunction = externalLocations[2].isFunction();
        boolean latestChangedFunction = (originalLatestChanges & 0x40) != 0;
        boolean bl = myChangedFunction = (originalMyChanges & 0x40) != 0;
        if (!latestIsFunction && !myIsFunction) {
            return;
        }
        boolean bl2 = differentFunctions = (latestMyChanges & 0x40) != 0;
        if (differentFunctions && myChangedFunction) {
            if (latestChangedFunction) {
                this.determineDetailedFunctionConflicts(externalLocations, monitor);
            } else {
                this.replaceFunction(externalLocations[0], externalLocations[2], this.getMergeMy(), monitor);
            }
        }
    }

    private void determineDetailedFunctionConflicts(ExternalLocation[] externalLocations, TaskMonitor monitor) throws CancelledException {
        boolean noOriginalFunction;
        Function[] functions = new Function[]{externalLocations[0].getFunction(), externalLocations[1].getFunction(), externalLocations[2].getFunction(), externalLocations[3] != null ? externalLocations[3].getFunction() : null};
        boolean noLatestFunction = functions[1] == null;
        boolean noMyFunction = functions[2] == null;
        boolean bl = noOriginalFunction = functions[3] == null;
        if (noLatestFunction && noMyFunction) {
            throw new AssertException("Shouldn't be here! Something is wrong.");
        }
        if (!noOriginalFunction && noLatestFunction != noMyFunction) {
            long originalID = externalLocations[3].getSymbol().getID();
            this.saveExternalRemoveFunctionConflict(originalID);
            return;
        }
        this.determineFunctionConflicts(functions, true, monitor);
        if (noOriginalFunction && (noLatestFunction || noMyFunction)) {
            throw new AssertException("Shouldn't be here! It looks like only Latest or My added the function.");
        }
    }

    private void determineExternalAddConflicts(TaskMonitor monitor) throws CancelledException {
        monitor.checkCancelled();
        if (this.totalChanges <= 0) {
            return;
        }
        this.mergeManager.updateProgress(this.changeNum / this.totalChanges * 100, "Finding conflicts for added externals.");
        this.changeNum += this.latestAddIDs.size();
        this.mergeManager.updateProgress(this.changeNum / this.totalChanges * 100);
        Iterator<Long> myIterator = this.myAddIDs.iterator();
        while (myIterator.hasNext()) {
            SymbolType symbolType;
            monitor.checkCancelled();
            long myID = myIterator.next();
            Symbol mySymbol = this.symbolTables[2].getSymbol(myID);
            if (!mySymbol.isPrimary()) continue;
            ExternalLocation myExternalLocation = this.externalManagers[2].getExternalLocation(mySymbol);
            if (myExternalLocation == null) {
                throw new AssertException("Why don't we have an external location?");
            }
            Symbol latestSymbol = SimpleDiffUtility.getMatchingExternalSymbol((Program)this.programs[2], (Symbol)mySymbol, (Program)this.programs[1], this.latestAddIDs);
            ExternalLocation latestExternalLocation = null;
            if (latestSymbol != null && ((symbolType = latestSymbol.getSymbolType()) == SymbolType.LABEL || symbolType == SymbolType.FUNCTION)) {
                latestExternalLocation = this.externalManagers[1].getExternalLocation(latestSymbol);
            }
            if (latestExternalLocation == null) {
                try {
                    ExternalLocation resultExternalLocation = this.addExternal(myExternalLocation, monitor);
                    ExternalLocation[] externalLocations = new ExternalLocation[]{resultExternalLocation, latestExternalLocation, myExternalLocation, null};
                    this.adjustIDMapsForAdd(externalLocations, resultExternalLocation, 2);
                }
                catch (DuplicateNameException e) {
                    Msg.error((Object)this, (Object)("Couldn't add external '" + myExternalLocation.getSymbol().getName(true) + ",. " + e.getMessage()));
                }
                catch (InvalidInputException e) {
                    Msg.error((Object)this, (Object)("Couldn't add external '" + myExternalLocation.getSymbol().getName(true) + ",. " + e.getMessage()));
                }
                continue;
            }
            boolean hasExternalAddConflicts = this.hasExternalAddConflicts(latestExternalLocation, myExternalLocation);
            if (hasExternalAddConflicts) {
                if (this.isAddConflictSpecialFunctionVsData(latestExternalLocation, myExternalLocation, monitor)) {
                    this.saveExternalFunctionVersusDataTypeConflict(myExternalLocation.getExternalSpaceAddress());
                    continue;
                }
                this.saveExternalAddConflict(latestExternalLocation, myExternalLocation, monitor);
                continue;
            }
            this.mergeAddsAndDetermineConflicts(latestExternalLocation, myExternalLocation, monitor);
            this.mergeManager.updateProgress(++this.changeNum / this.totalChanges * 100);
        }
    }

    private boolean isAddConflictSpecialFunctionVsData(ExternalLocation latestExternalLocation, ExternalLocation myExternalLocation, TaskMonitor monitor) {
        long myExternalID = myExternalLocation.getSymbol().getID();
        long latestExternalID = latestExternalLocation.getSymbol().getID();
        long resultExternalID = this.getResultIDfromLatestID(latestExternalID);
        Symbol latestSymbol = this.symbolTables[1].getSymbol(latestExternalID);
        Symbol mySymbol = this.symbolTables[2].getSymbol(myExternalID);
        Symbol resultSymbol = this.symbolTables[0].getSymbol(resultExternalID);
        ExternalLocation[] externalLocations = new ExternalLocation[4];
        externalLocations[1] = this.externalManagers[1].getExternalLocation(latestSymbol);
        externalLocations[2] = this.externalManagers[2].getExternalLocation(mySymbol);
        externalLocations[3] = null;
        externalLocations[0] = this.externalManagers[0].getExternalLocation(resultSymbol);
        String latestName = this.getExternalName(externalLocations, 1, true);
        String myName = this.getExternalName(externalLocations, 2, true);
        boolean latestIsFunction = externalLocations[1].isFunction();
        boolean myIsFunction = externalLocations[2].isFunction();
        Address latestAddress = externalLocations[1].getAddress();
        Address myAddress = externalLocations[2].getAddress();
        boolean hasAddresses = latestAddress != null && myAddress != null;
        boolean namesMatch = SystemUtilities.isEqual((Object)latestName, (Object)myName);
        boolean addressesMatch = SystemUtilities.isEqual((Object)latestAddress, (Object)myAddress);
        boolean typesDiffer = latestIsFunction != myIsFunction;
        return namesMatch && typesDiffer && hasAddresses && addressesMatch;
    }

    private void saveExternalAddConflict(ExternalLocation latestExternalLocation, ExternalLocation myExternalLocation, TaskMonitor monitor) {
        long myID = myExternalLocation.getSymbol().getID();
        long latestID = latestExternalLocation.getSymbol().getID();
        this.externalAddConflicts.put(myID, latestID);
    }

    private void mergeAddsAndDetermineConflicts(ExternalLocation latestExternalLocation, ExternalLocation myExternalLocation, TaskMonitor monitor) throws CancelledException {
        if (!this.equivalentExternals(latestExternalLocation, myExternalLocation)) {
            Namespace latestNamespace = latestExternalLocation.getParentNameSpace();
            String latestLabel = latestExternalLocation.getLabel();
            DataType latestDataType = this.getResultDataType(latestExternalLocation);
            Address latestAddress = latestExternalLocation.getAddress();
            String latestOriginalName = latestExternalLocation.getOriginalImportedName();
            Function latestFunction = latestExternalLocation.getFunction();
            boolean latestExternalIsFunction = latestFunction != null;
            Namespace myNamespace = myExternalLocation.getParentNameSpace();
            boolean myNamespaceIsDefault = myNamespace.getSymbol().getSymbolType() == SymbolType.LIBRARY && myNamespace.getName() == "<EXTERNAL>";
            String myLabel = myExternalLocation.getLabel();
            boolean myLabelIsDefault = this.hasDefaultExternalName(myExternalLocation);
            DataType myDataType = this.getResultDataType(myExternalLocation);
            boolean myDataTypeIsDefined = this.hasDefinedDataType(myExternalLocation);
            Address myAddress = myExternalLocation.getAddress();
            String myOriginalName = myExternalLocation.getOriginalImportedName();
            Function myFunction = myExternalLocation.getFunction();
            boolean myExternalIsFunction = myFunction != null;
            Address resultExternalAddress = this.getResultSpaceAddressForLatestLocation(latestExternalLocation);
            Symbol resultSymbol = this.symbolTables[0].getPrimarySymbol(resultExternalAddress);
            ExternalLocation resultExternalLocation = this.externalManagers[0].getExternalLocation(resultSymbol);
            Object originalLocation = null;
            ExternalLocation[] locations = new ExternalLocation[]{resultExternalLocation, latestExternalLocation, myExternalLocation, originalLocation};
            this.updateAddressTranslators(locations);
            if (!myNamespaceIsDefault && !this.equivalentNamespaces(latestNamespace, myNamespace)) {
                this.mergeExternalDetail(1, resultExternalLocation, myExternalLocation, monitor);
            }
            if (!(myLabelIsDefault || SystemUtilities.isEqual((Object)latestLabel, (Object)myLabel) || SystemUtilities.isEqual((Object)latestOriginalName, (Object)myLabel))) {
                this.mergeExternalDetail(2, resultExternalLocation, myExternalLocation, monitor);
            }
            if (myAddress != null && !SystemUtilities.isEqual((Object)latestAddress, (Object)myAddress)) {
                this.mergeExternalDetail(4, resultExternalLocation, myExternalLocation, monitor);
            }
            if (myDataTypeIsDefined && !this.isSameDataType(latestDataType, myDataType)) {
                this.replaceExternalDataType(resultExternalLocation, myExternalLocation, monitor);
            }
            if (myExternalIsFunction && !latestExternalIsFunction) {
                Function resultFunction = resultExternalLocation.createFunction();
                this.getMergeMy().replaceExternalFunction(resultFunction, myFunction, monitor);
            }
        }
    }

    private Address getResultSpaceAddressForLatestLocation(ExternalLocation latestExternalLocation) {
        long latestID = latestExternalLocation.getSymbol().getID();
        long resultID = this.getResultIDfromLatestID(latestID);
        Symbol resultSymbol = this.symbolTables[0].getSymbol(resultID);
        ExternalLocation resultExternalLocation = this.externalManagers[0].getExternalLocation(resultSymbol);
        if (resultExternalLocation != null) {
            return resultExternalLocation.getExternalSpaceAddress();
        }
        Address latestSpaceAddress = latestExternalLocation.getExternalSpaceAddress();
        return SimpleDiffUtility.getCompatibleAddress((Program)this.programs[1], (Address)latestSpaceAddress, (Program)this.programs[0]);
    }

    private ExternalLocation addExternal(ExternalLocation myExternalLocation, TaskMonitor monitor) throws DuplicateNameException, InvalidInputException, CancelledException {
        ExternalLocation resultExternalLocation = this.addExternal(myExternalLocation, this.getMergeMy(), monitor);
        if (resultExternalLocation != null && !resultExternalLocation.getLabel().equals(myExternalLocation.getLabel())) {
            this.renamedConflictIDs.add(resultExternalLocation.getSymbol().getID());
        }
        return resultExternalLocation;
    }

    private ExternalLocation addExternal(ExternalLocation externalLocation, ProgramMerge programMerge, TaskMonitor monitor) throws DuplicateNameException, InvalidInputException, CancelledException, UnsupportedOperationException {
        Namespace resolvedNamespace;
        Address address = externalLocation.getAddress();
        Namespace namespace = resolvedNamespace = this.listingMergeManager.resolveNamespace(programMerge.getOriginProgram(), externalLocation.getParentNameSpace());
        String name = externalLocation.getLabel();
        SourceType sourceType = externalLocation.getSource();
        String originalImportedName = externalLocation.getOriginalImportedName();
        if (originalImportedName != null) {
            namespace = NamespaceUtils.getLibrary((Namespace)namespace);
            name = originalImportedName;
            sourceType = SourceType.IMPORTED;
        }
        ExternalLocation resultExternalLocation = null;
        if (externalLocation.isFunction()) {
            Function function = externalLocation.getFunction();
            if (function == null) {
                throw new AssertException("Uh Oh! Function symbol, but no function.");
            }
            resultExternalLocation = this.externalManagers[0].addExtFunction(namespace, name, address, sourceType, false);
            Function resultFunction = resultExternalLocation.getFunction();
            programMerge.replaceExternalFunction(resultFunction, function, monitor);
        } else {
            resultExternalLocation = this.externalManagers[0].addExtLocation(namespace, name, address, sourceType, false);
            DataType dataType = this.getResultDataType(externalLocation);
            if (dataType != null && resultExternalLocation != null) {
                resultExternalLocation.setDataType(dataType);
            }
        }
        if (originalImportedName != null) {
            try {
                resultExternalLocation.getSymbol().setNameAndNamespace(externalLocation.getLabel(), resolvedNamespace, externalLocation.getSource());
            }
            catch (CircularDependencyException e) {
                throw new AssertException((Throwable)e);
            }
        }
        return resultExternalLocation;
    }

    public void mergeConflicts(int chosenConflictOption, ConflictInfoPanel listingConflictInfoPanel, TaskMonitor monitor) throws CancelledException {
        this.conflictInfoPanel = new ExternalConflictInfoPanel();
        this.listingMergePanel.setTopComponent(this.conflictInfoPanel);
        monitor.setMessage("Resolving Externals conflicts");
        this.totalConflicts = this.removeConflictIDs.size() + this.externalDetailConflicts.size() + (int)this.externalDataTypeConflicts.getNumAddresses() + (int)this.externalFunctionVersusDataTypeConflicts.getNumAddresses() + this.removeFunctionConflictIDs.size() + (int)this.funcSet.getNumAddresses() + this.externalAddConflicts.size();
        monitor.initialize((long)this.totalConflicts);
        this.conflictIndex = 1;
        this.conflictInfoPanel.setConflictInfo(this.conflictIndex, this.totalConflicts);
        this.processExternalRemoveConflicts(chosenConflictOption, monitor);
        this.processExternalDetailConflicts(chosenConflictOption, monitor);
        this.processExternalDataTypeConflicts(chosenConflictOption, monitor);
        this.processExternalFunctionVsDataTypeConflicts(chosenConflictOption, monitor);
        this.processExternalFunctionRemoveConflicts(chosenConflictOption, monitor);
        this.processExternalFunctionDetailConflicts(chosenConflictOption, monitor);
        this.processExternalAddConflicts(chosenConflictOption, monitor);
        this.listingMergePanel.setTopComponent(listingConflictInfoPanel);
        this.mergeManager.showComponent(null, null, null);
        this.infoBuf.append(this.getRenamedConflictsInfo());
        this.showResolveErrors(ERROR_TITLE);
        this.showResolveInfo(INFO_TITLE);
        this.setResolveInformation();
        this.clearResolveInfo();
        this.cleanupConflictPanels();
        monitor.setMessage("Done resolving Externals conflicts.");
    }

    private void processExternalRemoveConflicts(int chosenConflictOption, TaskMonitor monitor) throws CancelledException {
        for (long originalExternalID : this.removeConflictIDs) {
            this.handleRemoveConflict(originalExternalID, chosenConflictOption, monitor);
            monitor.setProgress((long)this.conflictIndex++);
            this.conflictInfoPanel.setConflictInfo(this.conflictIndex, this.totalConflicts);
        }
    }

    private void processExternalDetailConflicts(int chosenConflictOption, TaskMonitor monitor) throws CancelledException {
        Address[] keys;
        for (Address myAddress : keys = (Address[])this.externalDetailConflicts.getKeys((Object[])new Address[this.externalDetailConflicts.size()])) {
            ExternalLocation[] externalLocations = this.getExternalLocationsForMyAddress(myAddress);
            this.handleExternalDetailsConflict(externalLocations, chosenConflictOption, monitor);
            monitor.setProgress((long)this.conflictIndex++);
            this.conflictInfoPanel.setConflictInfo(this.conflictIndex, this.totalConflicts);
        }
    }

    private void processExternalDataTypeConflicts(int chosenConflictOption, TaskMonitor monitor) throws CancelledException {
        AddressIterator dataTypeAddresses = this.externalDataTypeConflicts.getAddresses(true);
        while (dataTypeAddresses.hasNext()) {
            Address myAddress = dataTypeAddresses.next();
            ExternalLocation[] externalLocations = this.getExternalLocationsForMyAddress(myAddress);
            this.handleExternalDataTypeConflict(externalLocations, chosenConflictOption, monitor);
            monitor.setProgress((long)this.conflictIndex++);
            this.conflictInfoPanel.setConflictInfo(this.conflictIndex, this.totalConflicts);
        }
    }

    private void processExternalFunctionVsDataTypeConflicts(int chosenConflictOption, TaskMonitor monitor) throws CancelledException {
        AddressIterator functionVsDataTypeAddresses = this.externalFunctionVersusDataTypeConflicts.getAddresses(true);
        while (functionVsDataTypeAddresses.hasNext()) {
            Address myAddress = functionVsDataTypeAddresses.next();
            ExternalLocation[] externalLocations = this.getExternalLocationsForMyAddress(myAddress);
            this.handleExternalFunctionVersusDataTypeConflict(externalLocations, chosenConflictOption, monitor);
            monitor.setProgress((long)this.conflictIndex++);
            this.conflictInfoPanel.setConflictInfo(this.conflictIndex, this.totalConflicts);
        }
    }

    private void processExternalFunctionRemoveConflicts(int chosenConflictOption, TaskMonitor monitor) throws CancelledException {
        for (Long originalID : this.removeFunctionConflictIDs) {
            ExternalLocation[] externalLocations = this.getExternalLocationsForOriginalID(originalID);
            this.handleExternalRemoveFunctionConflict(externalLocations, chosenConflictOption, monitor);
            monitor.setProgress((long)this.conflictIndex++);
            this.conflictInfoPanel.setConflictInfo(this.conflictIndex, this.totalConflicts);
        }
    }

    private void processExternalFunctionDetailConflicts(int chosenConflictOption, TaskMonitor monitor) throws CancelledException {
        AddressIterator detailFunctionConflictAddresses = this.funcSet.getAddresses(true);
        while (detailFunctionConflictAddresses.hasNext()) {
            Address myEntryPoint = detailFunctionConflictAddresses.next();
            ExternalLocation[] externalLocations = this.getExternalLocationsForMyAddress(myEntryPoint);
            Function[] functions = this.getFunctions(externalLocations);
            this.handleExternalFunctionConflict(functions, myEntryPoint, chosenConflictOption, this.listingMergePanel, monitor);
            monitor.setProgress((long)this.conflictIndex++);
            this.conflictInfoPanel.setConflictInfo(this.conflictIndex, this.totalConflicts);
        }
    }

    private void processExternalAddConflicts(int chosenConflictOption, TaskMonitor monitor) throws CancelledException {
        long[] addConflictIDs;
        for (long myExternalSymbolID : addConflictIDs = this.externalAddConflicts.getKeys()) {
            try {
                long latestExternalSymbolID = this.externalAddConflicts.get(myExternalSymbolID);
                this.handleExternalAddConflict(latestExternalSymbolID, myExternalSymbolID, chosenConflictOption, monitor);
                monitor.setProgress((long)this.conflictIndex++);
                this.conflictInfoPanel.setConflictInfo(this.conflictIndex, this.totalConflicts);
            }
            catch (NoValueException e) {
                Msg.error((Object)this, (Object)("Couldn't get merge conflict for external that was added. " + e.getMessage()));
            }
        }
    }

    private void setResolveInformation() {
        if (this.mergeManager != null) {
            this.mergeManager.setResolveInformation("ResolvedLatestSymbols", this.latestResolvedSymbols);
            this.mergeManager.setResolveInformation("ResolvedMySymbols", this.myResolvedSymbols);
            this.mergeManager.setResolveInformation("ResolvedOriginalSymbols", this.originalResolvedSymbols);
        }
    }

    private void cleanupConflictPanels() {
        if (this.addConflictPanel != null) {
            this.mergeManager.removeComponent(this.addConflictPanel);
        }
    }

    private void handleExternalRemoveFunctionConflict(ExternalLocation[] externalLocations, int chosenConflictOption, TaskMonitor monitor) throws CancelledException {
        this.currentExternalConflictType = ExternalConflictType.EXTERNAL_FUNCTION_REMOVE_CONFLICT;
        this.updateExternalNameInfo(externalLocations, 2);
        boolean askUser = this.externalFunctionRemovalChoice == 0 && chosenConflictOption == 0;
        this.updateAddressTranslators(externalLocations);
        if (askUser && this.mergeManager != null) {
            VerticalChoicesPanel choicesPanel = this.createExternalRemoveFunctionConflictPanel(externalLocations, monitor);
            boolean useForAll = this.removeChoice != 0;
            choicesPanel.setUseForAll(useForAll);
            choicesPanel.setConflictType("External Function Removal");
            this.setupConflictPanel(this.listingMergePanel, choicesPanel, externalLocations, monitor);
            monitor.checkCancelled();
        } else {
            int optionToUse = this.externalFunctionRemovalChoice == 0 ? chosenConflictOption : this.externalFunctionRemovalChoice;
            this.merge(externalLocations, optionToUse, monitor);
        }
    }

    private void handleExternalFunctionConflict(Function[] functions, Address myEntryPoint, int currentConflictOption, ListingMergePanel listingPanel, TaskMonitor monitor) throws CancelledException {
        boolean askUser = currentConflictOption == 0;
        this.updateAddressTranslators(functions);
        ExternalLocation[] externalLocations = this.getExternalLocationsForFunctions(functions);
        this.currentExternalConflictType = ExternalConflictType.FUNCTION_DETAILS_CONFLICT;
        if (this.funcConflicts.contains((Object)myEntryPoint)) {
            ConflictPanel choicesPanel;
            boolean useForAll;
            int conflicts;
            try {
                conflicts = this.funcConflicts.get((Object)myEntryPoint);
            }
            catch (NoValueException e) {
                String message = "Couldn't process function conflict for external '" + functions[2].getName() + "'.";
                this.errorBuf.append(message);
                Msg.error((Object)this, (Object)message, (Throwable)e);
                return;
            }
            if ((conflicts & 0x8000) != 0) {
                this.mergeHigherPrioritySignatureSource(functions, monitor);
            }
            if ((conflicts & 0x1F2) != 0) {
                if (this.detailsChoice != 0) {
                    this.mergeFunctionDetails(functions, this.detailsChoice, monitor);
                } else if (askUser && this.mergeManager != null) {
                    VariousChoicesPanel choicesPanel2 = this.createFunctionConflictPanel(functions, monitor);
                    boolean useForAll2 = this.detailsChoice != 0;
                    choicesPanel2.setUseForAll(useForAll2);
                    choicesPanel2.setConflictType("Function Detail");
                    this.setupConflictPanel(listingPanel, choicesPanel2, externalLocations, monitor);
                    monitor.checkCancelled();
                } else {
                    this.mergeFunctionDetails(functions, currentConflictOption, monitor);
                }
            }
            FunctionVariableStorageConflicts variableStorageConflicts = null;
            List<AbstractFunctionMerger.ParamInfoConflict> paramInfoConflicts = null;
            List<AbstractFunctionMerger.LocalVariableConflict> localVarConflicts = null;
            if ((conflicts & 0x100) != 0) {
                boolean skipParamChecks;
                variableStorageConflicts = this.determineStorageConflict(functions, monitor);
                boolean bl = skipParamChecks = variableStorageConflicts != null && variableStorageConflicts.hasParameterConflict();
                if (skipParamChecks) {
                    this.determineReturnConflict(functions, true, monitor);
                } else if (this.determineSignatureConflicts(functions, monitor)) {
                    paramInfoConflicts = this.determineParameterInfoConflicts(functions, true, monitor);
                    this.determineReturnConflict(functions, true, monitor);
                }
                localVarConflicts = this.determineLocalVariableInfoConflicts(functions, true, variableStorageConflicts, monitor);
                try {
                    conflicts = this.funcConflicts.get((Object)myEntryPoint);
                }
                catch (NoValueException e) {
                    String message = "Couldn't process function conflict for external '" + functions[2].getName() + "'.";
                    this.errorBuf.append(message);
                    Msg.error((Object)this, (Object)message, (Throwable)e);
                    return;
                }
            }
            if ((conflicts & 1) != 0) {
                this.currentExternalConflictType = ExternalConflictType.FUNCTION_RETURN_CONFLICT;
                if (this.functionReturnChoice != 0) {
                    this.mergeFunctionReturn(functions, this.functionReturnChoice, monitor);
                } else if (askUser && this.mergeManager != null) {
                    VerticalChoicesPanel choicesPanel3 = this.createFunctionReturnConflictPanel(functions, monitor);
                    boolean useForAll3 = this.functionReturnChoice != 0;
                    choicesPanel3.setUseForAll(useForAll3);
                    choicesPanel3.setConflictType("Function Return");
                    this.setupConflictPanel(listingPanel, choicesPanel3, externalLocations, monitor);
                    monitor.checkCancelled();
                } else {
                    this.mergeFunctionReturn(functions, currentConflictOption, monitor);
                }
            }
            if ((conflicts & 0x400) != 0) {
                this.currentExternalConflictType = ExternalConflictType.VARIABLE_STORAGE_CONFLICT;
                if (variableStorageConflicts == null) {
                    variableStorageConflicts = this.determineStorageConflict(functions, monitor);
                }
                if (this.variableStorageChoice != 0) {
                    for (Pair pair : variableStorageConflicts.getOverlappingVariables()) {
                        monitor.checkCancelled();
                        this.mergeVariableStorage(functions, (Pair<List<Variable>, List<Variable>>)pair, this.variableStorageChoice, monitor);
                    }
                } else if (askUser && this.mergeManager != null) {
                    for (Pair pair : variableStorageConflicts.getOverlappingVariables()) {
                        monitor.checkCancelled();
                        boolean bl = useForAll = this.variableStorageChoice != 0;
                        if (useForAll) {
                            this.mergeVariableStorage(functions, (Pair<List<Variable>, List<Variable>>)pair, this.variableStorageChoice, monitor);
                            continue;
                        }
                        choicesPanel = this.createStorageConflictPanel(functions, (Pair<List<Variable>, List<Variable>>)pair, monitor);
                        choicesPanel.setUseForAll(useForAll);
                        choicesPanel.setConflictType("Function Variable Storage");
                        this.setupConflictPanel(listingPanel, choicesPanel, externalLocations, monitor);
                    }
                } else {
                    for (Pair pair : variableStorageConflicts.getOverlappingVariables()) {
                        monitor.checkCancelled();
                        this.mergeVariableStorage(functions, (Pair<List<Variable>, List<Variable>>)pair, currentConflictOption, monitor);
                    }
                }
            }
            if ((conflicts & 0x800) != 0) {
                this.currentExternalConflictType = ExternalConflictType.PARAMETER_SIGNATURE_CONFLICT;
                if (this.parameterSignatureChoice != 0) {
                    this.mergeParameters(functions, this.parameterSignatureChoice, monitor);
                } else if (askUser && this.mergeManager != null) {
                    VerticalChoicesPanel choicesPanel4 = this.createParameterSigConflictPanel(functions, monitor);
                    boolean useForAll4 = this.parameterSignatureChoice != 0;
                    choicesPanel4.setUseForAll(useForAll4);
                    choicesPanel4.setConflictType("Function Parameter Signature");
                    this.setupConflictPanel(listingPanel, choicesPanel4, externalLocations, monitor);
                    monitor.checkCancelled();
                } else {
                    this.mergeParameters(functions, currentConflictOption, monitor);
                }
            }
            if ((conflicts & 0x2000) != 0) {
                this.currentExternalConflictType = ExternalConflictType.PARAMETER_INFO_CONFLICT;
                if (paramInfoConflicts == null) {
                    paramInfoConflicts = this.determineParameterInfoConflicts(functions, false, monitor);
                }
                if (this.parameterInfoChoice != 0) {
                    this.mergeParamInfo(functions, paramInfoConflicts, this.parameterInfoChoice, monitor);
                } else if (askUser && this.mergeManager != null) {
                    Iterator<AbstractFunctionMerger.ParamInfoConflict> iter = paramInfoConflicts.iterator();
                    while (iter.hasNext()) {
                        monitor.checkCancelled();
                        AbstractFunctionMerger.ParamInfoConflict pc = iter.next();
                        boolean bl = useForAll = this.parameterInfoChoice != 0;
                        if (useForAll) {
                            this.mergeParamInfo(functions, pc, this.parameterInfoChoice, monitor);
                            continue;
                        }
                        choicesPanel = this.createParamInfoConflictPanel(functions, pc, monitor);
                        choicesPanel.setUseForAll(useForAll);
                        choicesPanel.setConflictType("Function Parameter Info");
                        this.setupConflictPanel(listingPanel, choicesPanel, externalLocations, monitor);
                        monitor.checkCancelled();
                    }
                } else {
                    this.mergeParamInfo(functions, paramInfoConflicts, currentConflictOption, monitor);
                }
            }
            if ((conflicts & 0x1000) != 0) {
                this.currentExternalConflictType = ExternalConflictType.LOCAL_VARIABLE_DETAIL_CONFLICT;
                if (localVarConflicts == null) {
                    localVarConflicts = this.determineLocalVariableInfoConflicts(functions, false, variableStorageConflicts, monitor);
                }
                if (askUser && this.mergeManager != null) {
                    for (AbstractFunctionMerger.LocalVariableConflict localVariableConflict : localVarConflicts) {
                        ConflictPanel choicesPanel5;
                        monitor.checkCancelled();
                        if ((localVariableConflict.varConflicts & 0x200) != 0) {
                            this.currentExternalConflictType = ExternalConflictType.REMOVED_LOCAL_VARIABLE_CONFLICT;
                            if (this.removedLocalVariableChoice != 0) {
                                this.mergeLocalVariable(512, myEntryPoint, localVariableConflict.vars, this.removedLocalVariableChoice, monitor);
                                continue;
                            }
                            choicesPanel5 = this.createRemovedVarConflictPanel(localVariableConflict, monitor);
                            useForAll = this.removedLocalVariableChoice != 0;
                            choicesPanel5.setUseForAll(useForAll);
                            choicesPanel5.setConflictType("Local Variable Removal");
                        } else {
                            this.currentExternalConflictType = ExternalConflictType.LOCAL_VARIABLE_DETAIL_CONFLICT;
                            if (this.localVariableDetailChoice != 0) {
                                this.mergeLocal(myEntryPoint, localVariableConflict, this.localVariableDetailChoice, monitor);
                                continue;
                            }
                            choicesPanel5 = this.createLocalVariableConflictPanel(localVariableConflict, monitor);
                            useForAll = this.localVariableDetailChoice != 0;
                            choicesPanel5.setUseForAll(useForAll);
                            choicesPanel5.setConflictType("Local Variable Detail");
                        }
                        this.setupConflictPanel(listingPanel, choicesPanel5, externalLocations, monitor);
                    }
                } else {
                    this.mergeLocals(myEntryPoint, localVarConflicts, currentConflictOption, monitor);
                }
            }
        }
    }

    private ScrollingListChoicesPanel createStorageConflictPanel(final Function[] functions, final Pair<List<Variable>, List<Variable>> pair, final TaskMonitor monitor) {
        this.getEmptyScrollingListChoicesPanel();
        ChangeListener changeListener = new ChangeListener(){

            @Override
            public void stateChanged(ChangeEvent e) {
                int choice = ExternalFunctionMerger.this.scrollingListConflictPanel.getUseForAllChoice();
                if (choice == 0) {
                    if (ExternalFunctionMerger.this.mergeManager != null) {
                        ExternalFunctionMerger.this.mergeManager.setApplyEnabled(false);
                    }
                    return;
                }
                if (ExternalFunctionMerger.this.mergeManager != null) {
                    ExternalFunctionMerger.this.mergeManager.clearStatusText();
                }
                try {
                    ExternalFunctionMerger.this.mergeVariableStorage(functions, (Pair<List<Variable>, List<Variable>>)pair, choice == 1 ? 2 : 4, monitor);
                    if (ExternalFunctionMerger.this.mergeManager != null) {
                        ExternalFunctionMerger.this.mergeManager.setApplyEnabled(true);
                    }
                }
                catch (Exception e1) {
                    Msg.error((Object)this, (Object)("Unexpected Exception: " + e1.getMessage()), (Throwable)e1);
                }
            }
        };
        this.runSwing(() -> {
            this.scrollingListConflictPanel.setTitle("Parameter/Variable Storage");
            String text = "Latest function '" + functions[1].getName(true) + "' and Checked Out function '" + functions[2].getName(true) + "' have conflicting parameter/variable storage resulting from changes.<br>Choose the desired set of parameters/variables to keep.<br>";
            this.scrollingListConflictPanel.setHeader(text);
            this.scrollingListConflictPanel.setChoiceNames("Latest", "LatestListRB", "Checked Out", "CheckedOutListRB");
            this.scrollingListConflictPanel.setListChoice(changeListener, STORAGE_CONFLICT_CHOICES, STORAGE_CONFLICT_HEADINGS, this.getVariableDetails((List)pair.first), this.getVariableDetails((List)pair.second));
        });
        return this.scrollingListConflictPanel;
    }

    private void mergeVariableStorage(Function[] functions, Pair<List<Variable>, List<Variable>> pair, int currentConflictOption, TaskMonitor monitor) throws CancelledException {
        Address entryPt;
        List list;
        ProgramMerge pgmMerge = this.getProgramListingMerge(currentConflictOption);
        if (currentConflictOption == 2) {
            list = (List)pair.first;
            entryPt = functions[1].getEntryPoint();
        } else {
            list = (List)pair.second;
            entryPt = functions[2].getEntryPoint();
        }
        pgmMerge.replaceVariables(entryPt, list, monitor);
    }

    private ExternalLocation[] getExternalLocationsForFunctions(Function[] functions) {
        ExternalLocation[] externalLocations = new ExternalLocation[4];
        if (functions[0] != null) {
            externalLocations[0] = functions[0].getExternalLocation();
        }
        if (functions[1] != null) {
            externalLocations[1] = functions[1].getExternalLocation();
        }
        if (functions[2] != null) {
            externalLocations[2] = functions[2].getExternalLocation();
        }
        if (functions[3] != null) {
            externalLocations[3] = functions[3].getExternalLocation();
        }
        return externalLocations;
    }

    private void updateAddressTranslators(ExternalLocation[] locations) {
        Address resultExternalAddress = locations[0] != null ? locations[0].getExternalSpaceAddress() : null;
        Address latestExternalAddress = locations[1] != null ? locations[1].getExternalSpaceAddress() : null;
        Address myExternalAddress = locations[2] != null ? locations[2].getExternalSpaceAddress() : null;
        Address originalExternalAddress = locations[3] != null ? locations[3].getExternalSpaceAddress() : null;
        this.myAddressTranslator.setPair(resultExternalAddress, myExternalAddress);
        this.latestAddressTranslator.setPair(resultExternalAddress, latestExternalAddress);
        this.originalAddressTranslator.setPair(resultExternalAddress, originalExternalAddress);
    }

    private void updateAddressTranslators(Function[] functions) {
        Address resultExternalAddress = functions[0] != null ? functions[0].getEntryPoint() : null;
        Address latestExternalAddress = functions[1] != null ? functions[1].getEntryPoint() : null;
        Address myExternalAddress = functions[2] != null ? functions[2].getEntryPoint() : null;
        Address originalExternalAddress = functions[3] != null ? functions[3].getEntryPoint() : null;
        this.myAddressTranslator.setPair(resultExternalAddress, myExternalAddress);
        this.latestAddressTranslator.setPair(resultExternalAddress, latestExternalAddress);
        this.originalAddressTranslator.setPair(resultExternalAddress, originalExternalAddress);
    }

    public void mergeConflictsForAdd(ExternalLocation[] externalLocations, int chosenConflictOption, TaskMonitor monitor) throws CancelledException {
        Address myAddress = externalLocations[2].getExternalSpaceAddress();
        if (this.externalDetailConflicts.contains((Object)myAddress)) {
            monitor.checkCancelled();
            this.handleExternalDetailsConflict(externalLocations, chosenConflictOption, monitor);
        }
        if (this.externalDataTypeConflicts.contains(myAddress)) {
            monitor.checkCancelled();
            this.handleExternalDataTypeConflict(externalLocations, chosenConflictOption, monitor);
        }
        if (this.externalFunctionVersusDataTypeConflicts.contains(myAddress)) {
            monitor.checkCancelled();
            this.handleExternalFunctionVersusDataTypeConflict(externalLocations, chosenConflictOption, monitor);
        }
        if (this.funcSet.contains(myAddress)) {
            monitor.checkCancelled();
            Address myEntryPoint = myAddress;
            Function[] functions = this.getFunctions(externalLocations);
            this.updateExternalNameInfo(externalLocations, 2);
            this.handleExternalFunctionConflict(functions, myEntryPoint, chosenConflictOption, this.listingMergePanel, monitor);
            this.funcSet.deleteRange(myAddress, myAddress);
        }
    }

    private long resolveOriginalIDFromLatestID(long latestID) {
        try {
            return this.latestToOriginalHash.get(latestID);
        }
        catch (NoValueException e) {
            return latestID;
        }
    }

    private long resolveOriginalIDFromMyID(long myID) {
        try {
            return this.myToOriginalHash.get(myID);
        }
        catch (NoValueException e) {
            return myID;
        }
    }

    private long resolveLatestIDFromOriginalID(long originalID) {
        try {
            return this.originalToLatestHash.get(originalID);
        }
        catch (NoValueException e) {
            return originalID;
        }
    }

    private long resolveMyIDFromOriginalID(long originalID) {
        try {
            return this.originalToMyHash.get(originalID);
        }
        catch (NoValueException e) {
            return originalID;
        }
    }

    private ExternalLocation[] getExternalLocationsForMyAddress(Address myAddress) {
        long resultID;
        ExternalLocation[] externalLocations = new ExternalLocation[4];
        Symbol mySymbol = this.symbolTables[2].getPrimarySymbol(myAddress);
        long myID = mySymbol.getID();
        long originalID = this.resolveOriginalIDFromMyID(myID);
        long latestID = this.resolveLatestIDFromOriginalID(originalID);
        Symbol latestSymbol = this.symbolTables[1].getSymbol(latestID);
        Symbol originalSymbol = this.symbolTables[3].getSymbol(originalID);
        if (latestSymbol != null) {
            externalLocations[1] = this.externalManagers[1].getExternalLocation(latestSymbol);
        }
        externalLocations[2] = this.externalManagers[2].getExternalLocation(mySymbol);
        if (originalSymbol != null) {
            externalLocations[3] = this.externalManagers[3].getExternalLocation(originalSymbol);
        }
        try {
            resultID = this.myResolvedSymbols.get(myID);
        }
        catch (NoValueException e) {
            resultID = this.getResultIDfromLatestID(latestID);
        }
        Symbol resultSymbol = this.symbolTables[0].getSymbol(resultID);
        if (resultSymbol != null) {
            externalLocations[0] = this.externalManagers[0].getExternalLocation(resultSymbol);
        }
        return externalLocations;
    }

    private ExternalLocation[] getExternalLocationsForOriginalID(long originalID) {
        long resultID;
        ExternalLocation[] externalLocations = new ExternalLocation[4];
        Symbol originalSymbol = this.symbolTables[3].getSymbol(originalID);
        long latestID = this.resolveLatestIDFromOriginalID(originalID);
        long myID = this.resolveMyIDFromOriginalID(originalID);
        Symbol latestSymbol = this.symbolTables[1].getSymbol(latestID);
        Symbol mySymbol = this.symbolTables[2].getSymbol(myID);
        if (latestSymbol != null) {
            externalLocations[1] = this.externalManagers[1].getExternalLocation(latestSymbol);
        }
        if (mySymbol != null) {
            externalLocations[2] = this.externalManagers[2].getExternalLocation(mySymbol);
        }
        if (originalSymbol != null) {
            externalLocations[3] = this.externalManagers[3].getExternalLocation(originalSymbol);
        }
        try {
            resultID = this.originalResolvedSymbols.get(originalID);
        }
        catch (NoValueException e) {
            resultID = latestID;
        }
        Symbol resultSymbol = this.symbolTables[0].getSymbol(resultID);
        if (resultSymbol != null) {
            externalLocations[0] = this.externalManagers[0].getExternalLocation(resultSymbol);
        }
        return externalLocations;
    }

    private void handleExternalDetailsConflict(ExternalLocation[] externalLocations, int chosenConflictOption, TaskMonitor monitor) throws CancelledException {
        this.currentExternalConflictType = ExternalConflictType.EXTERNAL_DETAILS_CONFLICT;
        this.updateExternalNameInfo(externalLocations, 2);
        boolean askUser = this.externalDetailsChoice == 0 && chosenConflictOption == 0;
        this.updateAddressTranslators(externalLocations);
        Address myExternalAddress = externalLocations[2].getExternalSpaceAddress();
        if (askUser && this.mergeManager != null) {
            VariousChoicesPanel choicesPanel = this.createExternalDetailConflictPanel(externalLocations, myExternalAddress, monitor);
            boolean useForAll = this.externalDetailsChoice != 0;
            choicesPanel.setUseForAll(useForAll);
            choicesPanel.setConflictType("External Details");
            this.setupConflictPanel(this.listingMergePanel, choicesPanel, externalLocations, monitor);
            monitor.checkCancelled();
        } else {
            int optionToUse = this.externalDetailsChoice == 0 ? chosenConflictOption : this.externalDetailsChoice;
            try {
                int conflicts = this.externalDetailConflicts.get((Object)myExternalAddress);
                for (int shift = 0; shift <= 6; ++shift) {
                    int type = 1 << shift;
                    if ((conflicts & type) == 0) continue;
                    this.mergeBasicExternalDetail(type, externalLocations, optionToUse, monitor);
                }
            }
            catch (NoValueException e) {
                Msg.error((Object)this, (Object)("Couldn't merge external details conflict at address " + myExternalAddress + "."));
            }
        }
    }

    private void handleExternalDataTypeConflict(ExternalLocation[] externalLocations, int chosenConflictOption, TaskMonitor monitor) throws CancelledException {
        this.currentExternalConflictType = ExternalConflictType.EXTERNAL_DATA_TYPE_CONFLICT;
        this.updateExternalNameInfo(externalLocations, 2);
        boolean askUser = this.externalDataTypeChoice == 0 && chosenConflictOption == 0;
        this.updateAddressTranslators(externalLocations);
        if (askUser && this.mergeManager != null) {
            VerticalChoicesPanel choicesPanel = this.createExternalDataTypeConflictPanel(externalLocations, monitor);
            boolean useForAll = this.externalDataTypeChoice != 0;
            choicesPanel.setUseForAll(useForAll);
            choicesPanel.setConflictType("External Data Type");
            this.setupConflictPanel(this.listingMergePanel, choicesPanel, externalLocations, monitor);
            monitor.checkCancelled();
        } else {
            int optionToUse = this.externalDataTypeChoice == 0 ? chosenConflictOption : this.externalDataTypeChoice;
            this.mergeExternalDataType(externalLocations, optionToUse, monitor);
        }
    }

    private void handleExternalFunctionVersusDataTypeConflict(ExternalLocation[] externalLocations, int chosenConflictOption, TaskMonitor monitor) throws CancelledException {
        this.currentExternalConflictType = ExternalConflictType.EXTERNAL_FUNCTION_VS_DATA_TYPE_CONFLICT;
        this.updateExternalNameInfo(externalLocations, 2);
        boolean askUser = this.externalFunctionVsDataTypeChoice == 0 && chosenConflictOption == 0;
        this.updateAddressTranslators(externalLocations);
        if (askUser && this.mergeManager != null) {
            VerticalChoicesPanel choicesPanel = this.createExternalFunctionVsDataTypeConflictPanel(externalLocations, monitor);
            boolean useForAll = this.externalFunctionVsDataTypeChoice != 0;
            choicesPanel.setUseForAll(useForAll);
            choicesPanel.setConflictType("External Function Versus Data Type");
            this.setupConflictPanel(this.listingMergePanel, choicesPanel, externalLocations, monitor);
            monitor.checkCancelled();
        } else {
            int optionToUse = this.externalFunctionVsDataTypeChoice == 0 ? chosenConflictOption : this.externalFunctionVsDataTypeChoice;
            this.merge(externalLocations, optionToUse, monitor);
        }
    }

    private void handleExternalAddConflict(long latestExternalID, long myExternalID, int chosenConflictOption, TaskMonitor monitor) throws CancelledException {
        this.currentExternalConflictType = ExternalConflictType.EXTERNAL_ADD_CONFLICT;
        long resultExternalID = this.getResultIDfromLatestID(latestExternalID);
        Symbol latestSymbol = this.symbolTables[1].getSymbol(latestExternalID);
        Symbol mySymbol = this.symbolTables[2].getSymbol(myExternalID);
        Symbol resultSymbol = this.symbolTables[0].getSymbol(resultExternalID);
        ExternalLocation[] externalLocations = new ExternalLocation[4];
        externalLocations[1] = this.externalManagers[1].getExternalLocation(latestSymbol);
        externalLocations[2] = this.externalManagers[2].getExternalLocation(mySymbol);
        externalLocations[3] = null;
        externalLocations[0] = this.externalManagers[0].getExternalLocation(resultSymbol);
        this.updateExternalNameInfo(externalLocations, 2);
        boolean askUser = this.externalAddChoice == 0 && chosenConflictOption == 0;
        this.updateAddressTranslators(externalLocations);
        if (askUser && this.mergeManager != null) {
            if (this.addConflictPanel == null) {
                this.addConflictPanel = new ExternalAddConflictPanel(this.mergeManager, this.totalConflicts, this.programs[1], this.programs[2], this.showListingPanel);
            }
            VerticalChoicesPanel choicesPanel = this.createAddConflictPanel(externalLocations, monitor);
            boolean useForAll = this.externalAddChoice != 0;
            choicesPanel.setUseForAll(useForAll);
            choicesPanel.setConflictType("External Add");
            this.setupAddConflictPanel(this.addConflictPanel, choicesPanel, externalLocations[1], externalLocations[2], monitor);
            monitor.checkCancelled();
        } else {
            int optionToUse = this.externalAddChoice == 0 ? chosenConflictOption : this.externalAddChoice;
            this.resolveAddConflict(externalLocations, optionToUse, monitor);
        }
        this.mergeConflictsForAdd(externalLocations, chosenConflictOption, monitor);
    }

    private Function[] getFunctions(ExternalLocation[] externalLocations) {
        Function[] functions = new Function[]{externalLocations[0] != null ? externalLocations[0].getFunction() : null, externalLocations[1] != null ? externalLocations[1].getFunction() : null, externalLocations[2] != null ? externalLocations[2].getFunction() : null, externalLocations[3] != null ? externalLocations[3].getFunction() : null};
        return functions;
    }

    private void handleRemoveConflict(long originalExternalID, int currentConflictOption, TaskMonitor monitor) throws CancelledException {
        this.currentExternalConflictType = ExternalConflictType.EXTERNAL_REMOVE_CONFLICT;
        ExternalLocation[] externalLocations = this.getExternalLocationsForOriginalID(originalExternalID);
        if (externalLocations[3] == null) {
            throw new AssertException("Couldn't get original external location for ID, " + originalExternalID + ".");
        }
        this.updateExternalNameInfo(externalLocations, 3);
        boolean askUser = this.externalRemoveChoice == 0 && currentConflictOption == 0;
        this.updateAddressTranslators(externalLocations);
        if (askUser && this.mergeManager != null) {
            VerticalChoicesPanel choicesPanel = this.createRemoveConflictPanel(externalLocations, monitor);
            boolean useForAll = this.externalRemoveChoice != 0;
            choicesPanel.setUseForAll(useForAll);
            choicesPanel.setConflictType("External Removal");
            this.setupConflictPanel(this.listingMergePanel, choicesPanel, externalLocations, monitor);
            monitor.checkCancelled();
        } else {
            int optionToUse = this.externalRemoveChoice == 0 ? currentConflictOption : this.externalRemoveChoice;
            this.merge(externalLocations, optionToUse, monitor);
        }
    }

    private void updateExternalNameInfo(ExternalLocation[] externalLocations, int programVersion) {
        this.conflictInfoPanel.setExternalName(this.getVersionName(programVersion), externalLocations[programVersion].getSymbol().getName(true));
    }

    private VerticalChoicesPanel createAddConflictPanel(ExternalLocation[] externalLocations, TaskMonitor monitor) {
        String[] header = this.getExternalInfo(externalLocations, -1);
        String[] latest = this.getExternalInfo(externalLocations, 1);
        String[] my = this.getExternalInfo(externalLocations, 2);
        String[] keepBoth = new String[]{"Keep Both", "", "", "", "", "", ""};
        String[] mergeBoth = new String[]{"Merge Together", "", "", "", "", "", ""};
        VerticalChoicesPanel panel = this.getEmptyVerticalPanel();
        this.runSwing(() -> {
            panel.setTitle("External Add");
            StringBuffer buf = new StringBuffer();
            buf.append("Latest external '");
            String latestName = this.getExternalName(externalLocations, 1, true);
            buf.append(ConflictUtility.getEmphasizeString(latestName));
            buf.append("' and Checked Out external '");
            String myName = this.getExternalName(externalLocations, 2, true);
            buf.append(ConflictUtility.getEmphasizeString(myName));
            buf.append("' were added,<br>but are possibly intended to be the same external.");
            buf.append(HTMLUtilities.spaces((int)2));
            buf.append("Choose which one(s) you want to keep.<br>");
            buf.append(HTMLUtilities.spaces((int)2));
            panel.setHeader(buf.toString());
            ExternalAddConflictChangeListener changeListener = new ExternalAddConflictChangeListener(externalLocations, panel, monitor);
            panel.setRowHeader(header);
            panel.addRadioButtonRow(latest, "LatestVersionRB", 1, changeListener);
            panel.addRadioButtonRow(my, "CheckedOutVersionRB", 2, changeListener);
            panel.addRadioButtonRow(keepBoth, KEEP_BOTH_BUTTON_NAME, 4, changeListener);
            panel.addRadioButtonRow(mergeBoth, MERGE_BOTH_BUTTON_NAME, 8, changeListener);
        });
        return panel;
    }

    private VerticalChoicesPanel createRemoveConflictPanel(ExternalLocation[] externalLocations, TaskMonitor monitor) {
        String[] header = this.getExternalInfo(externalLocations, -1);
        String[] latest = this.getExternalInfo(externalLocations, 1);
        String[] my = this.getExternalInfo(externalLocations, 2);
        String[] original = this.getExternalInfo(externalLocations, 3);
        VerticalChoicesPanel panel = this.getEmptyVerticalPanel();
        this.runSwing(() -> {
            panel.setTitle("External Remove");
            StringBuffer buf = new StringBuffer();
            buf.append("One external was removed and the other changed for ");
            buf.append(this.getExternalName(externalLocations, 3, true));
            buf.append(".");
            panel.setHeader(buf.toString());
            ExternalRemoveConflictChangeListener changeListener = new ExternalRemoveConflictChangeListener(externalLocations, panel, monitor);
            panel.setRowHeader(header);
            panel.addRadioButtonRow(latest, "LatestVersionRB", 2, changeListener);
            panel.addRadioButtonRow(my, "CheckedOutVersionRB", 4, changeListener);
            panel.addRadioButtonRow(original, "OriginalVersionRB", 1, changeListener);
        });
        return panel;
    }

    private VariousChoicesPanel createExternalDetailConflictPanel(ExternalLocation[] locations, Address myEntryPoint, TaskMonitor monitor) {
        int conflicts = 0;
        try {
            conflicts = this.externalDetailConflicts.get((Object)myEntryPoint);
        }
        catch (NoValueException e) {
            throw new AssertException();
        }
        return this.createExternalDetailConflictPanel(locations, conflicts, monitor);
    }

    private VariousChoicesPanel createExternalDetailConflictPanel(ExternalLocation[] locations, int conflicts, TaskMonitor monitor) {
        VariousChoicesPanel panel = this.getEmptyVariousPanel();
        Address resultExternalAddress = locations[0] != null ? locations[0].getExternalSpaceAddress() : null;
        Address latestExternalAddress = locations[1] != null ? locations[1].getExternalSpaceAddress() : null;
        Address myExternalAddress = locations[2] != null ? locations[2].getExternalSpaceAddress() : null;
        Address originalExternalAddress = locations[3] != null ? locations[3].getExternalSpaceAddress() : null;
        this.myAddressTranslator.setPair(resultExternalAddress, myExternalAddress);
        this.latestAddressTranslator.setPair(resultExternalAddress, latestExternalAddress);
        this.originalAddressTranslator.setPair(resultExternalAddress, originalExternalAddress);
        this.runSwing(() -> {
            String my;
            String latest;
            String addressString;
            String label;
            String typeString;
            panel.setTitle("External Detail");
            if (locations[3] != null) {
                typeString = "Original";
                label = locations[3].getSymbol().getName(true);
                address = locations[3].getAddress();
                addressString = address != null ? " associated with external memory address '" + ConflictUtility.getAddressString(address, true) + "'" : "";
            } else {
                typeString = "Result";
                label = locations[0].getLabel();
                address = locations[0].getAddress();
                addressString = address != null ? " associated with external memory address '" + ConflictUtility.getAddressString(address, true) + "'" : "";
            }
            String text = "Detail conflicts need to be resolved for the " + typeString + " external '" + ConflictUtility.getEmphasizeString(label) + "'" + addressString + ".<br>Make a choice for each conflict type.";
            panel.setHeader(text);
            panel.addInfoRow("Conflict", new String[]{"Latest", "Checked Out"}, true);
            if ((conflicts & 1) != 0) {
                Namespace latestNamespace = locations[1].getParentNameSpace();
                Namespace myNamespace = locations[2].getParentNameSpace();
                latest = latestNamespace.getName(true);
                my = myNamespace.getName(true);
                panel.addSingleChoice("Namespace", new String[]{latest, my}, new ExternalDetailChangeListener(1, locations, panel, monitor));
            }
            if ((conflicts & 2) != 0) {
                String latest2 = locations[1].getLabel();
                String my2 = locations[2].getLabel();
                panel.addSingleChoice("Name", new String[]{latest2, my2}, new ExternalDetailChangeListener(2, locations, panel, monitor));
            }
            if ((conflicts & 4) != 0) {
                Address latestAddress = locations[1].getAddress();
                Address myAddress = locations[2].getAddress();
                latest = latestAddress != null ? latestAddress.toString() : null;
                my = myAddress != null ? myAddress.toString() : null;
                panel.addSingleChoice("Address", new String[]{latest, my}, new ExternalDetailChangeListener(4, locations, panel, monitor));
            }
            if ((conflicts & 0x20) != 0) {
                DataType latestResultDt = this.getResultDataType(locations[1]);
                DataType myResultDt = this.getResultDataType(locations[2]);
                latest = latestResultDt != null ? latestResultDt.getName() : "";
                my = myResultDt != null ? myResultDt.getName() : "";
                panel.addSingleChoice("Data Type", new String[]{latest, my}, new ExternalDetailChangeListener(32, locations, panel, monitor));
            }
        });
        return panel;
    }

    private VerticalChoicesPanel createExternalDataTypeConflictPanel(ExternalLocation[] externalLocations, TaskMonitor monitor) {
        String changeString;
        String removeString;
        DataType latestDataType = this.getResultDataType(externalLocations[1]);
        DataType myDataType = this.getResultDataType(externalLocations[2]);
        if (latestDataType == null) {
            removeString = "Latest";
            changeString = "Checked Out";
        } else if (myDataType == null) {
            removeString = "Checked Out";
            changeString = "Latest";
        } else {
            removeString = null;
            changeString = null;
        }
        String[] header = this.getExternalInfo(externalLocations, -1);
        String[] latest = this.getExternalInfo(externalLocations, 1);
        String[] my = this.getExternalInfo(externalLocations, 2);
        String[] original = this.getExternalInfo(externalLocations, 3);
        VerticalChoicesPanel panel = this.getEmptyVerticalPanel();
        this.runSwing(() -> {
            panel.setTitle("External Data Type");
            StringBuffer buf = new StringBuffer();
            if (removeString != null) {
                buf.append("External data type was removed in " + removeString + " and changed in " + changeString + " /nfor ");
                buf.append(this.getExternalName(externalLocations, 3, true));
                buf.append(".");
            } else {
                buf.append("Latest and Checked Out both changed data type \nfor ");
                buf.append(this.getExternalName(externalLocations, 3, true));
                buf.append(".");
            }
            panel.setHeader(buf.toString());
            ExternalDataTypeConflictChangeListener changeListener = new ExternalDataTypeConflictChangeListener(externalLocations, panel, monitor);
            panel.setRowHeader(header);
            panel.addRadioButtonRow(latest, "LatestVersionRB", 2, changeListener);
            panel.addRadioButtonRow(my, "CheckedOutVersionRB", 4, changeListener);
            original[0] = "Original version";
            panel.addInfoRow(original);
        });
        return panel;
    }

    private VerticalChoicesPanel createExternalRemoveFunctionConflictPanel(ExternalLocation[] externalLocations, TaskMonitor monitor) {
        Function latestFunction = externalLocations[1] != null ? externalLocations[1].getFunction() : null;
        Function myFunction = externalLocations[2] != null ? externalLocations[2].getFunction() : null;
        String[] header = this.getExternalInfo(externalLocations, -1);
        String[] latest = this.getExternalInfo(externalLocations, 1);
        String[] my = this.getExternalInfo(externalLocations, 2);
        String[] original = this.getExternalInfo(externalLocations, 3);
        String latestRemovedOrChanged = latestFunction == null ? "removed" : "changed";
        String myRemovedOrChanged = myFunction == null ? "removed" : "changed";
        String originalName = externalLocations[3].getSymbol().getName(true);
        String headerString = "The external function '" + originalName + "' was " + latestRemovedOrChanged + " in Latest, but was " + myRemovedOrChanged + " in Checked Out.";
        VerticalChoicesPanel panel = this.getEmptyVerticalPanel();
        this.runSwing(() -> {
            panel.setTitle("External Function Remove");
            panel.setHeader(headerString);
            ExternalRemoveFunctionConflictChangeListener changeListener = new ExternalRemoveFunctionConflictChangeListener(externalLocations, panel, monitor);
            panel.setRowHeader(header);
            panel.addRadioButtonRow(latest, "LatestVersionRB", 2, changeListener);
            panel.addRadioButtonRow(my, "CheckedOutVersionRB", 4, changeListener);
            original[0] = "Original version";
            panel.addInfoRow(original);
        });
        return panel;
    }

    private VerticalChoicesPanel createExternalFunctionVsDataTypeConflictPanel(ExternalLocation[] externalLocations, TaskMonitor monitor) {
        String headerString;
        String functionIsLatestOrMy;
        DataType latestDataType = this.getResultDataType(externalLocations[1]);
        Function latestFunction = externalLocations[1].getFunction();
        Function originalFunction = externalLocations[3] != null ? externalLocations[3].getFunction() : null;
        String[] header = this.getExternalInfo(externalLocations, -1);
        String[] latest = this.getExternalInfo(externalLocations, 1);
        String[] my = this.getExternalInfo(externalLocations, 2);
        String[] original = this.getExternalInfo(externalLocations, 3);
        String latestName = externalLocations[1].getSymbol().getName(true);
        String dataTypeIsLatestOrMy = latestDataType == null ? "Checked Out" : "Latest";
        String string = functionIsLatestOrMy = latestFunction == null ? "Checked Out" : "Latest";
        if (externalLocations[3] != null) {
            String originalName = externalLocations[3].getSymbol().getName(true);
            headerString = originalFunction == null ? "The external label, " + originalName + ", had its data type changed in " + dataTypeIsLatestOrMy + ", but was switched to a function in " + functionIsLatestOrMy + "." : "The external function, " + originalName + ", was changed in " + functionIsLatestOrMy + ", but was switched to a label with a data type in " + dataTypeIsLatestOrMy + ".";
        } else {
            headerString = latestFunction == null ? "The external label, " + latestName + ", was added with a data type in " + dataTypeIsLatestOrMy + ", but was added as a function in " + functionIsLatestOrMy + "." : "The external function, " + latestName + ", was added as a function in " + functionIsLatestOrMy + ", but was added as a label with a data type in " + dataTypeIsLatestOrMy + ".";
        }
        VerticalChoicesPanel panel = this.getEmptyVerticalPanel();
        this.runSwing(() -> {
            panel.setTitle("External Function Versus Data Type");
            panel.setHeader(headerString);
            ExternalFunctionVsDataTypeConflictChangeListener changeListener = new ExternalFunctionVsDataTypeConflictChangeListener(externalLocations, panel, monitor);
            panel.setRowHeader(header);
            panel.addRadioButtonRow(latest, "LatestVersionRB", 2, changeListener);
            panel.addRadioButtonRow(my, "CheckedOutVersionRB", 4, changeListener);
            original[0] = "Original version";
            panel.addInfoRow(original);
        });
        return panel;
    }

    protected VariousChoicesPanel createParamInfoConflictPanel(Function[] functions, AbstractFunctionMerger.ParamInfoConflict pc, TaskMonitor monitor) {
        int ordinal = pc.ordinal;
        int conflicts = pc.paramConflicts;
        Parameter latestParam = functions[1] != null ? functions[1].getParameter(ordinal) : null;
        Parameter myParam = functions[2] != null ? functions[2].getParameter(ordinal) : null;
        VariousChoicesPanel panel = this.getEmptyVariousPanel();
        this.runSwing(() -> {
            String my;
            String latest;
            panel.setTitle("Function Parameter");
            Parameter param = latestParam != null ? latestParam : myParam;
            String varInfo = "Stack Parameter" + ConflictUtility.spaces(4) + "Storage: " + ConflictUtility.getEmphasizeString(param.getVariableStorage().toString());
            String text = "The following parameter has conflicts between Latest and Checked Out. For each conflict choose the detail you want to keep.<br><br>Result External Function: " + ConflictUtility.getEmphasizeString(functions[0].getName(true)) + ConflictUtility.spaces(4) + ConflictUtility.spaces(4) + "Parameter #" + ConflictUtility.getNumberString(param.getOrdinal() + 1) + ConflictUtility.spaces(4) + varInfo;
            panel.setHeader(text);
            panel.addInfoRow("Conflict", new String[]{"Latest", "Checked Out"}, true);
            if ((conflicts & 2) != 0) {
                latest = latestParam != null ? latestParam.getName() : "";
                my = myParam != null ? myParam.getName() : "";
                panel.addSingleChoice("Parameter Name", new String[]{latest, my}, new ExternalParameterChangeListener(2, functions, ordinal, panel, monitor));
            }
            if ((conflicts & 4) != 0) {
                DataType latestDataType = this.getResultDataType(latestParam.getDataType());
                DataType myDataType = this.getResultDataType(myParam.getDataType());
                String latest2 = latestDataType != null ? latestDataType.getName() : "";
                String my2 = myDataType != null ? myDataType.getName() : "";
                panel.addSingleChoice("Parameter Data Type", new String[]{latest2, my2}, new ExternalParameterChangeListener(4, functions, ordinal, panel, monitor));
            }
            if ((conflicts & 0x10) != 0) {
                latest = latestParam != null ? latestParam.getComment() : "";
                my = myParam != null ? myParam.getComment() : "";
                panel.addSingleChoice("Parameter Comment", new String[]{latest, my}, new ExternalParameterChangeListener(16, functions, ordinal, panel, monitor));
            }
        });
        return panel;
    }

    private String getExternalName(ExternalLocation[] externalLocations, int programVersion, boolean includeNamespace) {
        Symbol symbol = null;
        switch (programVersion) {
            case 1: {
                Address latestAddress;
                Address address = latestAddress = externalLocations[1] != null ? externalLocations[1].getExternalSpaceAddress() : null;
                if (latestAddress == null) break;
                symbol = this.symbolTables[1].getPrimarySymbol(latestAddress);
                break;
            }
            case 2: {
                Address myAddress;
                Address address = myAddress = externalLocations[2] != null ? externalLocations[2].getExternalSpaceAddress() : null;
                if (myAddress == null) break;
                symbol = this.symbolTables[2].getPrimarySymbol(myAddress);
                break;
            }
            case 3: {
                Address originalAddress;
                Address address = originalAddress = externalLocations[3] != null ? externalLocations[3].getExternalSpaceAddress() : null;
                if (originalAddress == null) break;
                symbol = this.symbolTables[3].getPrimarySymbol(originalAddress);
            }
        }
        if (symbol != null) {
            return symbol.getName(includeNamespace);
        }
        return "Unknown";
    }

    private void resolveAddConflict(ExternalLocation[] externalLocations, int choice, TaskMonitor monitor) throws CancelledException {
        switch (choice) {
            case 1: {
                this.adjustIDMapsForReplace(externalLocations, 1);
                break;
            }
            case 2: {
                this.merge(externalLocations, 4, monitor);
                this.adjustIDMapsForReplace(externalLocations, 2);
                break;
            }
            case 4: {
                ExternalLocation resultExternalLocation = this.addMyExternal(externalLocations[2], monitor);
                this.adjustIDMapsForAdd(externalLocations, resultExternalLocation, 2);
                break;
            }
            case 8: {
                this.mergeLatestAndMyForAddConflict(externalLocations, monitor);
                this.adjustIDMapsForReplace(externalLocations, 0);
                break;
            }
            default: {
                String message = "Resolving External ADD conflict. " + choice + " is not a valid choice.";
                throw new AssertException(message);
            }
        }
    }

    private Namespace resolveNamespace(Program sourceProgram, Namespace sourceNamespace) throws DuplicateNameException, InvalidInputException {
        return this.listingMergeManager.resolveNamespace(sourceProgram, sourceNamespace);
    }

    public ExternalLocation replaceExternalLocation(ExternalLocation toExternalLocation, ExternalLocation fromExternalLocation, ProgramMerge programMerge, TaskMonitor monitor) throws DuplicateNameException, InvalidInputException, CancelledException {
        this.replaceNamespace(toExternalLocation, fromExternalLocation, monitor);
        this.replaceLocation(toExternalLocation, fromExternalLocation, monitor);
        this.replaceExternalDataType(toExternalLocation, fromExternalLocation, monitor);
        return this.replaceFunction(toExternalLocation, fromExternalLocation, programMerge, monitor);
    }

    private void replaceNamespace(ExternalLocation toExternalLocation, ExternalLocation fromExternalLocation, TaskMonitor monitor) {
        Symbol toSymbol = toExternalLocation.getSymbol();
        Symbol fromSymbol = fromExternalLocation.getSymbol();
        Program fromProgram = fromSymbol.getProgram();
        Namespace currentResultNamespace = toSymbol.getParentNamespace();
        Namespace fromNamespace = fromExternalLocation.getParentNameSpace();
        Throwable exc = null;
        try {
            Namespace desiredResultNamespace = this.resolveNamespace(fromProgram, fromNamespace);
            if (currentResultNamespace == desiredResultNamespace) {
                return;
            }
            toSymbol.setNamespace(desiredResultNamespace);
        }
        catch (CircularDependencyException | DuplicateNameException | InvalidInputException e) {
            exc = e;
        }
        if (exc != null) {
            Msg.error((Object)this, (Object)("Couldn't replace namespace '" + currentResultNamespace.getName(true) + "' with '" + fromNamespace.getName(true) + "'." + exc.getMessage()));
        }
    }

    private void replaceLocation(ExternalLocation toExternalLocation, ExternalLocation fromExternalLocation, TaskMonitor monitor) throws DuplicateNameException, InvalidInputException {
        String toLabel;
        Address toAddress;
        Address fromAddress = fromExternalLocation.getAddress();
        boolean addressChanged = !SystemUtilities.isEqual((Object)fromAddress, (Object)(toAddress = toExternalLocation.getAddress()));
        String fromLabel = fromExternalLocation.getSource() == SourceType.DEFAULT ? null : fromExternalLocation.getLabel();
        String string = toLabel = toExternalLocation.getSource() == SourceType.DEFAULT ? null : toExternalLocation.getLabel();
        if (!SystemUtilities.isEqual((Object)fromLabel, (Object)toLabel)) {
            if (fromLabel == null && addressChanged) {
                toExternalLocation.setAddress(fromAddress);
                addressChanged = false;
            }
            SourceType fromSourceType = fromExternalLocation.getSource();
            toExternalLocation.getSymbol().setName(fromLabel, fromSourceType);
        }
        if (addressChanged) {
            toExternalLocation.setAddress(fromAddress);
        }
    }

    private ExternalLocation replaceFunction(ExternalLocation toExternalLocation, ExternalLocation fromExternalLocation, ProgramMerge programMerge, TaskMonitor monitor) throws CancelledException, UnsupportedOperationException {
        Function fromFunction = fromExternalLocation.getFunction();
        Function toFunction = toExternalLocation.getFunction();
        if (fromFunction == null) {
            if (toFunction == null) {
                return toExternalLocation;
            }
            DataType dataType = this.getResultDataType(toExternalLocation);
            Namespace namespace = toExternalLocation.getParentNameSpace();
            String label = toExternalLocation.getLabel();
            Symbol toSymbol = toExternalLocation.getSymbol();
            Address addr = toSymbol.getAddress();
            ExternalManager externalManager = programMerge.getResultProgram().getExternalManager();
            toSymbol.delete();
            SymbolTable symbolTable = programMerge.getResultProgram().getSymbolTable();
            Symbol symbol = symbolTable.getSymbol(label, addr, namespace);
            ExternalLocation newLocation = externalManager.getExternalLocation(symbol);
            if (newLocation != null && dataType != null && dataType != DataType.DEFAULT) {
                newLocation.setDataType(dataType);
            }
            return newLocation;
        }
        if (toFunction == null) {
            toFunction = toExternalLocation.createFunction();
        }
        if (ProgramDiff.equivalentFunctions(fromFunction, toFunction)) {
            return toExternalLocation;
        }
        programMerge.replaceExternalFunction(toFunction, fromFunction, monitor);
        return toFunction.getExternalLocation();
    }

    private ExternalLocation addMyExternal(ExternalLocation myExternalLocation, TaskMonitor monitor) throws CancelledException {
        ExternalLocation resultExternalLocation = null;
        try {
            resultExternalLocation = this.addExternal(myExternalLocation, monitor);
        }
        catch (DuplicateNameException e) {
            Msg.showError((Object)this, (Component)this.mergeManager.getMergeTool().getToolFrame(), (String)"Error Merging External Location", (Object)("Couldn't merge external '" + myExternalLocation.getLabel() + "'. " + e.getMessage()));
        }
        catch (InvalidInputException e) {
            Msg.showError((Object)this, (Component)this.mergeManager.getMergeTool().getToolFrame(), (String)"Error Merging External Location", (Object)("Couldn't merge external '" + myExternalLocation.getLabel() + "'. " + e.getMessage()));
        }
        return resultExternalLocation;
    }

    private void mergeLatestAndMyForAddConflict(ExternalLocation[] externalLocations, TaskMonitor monitor) throws CancelledException {
        boolean differentFunctions;
        int latestMyChanges = this.getBasicExternalDiffs(externalLocations[1], externalLocations[2]);
        int detailConflictFlags = latestMyChanges & 7;
        if ((detailConflictFlags & 4) != 0) {
            Address latestAddress = externalLocations[1].getAddress();
            Address myAddress = externalLocations[2].getAddress();
            if (latestAddress != null && myAddress == null) {
                detailConflictFlags &= 0xFFFFFFFB;
            } else if (latestAddress == null && myAddress != null) {
                this.mergeExternalDetail(4, externalLocations[0], externalLocations[2], monitor);
                detailConflictFlags &= 0xFFFFFFFB;
            }
        }
        if (detailConflictFlags != 0) {
            this.saveExternalDetailConflict(externalLocations, detailConflictFlags);
        }
        Address myExternalAddress = externalLocations[2].getExternalSpaceAddress();
        DataType latestDataType = this.getResultDataType(externalLocations[1]);
        DataType myDataType = this.getResultDataType(externalLocations[2]);
        boolean latestHasDataType = latestDataType != null && latestDataType != DataType.DEFAULT;
        boolean myHasDataType = myDataType != null && myDataType != DataType.DEFAULT;
        boolean differentDataTypes = latestHasDataType && myHasDataType && (latestMyChanges & 0x20) != 0;
        boolean latestIsFunction = externalLocations[1].isFunction();
        boolean myIsFunction = externalLocations[2].isFunction();
        boolean bl = differentFunctions = latestIsFunction && myIsFunction && (latestMyChanges & 0x40) != 0;
        if (differentDataTypes) {
            this.saveExternalDataTypeConflict(myExternalAddress);
        }
        if (differentFunctions) {
            this.determineDetailedFunctionConflicts(externalLocations, monitor);
        }
        if (latestIsFunction && !latestHasDataType && !myIsFunction && myHasDataType || myIsFunction && !myHasDataType && !latestIsFunction && latestHasDataType) {
            this.saveExternalFunctionVersusDataTypeConflict(myExternalAddress);
        } else {
            if (myHasDataType && !latestHasDataType) {
                this.replaceExternalDataType(externalLocations[0], externalLocations[2], monitor);
            }
            if (myIsFunction && !latestIsFunction) {
                this.replaceFunction(externalLocations[0], externalLocations[2], this.getMergeMy(), monitor);
            }
        }
    }

    protected void mergeBasicExternalDetail(int type, ExternalLocation[] externalLocations, int currentChosenOption, TaskMonitor monitor) throws CancelledException {
        ExternalLocation externalLocation = null;
        switch (currentChosenOption) {
            case 2: {
                externalLocation = externalLocations[1];
                break;
            }
            case 4: {
                externalLocation = externalLocations[2];
                break;
            }
            default: {
                throw new AssertException("Can only merge external detail from Latest or My.");
            }
        }
        this.mergeExternalDetail(type, externalLocations[0], externalLocation, monitor);
    }

    public void mergeFunction(ExternalLocation[] externalLocations, int currentChosenOption, TaskMonitor monitor) throws CancelledException, UnsupportedOperationException {
        switch (currentChosenOption) {
            case 2: {
                this.replaceFunction(externalLocations[0], externalLocations[1], this.getMergeLatest(), monitor);
                break;
            }
            case 4: {
                this.replaceFunction(externalLocations[0], externalLocations[2], this.getMergeMy(), monitor);
                break;
            }
            case 1: {
                this.replaceFunction(externalLocations[0], externalLocations[3], this.getMergeOriginal(), monitor);
            }
            default: {
                throw new AssertException("Can only merge external detail from Latest or My.");
            }
        }
    }

    private void merge(ExternalLocation[] externalLocations, int chosenConflictOption, TaskMonitor monitor) throws CancelledException {
        try {
            switch (chosenConflictOption) {
                case 2: {
                    this.mergeLatest(externalLocations, monitor);
                    break;
                }
                case 4: {
                    this.mergeMy(externalLocations, monitor);
                    break;
                }
                case 1: {
                    this.mergeOriginal(externalLocations, monitor);
                }
            }
        }
        catch (DuplicateNameException e) {
            Msg.showError((Object)this, (Component)this.mergeManager.getMergeTool().getToolFrame(), (String)"Error Merging External Location", (Object)e.getMessage());
        }
        catch (InvalidInputException e) {
            Msg.showError((Object)this, (Component)this.mergeManager.getMergeTool().getToolFrame(), (String)"Error Merging External Location", (Object)e.getMessage());
        }
    }

    private void mergeLatest(ExternalLocation[] externalLocations, TaskMonitor monitor) throws DuplicateNameException, InvalidInputException, CancelledException {
        if (externalLocations[1] == null) {
            this.removeExternal(this.programs[3], externalLocations[3]);
            externalLocations[0] = null;
            this.adjustIDMapsForRemove(externalLocations, 1);
        } else if (externalLocations[0] == null) {
            ExternalLocation resultExternalLocation;
            externalLocations[0] = resultExternalLocation = this.addExternal(externalLocations[1], this.mergeLatest, monitor);
            this.adjustIDMapsForAdd(externalLocations, resultExternalLocation, 1);
        } else {
            ExternalLocation resultExternalLocation;
            this.latestAddressTranslator.setPair(externalLocations[0].getExternalSpaceAddress(), externalLocations[1].getExternalSpaceAddress());
            externalLocations[0] = resultExternalLocation = this.replaceExternalLocation(externalLocations[0], externalLocations[1], this.getMergeLatest(), monitor);
            this.adjustIDMapsForReplace(externalLocations, 1);
        }
    }

    private void mergeMy(ExternalLocation[] externalLocations, TaskMonitor monitor) throws DuplicateNameException, InvalidInputException, CancelledException {
        if (externalLocations[2] == null) {
            this.removeExternal(this.programs[3], externalLocations[3]);
            externalLocations[0] = null;
            this.adjustIDMapsForRemove(externalLocations, 2);
        } else if (externalLocations[0] == null) {
            ExternalLocation resultExternalLocation;
            externalLocations[0] = resultExternalLocation = this.addExternal(externalLocations[2], this.mergeMy, monitor);
            this.adjustIDMapsForAdd(externalLocations, resultExternalLocation, 2);
        } else {
            ExternalLocation resultExternalLocation;
            this.myAddressTranslator.setPair(externalLocations[0].getExternalSpaceAddress(), externalLocations[2].getExternalSpaceAddress());
            externalLocations[0] = resultExternalLocation = this.replaceExternalLocation(externalLocations[0], externalLocations[2], this.getMergeMy(), monitor);
            this.adjustIDMapsForReplace(externalLocations, 2);
        }
    }

    private void mergeOriginal(ExternalLocation[] externalLocations, TaskMonitor monitor) throws DuplicateNameException, InvalidInputException, CancelledException {
        if (externalLocations[3] == null) {
            Program fromProgram = this.programs[1];
            ExternalLocation fromLocation = externalLocations[1];
            if (fromLocation == null) {
                fromProgram = this.programs[2];
                fromLocation = externalLocations[2];
            }
            if (fromLocation == null) {
                return;
            }
            this.removeExternal(fromProgram, fromLocation);
            externalLocations[0] = null;
            this.adjustIDMapsForRemove(externalLocations, 3);
        } else if (externalLocations[0] == null) {
            ExternalLocation resultExternalLocation;
            externalLocations[0] = resultExternalLocation = this.addExternal(externalLocations[3], this.mergeOriginal, monitor);
            this.adjustIDMapsForAdd(externalLocations, resultExternalLocation, 3);
        } else {
            ExternalLocation resultExternalLocation;
            this.originalAddressTranslator.setPair(externalLocations[0].getExternalSpaceAddress(), externalLocations[3].getExternalSpaceAddress());
            externalLocations[0] = resultExternalLocation = this.replaceExternalLocation(externalLocations[0], externalLocations[3], this.getMergeOriginal(), monitor);
            this.adjustIDMapsForReplace(externalLocations, 3);
        }
    }

    private void adjustIDMapsForRemove(ExternalLocation[] externalLocations, int chosenExternal) {
        long originalID;
        long l = originalID = externalLocations[3] != null ? externalLocations[3].getSymbol().getID() : -1L;
        if (originalID != -1L) {
            this.originalResolvedSymbols.put(originalID, -1L);
        }
        switch (chosenExternal) {
            case 1: {
                long myID = this.resolveMyIDFromOriginalID(originalID);
                this.myResolvedSymbols.put(myID, -1L);
                break;
            }
            case 2: {
                long latestID = this.resolveLatestIDFromOriginalID(originalID);
                this.latestResolvedSymbols.put(latestID, -1L);
                break;
            }
            case 3: {
                long myID2;
                long latestID2;
                long l2 = latestID2 = externalLocations[1] != null ? externalLocations[1].getSymbol().getID() : -1L;
                if (latestID2 != -1L) {
                    this.latestResolvedSymbols.put(latestID2, -1L);
                }
                long l3 = myID2 = externalLocations[2] != null ? externalLocations[2].getSymbol().getID() : -1L;
                if (myID2 == -1L) break;
                this.myResolvedSymbols.put(myID2, -1L);
                break;
            }
            default: {
                Msg.error((Object)this, (Object)("    ERROR :  UNRECOGNIZED chosenExternal=" + chosenExternal + "."));
                return;
            }
        }
    }

    private void adjustIDMapsForAdd(ExternalLocation[] externalLocations, ExternalLocation resultExternalLocation, int chosenExternal) {
        long latestID = externalLocations[1] != null ? externalLocations[1].getSymbol().getID() : -1L;
        long myID = externalLocations[2] != null ? externalLocations[2].getSymbol().getID() : -1L;
        long originalID = externalLocations[3] != null ? externalLocations[3].getSymbol().getID() : -1L;
        long resultID = resultExternalLocation.getSymbol().getID();
        long chosenID = externalLocations[chosenExternal].getSymbol().getID();
        boolean isChange = originalID != -1L;
        switch (chosenExternal) {
            case 1: {
                this.latestResolvedSymbols.put(chosenID, resultID);
                if (!isChange || myID != originalID) break;
                this.myResolvedSymbols.put(myID, resultID);
                break;
            }
            case 2: {
                this.myResolvedSymbols.put(chosenID, resultID);
                if (!isChange || latestID != originalID) break;
                this.latestResolvedSymbols.put(latestID, resultID);
                break;
            }
            case 3: {
                if (chosenID != resultID) {
                    this.originalResolvedSymbols.put(chosenID, resultID);
                    if (!isChange) break;
                    if (latestID != -1L) {
                        this.latestResolvedSymbols.put(latestID, resultID);
                    }
                    if (myID == -1L) break;
                    this.myResolvedSymbols.put(myID, resultID);
                    break;
                }
                if (latestID != -1L) {
                    this.latestResolvedSymbols.put(latestID, resultID);
                }
                if (myID == -1L) break;
                this.myResolvedSymbols.put(myID, resultID);
                break;
            }
            default: {
                Msg.error((Object)this, (Object)("    ERROR :  UNRECOGNIZED chosenExternal=" + chosenExternal + "."));
            }
        }
        if (isChange) {
            this.originalResolvedSymbols.put(originalID, resultID);
        }
    }

    private void adjustIDMapsForReplace(ExternalLocation[] externalLocations, int chosenExternal) {
        long originalID;
        long resultID = externalLocations[0] != null ? externalLocations[0].getSymbol().getID() : -1L;
        long latestID = externalLocations[1] != null ? externalLocations[1].getSymbol().getID() : -1L;
        long myID = externalLocations[2] != null ? externalLocations[2].getSymbol().getID() : -1L;
        long l = originalID = externalLocations[3] != null ? externalLocations[3].getSymbol().getID() : -1L;
        if (originalID != -1L) {
            this.originalResolvedSymbols.put(originalID, resultID);
        }
        if (latestID != -1L) {
            this.latestResolvedSymbols.put(latestID, resultID);
        }
        if (myID != -1L) {
            this.myResolvedSymbols.put(myID, resultID);
        }
    }

    public void refreshResultPanel(ExternalLocation[] externalLocations) {
        Address resultAddress = externalLocations[0] != null ? externalLocations[0].getExternalSpaceAddress() : null;
        Address latestAddress = externalLocations[1] != null ? externalLocations[1].getExternalSpaceAddress() : null;
        Address myAddress = externalLocations[2] != null ? externalLocations[2].getExternalSpaceAddress() : null;
        Address originalAddress = externalLocations[3] != null ? externalLocations[3].getExternalSpaceAddress() : null;
        this.mergeManager.refreshListingMergePanel(resultAddress, latestAddress, myAddress, originalAddress);
    }

    private void removeExternal(long resultExternalSymbolID) {
        Symbol symbol;
        Symbol externalSymbol = this.symbolTables[0].getSymbol(resultExternalSymbolID);
        if (!externalSymbol.isExternal()) {
            throw new AssertException("Symbol to remove isn't an external as expected.");
        }
        ExternalLocation resultExternalLocation = this.externalManagers[0].getExternalLocation(externalSymbol);
        if (resultExternalLocation == null) {
            return;
        }
        if (resultExternalLocation.isFunction()) {
            symbol = resultExternalLocation.getSymbol();
            Address addr = symbol.getAddress();
            symbol.delete();
            Symbol resultSymbol = this.symbolTables[0].getPrimarySymbol(addr);
            resultExternalLocation = this.externalManagers[0].getExternalLocation(resultSymbol);
            if (resultExternalLocation == null) {
                throw new AssertException("Why isn't there an external label.");
            }
        }
        if ((symbol = resultExternalLocation.getSymbol()) != null) {
            symbol.delete();
        }
    }

    private void removeExternal(Program sourceProgram, ExternalLocation sourceExternalLocation) {
        Symbol symbol;
        ExternalLocation resultExternalLocation = SimpleDiffUtility.getMatchingExternalLocation((Program)sourceProgram, (ExternalLocation)sourceExternalLocation, (Program)this.programs[0]);
        if (resultExternalLocation == null) {
            return;
        }
        Address externalSpaceAddress = resultExternalLocation.getExternalSpaceAddress();
        if (resultExternalLocation.isFunction()) {
            this.functionManagers[0].removeFunction(externalSpaceAddress);
            resultExternalLocation = SimpleDiffUtility.getMatchingExternalLocation((Program)sourceProgram, (ExternalLocation)sourceExternalLocation, (Program)this.programs[0]);
            if (resultExternalLocation == null) {
                return;
            }
        }
        if ((symbol = resultExternalLocation.getSymbol()) != null) {
            symbol.delete();
        }
    }

    @Override
    ProgramMerge getMergeLatest() {
        return this.mergeLatest;
    }

    @Override
    ProgramMerge getMergeMy() {
        return this.mergeMy;
    }

    @Override
    ProgramMerge getMergeOriginal() {
        return this.mergeOriginal;
    }

    private void setupAddConflictPanel(ExternalAddConflictPanel addConflictPanel, JPanel conflictPanel, ExternalLocation latestLocation, ExternalLocation myLocation, TaskMonitor monitor) {
        this.currentMonitor = monitor;
        this.currentConflictPanel = (ConflictPanel)conflictPanel;
        try {
            SwingUtilities.invokeAndWait(() -> addConflictPanel.setBottomComponent(conflictPanel));
        }
        catch (InterruptedException e) {
            Msg.showError((Object)this, null, (String)"Error Displaying Conflict Panel", (Object)e);
            return;
        }
        catch (InvocationTargetException e) {
            Msg.showError((Object)this, null, (String)"Error Displaying Conflict Panel", (Object)e);
            return;
        }
        if (this.mergeManager != null) {
            this.mergeManager.setApplyEnabled(false);
            addConflictPanel.setConflictInfo(this.conflictIndex, latestLocation, myLocation);
            HelpLocation helpLocation = null;
            this.mergeManager.removeListingMergePanel();
            this.mergeManager.showComponent(addConflictPanel, "ExternalAddConflictPanel", helpLocation);
        }
        this.mergeManager.removeComponent(addConflictPanel);
    }

    private void setupConflictPanel(ListingMergePanel listingPanel, ConflictPanel conflictPanel, ExternalLocation[] externalLocations, TaskMonitor monitor) {
        if (conflictPanel == null) {
            Msg.showError((Object)this, null, (String)"Error Displaying Conflict Panel", (Object)"The conflict panel could not be created.");
            return;
        }
        this.currentMonitor = monitor;
        this.currentConflictPanel = conflictPanel;
        try {
            SwingUtilities.invokeAndWait(() -> listingPanel.setBottomComponent(conflictPanel));
            SwingUtilities.invokeLater(() -> {});
        }
        catch (InterruptedException e) {
            Msg.showError((Object)this, null, (String)"Error Displaying Conflict Panel", (Object)e);
            return;
        }
        catch (InvocationTargetException e) {
            Msg.showError((Object)this, null, (String)"Error Displaying Conflict Panel", (Object)e);
            return;
        }
        if (this.mergeManager != null) {
            this.mergeManager.setApplyEnabled(false);
            Address resultAddress = externalLocations[0] != null ? externalLocations[0].getExternalSpaceAddress() : null;
            Address latestAddress = externalLocations[1] != null ? externalLocations[1].getExternalSpaceAddress() : null;
            Address myAddress = externalLocations[2] != null ? externalLocations[2].getExternalSpaceAddress() : null;
            Address originalAddress = externalLocations[3] != null ? externalLocations[3].getExternalSpaceAddress() : null;
            this.mergeManager.showListingMergePanel(resultAddress, latestAddress, myAddress, originalAddress);
        }
    }

    @Override
    protected void saveFunctionDetailConflict(Function[] functions, int type) {
        Address myEntry = functions[2].getEntryPoint();
        int bits = 0;
        try {
            bits = this.funcConflicts.get((Object)myEntry);
        }
        catch (NoValueException noValueException) {
            // empty catch block
        }
        this.funcConflicts.put((Object)myEntry, bits |= type);
        this.funcSet.addRange(myEntry, myEntry);
    }

    private String[] getExternalInfo(ExternalLocation[] externalLocations, int programVersion) {
        Address latestAddress = externalLocations[1] != null ? externalLocations[1].getExternalSpaceAddress() : null;
        Address myAddress = externalLocations[2] != null ? externalLocations[2].getExternalSpaceAddress() : null;
        Address originalAddress = externalLocations[3] != null ? externalLocations[3].getExternalSpaceAddress() : null;
        String[] info = new String[]{"", "", "", "", "", "", ""};
        String versionName = "Result";
        String externalName = "";
        String externalType = "label";
        String actionString = "Keep";
        ExternalLocation externalLocation = null;
        Program pgm = this.programs[0];
        switch (programVersion) {
            case -1: {
                return new String[]{"Option", "Name", "Type", "Address", "DataType", "Source", "Function"};
            }
            case 1: {
                pgm = this.programs[1];
                versionName = "Latest";
                if (latestAddress == null) {
                    actionString = "Remove";
                    break;
                }
                externalLocation = this.getExternalLocation(latestAddress, 1);
                break;
            }
            case 2: {
                pgm = this.programs[2];
                versionName = "Checked Out";
                if (myAddress == null) {
                    actionString = "Remove";
                    break;
                }
                externalLocation = this.getExternalLocation(myAddress, 2);
                break;
            }
            case 3: {
                pgm = this.programs[3];
                versionName = "Original";
                if (originalAddress == null) {
                    actionString = "No";
                    break;
                }
                externalLocation = this.getExternalLocation(originalAddress, 3);
            }
        }
        info[0] = actionString + " '" + versionName + "'.";
        if (externalLocation != null) {
            Symbol symbol = externalLocation.getSymbol();
            externalName = symbol.getName(true);
            if (symbol.getSymbolType() == SymbolType.FUNCTION) {
                externalType = "function";
            }
            Address externalAddress = externalLocation.getAddress();
            DataType dataType = this.getResultDataType(externalLocation);
            SourceType sourceType = externalLocation.getSource();
            Function function = externalLocation.getFunction();
            info[1] = externalName;
            info[2] = externalType;
            info[3] = DiffUtility.getUserToAddressString(pgm, externalAddress);
            if (dataType != null) {
                info[4] = dataType.getDisplayName();
            }
            info[5] = sourceType.getDisplayString();
            if (function != null) {
                info[6] = function.getPrototypeString(true, true);
            }
        }
        return info;
    }

    private ExternalLocation getExternalLocation(Address externalSpaceAddress, int version) {
        if (externalSpaceAddress == null || !externalSpaceAddress.isExternalAddress()) {
            return null;
        }
        Symbol symbol = this.symbolTables[version].getPrimarySymbol(externalSpaceAddress);
        if (symbol == null) {
            return null;
        }
        ExternalLocation externalLocation = this.externalManagers[version].getExternalLocation(symbol);
        return externalLocation;
    }

    private StringBuffer getRenamedConflictsInfo() {
        StringBuffer buf = new StringBuffer();
        Iterator<Long> iter = this.renamedConflictIDs.iterator();
        boolean hasSome = iter.hasNext();
        if (hasSome) {
            buf.append("The following externals were renamed to avoid conflicts: \n");
        }
        while (iter.hasNext()) {
            long id = iter.next();
            Symbol s = this.symbolTables[0].getSymbol(id);
            buf.append(s.getName(true) + "\n");
        }
        if (hasSome) {
            buf.append("\n");
        }
        return buf;
    }

    @Override
    public String getConflictType() {
        return "Externals";
    }

    @Override
    public int getNumConflictsResolved() {
        return 1;
    }

    @Override
    public boolean hasConflict(Address addr) {
        return false;
    }

    @Override
    public int getConflictCount(Address addr) {
        return 0;
    }

    @Override
    public void mergeConflicts(ListingMergePanel listingPanel, Address addr, int conflictOption, TaskMonitor monitor) throws CancelledException, MemoryAccessException {
    }

    @Override
    public AddressSetView getConflicts() {
        return null;
    }

    @Override
    protected String getInfoTitle() {
        return INFO_TITLE;
    }

    @Override
    protected String getErrorTitle() {
        return ERROR_TITLE;
    }

    private String getVersionName(int programVersion) {
        switch (programVersion) {
            case 0: {
                return "Result";
            }
            case 1: {
                return "Latest";
            }
            case 2: {
                return "Checked Out";
            }
            case 3: {
                return "Original";
            }
        }
        return "UNKNOWN";
    }

    @Override
    public void dispose() {
        this.latestChanges = null;
        this.myChanges = null;
        this.originalToLatestHash = null;
        this.latestToOriginalHash = null;
        this.originalToMyHash = null;
        this.myToOriginalHash = null;
        this.originalResolvedSymbols = null;
        this.latestResolvedSymbols = null;
        this.myResolvedSymbols = null;
        this.latestAddIDs = null;
        this.latestRemovedOriginalIDs = null;
        this.latestModifiedIDs = null;
        this.myAddIDs = null;
        this.myRemovedOriginalIDs = null;
        this.myModifiedIDs = null;
        this.removeConflictIDs = null;
        this.removeFunctionConflictIDs = null;
        this.renamedConflictIDs = null;
        this.symbolTables = null;
        this.externalManagers = null;
        this.conflictListener = null;
        this.latestExternalSet = null;
        this.myExternalSet = null;
        this.externalDetailConflicts = null;
        this.externalDataTypeConflicts = null;
        this.externalFunctionVersusDataTypeConflicts = null;
        this.externalAddConflicts = null;
        this.mergeMy = null;
        this.mergeLatest = null;
        this.mergeOriginal = null;
        this.myAddressTranslator = null;
        this.latestAddressTranslator = null;
        this.originalAddressTranslator = null;
        super.dispose();
    }

    private static interface ConflictListener {
        public void resolveConflict();
    }

    protected static enum ExternalConflictType {
        EXTERNAL_FUNCTION_REMOVE_CONFLICT,
        EXTERNAL_FUNCTION_CONFLICT,
        EXTERNAL_DETAILS_CONFLICT,
        EXTERNAL_DATA_TYPE_CONFLICT,
        EXTERNAL_FUNCTION_VS_DATA_TYPE_CONFLICT,
        EXTERNAL_ADD_CONFLICT,
        EXTERNAL_REMOVE_CONFLICT,
        FUNCTION_OVERLAP_CONFLICT,
        FUNCTION_BODY_CONFLICT,
        FUNCTION_REMOVE_CONFLICT,
        FUNCTION_RETURN_CONFLICT,
        FUNCTION_DETAILS_CONFLICT,
        VARIABLE_STORAGE_CONFLICT,
        PARAMETER_SIGNATURE_CONFLICT,
        PARAMETER_INFO_CONFLICT,
        REMOVED_LOCAL_VARIABLE_CONFLICT,
        LOCAL_VARIABLE_DETAIL_CONFLICT,
        THUNK_CONFLICT;

    }

    class ExternalParameterChangeListener
    implements ChangeListener {
        int type;
        Function[] functions;
        int ordinal;
        TaskMonitor monitor;
        VariousChoicesPanel vPanel;

        ExternalParameterChangeListener(int type, Function[] functions, int ordinal, VariousChoicesPanel vPanel, TaskMonitor monitor) {
            this.type = type;
            this.functions = functions;
            this.ordinal = ordinal;
            this.monitor = monitor;
            this.vPanel = vPanel;
        }

        @Override
        public void stateChanged(ChangeEvent e) {
            ResolveConflictChangeEvent re = (ResolveConflictChangeEvent)e;
            int choice = re.getChoice();
            ExternalFunctionMerger.this.mergeParameter(this.type, this.functions, this.ordinal, ExternalFunctionMerger.this.getOptionForChoice(choice), this.monitor);
            this.adjustUseForAll();
            this.adjustApply();
        }

        void adjustUseForAll() {
            if (ExternalFunctionMerger.this.mergeManager != null) {
                this.vPanel.adjustUseForAllEnablement();
            }
        }

        void adjustApply() {
            if (ExternalFunctionMerger.this.mergeManager != null) {
                ExternalFunctionMerger.this.mergeManager.setApplyEnabled(this.vPanel.allChoicesAreResolved());
            }
        }
    }

    class ExternalFunctionVsDataTypeConflictChangeListener
    implements ChangeListener {
        ExternalLocation[] externalLocations;
        TaskMonitor monitor;
        ConflictPanel vPanel;

        ExternalFunctionVsDataTypeConflictChangeListener(ExternalLocation[] externalLocations, ConflictPanel vPanel, TaskMonitor monitor) {
            this.externalLocations = externalLocations;
            this.monitor = monitor;
            this.vPanel = vPanel;
        }

        @Override
        public void stateChanged(ChangeEvent e) {
            ResolveConflictChangeEvent re = (ResolveConflictChangeEvent)e;
            int choice = re.getChoice();
            try {
                ExternalFunctionMerger.this.merge(this.externalLocations, choice, this.monitor);
                ExternalFunctionMerger.this.refreshResultPanel(this.externalLocations);
            }
            catch (CancelledException cancelledException) {
                // empty catch block
            }
            this.adjustApply();
        }

        void adjustApply() {
            if (ExternalFunctionMerger.this.mergeManager != null) {
                ExternalFunctionMerger.this.mergeManager.setApplyEnabled(this.vPanel.allChoicesAreResolved());
            }
        }
    }

    class ExternalRemoveFunctionConflictChangeListener
    implements ChangeListener {
        ExternalLocation[] externalLocations;
        TaskMonitor monitor;
        ConflictPanel vPanel;

        ExternalRemoveFunctionConflictChangeListener(ExternalLocation[] externalLocations, ConflictPanel vPanel, TaskMonitor monitor) {
            this.externalLocations = externalLocations;
            this.monitor = monitor;
            this.vPanel = vPanel;
        }

        @Override
        public void stateChanged(ChangeEvent e) {
            ResolveConflictChangeEvent re = (ResolveConflictChangeEvent)e;
            int choice = re.getChoice();
            try {
                ExternalFunctionMerger.this.mergeFunction(this.externalLocations, choice, this.monitor);
                ExternalFunctionMerger.this.refreshResultPanel(this.externalLocations);
            }
            catch (CancelledException cancelledException) {
                // empty catch block
            }
            this.adjustApply();
        }

        void adjustApply() {
            if (ExternalFunctionMerger.this.mergeManager != null) {
                ExternalFunctionMerger.this.mergeManager.setApplyEnabled(this.vPanel.allChoicesAreResolved());
            }
        }
    }

    class ExternalDataTypeConflictChangeListener
    implements ChangeListener {
        ExternalLocation[] externalLocations;
        TaskMonitor monitor;
        ConflictPanel vPanel;

        ExternalDataTypeConflictChangeListener(ExternalLocation[] externalLocations, ConflictPanel vPanel, TaskMonitor monitor) {
            this.externalLocations = externalLocations;
            this.monitor = monitor;
            this.vPanel = vPanel;
        }

        @Override
        public void stateChanged(ChangeEvent e) {
            ResolveConflictChangeEvent re = (ResolveConflictChangeEvent)e;
            int choice = re.getChoice();
            try {
                ExternalFunctionMerger.this.mergeExternalDataType(this.externalLocations, choice, this.monitor);
                ExternalFunctionMerger.this.refreshResultPanel(this.externalLocations);
            }
            catch (CancelledException cancelledException) {
                // empty catch block
            }
            this.adjustApply();
        }

        void adjustApply() {
            if (ExternalFunctionMerger.this.mergeManager != null) {
                ExternalFunctionMerger.this.mergeManager.setApplyEnabled(this.vPanel.allChoicesAreResolved());
            }
        }
    }

    class ExternalDetailChangeListener
    implements ChangeListener {
        int type;
        ExternalLocation[] locations;
        TaskMonitor monitor;
        VariousChoicesPanel vPanel;

        ExternalDetailChangeListener(int type, ExternalLocation[] locations, VariousChoicesPanel vPanel, TaskMonitor monitor) {
            this.type = type;
            this.locations = locations;
            this.monitor = monitor;
            this.vPanel = vPanel;
        }

        @Override
        public void stateChanged(ChangeEvent e) {
            ResolveConflictChangeEvent re = (ResolveConflictChangeEvent)e;
            int choice = re.getChoice();
            try {
                ExternalFunctionMerger.this.mergeBasicExternalDetail(this.type, this.locations, ExternalFunctionMerger.this.getOptionForChoice(choice), this.monitor);
            }
            catch (CancelledException cancelledException) {
                // empty catch block
            }
            this.adjustUseForAll();
            this.adjustApply();
        }

        void adjustUseForAll() {
            if (ExternalFunctionMerger.this.mergeManager != null) {
                this.vPanel.adjustUseForAllEnablement();
            }
        }

        void adjustApply() {
            if (ExternalFunctionMerger.this.mergeManager != null) {
                ExternalFunctionMerger.this.mergeManager.setApplyEnabled(this.vPanel.allChoicesAreResolved());
            }
        }
    }

    class ExternalRemoveConflictChangeListener
    implements ChangeListener {
        ExternalLocation[] externalLocations;
        TaskMonitor monitor;
        ConflictPanel vPanel;

        ExternalRemoveConflictChangeListener(ExternalLocation[] externalLocations, ConflictPanel vPanel, TaskMonitor monitor) {
            this.externalLocations = externalLocations;
            this.monitor = monitor;
            this.vPanel = vPanel;
        }

        @Override
        public void stateChanged(ChangeEvent e) {
            ResolveConflictChangeEvent re = (ResolveConflictChangeEvent)e;
            int choice = re.getChoice();
            try {
                ExternalFunctionMerger.this.merge(this.externalLocations, choice, this.monitor);
                ExternalFunctionMerger.this.refreshResultPanel(this.externalLocations);
            }
            catch (CancelledException cancelledException) {
                // empty catch block
            }
            this.adjustApply();
        }

        void adjustApply() {
            if (ExternalFunctionMerger.this.mergeManager != null) {
                ExternalFunctionMerger.this.mergeManager.setApplyEnabled(this.vPanel.allChoicesAreResolved());
            }
        }
    }

    class ExternalAddConflictChangeListener
    implements ChangeListener {
        ExternalLocation[] externalLocations;
        TaskMonitor monitor;
        ConflictPanel vPanel;

        ExternalAddConflictChangeListener(ExternalLocation[] externalLocations, ConflictPanel vPanel, TaskMonitor monitor) {
            this.externalLocations = externalLocations;
            this.monitor = monitor;
            this.vPanel = vPanel;
        }

        @Override
        public void stateChanged(ChangeEvent e) {
            ResolveConflictChangeEvent re = (ResolveConflictChangeEvent)e;
            int choice = re.getChoice();
            ExternalFunctionMerger.this.conflictListener = () -> {
                try {
                    ExternalFunctionMerger.this.resolveAddConflict(this.externalLocations, choice, this.monitor);
                }
                catch (CancelledException cancelledException) {
                    // empty catch block
                }
            };
            this.adjustApply();
        }

        void adjustApply() {
            if (ExternalFunctionMerger.this.mergeManager != null) {
                ExternalFunctionMerger.this.mergeManager.setApplyEnabled(this.vPanel.allChoicesAreResolved());
            }
        }
    }
}

