/*
 * Decompiled with CFR 0.152.
 */
package ghidra.app.merge.util;

import generic.theme.GThemeDefaults;
import ghidra.app.merge.MergeConstants;
import ghidra.util.Msg;
import java.awt.BorderLayout;
import javax.swing.BorderFactory;
import javax.swing.JPanel;
import javax.swing.JTextPane;
import javax.swing.text.BadLocationException;
import javax.swing.text.SimpleAttributeSet;
import javax.swing.text.StyleConstants;
import javax.swing.text.StyledDocument;

public class ConflictCountPanel
extends JPanel {
    private JTextPane textPane;
    private StyledDocument doc;
    private SimpleAttributeSet textAttrSet;
    private SimpleAttributeSet countAttrSet;

    public ConflictCountPanel() {
        super(new BorderLayout());
        this.create();
    }

    public void updateCount(int currentCount, int totalCount) {
        this.textPane.setText("");
        int offset = this.doc.getLength();
        try {
            this.doc.insertString(offset, "Conflict # ", this.textAttrSet);
            offset = this.doc.getLength();
            this.doc.insertString(offset, " " + currentCount + " ", this.countAttrSet);
            offset = this.doc.getLength();
            this.doc.insertString(offset, " of ", this.textAttrSet);
            offset = this.doc.getLength();
            this.doc.insertString(offset, " " + totalCount + " ", this.countAttrSet);
        }
        catch (BadLocationException e) {
            Msg.debug((Object)this, (Object)"Exception updating text", (Throwable)e);
        }
    }

    private void create() {
        this.setBorder(BorderFactory.createTitledBorder("Current Conflict"));
        this.textPane = new JTextPane();
        this.textPane.setBorder(BorderFactory.createEmptyBorder(10, 5, 10, 0));
        this.textPane.setEditable(false);
        this.add(this.textPane);
        this.doc = this.textPane.getStyledDocument();
        this.textPane.setBackground(this.getBackground());
        SimpleAttributeSet set = new SimpleAttributeSet();
        set.addAttribute(StyleConstants.Bold, Boolean.TRUE);
        set.addAttribute(StyleConstants.Foreground, GThemeDefaults.Colors.Messages.ERROR);
        this.textAttrSet = new SimpleAttributeSet();
        this.textAttrSet.addAttribute(StyleConstants.FontSize, 12);
        this.countAttrSet = new SimpleAttributeSet();
        this.countAttrSet.addAttribute(StyleConstants.Bold, Boolean.TRUE);
        this.countAttrSet.addAttribute(StyleConstants.Foreground, MergeConstants.CONFLICT_COLOR);
        this.updateCount(0, 10);
    }
}

