/*
 * Decompiled with CFR 0.152.
 */
package ghidra.app.plugin.core.analysis;

import generic.jar.ResourceFile;
import ghidra.app.cmd.function.CreateFunctionCmd;
import ghidra.app.plugin.core.analysis.NonReturningFunctionNames;
import ghidra.app.services.AbstractAnalyzer;
import ghidra.app.services.AnalysisPriority;
import ghidra.app.services.AnalyzerType;
import ghidra.app.util.importer.MessageLog;
import ghidra.framework.model.DomainObject;
import ghidra.framework.options.Options;
import ghidra.program.model.address.Address;
import ghidra.program.model.address.AddressSetView;
import ghidra.program.model.listing.Data;
import ghidra.program.model.listing.Function;
import ghidra.program.model.listing.Program;
import ghidra.program.model.symbol.ExternalLocation;
import ghidra.program.model.symbol.Namespace;
import ghidra.program.model.symbol.Reference;
import ghidra.program.model.symbol.Symbol;
import ghidra.program.model.symbol.SymbolIterator;
import ghidra.program.model.symbol.SymbolTable;
import ghidra.program.model.symbol.SymbolType;
import ghidra.util.Msg;
import ghidra.util.exception.CancelledException;
import ghidra.util.task.TaskMonitor;
import ghidra.xml.XmlParseException;
import java.io.BufferedReader;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStreamReader;
import java.util.HashSet;
import java.util.List;
import java.util.Set;

public class NoReturnFunctionAnalyzer
extends AbstractAnalyzer {
    private static final String NAME = "Non-Returning Functions - Known";
    private static final String DESCRIPTION = "Locates known functions by name, that generally do not return (exit, abort, etc) and sets the \"No Return\" flag.";
    private static final String OPTION_NAME_CREATE_BOOKMARKS = "Create Analysis Bookmarks";
    private static final String OPTION_DESCRIPTION_CREATE_BOOKMARKS = "If checked, an analysis bookmark will created on each function marked as non-returning.";
    private static final boolean OPTION_DEFAULT_CREATE_BOOKMARKS_ENABLED = true;
    private boolean createBookmarksEnabled = true;
    private Set<String> functionNames;
    private Set<String> wildcardFunctionNames;

    public NoReturnFunctionAnalyzer() {
        super(NAME, DESCRIPTION, AnalyzerType.BYTE_ANALYZER);
        this.setDefaultEnablement(true);
        this.setPriority(AnalysisPriority.FORMAT_ANALYSIS.before().before().before());
    }

    @Override
    public boolean canAnalyze(Program program) {
        return NonReturningFunctionNames.hasDataFiles(program);
    }

    @Override
    public boolean added(Program program, AddressSetView set, TaskMonitor monitor, MessageLog log) throws CancelledException {
        try {
            this.loadFunctionNamesIfNeeded(program);
        }
        catch (Exception e) {
            log.appendMsg("Failed to load non-returning function name list: " + e.getMessage());
        }
        SymbolTable symbolTable = program.getSymbolTable();
        SymbolIterator iterator = symbolTable.getPrimarySymbolIterator(set, true);
        block2: while (iterator.hasNext()) {
            int startIndex;
            Symbol symbol = iterator.next();
            String name = symbol.getName(false);
            int nameLength = name.length();
            for (startIndex = 0; startIndex < nameLength && name.charAt(startIndex) == '_'; ++startIndex) {
            }
            if (startIndex > 0) {
                name = name.substring(startIndex);
            }
            if (this.functionNames.contains(name)) {
                this.makeNoReturnFunction(program, symbol, monitor, log);
                continue;
            }
            for (String functionName : this.wildcardFunctionNames) {
                if (!name.startsWith(functionName)) continue;
                this.makeNoReturnFunction(program, symbol, monitor, log);
                continue block2;
            }
        }
        return true;
    }

    private void makeNoReturnFunction(Program program, Symbol symbol, TaskMonitor monitor, MessageLog log) {
        Function functionAt;
        List pathList;
        Namespace parentNamespace = symbol.getParentNamespace();
        if (!(parentNamespace == null || parentNamespace.isGlobal() || parentNamespace.isLibrary() || (pathList = parentNamespace.getPathList(true)).size() == 1 && pathList.get(0) == "std")) {
            return;
        }
        if ((symbol = this.checkForAssociatedExternalSymbol(symbol)).isExternal()) {
            ExternalLocation externalLocation = program.getExternalManager().getExternalLocation(symbol);
            if (externalLocation != null) {
                Function functionAt2 = externalLocation.createFunction();
                functionAt2.setNoReturn(true);
            }
            return;
        }
        Address address = symbol.getAddress();
        if (symbol.getSymbolType() == SymbolType.LABEL) {
            if (!SymbolType.FUNCTION.isValidParent(program, parentNamespace, address, false)) {
                return;
            }
            CreateFunctionCmd fCommand = new CreateFunctionCmd(address);
            fCommand.applyTo((DomainObject)program, monitor);
        }
        if ((functionAt = program.getFunctionManager().getFunctionAt(address)) == null) {
            log.appendMsg("Failed to create \"no return\" function " + symbol.getName(true) + " at " + address);
            return;
        }
        functionAt.setNoReturn(true);
        if (this.createBookmarksEnabled) {
            program.getBookmarkManager().setBookmark(address, "Analysis", "Non-Returning Function", "Non-Returning Function Identified");
        }
    }

    private Symbol checkForAssociatedExternalSymbol(Symbol symbol) {
        Reference[] referencesFrom;
        Program program = symbol.getProgram();
        Address addr = symbol.getAddress();
        if (addr.isExternalAddress()) {
            return symbol;
        }
        Data data = program.getListing().getDefinedDataAt(symbol.getAddress());
        if (data == null || !data.isPointer()) {
            return symbol;
        }
        for (Reference reference : referencesFrom = program.getReferenceManager().getReferencesFrom(addr)) {
            if (!reference.isExternalReference()) continue;
            return program.getSymbolTable().getPrimarySymbol(reference.getToAddress());
        }
        return symbol;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void loadFunctionNamesIfNeeded(Program program) throws FileNotFoundException, IOException, XmlParseException {
        ResourceFile[] files;
        if (this.functionNames != null) {
            return;
        }
        this.functionNames = new HashSet<String>();
        this.wildcardFunctionNames = new HashSet<String>();
        block3: for (ResourceFile file : files = NonReturningFunctionNames.findDataFiles(program)) {
            try (BufferedReader reader = new BufferedReader(new InputStreamReader(file.getInputStream()));){
                while (true) {
                    String funcName;
                    String line;
                    if ((line = reader.readLine()) == null) {
                        continue block3;
                    }
                    if ((line = line.trim()).length() == 0 || line.charAt(0) == '#') continue;
                    int startIndex = 0;
                    while (line.charAt(startIndex) == '_') {
                        ++startIndex;
                    }
                    if (startIndex != 0) {
                        Msg.warn((Object)this, (Object)("Ignoring leading '_' chars on no-return name '" + line + "' specified in file: " + file.getAbsolutePath()));
                        line = line.substring(startIndex);
                    }
                    if ((funcName = line.trim()).endsWith("*")) {
                        funcName = funcName.substring(0, funcName.length() - 1);
                        this.wildcardFunctionNames.add(funcName);
                        continue;
                    }
                    this.functionNames.add(funcName);
                }
            }
        }
    }

    @Override
    public void registerOptions(Options options, Program program) {
        options.registerOption(OPTION_NAME_CREATE_BOOKMARKS, (Object)this.createBookmarksEnabled, null, OPTION_DESCRIPTION_CREATE_BOOKMARKS);
    }

    @Override
    public void optionsChanged(Options options, Program program) {
        this.createBookmarksEnabled = options.getBoolean(OPTION_NAME_CREATE_BOOKMARKS, this.createBookmarksEnabled);
    }
}

