/*
 * Decompiled with CFR 0.152.
 */
package ghidra.app.plugin.core.analysis.rust.demangler;

import ghidra.app.plugin.core.analysis.rust.RustUtilities;
import ghidra.app.plugin.core.analysis.rust.demangler.RustDemanglerFormat;
import ghidra.app.plugin.core.analysis.rust.demangler.RustDemanglerLegacy;
import ghidra.app.plugin.core.analysis.rust.demangler.RustDemanglerOptions;
import ghidra.app.plugin.core.analysis.rust.demangler.RustDemanglerParser;
import ghidra.app.plugin.core.analysis.rust.demangler.RustDemanglerV0;
import ghidra.app.util.demangler.DemangledException;
import ghidra.app.util.demangler.DemangledFunction;
import ghidra.app.util.demangler.DemangledObject;
import ghidra.app.util.demangler.Demangler;
import ghidra.app.util.demangler.DemanglerOptions;
import ghidra.program.model.listing.Program;

public class RustDemangler
implements Demangler {
    @Override
    public DemanglerOptions createDefaultOptions() {
        return new RustDemanglerOptions();
    }

    @Override
    public boolean canDemangle(Program program) {
        return RustUtilities.isRustProgram(program);
    }

    @Override
    @Deprecated(since="9.2", forRemoval=true)
    public DemangledObject demangle(String mangled, boolean demangleOnlyKnownPatterns) throws DemangledException {
        return null;
    }

    @Override
    public DemangledObject demangle(String mangled, DemanglerOptions options) {
        RustDemanglerOptions rustOptions = this.getRustOptions(options);
        if (this.skip(mangled, rustOptions)) {
            return null;
        }
        String demangled = null;
        if (rustOptions.getDemanglerFormat() == RustDemanglerFormat.LEGACY || rustOptions.getDemanglerFormat() == RustDemanglerFormat.AUTO) {
            demangled = RustDemanglerLegacy.demangle(mangled);
        }
        if (rustOptions.getDemanglerFormat() == RustDemanglerFormat.V0 || rustOptions.getDemanglerFormat() == RustDemanglerFormat.AUTO && demangled == null) {
            demangled = RustDemanglerV0.demangle(mangled);
        }
        RustDemanglerParser parser = new RustDemanglerParser();
        DemangledObject demangledObject = parser.parse(mangled, demangled);
        if (options.applyCallingConvention() && demangledObject instanceof DemangledFunction) {
            DemangledFunction demangledFunction = (DemangledFunction)demangledObject;
            demangledFunction.setCallingConvention("__rustcall");
        }
        return demangledObject;
    }

    private RustDemanglerOptions getRustOptions(DemanglerOptions options) {
        if (options instanceof RustDemanglerOptions) {
            return (RustDemanglerOptions)options;
        }
        return new RustDemanglerOptions(options);
    }

    private boolean skip(String mangled, RustDemanglerOptions options) {
        if (!options.demangleOnlyKnownPatterns()) {
            return false;
        }
        return !RustDemangler.isRustMangled(mangled);
    }

    public static boolean isRustMangled(String mangled) {
        if (mangled.startsWith("_ZN")) {
            return true;
        }
        if (mangled.startsWith("__ZN")) {
            return true;
        }
        if (mangled.startsWith("_R")) {
            return true;
        }
        return mangled.startsWith("__R");
    }
}

