/*
 * Decompiled with CFR 0.152.
 */
package ghidra.app.plugin.core.bookmark;

import docking.DialogComponentProvider;
import docking.widgets.checkbox.GCheckBox;
import docking.widgets.combobox.GhidraComboBox;
import docking.widgets.label.GIconLabel;
import docking.widgets.label.GLabel;
import ghidra.app.plugin.core.bookmark.BookmarkNavigator;
import ghidra.app.plugin.core.bookmark.BookmarkPlugin;
import ghidra.program.model.address.Address;
import ghidra.program.model.listing.Bookmark;
import ghidra.program.model.listing.BookmarkManager;
import ghidra.program.model.listing.CodeUnit;
import ghidra.program.model.listing.Program;
import ghidra.util.HelpLocation;
import ghidra.util.layout.PairLayout;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.LayoutManager;
import java.util.Arrays;
import javax.swing.BorderFactory;
import javax.swing.ComboBoxModel;
import javax.swing.DefaultComboBoxModel;
import javax.swing.Icon;
import javax.swing.JCheckBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextField;

public class CreateBookmarkDialog
extends DialogComponentProvider {
    private BookmarkPlugin plugin;
    private Program program;
    private Address address;
    private GhidraComboBox<String> categoryComboBox;
    private JTextField descriptionTextField;
    private JCheckBox selectionCB;
    private boolean hasSelection;

    CreateBookmarkDialog(BookmarkPlugin plugin, CodeUnit cu, boolean hasSelection) {
        super("Note Bookmark", true, true, true, false);
        this.plugin = plugin;
        this.hasSelection = hasSelection;
        this.program = plugin.getCurrentProgram();
        this.address = cu.getMinAddress();
        this.addWorkPanel(this.buildMainPanel());
        this.addOKButton();
        this.addCancelButton();
        this.initializeDescription(cu);
        this.setFocusComponent((Component)this.categoryComboBox);
        this.setHelpLocation(new HelpLocation("BookmarkPlugin", "CreateBookmarkDialog"));
    }

    public void dispose() {
        this.plugin = null;
        this.program = null;
        this.address = null;
        super.dispose();
    }

    protected void okCallback() {
        String cat = this.categoryComboBox.getText();
        String com = this.descriptionTextField.getText();
        if (this.selectionCB.isSelected()) {
            this.plugin.setNote(null, cat, com);
        } else {
            this.plugin.setNote(this.address, cat, com);
        }
        this.close();
    }

    private JPanel buildMainPanel() {
        JPanel panel = new JPanel(new BorderLayout());
        panel.setBorder(BorderFactory.createEmptyBorder(20, 0, 0, 10));
        panel.add((Component)this.buildIconLabel(), "West");
        panel.add(this.buildCentralPanel(), "Center");
        panel.add((Component)this.buildCheckboxPanel(), "South");
        return panel;
    }

    private JPanel buildCheckboxPanel() {
        this.selectionCB = new GCheckBox("Bookmark Top of Each Selection", this.hasSelection);
        this.selectionCB.setEnabled(this.getSelectionRangeCount() > 1);
        JPanel panel = new JPanel();
        panel.setBorder(BorderFactory.createEmptyBorder(10, 0, 0, 0));
        panel.add(this.selectionCB);
        return panel;
    }

    private Component buildCentralPanel() {
        JPanel panel = new JPanel((LayoutManager)new PairLayout(3, 5));
        this.categoryComboBox = new GhidraComboBox(this.getModel());
        this.categoryComboBox.setEditable(true);
        this.categoryComboBox.setEnterKeyForwarding(true);
        this.descriptionTextField = new JTextField(20);
        panel.add(new JLabel("Address: ", 4));
        panel.add((Component)new GLabel(this.buildLocationString()));
        panel.add(new JLabel("Category: ", 4));
        panel.add((Component)this.categoryComboBox);
        panel.add(new JLabel("Description: ", 4));
        panel.add(this.descriptionTextField);
        return panel;
    }

    private String buildLocationString() {
        int ranges = this.getSelectionRangeCount();
        if (ranges > 1) {
            return this.address.toString() + " (plus " + (ranges - 1) + " more)";
        }
        return this.address.toString();
    }

    private JLabel buildIconLabel() {
        Icon icon = BookmarkNavigator.NOTE_ICON;
        GIconLabel imageLabel = new GIconLabel(icon);
        imageLabel.setPreferredSize(new Dimension(icon.getIconWidth() + 20, icon.getIconHeight() + 20));
        return imageLabel;
    }

    private int getSelectionRangeCount() {
        if (this.hasSelection) {
            return this.plugin.getProgramSelection().getNumAddressRanges();
        }
        return 0;
    }

    private ComboBoxModel<String> getModel() {
        BookmarkManager mgr = this.program.getBookmarkManager();
        String[] categories = mgr.getCategories("Note");
        Object[] array = new String[categories.length + 1];
        array[0] = "";
        System.arraycopy(categories, 0, array, 1, categories.length);
        Arrays.sort(array);
        return new DefaultComboBoxModel<Object>(array);
    }

    private void initializeDescription(CodeUnit codeUnit) {
        String defaultComment = this.getEolComment(codeUnit);
        BookmarkManager bmMgr = this.program.getBookmarkManager();
        Bookmark[] bookmarks = bmMgr.getBookmarks(this.address, "Note");
        if (bookmarks.length != 0) {
            this.categoryComboBox.setSelectedItem((Object)bookmarks[0].getCategory());
            this.descriptionTextField.setText(bookmarks[0].getComment());
        } else {
            this.descriptionTextField.setText(defaultComment);
        }
        this.descriptionTextField.setCaretPosition(0);
        this.descriptionTextField.selectAll();
    }

    private String getEolComment(CodeUnit codeUnit) {
        String comment = codeUnit.getComment(0);
        if (comment == null) {
            return "";
        }
        return comment.replace('\n', ' ');
    }
}

