/*
 * Decompiled with CFR 0.152.
 */
package ghidra.app.plugin.core.compositeeditor;

import ghidra.program.model.data.ArchiveType;
import ghidra.program.model.data.Composite;
import ghidra.program.model.data.DataType;
import ghidra.program.model.data.DataTypeConflictHandler;
import ghidra.program.model.data.DataTypeManager;
import ghidra.program.model.data.StandAloneDataTypeManager;
import ghidra.program.model.lang.ProgramArchitecture;
import ghidra.util.exception.AssertException;
import ghidra.util.exception.CancelledException;
import ghidra.util.task.TaskMonitor;
import java.io.IOException;

public class CompositeViewerDataTypeManager
extends StandAloneDataTypeManager {
    private final DataTypeManager originalDTM;
    private final Composite originalComposite;
    private final Composite viewComposite;
    private final int transactionID;

    public CompositeViewerDataTypeManager(String rootName, Composite originalComposite) {
        super(rootName, originalComposite.getDataTypeManager().getDataOrganization());
        this.originalComposite = originalComposite;
        this.transactionID = this.startTransaction("");
        this.originalDTM = originalComposite.getDataTypeManager();
        ProgramArchitecture arch = this.originalDTM.getProgramArchitecture();
        if (arch != null) {
            try {
                this.setProgramArchitecture(arch, null, true, TaskMonitor.DUMMY);
            }
            catch (CancelledException e) {
                throw new AssertException((Throwable)e);
            }
            catch (IOException e) {
                this.errHandler.dbError(e);
            }
        }
        this.viewComposite = (Composite)super.resolve((DataType)originalComposite, null);
    }

    protected final boolean isArchitectureChangeAllowed() {
        return false;
    }

    public void close() {
        this.endTransaction(this.transactionID, true);
        super.close();
    }

    public DataTypeManager getOriginalDataTypeManager() {
        return this.originalDTM;
    }

    public ArchiveType getType() {
        return this.originalDTM.getType();
    }

    public boolean allowsDefaultBuiltInSettings() {
        return this.originalDTM.allowsDefaultBuiltInSettings();
    }

    public DataType resolve(DataType dataType, DataTypeConflictHandler handler) {
        if (dataType == this.originalComposite && this.viewComposite != null) {
            return this.viewComposite;
        }
        return super.resolve(dataType, handler);
    }
}

