/*
 * Decompiled with CFR 0.152.
 */
package ghidra.app.plugin.core.datamgr;

import ghidra.app.plugin.core.datamgr.DataTypeSyncState;
import ghidra.app.plugin.core.datamgr.DataTypeSynchronizer;
import ghidra.program.model.data.DataType;
import ghidra.program.model.data.DataTypeManager;
import ghidra.util.DateUtils;
import ghidra.util.UniversalID;
import java.util.Date;
import org.apache.commons.lang3.StringUtils;

public class DataTypeSyncInfo {
    private final DataType refDt;
    private final DataType sourceDt;
    private final DataTypeManager sourceDTM;
    private final DataTypeSyncState syncState;

    public DataTypeSyncInfo(DataType refDt, DataTypeManager sourceDTM) {
        this.refDt = refDt;
        this.sourceDTM = sourceDTM;
        UniversalID dtId = refDt.getUniversalID();
        this.sourceDt = sourceDTM != null && dtId != null ? sourceDTM.getDataType(sourceDTM.getLocalSourceArchive(), dtId) : null;
        this.syncState = this.computeSyncState();
    }

    public DataTypeSyncState getSyncState() {
        return this.syncState;
    }

    private DataTypeSyncState computeSyncState() {
        if (this.sourceDTM == null) {
            return DataTypeSyncState.UNKNOWN;
        }
        if (this.sourceDt == null) {
            return DataTypeSyncState.ORPHAN;
        }
        if (this.canUpdate()) {
            return this.canCommit() ? DataTypeSyncState.CONFLICT : DataTypeSyncState.UPDATE;
        }
        if (this.canCommit()) {
            return DataTypeSyncState.COMMIT;
        }
        return DataTypeSyncState.IN_SYNC;
    }

    public boolean canUpdate() {
        if (this.sourceDt == null) {
            return false;
        }
        if (this.sourceDt.getLastChangeTime() == this.refDt.getLastChangeTimeInSourceArchive()) {
            return false;
        }
        return this.refDt.getLastChangeTimeInSourceArchive() <= this.sourceDt.getLastChangeTime();
    }

    public boolean canCommit() {
        if (this.sourceDt == null) {
            return true;
        }
        if (this.refDt.getLastChangeTime() != this.refDt.getLastChangeTimeInSourceArchive()) {
            return true;
        }
        return this.refDt.getLastChangeTimeInSourceArchive() > this.sourceDt.getLastChangeTime();
    }

    public boolean canRevert() {
        return this.sourceDt != null && this.canCommit();
    }

    public void commit() {
        DataTypeSynchronizer.commitAssumingTransactionsOpen(this.sourceDTM, this.refDt);
    }

    public void update() {
        DataTypeSynchronizer.updateAssumingTransactionsOpen(this.refDt.getDataTypeManager(), this.sourceDt);
    }

    public void revert() {
        DataTypeSynchronizer.updateAssumingTransactionsOpen(this.refDt.getDataTypeManager(), this.sourceDt);
    }

    public void disassociate() {
        DataTypeManager refDTM = this.refDt.getDataTypeManager();
        refDTM.disassociate(this.refDt);
    }

    public String getSourceDtPath() {
        if (this.sourceDt == null) {
            return "";
        }
        return this.sourceDt.getPathName();
    }

    public String getRefDtPath() {
        return this.refDt.getCategoryPath().getPath();
    }

    public long getLastChangeTime(boolean useSource) {
        DataType dt;
        DataType dataType = dt = useSource ? this.sourceDt : this.refDt;
        if (this.canUpdate()) {
            return dt.getLastChangeTime();
        }
        return Long.MAX_VALUE;
    }

    public String getLastChangeTimeString(boolean useSource) {
        DataType dt;
        DataType dataType = dt = useSource ? this.sourceDt : this.refDt;
        if (this.canUpdate()) {
            return this.getDateString(dt.getLastChangeTime());
        }
        return "";
    }

    public String getLastSyncTimeString() {
        return this.getDateString(this.refDt.getLastChangeTimeInSourceArchive());
    }

    public long getLastSyncTime() {
        return this.refDt.getLastChangeTimeInSourceArchive();
    }

    private String getDateString(long date) {
        if (date == 0L) {
            return "";
        }
        return DateUtils.formatDateTimestamp((Date)new Date(date));
    }

    public DataType getRefDataType() {
        return this.refDt;
    }

    public DataType getSourceDataType() {
        return this.sourceDt;
    }

    public boolean hasChange() {
        if (this.sourceDt == null) {
            return true;
        }
        if (!DataTypeSynchronizer.namesAreEquivalent(this.sourceDt, this.refDt)) {
            return true;
        }
        if (!StringUtils.equals((CharSequence)this.refDt.getDescription(), (CharSequence)this.sourceDt.getDescription())) {
            return true;
        }
        DataType dt = this.sourceDt.clone(this.refDt.getDataTypeManager());
        return !dt.isEquivalent(this.refDt);
    }

    public void syncTimes() {
        if (this.sourceDt == null) {
            throw new IllegalStateException("Can't sync datatypes with missing source datatype.");
        }
        long lastChangeTime = this.sourceDt.getLastChangeTime();
        this.refDt.setLastChangeTimeInSourceArchive(lastChangeTime);
        this.refDt.setLastChangeTime(lastChangeTime);
    }

    public String getName() {
        return this.refDt.getName();
    }
}

