/*
 * Decompiled with CFR 0.152.
 */
package ghidra.app.plugin.core.datamgr.actions;

import docking.ActionContext;
import docking.action.DockingAction;
import docking.action.MenuData;
import docking.widgets.OptionDialog;
import docking.widgets.tree.GTree;
import docking.widgets.tree.GTreeNode;
import ghidra.app.plugin.core.datamgr.DataTypeManagerPlugin;
import ghidra.app.plugin.core.datamgr.DataTypesActionContext;
import ghidra.app.plugin.core.datamgr.tree.DataTypeNode;
import ghidra.app.plugin.core.navigation.FindAppliedDataTypesService;
import ghidra.app.services.FieldMatcher;
import ghidra.framework.plugintool.PluginTool;
import ghidra.program.model.data.Composite;
import ghidra.program.model.data.DataType;
import ghidra.program.model.data.DataTypeComponent;
import ghidra.program.model.data.Enum;
import ghidra.util.HelpLocation;
import ghidra.util.Msg;
import ghidra.util.NumericUtilities;
import ghidra.util.Swing;
import java.util.ArrayList;
import javax.swing.tree.TreePath;
import org.apache.commons.lang3.StringUtils;

public class FindReferencesToFieldAction
extends DockingAction {
    private final DataTypeManagerPlugin plugin;

    public FindReferencesToFieldAction(DataTypeManagerPlugin plugin) {
        super("Find Uses of Field", plugin.getName());
        this.plugin = plugin;
        String menuGroup = "ZVeryLast";
        this.setPopupMenuData(new MenuData(new String[]{"Find Uses of Field..."}, null, menuGroup));
        this.setHelpLocation(new HelpLocation("LocationReferencesPlugin", "Data_Types"));
        this.setEnabled(true);
    }

    public boolean isEnabledForContext(ActionContext context) {
        if (!(context instanceof DataTypesActionContext)) {
            return false;
        }
        Object contextObject = context.getContextObject();
        GTree gtree = (GTree)contextObject;
        TreePath[] selectionPaths = gtree.getSelectionPaths();
        if (selectionPaths.length != 1) {
            return false;
        }
        GTreeNode node = (GTreeNode)selectionPaths[0].getLastPathComponent();
        if (!(node instanceof DataTypeNode)) {
            return false;
        }
        DataTypeNode dtNode = (DataTypeNode)node;
        DataType dataType = dtNode.getDataType();
        return dataType instanceof Composite || dataType instanceof Enum;
    }

    public void actionPerformed(ActionContext context) {
        GTree gTree = (GTree)context.getContextObject();
        TreePath[] selectionPaths = gTree.getSelectionPaths();
        DataTypeNode dataTypeNode = (DataTypeNode)((Object)selectionPaths[0].getLastPathComponent());
        PluginTool tool = this.plugin.getTool();
        FindAppliedDataTypesService service = (FindAppliedDataTypesService)tool.getService(FindAppliedDataTypesService.class);
        if (service == null) {
            Msg.showError((Object)((Object)this), null, (String)"Missing Plugin", (Object)"The FindAppliedDataTypesService is not installed.\nPlease add the plugin implementing this service.");
            return;
        }
        DataType dt = dataTypeNode.getDataType();
        String[] choices = null;
        if (dt instanceof Composite) {
            choices = this.getCompisiteFieldNames((Composite)dt);
        } else if (dt instanceof Enum) {
            choices = ((Enum)dt).getNames();
        }
        String message = "Find uses of '" + dt.getName() + "' field by name or offset";
        String userChoice = OptionDialog.showEditableInputChoiceDialog(null, (String)"Choose Field", (String)message, (String[])choices, null, (int)3);
        if (userChoice == null) {
            return;
        }
        Long longChoice = this.parseInt(userChoice);
        FieldMatcher fieldMatcher = longChoice != null ? new FieldMatcher(dt, longChoice.intValue()) : new FieldMatcher(dt, userChoice);
        Swing.runLater(() -> service.findAndDisplayAppliedDataTypeAddresses(dt, fieldMatcher));
    }

    private Long parseInt(String s) {
        return NumericUtilities.parseNumber((String)s, null);
    }

    private String[] getCompisiteFieldNames(Composite composite) {
        DataTypeComponent[] components = composite.getDefinedComponents();
        ArrayList<String> names = new ArrayList<String>();
        for (DataTypeComponent dataTypeComponent : components) {
            String fieldName;
            if (dataTypeComponent.isBitFieldComponent() || StringUtils.isBlank((CharSequence)(fieldName = dataTypeComponent.getFieldName()))) continue;
            names.add(fieldName);
        }
        return (String[])names.toArray(String[]::new);
    }
}

