/*
 * Decompiled with CFR 0.152.
 */
package ghidra.app.plugin.core.datamgr.actions;

import docking.ActionContext;
import docking.action.DockingAction;
import docking.action.MenuData;
import docking.widgets.dialogs.NumberRangeInputDialog;
import docking.widgets.tree.DefaultGTreeFilterProvider;
import docking.widgets.tree.GTree;
import docking.widgets.tree.GTreeFilterProvider;
import docking.widgets.tree.GTreeNode;
import docking.widgets.tree.support.CombinedGTreeFilter;
import docking.widgets.tree.support.GTreeFilter;
import ghidra.app.plugin.core.datamgr.DataTypeManagerPlugin;
import ghidra.app.plugin.core.datamgr.DataTypesProvider;
import ghidra.app.plugin.core.datamgr.tree.DataTypeArchiveGTree;
import ghidra.app.plugin.core.datamgr.tree.DataTypeNode;
import ghidra.program.model.data.DataType;
import ghidra.program.model.data.DataTypeComponent;
import ghidra.program.model.data.Structure;
import ghidra.util.HelpLocation;
import ghidra.util.datastruct.Range;
import ghidra.util.datastruct.SortedRangeList;
import java.util.Iterator;
import util.CollectionUtils;

public class FindStructuresByOffsetAction
extends DockingAction {
    public static final String NAME = "Find Structures by Offset";
    private DataTypeManagerPlugin plugin;

    public FindStructuresByOffsetAction(DataTypeManagerPlugin plugin, String menuSubGroup) {
        super(NAME, plugin.getName());
        this.plugin = plugin;
        this.setMenuBarData(new MenuData(new String[]{"Find Structures by Offset..."}, null, "VeryLast", -1, menuSubGroup));
        this.setHelpLocation(new HelpLocation("DataTypeManagerPlugin", "Find_Structures_By_Offset"));
    }

    public void actionPerformed(ActionContext context) {
        NumberRangeInputDialog inputDialog = new NumberRangeInputDialog(NAME, "Offset(s)");
        if (!inputDialog.show()) {
            return;
        }
        SortedRangeList values = inputDialog.getValue();
        DataTypesProvider newProvider = this.plugin.createProvider();
        newProvider.setTitle(NAME);
        DataTypeArchiveGTree tree = newProvider.getGTree();
        tree.setFilterProvider((GTreeFilterProvider)new MyTreeFilterProvider(tree, new OffsetGTreeFilter(values)));
        newProvider.setVisible(true);
    }

    private class MyTreeFilterProvider
    extends DefaultGTreeFilterProvider {
        private GTreeFilter secondaryFilter;

        MyTreeFilterProvider(GTree tree, GTreeFilter secondaryFilter) {
            super(tree);
            this.secondaryFilter = secondaryFilter;
        }

        public GTreeFilter getFilter() {
            GTreeFilter filter = super.getFilter();
            if (filter == null) {
                return this.secondaryFilter;
            }
            return new CombinedGTreeFilter(filter, this.secondaryFilter);
        }
    }

    private class OffsetGTreeFilter
    implements GTreeFilter {
        private final SortedRangeList offsets;

        OffsetGTreeFilter(SortedRangeList offsets) {
            this.offsets = offsets;
        }

        public boolean showFilterMatches() {
            return true;
        }

        public boolean acceptsNode(GTreeNode node) {
            if (!(node instanceof DataTypeNode)) {
                return false;
            }
            DataTypeNode dataTypeNode = (DataTypeNode)node;
            DataType dataType = dataTypeNode.getDataType();
            if (!(dataType instanceof Structure)) {
                return false;
            }
            Structure structure = (Structure)dataType;
            OffsetIterator it = new OffsetIterator(structure);
            block0: for (Integer structureOffset : CollectionUtils.asIterable((Iterator)it)) {
                for (Range range : this.offsets) {
                    if (range.contains(structureOffset.intValue())) {
                        return true;
                    }
                    if (structureOffset <= range.max) continue;
                    continue block0;
                }
            }
            return false;
        }

        private class OffsetIterator
        implements Iterator<Integer> {
            private DataTypeComponent[] components;
            private int index = 0;
            private int length;

            OffsetIterator(Structure s) {
                this.components = s.getComponents();
                this.length = this.components.length;
            }

            @Override
            public boolean hasNext() {
                return this.index < this.length;
            }

            @Override
            public Integer next() {
                DataTypeComponent dtc = this.components[this.index++];
                return dtc.getOffset();
            }
        }
    }
}

