/*
 * Decompiled with CFR 0.152.
 */
package ghidra.app.plugin.core.function.tags;

import ghidra.app.plugin.core.function.tags.FunctionTableModel;
import ghidra.framework.plugintool.ComponentProviderAdapter;
import ghidra.framework.plugintool.ServiceProvider;
import ghidra.program.model.listing.Function;
import ghidra.program.model.listing.FunctionTag;
import ghidra.program.model.listing.Program;
import ghidra.util.table.GhidraTable;
import ghidra.util.table.GhidraTableFilterPanel;
import ghidra.util.table.GhidraThreadedTablePanel;
import java.awt.BorderLayout;
import java.awt.Component;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import java.util.stream.Collectors;
import javax.swing.BorderFactory;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTable;

public class AllFunctionsPanel
extends JPanel {
    private FunctionTableModel model;
    private GhidraTable table;
    private GhidraTableFilterPanel<Function> filterPanel;
    private JLabel titleLabel;

    public AllFunctionsPanel(Program program, ComponentProviderAdapter provider, String title) {
        this.model = new FunctionTableModel(title, (ServiceProvider)provider.getTool(), program, null);
        GhidraThreadedTablePanel<Function> tablePanel = new GhidraThreadedTablePanel<Function>(this.model);
        this.table = tablePanel.getTable();
        this.filterPanel = new GhidraTableFilterPanel((JTable)((Object)this.table), this.model);
        this.setLayout(new BorderLayout());
        this.titleLabel = new JLabel(title);
        this.titleLabel.setBorder(BorderFactory.createEmptyBorder(3, 5, 0, 0));
        this.add((Component)this.titleLabel, "North");
        this.add((Component)((Object)tablePanel), "Center");
        this.add((Component)((Object)this.filterPanel), "South");
        this.table.installNavigation((ServiceProvider)provider.getTool());
    }

    public void refresh() {
        this.model.reload();
    }

    public void refresh(Set<FunctionTag> selectedTags) {
        this.setSelectedTags(selectedTags);
    }

    public void setProgram(Program program) {
        this.model.setProgram(program);
    }

    public void setSelectedTags(Set<FunctionTag> tags) {
        Set<FunctionTag> currentTags = this.model.getTags();
        if (Objects.equals(tags, currentTags)) {
            return;
        }
        String tagNames = tags.stream().map(t -> t.getName()).collect(Collectors.joining(" or ")).toString();
        this.titleLabel.setText("Functions With Tag: " + tagNames);
        this.model.setTags(tags);
    }

    public List<Function> getFunctions() {
        return this.model.getFunctions();
    }

    public FunctionTableModel getTableModel() {
        return this.model;
    }
}

